unit settingsform;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls, Menus, Buttons;

type
  TFrmSettings = class(TForm)
    TabSettings: TPageControl;
    PagGlobal: TTabSheet;
    PagView: TTabSheet;
    BtnOK: TButton;
    BtnCancel: TButton;
    GroupBox1: TGroupBox;
    ChkConfirmFileDeletion: TCheckBox;
    ChkConfirmOverwriting: TCheckBox;
    ChkConfirmExiting: TCheckBox;
    ChkConfirmDirDeletion: TCheckBox;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    LblFont: TLabel;
    BtnChangeFont: TButton;
    Label3: TLabel;
    Label4: TLabel;
    ShpForeColor: TShape;
    ShpBackColor: TShape;
    DlgFont: TFontDialog;
    DlgColor: TColorDialog;
    TabTextEdit: TTabSheet;
    RdoInternal: TRadioButton;
    RdoExternal: TRadioButton;
    GrpExternalTextEdit: TGroupBox;
    Label5: TLabel;
    EdtPath: TEdit;
    SpdBrowse: TSpeedButton;
    Label6: TLabel;
    EdtParams: TEdit;
    Label7: TLabel;
    DlgBrowse: TOpenDialog;
    ScrollBox1: TScrollBox;
    LblPreview: TLabel;
    BtnHelp: TButton;
    GroupBox4: TGroupBox;
    ChkSelectDirectories: TCheckBox;
    ChkClearReadOnlyAttribute: TCheckBox;
    PagFilePanels: TTabSheet;
    RdoCharCase: TRadioGroup;
    ChkSynchronizeColumnWidth: TCheckBox;
    PagRecycleBin: TTabSheet;
    RdoUseRecycleBin: TRadioButton;
    RdoDontUseRecycleBin: TRadioButton;
    ImgDelete: TImage;
    Label8: TLabel;
    Label9: TLabel;
    GroupBox5: TGroupBox;
    RdoUseStandardIcons: TRadioButton;
    RdoUseSimpleIcons: TRadioButton;
    RdoUseSimpleIconsFor: TRadioButton;
    ChkUSI_Harddisk: TCheckBox;
    ChkUSI_FloppyDrive: TCheckBox;
    ChkUSI_NetworkDrive: TCheckBox;
    ChkUSI_CDROM: TCheckBox;
    ChkUSI_Other: TCheckBox;
    PagDragDrop: TTabSheet;
    GroupBox6: TGroupBox;
    ChkConfirmDDMove: TCheckBox;
    ChkConfirmDDCopy: TCheckBox;
    ChkConfirmDDCreateLinks: TCheckBox;
    RdoDDStandardAction: TRadioGroup;
    PagStartup: TTabSheet;
    ChkRestoreWindow: TCheckBox;
    GroupBox7: TGroupBox;
    RdoRestoreDirectories: TRadioButton;
    RdoStandardDirectories: TRadioButton;
    Label10: TLabel;
    Label11: TLabel;
    EdtLeftDir: TEdit;
    EdtRightDir: TEdit;
    SpdBrowseDirLeft: TSpeedButton;
    SpdBrowseDirRight: TSpeedButton;
    ChkClickToRename: TCheckBox;
    PagEnhanced: TTabSheet;
    ChkPreventMultiInstances: TCheckBox;
    ChkWindowClientDraggable: TCheckBox;
    ChkUseDoubleBuffer: TCheckBox;
    ChkGridLines: TCheckBox;
    ChkClickToOpen: TCheckBox;
    ChkGhostHiddenFiles: TCheckBox;
    SpdChangeForeground: TSpeedButton;
    SpdChangeBackground: TSpeedButton;
    ChkMarkDirectories: TCheckBox;
    procedure BtnChangeFontClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure SpdBrowseClick(Sender: TObject);
    procedure EdtPathEnter(Sender: TObject);
    procedure EdtParamsEnter(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BtnHelpClick(Sender: TObject);
    procedure RdoUseSimpleIconsForClick(Sender: TObject);
    procedure RdoUseStandardIconsClick(Sender: TObject);
    procedure RdoUseSimpleIconsClick(Sender: TObject);
    procedure SpdBrowseDirLeftClick(Sender: TObject);
    procedure SpdBrowseDirRightClick(Sender: TObject);
    procedure RdoRestoreDirectoriesClick(Sender: TObject);
    procedure RdoStandardDirectoriesClick(Sender: TObject);
    procedure RdoInternalClick(Sender: TObject);
    procedure RdoExternalClick(Sender: TObject);
    procedure ChkClickToOpenClick(Sender: TObject);
    procedure SpdChangeForegroundClick(Sender: TObject);
    procedure SpdChangeBackgroundClick(Sender: TObject);
  private
    { Private-Deklarationen }
    Procedure WMNCHitTest(Var Msg: TMessage); Message WM_NCHITTEST;
  public
    { Public-Deklarationen }
    Procedure OptionsTosettingsForm;
    Procedure SettingsFormToOptions;
  end;

Var
   FrmSettings: TFrmSettings;

Implementation

{$R *.DFM}

Uses
    MainForm;

Procedure UpdateUseSimpleIconsFor;
Begin
     With FrmSettings Do Begin
          ChkUSI_Harddisk.Enabled:=RdoUseSimpleIconsFor.Checked;
          ChkUSI_FloppyDrive.Enabled:=RdoUseSimpleIconsFor.Checked;
          ChkUSI_NetworkDrive.Enabled:=RdoUseSimpleIconsFor.Checked;
          ChkUSI_CDROM.Enabled:=RdoUseSimpleIconsFor.Checked;
          ChkUSI_Other.Enabled:=RdoUseSimpleIconsFor.Checked;
     End;
End;

Procedure UpdateRestoreDirectories;
Begin
     With FrmSettings Do Begin
          If RdoRestoreDirectories.Checked Then Begin
             EdtLeftDir.Enabled:=False;
             EdtRightDir.Enabled:=False;
             SpdBrowseDirLeft.Enabled:=False;
             SpdBrowseDirRight.Enabled:=False;
          End Else Begin
             EdtLeftDir.Enabled:=True;
             EdtRightDir.Enabled:=True;
             SpdBrowseDirLeft.Enabled:=True;
             SpdBrowseDirRight.Enabled:=True;
          End;
     End;
End;

Procedure UpdateTextEditorSettings;
Begin
     With FrmSettings Do Begin
          If RdoInternal.Checked Then Begin
             EdtPath.Enabled:=False;
             EdtParams.Enabled:=False;
             SpdBrowse.Enabled:=False;
          End Else Begin
             EdtPath.Enabled:=True;
             EdtParams.Enabled:=True;
             SpdBrowse.Enabled:=True;
          End;
     End;
End;

procedure TFrmSettings.BtnChangeFontClick(Sender: TObject);
begin
     DlgFont.Font:=LblPreview.Font;
     If DlgFont.Execute Then Begin
        LblFont.Caption:=DlgFont.Font.Name;
        LblPreview.Font:=DlgFont.Font;
     End;
end;

procedure TFrmSettings.FormShow(Sender: TObject);
begin
     UpdateTextEditorSettings;
     UpdateRestoreDirectories;
     UpdateUseSimpleIconsFor;
     TabSettings.ActivePage:=PagGlobal;
     BtnOK.SetFocus;
end;

Procedure TFrmSettings.OptionsTosettingsForm;
Begin
     // Seite "Allgemein"
     ChkConfirmFileDeletion.Checked:=Options.ConfirmDeleteFile;
     ChkConfirmOverwriting.Checked:=Options.ConfirmOverwrite;
     ChkConfirmExiting.Checked:=Options.ConfirmExit;
     ChkConfirmDirDeletion.Checked:=Options.ConfirmDeleteDirectory;
     ChkClearReadOnlyAttribute.Checked:=Options.ClearReadOnlyAttribute;
     ChkSelectDirectories.Checked:=Options.SelectDirectories;
     // Seite "Start"
     If Options.RestoreDirectories Then
        RdoRestoreDirectories.Checked:=True
     Else
        RdoStandardDirectories.Checked:=True;
     EdtLeftDir.Text:=Options.StdDirLeft;
     EdtRightDir.Text:=Options.StdDirRight;
     ChkRestoreWindow.Checked:=Options.RestoreWindow;
     // Seite "Dateien"
     RdoCharCase.ItemIndex:=Options.CharCase;
     ChkSynchronizeColumnWidth.Checked:=Options.SynchronizeColumnWidth;
     ChkGridLines.Checked:=Options.GridLines;
     ChkClickToRename.Checked:=Options.ClickToRename;
     ChkClickToOpen.Checked:=Options.ClickToOpen;
     ChkClickToRename.Enabled:=Not ChkClickToOpen.Checked;
     ChkGhostHiddenFiles.Checked:=Options.GhostHiddenFiles;
     ChkMarkDirectories.Checked:=Options.MarkDirectories;
     Case Options.UseIcons Of
          uiStandardIcons: RdoUseStandardIcons.Checked:=True;
          uiSimpleIcons: RdoUseSimpleIcons.Checked:=True;
          uiUserDefined: RdoUseSimpleIconsFor.Checked:=True;
     End;
     ChkUSI_Harddisk.Checked:=Options.usi_Harddisk;
     ChkUSI_FloppyDrive.Checked:=Options.usi_FloppyDrive;
     ChkUSI_NetworkDrive.Checked:=Options.usi_NetworkDrive;
     ChkUSI_CDROM.Checked:=Options.usi_CDROM;
     ChkUSI_Other.Checked:=Options.usi_Other;
     // Seite "Darstellung"
     LblFont.Caption:=Options.FontName;
     LblPreview.Color:=Options.Color;
     LblPreview.Font.Name:=Options.FontName;
     LblPreview.Font.Color:=Options.FontColor;
     LblPreview.Font.Style:=Options.FontStyles;
     Lblpreview.Font.Size:=Options.FontSize;
     ShpForeColor.Brush.Color:=Options.FontColor;
     ShpBackColor.Brush.Color:=Options.Color;
     // Seite Papierkorb
     If Options.UseRecycleBin Then
        RdoUseRecycleBin.Checked:=True
     Else
        RdoDontUseRecycleBin.Checked:=True;
     // Seite "Text-Editor"
     RdoInternal.Checked:=Options.UseInternalTextEdit;
     RdoExternal.Checked:=Not Options.UseInternalTextEdit;
     EdtPath.Text:=Options.ExternalTextEditPath;
     EdtParams.Text:=Options.ExternalTextEditParams;
     // Seite "Drag'n'Drop"
     ChkConfirmDDMove.Checked:=Options.ConfirmDDMove;
     ChkConfirmDDCopy.Checked:=Options.ConfirmDDCopy;
     ChkConfirmDDCreateLinks.Checked:=Options.ConfirmDDCreateLinks;
     RdoDDStandardAction.ItemIndex:=Options.DDStandardAction;
     // Seite "Erweitert"
     ChkPreventMultiInstances.Checked:=Options.PreventMultiInstances;
     ChkWindowClientDraggable.Checked:=Options.WindowClientDraggable;
     ChkUseDoubleBuffer.Checked:=Options.UseDoubleBuffer;
End;

Procedure TFrmsettings.SettingsFormToOptions;
Begin
     // Seite "Allgemein"
     Options.ConfirmDeleteFile:=ChkConfirmFileDeletion.Checked;
     Options.ConfirmOverwrite:=ChkConfirmOverwriting.Checked;
     Options.ConfirmExit:=ChkConfirmExiting.Checked;
     Options.ConfirmDeleteDirectory:=ChkConfirmDirDeletion.Checked;
     Options.ClearReadOnlyAttribute:=ChkClearReadOnlyAttribute.Checked;
     Options.SelectDirectories:=ChkSelectDirectories.Checked;
     // Seite "Start"
     Options.RestoreDirectories:=RdoRestoreDirectories.Checked;
     Options.StdDirLeft:=EdtLeftDir.Text;
     Options.StdDirRight:=EdtRightDir.Text;
     Options.RestoreWindow:=ChkRestoreWindow.Checked;
     // Seite "Dateien"
     Options.CharCase:=RdoCharCase.ItemIndex;
     Options.SynchronizeColumnWidth:=ChkSynchronizeColumnWidth.Checked;
     Options.GridLines:=ChkGridLines.Checked;
     Options.ClickToRename:=ChkClickToRename.Checked;
     Options.ClickToOpen:=ChkClickToOpen.Checked;
     Options.GhostHiddenFiles:=ChkGhostHiddenFiles.Checked;
     Options.MarkDirectories:=ChkMarkDirectories.Checked;
     If RdoUseStandardIcons.Checked Then Options.UseIcons:=uiStandardIcons
     Else If RdoUseSimpleIcons.Checked Then Options.UseIcons:=uiSimpleIcons
     Else Options.UseIcons:=uiUserDefined;
     Options.usi_Harddisk:=ChkUSI_Harddisk.Checked;
     Options.usi_FloppyDrive:=ChkUSI_FloppyDrive.Checked;
     Options.usi_NetworkDrive:=ChkUSI_NetworkDrive.Checked;
     Options.usi_CDROM:=ChkUSI_CDROM.Checked;
     Options.usi_Other:=ChkUSI_Other.Checked;
     // Seite "Darstellung"
     Options.FontName:=LblFont.Caption;
     Options.Color:=LblPreview.Color;
     Options.FontName:=LblPreview.Font.Name;
     Options.FontColor:=LblPreview.Font.Color;
     Options.FontStyles:=LblPreview.Font.Style;
     Options.FontSize:=Lblpreview.Font.Size;
     Options.FontColor:=ShpForeColor.Brush.Color;
     Options.Color:=ShpBackColor.Brush.Color;
     // Seite Papierkorb
     Options.UseRecycleBin:=RdoUseRecycleBin.Checked;
     // Seite "Text-Editor"
     Options.UseInternalTextEdit:=RdoInternal.Checked;
     Options.ExternalTextEditPath:=EdtPath.Text;
     Options.ExternalTextEditParams:=EdtParams.Text;
     // Seite "Drag'n'Drop"
     Options.ConfirmDDMove:=ChkConfirmDDMove.Checked;
     Options.ConfirmDDCopy:=ChkConfirmDDCopy.Checked;
     Options.ConfirmDDCreateLinks:=ChkConfirmDDCreateLinks.Checked;
     Options.DDStandardAction:=RdoDDStandardAction.ItemIndex;
     // Seite "Erweitert"
     Options.PreventMultiInstances:=ChkPreventMultiInstances.Checked;
     Options.WindowClientDraggable:=ChkWindowClientDraggable.Checked;
     Options.UseDoubleBuffer:=ChkUseDoubleBuffer.Checked;
End;

procedure TFrmSettings.SpdBrowseClick(Sender: TObject);
begin
     If DlgBrowse.Execute Then Begin
        EdtPath.Text:=DlgBrowse.FileName;
        EdtPath.SelectAll;
     End;
end;

procedure TFrmSettings.EdtPathEnter(Sender: TObject);
begin
     EdtPath.SelectAll;
end;

procedure TFrmSettings.EdtParamsEnter(Sender: TObject);
begin
     EdtParams.SelectAll;
end;

procedure TFrmSettings.FormCreate(Sender: TObject);
begin
     HelpContext:=IDH_OptionsSettings;
end;

procedure TFrmSettings.BtnHelpClick(Sender: TObject);
begin
     Application.HelpCommand(HELP_CONTEXT, HelpContext);
End;

procedure TFrmSettings.RdoUseSimpleIconsForClick(Sender: TObject);
begin
     UpdateUseSimpleIconsFor;
end;

procedure TFrmSettings.RdoUseStandardIconsClick(Sender: TObject);
begin
     UpdateUseSimpleIconsFor;
end;

procedure TFrmSettings.RdoUseSimpleIconsClick(Sender: TObject);
begin
     UpdateUseSimpleIconsFor;
end;

procedure TFrmSettings.SpdBrowseDirLeftClick(Sender: TObject);
Var
   Path: String;
begin
     Path:=BrowseDir('Whlen Sie ein Verzeichnis.',Handle);
     If Path <> '' Then EdtLeftDir.Text:=Path;
     EdtLeftDir.SelectAll;
     EdtLeftDir.SetFocus;
end;

procedure TFrmSettings.SpdBrowseDirRightClick(Sender: TObject);
Var
   Path: String;
begin
     Path:=BrowseDir('Whlen Sie ein Verzeichnis.',Handle);
     If Path <> '' Then EdtRightDir.Text:=Path;
     EdtRightDir.SelectAll;
     EdtRightDir.SetFocus;
end;

procedure TFrmSettings.RdoRestoreDirectoriesClick(Sender: TObject);
begin
     UpdateRestoreDirectories;
end;

procedure TFrmSettings.RdoStandardDirectoriesClick(Sender: TObject);
begin
     UpdateRestoreDirectories;
end;

procedure TFrmSettings.RdoInternalClick(Sender: TObject);
begin
     UpdateTextEditorSettings;
end;

procedure TFrmSettings.RdoExternalClick(Sender: TObject);
begin
     UpdateTextEditorSettings;
end;

procedure TFrmSettings.ChkClickToOpenClick(Sender: TObject);
begin
     ChkClickToRename.Enabled:=Not ChkClickToOpen.Checked;
end;

Procedure TFrmSettings.WMNCHitTest(Var Msg : TMessage);
Var
   i: Integer;
   r: TRect;
   ctrl: TControl;

Function LeftMouseButtonPressed: Boolean;
Begin
     If GetSystemMetrics(SM_SWAPBUTTON) = 0 Then
        Result:=(GetAsyncKeyState(VK_LBUTTON) < 0)
     Else
        Result:=(GetAsyncKeyState(VK_RBUTTON) < 0);
End;

Begin
     If Options.WindowClientDraggable And LeftMouseButtonPressed Then Begin
        If (Msg.LParamLo >= Self.ClientToScreen(Point(0, 0)).x) And
           (Msg.LParamHi >= Self.ClientToScreen(Point(0, 0)).y) And
           (Msg.LParamLo <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).x) And
           (Msg.LParamHi <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).y)
        Then Begin
             For i:=0 To Self.ComponentCount-1 Do Begin
                 Try
                    If Self.Components[i] Is TControl Then Begin
                       ctrl:=TControl(Self.Components[i]);
                       r:=ctrl.BoundsRect;
                       If (Msg.LParamLo >= Self.ClientToScreen(Point(r.Left, r.Top)).x) And
                          (Msg.LParamHi >= Self.ClientToScreen(Point(r.Left, r.Top)).y) And
                          (Msg.LParamLo <= Self.ClientToScreen(Point(r.Right, r.Bottom)).x) And
                          (Msg.LParamHi <= Self.ClientToScreen(Point(r.Right, r.Bottom)).y) And ctrl.Visible
                       Then Begin
                          Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                          Exit;
                       End;
                    End;
                 Except
                    Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                    Exit;
                 End;
             End;
             Msg.Result:=HTCAPTION
        End Else
           Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
     End Else
        Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
End;

procedure TFrmSettings.SpdChangeForegroundClick(Sender: TObject);
begin
     DlgColor.Color:=ShpForeColor.Brush.Color;
     If DlgColor.Execute Then Begin
        ShpForeColor.Brush.Color:=DlgColor.Color;
        LblPreview.Font.Color:=DlgColor.Color;
     End;
end;

procedure TFrmSettings.SpdChangeBackgroundClick(Sender: TObject);
begin
     DlgColor.Color:=ShpBackColor.Brush.Color;
     If DlgColor.Execute Then Begin
        ShpBackColor.Brush.Color:=DlgColor.Color;
        LblPreview.Color:=DlgColor.Color;
     End;
end;

End.
