unit replaceform;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TFrmReplace = class(TForm)
    BtnOK: TButton;
    BtnCancel: TButton;
    BtnReplaceAll: TButton;
    LblFind: TLabel;
    EdtFind: TEdit;
    LblReplace: TLabel;
    EdtReplace: TEdit;
    GrpOptions: TGroupBox;
    ChkWholeWords: TCheckBox;
    ChkMatchCase: TCheckBox;
    ChkConfirm: TCheckBox;
    RdgStart: TRadioGroup;
    Bevel1: TBevel;
    procedure FormActivate(Sender: TObject);
    procedure EdtFindChange(Sender: TObject);
  private
    { Private-Deklarationen }
    Procedure WMNCHitTest(Var Msg: TMessage); Message WM_NCHITTEST;
  public
    { Public-Deklarationen }
  end;

var
  FrmReplace: TFrmReplace;

implementation

{$R *.DFM}

Uses
    Mainform;

procedure TFrmReplace.FormActivate(Sender: TObject);
begin
     EdtFind.SelStart:=0;
     EdtFind.SelLength:=Length(EdtFind.Text);
     EdtFind.SetFocus;
     EdtFindChange(Sender);
end;

procedure TFrmReplace.EdtFindChange(Sender: TObject);
begin
     If EdtFind.Text = '' Then BtnOK.Enabled:=False Else BtnOK.Enabled:=True;
end;


Procedure TFrmReplace.WMNCHitTest(Var Msg : TMessage);
Var
   i: Integer;
   r: TRect;
   ctrl: TControl;

Function LeftMouseButtonPressed: Boolean;
Begin
     If GetSystemMetrics(SM_SWAPBUTTON) = 0 Then
        Result:=(GetAsyncKeyState(VK_LBUTTON) < 0)
     Else
        Result:=(GetAsyncKeyState(VK_RBUTTON) < 0);
End;

Begin
     If Options.WindowClientDraggable And LeftMouseButtonPressed Then Begin
        If (Msg.LParamLo >= Self.ClientToScreen(Point(0, 0)).x) And
           (Msg.LParamHi >= Self.ClientToScreen(Point(0, 0)).y) And
           (Msg.LParamLo <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).x) And
           (Msg.LParamHi <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).y)
        Then Begin
             For i:=0 To Self.ComponentCount-1 Do Begin
                 Try
                    If Self.Components[i] Is TControl Then Begin
                       ctrl:=TControl(Self.Components[i]);
                       r:=ctrl.BoundsRect;
                       If (Msg.LParamLo >= Self.ClientToScreen(Point(r.Left, r.Top)).x) And
                          (Msg.LParamHi >= Self.ClientToScreen(Point(r.Left, r.Top)).y) And
                          (Msg.LParamLo <= Self.ClientToScreen(Point(r.Right, r.Bottom)).x) And
                          (Msg.LParamHi <= Self.ClientToScreen(Point(r.Right, r.Bottom)).y) And ctrl.Visible
                       Then Begin
                          Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                          Exit;
                       End;
                    End;
                 Except
                    Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                    Exit;
                 End;
             End;
             Msg.Result:=HTCAPTION
        End Else
           Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
     End Else
        Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
End;

end.
