unit quickviewform;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, JPEG, GIFImage, Menus, ImgList;

type
  TFrmQuickView = class(TForm)
    GraphicFile: TImage;
    TextFile: TRichEdit;
    Directory: TGroupBox;
    Label2: TLabel;
    LblSubDir: TLabel;
    Label3: TLabel;
    LblFiles: TLabel;
    LblSize: TLabel;
    Label4: TLabel;
    LblReadError: TLabel;
    QuickPop: TPopupMenu;
    QuickPopStretch: TMenuItem;
    N1: TMenuItem;
    QuickPopCopy: TMenuItem;
    QuickPopWordWrap: TMenuItem;
    QuickPopSelectAll: TMenuItem;
    QuickPopMaintainAspectRatio: TMenuItem;
    ImgQuickPop: TImageList;
    procedure GraphicFileMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure TextFileMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure LblReadErrorMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure DirectoryMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure QuickPopPopup(Sender: TObject);
    procedure QuickPopStretchClick(Sender: TObject);
    procedure QuickPopSelectAllClick(Sender: TObject);
    procedure QuickPopCopyClick(Sender: TObject);
    procedure QuickPopWordWrapClick(Sender: TObject);
    procedure Label4MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Label2MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Label3MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure LblSizeMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure LblSubDirMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure LblFilesMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure QuickPopMaintainAspectRatioClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private-Deklarationen }
    fFitToImage, fMaintainAspectRatio: Boolean;
    Procedure ApplyImageSettings;
    Procedure SetFitToImage(Value: Boolean);
    Procedure SetMaintainAspectRatio(Value: Boolean);
    Procedure WMNCHitTest(Var Msg: TMessage); Message WM_NCHITTEST;
  public
    { Public-Deklarationen }
    Property FitToImage: Boolean Read fFitToImage Write SetFitToImage;
    Property MaintainAspectRatio: Boolean  Read fMaintainAspectRatio Write SetMaintainAspectRatio;
    Procedure LoadFile(FileName: String; Side: Integer);
    Procedure AlignToFileList(Side: Longint);
  end;

var
  FrmQuickView: TFrmQuickView;

implementation

Uses
    MainForm;

{$R *.DFM}

Procedure TFrmQuickView.ApplyImageSettings;
Var
   FactorX, FactorY: Real;
   WasVisible: Boolean;
Begin
     GraphicFile.Top:=0;
     GraphicFile.Left:=0;
     WasVisible:=GraphicFile.Visible;
     GraphicFile.Visible:=False;
     If (GraphicFile.Picture.Width > 0) And (GraphicFile.Picture.Height > 0) Then Begin
        If FitToImage Then Begin
           If MaintainAspectRatio Then Begin
              GraphicFile.AutoSize:=False;
              GraphicFile.Top:=0;
              GraphicFile.Left:=0;
              GraphicFile.Align:=alNone;
              GraphicFile.Stretch:=False;
              FactorX:=ClientWidth / GraphicFile.Picture.Width;
              FactorY:=ClientHeight / GraphicFile.Picture.Height;
              If FactorX < FactorY Then Begin
                 GraphicFile.Width:=Round(GraphicFile.Picture.Width*FactorX);
                 GraphicFile.Height:=Round(GraphicFile.Picture.Height*FactorX);
              End Else Begin
                 GraphicFile.Width:=Round(GraphicFile.Picture.Width*FactorY);
                 GraphicFile.Height:=Round(GraphicFile.Picture.Height*FactorY);
              End;
              GraphicFile.Stretch:=True;
           End Else Begin
              GraphicFile.AutoSize:=False;
              GraphicFile.Align:=alClient;
              GraphicFile.Stretch:=True;
           End;
        End Else Begin
           GraphicFile.Stretch:=False;
           GraphicFile.Align:=alNone;
           GraphicFile.AutoSize:=True;
        End;
     End;
     If WasVisible Then GraphicFile.Visible:=True;
End;

Procedure TFrmQuickView.SetFitToImage;
Begin
     If Value <> fFitToImage Then Begin
        fFitToImage:=Value;
        ApplyImageSettings;
     End;
End;

Procedure TFrmQuickView.SetMaintainAspectRatio;
Begin
     If Value <> fMaintainAspectRatio Then Begin
        fMaintainAspectRatio:=Value;
        ApplyImageSettings;
     End;
End;

Procedure AllInvisible;
Begin
     With FrmQuickView Do Begin
          GraphicFile.Visible:=False;
          TextFile.Visible:=False;
          Directory.Visible:=False;
          LblReadError.Visible:=False;
     End;
End;

Procedure ReadError;
Begin
     With FrmQuickView Do Begin
          LblReadError.Top:=(ClientHeight Div 2) - (LblReadError.Height Div 2);
          LblReadError.Left:=(Clientwidth Div 2) - (LblReadError.Width Div 2);
          LblReadError.Visible:=True;
     End;
End;

Function LoadText(FileName: String): Boolean;
Begin
     Result:=False;
     Try
        FrmQuickView.TextFile.Lines.LoadFromFile(FileName);
     Except On EFOpenError Do Begin
               Exit;
            End;
     End;
     FrmQuickView.TextFile.Align:=alClient;
     FrmQuickView.TextFile.Visible:=True;
     Result:=True;
End;

Function LoadGraphic(FileName: String): Boolean;
Begin
     Result:=False;
        Try
           FrmQuickView.GraphicFile.Picture.LoadFromFile(FileName);
        Except
           Exit;
        End;
        FrmQuickView.ApplyImageSettings;
        FrmQuickView.GraphicFile.Visible:=True;
        Result:=True;
End;

Function LoadDirectory(FileName: String; Side: Longint): Boolean;
Var
   Size: Int64;
   FileNum, DirNum: Longint;
   Siz: String;
Begin
     Result:=False;
     DirInfo(True, True, False, Side, FileNum, DirNum, Size);
     FrmQuickView.LblSubDir.Caption:=Formatted(DirNum-1);
     FrmQuickView.LblFiles.Caption:=Formatted(FileNum);
     If Size >= 1024*1024*1024 Then Begin
        Str(Size/(1024*1024*1024):5:1,Siz);
        Siz:=Siz+' GB ('+Formatted(Size)+' Bytes)';
     End Else If Size >= 1024*1024 Then Begin
        Str(Size/(1024*1024):3:1,Siz);
        Siz:=Siz+' MB ('+Formatted(Size)+' Bytes)';
     End Else If Size >= 1024 Then Begin
        Str(Size/1024:3:1,Siz);
        Siz:=Siz+' KB ('+Formatted(Size)+' Bytes)';
     End Else Begin
        Siz:=Formatted(Size)+' Bytes';
     End;
     FrmQuickView.LblSize.Caption:=Siz;
     FrmQuickView.Directory.Align:=alClient;
     FrmQuickView.Directory.Visible:=True;
End;

Procedure TFrmQuickView.LoadFile;
Var
   FindData: TSearchRec;
   Result: Longint;
Begin
     AllInvisible;
     If FileName = '' Then Begin
        Caption:='QuickView';
        Exit;
     End;
     Caption:='QuickView - Inhalt von '+FileName;
     Result:=FindFirst(FileName,faAnyFile,FindData);
     If Result = 0 Then Begin
        If (FindData.Attr And faDirectory) = faDirectory Then Begin
           If Not LoadDirectory(FileName, Side) Then ReadError;
        End Else Begin
           If Not LoadGraphic(FileName) Then If Not LoadText(FileName) Then ReadError;
        End;
     End Else Begin
         ReadError;
     End;
     FindClose(FindData);
End;

Procedure TFrmQuickView.AlignToFileList;
Begin
     FrmQuickView.Left:=FrmMain.Lists[Side].ClientToScreen(FrmMain.Lists[Side].ClientRect.TopLeft).x;
     FrmQuickView.Top:=FrmMain.Lists[Side].ClientToScreen(FrmMain.Lists[Side].ClientRect.TopLeft).y;
     FrmQuickView.Width:=FrmMain.Lists[Side].ClientWidth;
     FrmQuickView.Height:=FrmMain.Lists[Side].ClientHeight;
End;

Procedure Flee(x, y: Longint; Ctrl: TControl);
Var
   xGlob, xGlobRightList: Longint;
Begin
     If FrmMain.OptionsQuickViewFlees.Checked Then Begin
        xGlob:=Ctrl.ClientToScreen(Point(x,y)).x;
        xGlobRightList:=FrmMain.Lists[RightList].ClientToScreen(Point(0,0)).x;
        If xGlobRightList > xGlob Then
           FrmQuickView.AlignToFileList(RightList)
        Else
           FrmQuickView.AlignToFileList(LeftList);
     End;
End;

procedure TFrmQuickView.GraphicFileMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
     Flee(x,y,GraphicFile);
end;

procedure TFrmQuickView.TextFileMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
     Flee(x,y,TextFile);
end;

procedure TFrmQuickView.FormMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
     Flee(x,y,Self);
end;

procedure TFrmQuickView.LblReadErrorMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
     Flee(x,y,LblReadError);
end;

procedure TFrmQuickView.DirectoryMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
     Flee(x,y,Directory);
end;

procedure TFrmQuickView.FormCreate(Sender: TObject);
begin
     AllInvisible;
end;

procedure TFrmQuickView.QuickPopPopup(Sender: TObject);
begin
     QuickPopStretch.Checked:=FitToImage;
     QuickPopMaintainAspectRatio.Checked:=MaintainAspectRatio;
     QuickPopWordWrap.Checked:=TextFile.WordWrap;
     If GraphicFile.Visible Then Begin
        QuickPopStretch.Enabled:=True;
        QuickPopMaintainAspectRatio.Enabled:=True;
        QuickPopCopy.Enabled:=False;
        QuickPopSelectAll.Enabled:=False;
        QuickPopWordWrap.Enabled:=False;
     End Else If TextFile.Visible Then Begin
        QuickPopStretch.Enabled:=False;
        QuickPopMaintainAspectRatio.Enabled:=False;
        If TextFile.SelLength > 0 Then QuickPopCopy.Enabled:=True Else QuickPopCopy.Enabled:=True;
        QuickPopSelectAll.Enabled:=True;
        QuickPopWordWrap.Enabled:=True;
     End;
end;

procedure TFrmQuickView.QuickPopStretchClick(Sender: TObject);
begin
     FitToImage:=Not FitToImage;
end;

procedure TFrmQuickView.QuickPopSelectAllClick(Sender: TObject);
begin
     TextFile.SelectAll;
end;

procedure TFrmQuickView.QuickPopCopyClick(Sender: TObject);
begin
     TextFile.CopyToClipBoard;
end;

procedure TFrmQuickView.QuickPopWordWrapClick(Sender: TObject);
begin
     QuickPopWordWrap.Checked:=Not QuickPopWordWrap.Checked;
     TextFile.WordWrap:=QuickPopWordWrap.Checked;
end;

procedure TFrmQuickView.Label4MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
     Flee(x,y,Label4);
end;

procedure TFrmQuickView.Label2MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
     Flee(x,y,Label2);
end;

procedure TFrmQuickView.Label3MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
     Flee(x,y,Label3);
end;

procedure TFrmQuickView.LblSizeMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
     Flee(x,y,LblSize);
end;

procedure TFrmQuickView.LblSubDirMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
     Flee(x,y,LblSubDir);
end;

procedure TFrmQuickView.LblFilesMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
     Flee(x,y,LblFiles);
end;

procedure TFrmQuickView.QuickPopMaintainAspectRatioClick(Sender: TObject);
begin
     MaintainAspectRatio:=Not MaintainAspectRatio;
end;

procedure TFrmQuickView.FormResize(Sender: TObject);
begin
     If (MaintainAspectRatio And FitToImage) Then
        ApplyImageSettings;
end;

Procedure TFrmQuickView.WMNCHitTest(Var Msg : TMessage);
Var
   i: Integer;
   r: TRect;
   ctrl: TControl;

Function LeftMouseButtonPressed: Boolean;
Begin
     If GetSystemMetrics(SM_SWAPBUTTON) = 0 Then
        Result:=(GetAsyncKeyState(VK_LBUTTON) < 0)
     Else
        Result:=(GetAsyncKeyState(VK_RBUTTON) < 0);
End;

Begin
     If Options.WindowClientDraggable And LeftMouseButtonPressed Then Begin
        If (Msg.LParamLo >= Self.ClientToScreen(Point(0, 0)).x) And
           (Msg.LParamHi >= Self.ClientToScreen(Point(0, 0)).y) And
           (Msg.LParamLo <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).x) And
           (Msg.LParamHi <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).y)
        Then Begin
             For i:=0 To Self.ComponentCount-1 Do Begin
                 Try
                    If Self.Components[i] Is TControl Then Begin
                       ctrl:=TControl(Self.Components[i]);
                       r:=ctrl.BoundsRect;
                       If (Msg.LParamLo >= Self.ClientToScreen(Point(r.Left, r.Top)).x) And
                          (Msg.LParamHi >= Self.ClientToScreen(Point(r.Left, r.Top)).y) And
                          (Msg.LParamLo <= Self.ClientToScreen(Point(r.Right, r.Bottom)).x) And
                          (Msg.LParamHi <= Self.ClientToScreen(Point(r.Right, r.Bottom)).y) And ctrl.Visible
                       Then Begin
                          Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                          Exit;
                       End;
                    End;
                 Except
                    Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                    Exit;
                 End;
             End;
             Msg.Result:=HTCAPTION
        End Else
           Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
     End Else
        Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
End;

end.
