Unit MainForm;

{

      Hauptformular von "eXec"
      Alles Wichtige ist in dieser Datei versammelt.

      Copyright  2000 by Jan Strter.

}

Interface

Uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtCtrls, StdCtrls, FileCtrl, Grids,
  Menus, Buttons, FMXUtils, CommCtrl, ToolWin, ShellApi, BJDrive,
  ShlObj, ActiveX, SearchDir, IniFiles, FormatDrive, StcTxtEx, ImgList;

Const
   IniFileName = 'eXec.ini';
   FilterListFilename = 'Filter.dat';
   HelpFilename = 'eXec.hlp';
   StartUpSection = 'STARTUP';
   WindowSection = 'WINDOW';
   ConfirmSection = 'CONFIRM';
   FilePanelsSection = 'FILEPANELS';
   ViewSection = 'VIEW';
   RecycleBinSection = 'RECYCLEBIN';
   TextEditSection = 'TEXTEDIT';
   DragDropSection = 'DRAGDROP';
   QuickViewSection = 'QUICKVIEW';
   MiscSection = 'MISC';
   EditorSection = 'EDITOR';
   EnhancedSection = 'ENHANCED';
   ColumnsWidthStandardSection = 'COLUMNSWIDTHSTANDARD';
   FileListSections: Array[0..1] Of String = ('LEFTLISTSETTINGS', 'RIGHTLISTSETTINGS');
   PathListSection = 'PATHLIST';
   BufSize = 262144; // 256 KB
   DefaultLinkText: String = 'Verknpfung mit ';
   SpecialChars = '\/*?:<>|"';
   WidthMulFac = 10000;
   exec_WNDCLASS = 'TApplication';
   exec_Caption = 'eXec 2.511';

  // Interfaces
  IID_IPersistFile: TGUID = (D1:$0000010B;D2:$0000;D3:$0000;D4:($C0,$00,$00,$00,$00,$00,$00,$46));

  // Konstanten fr Datei-Anzeige
  SortNone = 0;
  SortName = 1;
  SortExt = 2;
  SortSize = 3;
  SortDate = 4;
  SortPath = 5;
  SortDirUp   = 0;
  SortDirDown = 1;
  LeftList = 0;
  RightList = 1;
  dtFileList = 0;
  dtFindResult = 1;
  ccLowerCase = 0;
  ccUpperCase = 1;
  ccMixed = 2;
  ccMixedIfMSDOS = 3;
  ccAsStoredOnDisk = 4;
  uiStandardIcons = 0;
  uiSimpleIcons = 1;
  uiUserDefined = 2;
  ColumnName = 0;
  ColumnSize = 1;
  ColumnDate = 2;
  ColumnAttr = 3;
  ColumnName2 = 0;
  ColumnPath = 1;
  DirectoryImageIndex = 45;

  // Standard-Symbole
  siFile = 0;
  siApplication = 2;
  siDirectory = 3;
  siDirectoryOpen = 4;

  // Diverse Konstanten
  cmCopy = 0;
  cmMove = 1;
  MaxPaths = 63;
  MaxFilenames = 4095;
  MaxRecentDirListEntries = 15;
  PathTag = 1;
  StdPixelsPerInch = 96;
  StdMinWindowWidth = 500;
  StdMinWindowHeight = 250;
  LEFTLIST_MASK = 2147483648;
  RIGHTLIST_MASK = 1073741824;
  GETTAG_MASK = LEFTLIST_MASK+RIGHTLIST_MASK;

  // Drag&Drop-Konstanten
  MaxFormatEtc = 1;
  HDROP_FormatEtc = 0;
  IDList_FormatEtc = 1;
  MinXYDiff = 3;
  msNoDrag = 0;
  msLeftDrag = 1;
  msRightDrag = 2;
  MaxPIDL = 16383;
  saMove = 0;
  saCopy = 1;
  saCreateLinks = 2;

  // Hilfe-Topic-Konstanten (alph. sortiert)
  IDH_Author = 5;
  IDH_ConcatFile = 212;
  IDH_Contents = 0;
  IDH_DefFilter = 1000;
  IDH_DefWildcards = 1001;
  IDH_DivideFile = 211;
  IDH_EditPath = 2000;
  IDH_FileClearFindResult = 215;
  IDH_FileCopy = 204;
  IDH_FileCreateDir = 208;
  IDH_FileCreateLink = 213;
  IDH_FileDelete = 207;
  IDH_FileDivideUnite = 210;
  IDH_FileEditNewFile = 217;
  IDH_FileExecuteWithParam = 203;
  IDH_FileExit = 216;
  IDH_FileFindFile = 214;
  IDH_FileMove = 205;
  IDH_FileProperties = 200;
  IDH_FileQuickView = 201;
  IDH_FileRename = 206;
  IDH_FileSetAttr = 209;
  IDH_FileView = 202;
  IDH_HelpAbout = 703;
  IDH_HelpContents = 700;
  IDH_HelpListOfMenuItems = 702;
  IDH_HelpTheMainWindow = 701;
  IDH_IndexOfMenuItems = 3;
  IDH_License = 6;
  IDH_MediaConnectNetworkDrive = 504;
  IDH_MediaDisConnectNetworkDrive = 505;
  IDH_MediaDiskCopy = 501;
  IDH_MediaEmptyRecycleBin = 507;
  IDH_MediaFormat = 500;
  IDH_MediaInformation = 502;
  IDH_MediaLabel = 503;
  IDH_MediaShowRecycleBin = 506;
  IDH_MediaStartDefrag = 509;
  IDH_MediaStartScanDisk = 508;
  IDH_OptionsDefaultColumnsWidth = 610;
  IDH_OptionsDirectoryBar = 601;
  IDH_OptionsDriveBar = 600;
  IDH_OptionsFiftyFifty = 608;
  IDH_OptionsQuickView = 603;
  IDH_OptionsQuickViewFlees = 604;
  IDH_OptionsQuickViewSettingsMaintainAspectRatio = 606;
  IDH_OptionsQuickViewSettingsStretch = 605;
  IDH_OptionsQuickViewSettingsWordWrap = 607;
  IDH_OptionsSetColumnWidthAsStandard = 609;
  IDH_OptionsSettings = 611;
  IDH_OptionsCommandLineBar = 612;
  IDH_OptionsStatusBar = 602;
  IDH_PanelsBigSymbols = 103;
  IDH_PanelsDetailed = 106;
  IDH_PanelsDriveDir = 100;
  IDH_PanelsFilter = 101;
  IDH_PanelsList = 105;
  IDH_PanelsShowFileList = 113;
  IDH_PanelsShowFindResult = 114;
  IDH_PanelsSmallSymbols = 104;
  IDH_PanelsSortDate = 110;
  IDH_PanelsSortDir = 112;
  IDH_PanelsSortName = 107;
  IDH_PanelsSortPath = 111;
  IDH_PanelsSortSize = 109;
  IDH_PanelsSortType = 108;
  IDH_PanelsUpdate = 115;
  IDH_PanelsUseFilter = 102;
  IDH_PathAddToList = 400;
  IDH_PathAdjust = 407;
  IDH_PathDirBack = 402;
  IDH_PathDirForward = 403;
  IDH_PathDirList = 404;
  IDH_PathEditList = 401;
  IDH_PathGoTo = 406;
  IDH_PathRoot = 405;
  IDH_SaveFilter = 2001;
  IDH_SelectionCompareDirectories = 305;
  IDH_SelectionGroupSelect = 300;
  IDH_SelectionGroupUnselect = 301;
  IDH_SelectionInvert = 304;
  IDH_SelectionSelectAll = 302;
  IDH_SelectionSelectNone = 303;
  IDH_Thanx = 4;
  IDH_TheMainWindow = 2;
  IDH_WhatsNew = 1;

Type
  TLVDispInfo = Record
     Hdr: TNMHdr;
     Item: TLVItem;
  End;
  PLVDispInfo = ^TLVDispInfo;

  TLVNGetDispInfo = Record
     Msg: Cardinal;
     IDCtrl: Integer;
     NMHdr: PLVDispInfo;
     Result: Integer;
  End;

  TColumnsWidth = Record
     NameWidth, SizeWidth, DateWidth, AttrWidth, Name2Width, PathWidth: Longint;
  End;

  DataType = Record
     SortType: Longint;
     SortDir: Longint;
     ListType: Longint;
     QueryDataType, DataType: Longint;
     Width: Real;
     Directory: String;
     UseFilter: Boolean;
     Filter: TFilterRec;
     ColumnsWidth: TColumnsWidth;
  End;

  Dat = Record
      fPath: String[255];
      fName: String[255];
      fAttr: Longint;
      fTime: TFileTime;
      fSize: Longint;
      Icon: Longint;
      IconLoaded: Boolean;
      UpDir: Boolean;
  End;

  TOptions = Record
     RestoreDirectories: Boolean;
     StdDirLeft, StdDirRight: String;
     RestoreWindow: Boolean;
     ConfirmOverwrite, ConfirmDeleteFile, ConfirmDeleteDirectory, ConfirmExit: Boolean;
     SelectDirectories, ClearReadOnlyAttribute: Boolean;
     CharCase: Integer;
     SynchronizeColumnWidth: Boolean;
     ClickToRename: Boolean;
     ClickToOpen: Boolean;
     GridLines: Boolean;
     GhostHiddenFiles: Boolean;
     MarkDirectories: Boolean;
     UseIcons: Integer;
     usi_Harddisk, usi_FloppyDrive, usi_NetworkDrive, usi_CDROM, usi_Other: Boolean;
     Color, FontColor: TColor;
     FontName: String;
     FontStyles: TFontStyles;
     FontSize: Integer;
     UseRecycleBin: Boolean;
     UseInternalTextEdit: Boolean;
     ExternalTextEditPath: String;
     ExternalTextEditParams: String;
     ConfirmDDMove, ConfirmDDCopy, ConfirmDDCreateLinks: Boolean;
     DDStandardAction: Integer;
     WindowClientDraggable, PreventMultiInstances, UseDoubleBuffer: Boolean;
     CloseDOSWindowAfterExecution: Boolean;
  End;

  TEditorOptions = Record
     ShowToolBar,
     ShowStatusBar,
     WordWrap,
     FindTextAtCursor: Boolean;
  End;

  TPath = Record
     Path: String;
     ShortCut: TShortCut;
  End;

  TFileNamesList = Record
     FileNum: Integer;
     Files: Array[0..MaxFilenames] Of String;
  End;

  TRecentDirList = Record
     EntryNum, ActEntry: Integer;
     Entries: Array[0..MaxRecentDirListEntries] Of String;
  End;

  TMouseInfo = Record
     pt: TPoint;
     State: Integer;
  End;

  TDropTarget = Class(TInterfacedObject, IDropTarget)
  Private
     Side, HighlightedItem: Integer;
     DraggedWithRightButton: Boolean;
     Timer: TTimer;
     ScrollMargin: Integer;
     CursorPos: TPoint;
  Public
     wnd: THandle;
     ListView: TListView;
     Constructor Create(AOwner: TListView; ListNr: Integer);
     Destructor Destroy; Override;
     Procedure ShowDragPopUp(Const Effect: Longint; Const pt: TPoint);
     Procedure DoScroll(Sender: TObject);
     Function GetDragEffect(grfKeyState, dwEffect: Longint; ItemIndex: Integer): Longint;
     Function DragEnter(Const dataObj: IDataObject; grfKeyState: Longint; pt: TPoint; Var dwEffect: Longint): HResult; StdCall;
     Function DragOver(grfKeyState: Longint; pt: TPoint; Var dwEffect: Longint): HResult; StdCall;
     Function DragLeave: HResult; StdCall;
     Function Drop(Const dataObj: IDataObject; grfKeyState: Longint; pt: TPoint; var dwEffect: Longint): HResult; StdCall;
  End;

  TDataObject = Class(TInterfacedObject, IDataObject)
  Private
     IndexOfList: Integer;
  Public
     Constructor Create(Side: Integer);
     Function GetData(Const formatetc: TFormatEtc; Out medium: TStgMedium): HResult; StdCall;
     Function GetDataHere(Const formatetc: TFormatEtc; Out medium: TStgMedium): HResult; StdCall;
     Function QueryGetData(Const formatetc: TFormatEtc): HResult; StdCall;
     Function SetData(Const formatetc: TFormatEtc; Var medium: TStgMedium; fRelease: BOOL): HResult; StdCall;
     Function GetCanonicalFormatEtc(Const formatetcIn: TFormatEtc;   out formatetcOut: TFormatEtc): HResult; StdCall;
     Function EnumFormatEtc(dwDirection: Longint; Out enumFormatEtc: IEnumFormatEtc): HResult; StdCall;
     Function DAdvise(Const formatetc: TFormatEtc; advf: Longint; const advSink: IAdviseSink; out dwConnection: Longint): HResult; StdCall;
     Function DUnadvise(dwConnection: Longint): HResult; StdCall;
     Function EnumDAdvise(Out enumAdvise: IEnumStatData): HResult; StdCall;
  End;

  TDropSource = Class(TInterfacedObject, IDropSource)
  Private
     dataobj: TDataObject;
     LeftButtonDrag: Boolean;
     IndexOfList: Integer;
  Public
     DataObject: IDataObject;
     Constructor Create(Side: Integer);
     Function QueryContinueDrag(fEscapePressed: BOOL; grfKeyState: Longint): HResult; StdCall;
     Function GiveFeedback(dwEffect: Longint): HResult; StdCall;
  End;

  TEnumFormatEtc = Class(TInterfacedObject, IEnumFormatEtc)
  Private
     ActFormatEtc: Integer;
  Public
     Constructor Create;
     Function Next(celt: Longint; Out elt; pceltFetched: PLongint): HResult; StdCall;
     Function Skip(celt: Longint): HResult; StdCall;
     Function Reset: HResult; StdCall;
     Function Clone(Out Enum: IEnumFormatEtc): HResult; StdCall;
  End;

  TFetchSysIcons = Class(TThread)
  Private
     ListNum: Integer;
  Protected
     Procedure Execute; Override;
     Procedure Terminate;
  Public
     Constructor Create(Side: Integer);
     Destructor Destroy; Override;
  End;

  TFrmMain = Class(TForm)
    MnuMain: TMainMenu;
    MnuLeft: TMenuItem;
    MnuFile: TMenuItem;
    MnuSelection: TMenuItem;
    MnuRight: TMenuItem;
    LeftChangeDir: TMenuItem;
    LeftFilter: TMenuItem;
    LeftUseFilter: TMenuItem;
    LeftUpDate: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    RightChangeDir: TMenuItem;
    N3: TMenuItem;
    RightFilter: TMenuItem;
    RightUseFilter: TMenuItem;
    N4: TMenuItem;
    RightUpdate: TMenuItem;
    FileCopy: TMenuItem;
    FileMove: TMenuItem;
    FileDelete: TMenuItem;
    FileNewDirectory: TMenuItem;
    FileAttr: TMenuItem;
    SelectionGroup: TMenuItem;
    SelectionUnGroup: TMenuItem;
    N7: TMenuItem;
    SelectionAll: TMenuItem;
    SelectionNone: TMenuItem;
    SelectionInvert: TMenuItem;
    N8: TMenuItem;
    FileExit: TMenuItem;
    FileView: TMenuItem;
    N10: TMenuItem;
    FileRename: TMenuItem;
    MenuOptions: TMenuItem;
    OptionsDriveBar: TMenuItem;
    OptionsStatusBar: TMenuItem;
    N6: TMenuItem;
    OptionsSettings: TMenuItem;
    SplitThis: TSplitter;
    N14: TMenuItem;
    LeftSmallIcons: TMenuItem;
    LeftShort: TMenuItem;
    LeftReport: TMenuItem;
    N15: TMenuItem;
    LeftSortName: TMenuItem;
    LeftSortExt: TMenuItem;
    LeftSortSize: TMenuItem;
    LeftSortDate: TMenuItem;
    N16: TMenuItem;
    LeftSortDirUp: TMenuItem;
    LeftShowFileList: TMenuItem;
    N17: TMenuItem;
    RightIcons: TMenuItem;
    RightSmallIcons: TMenuItem;
    RightShort: TMenuItem;
    RightReport: TMenuItem;
    N18: TMenuItem;
    RightSortName: TMenuItem;
    RightSortExt: TMenuItem;
    RightSortSize: TMenuItem;
    RightSortDate: TMenuItem;
    N19: TMenuItem;
    RightSortDirUp: TMenuItem;
    N20: TMenuItem;
    RightShowFileList: TMenuItem;
    N21: TMenuItem;
    LeftIcons: TMenuItem;
    N22: TMenuItem;
    N23: TMenuItem;
    FileCreateLink: TMenuItem;
    FileProperties: TMenuItem;
    N24: TMenuItem;
    FileFind: TMenuItem;
    FileClearFindResult: TMenuItem;
    LeftShowFindResult: TMenuItem;
    RightShowFindResult: TMenuItem;
    MnuPath: TMenuItem;
    PathAdd: TMenuItem;
    PathEdit: TMenuItem;
    PathDivider: TMenuItem;
    N26: TMenuItem;
    PathRootDir: TMenuItem;
    PathGoTo: TMenuItem;
    N27: TMenuItem;
    OptionsFiftyFifty: TMenuItem;
    OptionsQuickView: TMenuItem;
    OptionsQuickViewFlees: TMenuItem;
    OptionsQuickViewSettings: TMenuItem;
    OptionsStretch: TMenuItem;
    OptionsWordWrap: TMenuItem;
    OptionsDefaultColumnsWidth: TMenuItem;
    StsBar: TStatusBar;
    PnlDriveBar: TPanel;
    CboDrive1: TBJDrive;
    SpdRootLeft: TSpeedButton;
    SpdStepBackLeft: TSpeedButton;
    CboDrive2: TBJDrive;
    SpdRootRight: TSpeedButton;
    SpdStepBackRight: TSpeedButton;
    BvlTopLine: TBevel;
    LstFiles: TListView;
    LstFiles2: TListView;
    TmrChangeNotification: TTimer;
    PopFiles: TPopupMenu;
    PopLists: TPopupMenu;
    PopSort: TMenuItem;
    N5: TMenuItem;
    PopIcons: TMenuItem;
    PopSmallIcons: TMenuItem;
    PopList: TMenuItem;
    PopReport: TMenuItem;
    N9: TMenuItem;
    PopShowFileList: TMenuItem;
    PopShowFindResult: TMenuItem;
    N11: TMenuItem;
    PopUpdate: TMenuItem;
    PopSortName: TMenuItem;
    PopSortExt: TMenuItem;
    PopSortSize: TMenuItem;
    PopSortDate: TMenuItem;
    N12: TMenuItem;
    PopSortDirUp: TMenuItem;
    PopView: TMenuItem;
    PopCopy: TMenuItem;
    PopMove: TMenuItem;
    PopRename: TMenuItem;
    PopDelete: TMenuItem;
    PopSetAttributes: TMenuItem;
    N13: TMenuItem;
    PopProperties: TMenuItem;
    N25: TMenuItem;
    SpdPathListLeft: TSpeedButton;
    SpdPathListRight: TSpeedButton;
    PopPathList: TPopupMenu;
    PathAdjust: TMenuItem;
    MnuMedia: TMenuItem;
    MediaFormat: TMenuItem;
    N28: TMenuItem;
    MediaInformation: TMenuItem;
    MediaRename: TMenuItem;
    PopDrag: TPopupMenu;
    PopMoveHere: TMenuItem;
    PopCopyHere: TMenuItem;
    PopCreateLinksHere: TMenuItem;
    PopLine1: TMenuItem;
    PopCancel: TMenuItem;
    MnuHelp: TMenuItem;
    HelpContents: TMenuItem;
    HelpAbout: TMenuItem;
    N30: TMenuItem;
    HelpListOfMenuItems: TMenuItem;
    N31: TMenuItem;
    OptionsMaintainAspectRatio: TMenuItem;
    N32: TMenuItem;
    MediaStartScanDisk: TMenuItem;
    MediaStartDefrag: TMenuItem;
    N29: TMenuItem;
    SelectionCompareDirectories: TMenuItem;
    HelpTheMainWindow: TMenuItem;
    MediaDiskCopy: TMenuItem;
    N33: TMenuItem;
    FileEditNewFile: TMenuItem;
    PopQuickView: TMenuItem;
    N34: TMenuItem;
    PopOpen: TMenuItem;
    FileQuickView: TMenuItem;
    FileDivideJoin: TMenuItem;
    PnlDirectoryBar: TPanel;
    BvlBetweenDriveAndDirectoryBar: TBevel;
    SpdUseFilterLeft: TSpeedButton;
    SpdUpdateBothLists: TSpeedButton;
    SpdUseFilterRight: TSpeedButton;
    OptionsDirectoryBar: TMenuItem;
    ImgSortDirUp: TImage;
    ImgSortDirDown: TImage;
    LeftSortPath: TMenuItem;
    RightSortPath: TMenuItem;
    PopSortPath: TMenuItem;
    Image1: TImage;
    OptionsSetColumnWidthAsStandard: TMenuItem;
    SpdDirBackLeft: TSpeedButton;
    SpdDirForwardLeft: TSpeedButton;
    SpdDirListLeft: TSpeedButton;
    SpdDirBackRight: TSpeedButton;
    SpdDirListRight: TSpeedButton;
    SpdDirForwardRight: TSpeedButton;
    PopRecentDirList: TPopupMenu;
    N35: TMenuItem;
    PathDirBack: TMenuItem;
    PathDirForward: TMenuItem;
    PathDirList: TMenuItem;
    N36: TMenuItem;
    ImgMenu: TImageList;
    PopChangeToThisDirectory: TMenuItem;
    N37: TMenuItem;
    MediaConncectNetworkDrive: TMenuItem;
    MediaDisconnectNetworkDrive: TMenuItem;
    N38: TMenuItem;
    FileExecuteWithParam: TMenuItem;
    N39: TMenuItem;
    PopExecuteWithParam: TMenuItem;
    OptionsCommandLineBar: TMenuItem;
    PnlCommandLineBar: TPanel;
    LblCommandLine: TLabel;
    CboCommandLine: TComboBox;
    PopCommandLine: TPopupMenu;
    PopCmdCut: TMenuItem;
    PopCmdCopy: TMenuItem;
    PopCmdPaste: TMenuItem;
    PopCmdDelete: TMenuItem;
    N41: TMenuItem;
    PopCmdInsertPath: TMenuItem;
    PopCmdInsertFilename: TMenuItem;
    PopCmdInsertPathAndFilename: TMenuItem;
    N42: TMenuItem;
    PopCmdCloseWindowAfterExecution: TMenuItem;
    ImgCommandLineMenu: TImageList;
    N40: TMenuItem;
    MediaShowRecycleBin: TMenuItem;
    MediaEmptyRecycleBin: TMenuItem;
    N43: TMenuItem;
    PopExplorerMenu: TMenuItem;
    Procedure FormShow(Sender: TObject);
    Procedure FormResize(Sender: TObject);
    Procedure LstFilesEnter(Sender: TObject);
    Procedure LstFiles2Enter(Sender: TObject);
    Procedure FileExitClick(Sender: TObject);
    Procedure CboDrive1Change(Sender: TObject);
    Procedure CboDrive2Change(Sender: TObject);
    Procedure LstFilesDblClick(Sender: TObject);
    Procedure LstFiles2DblClick(Sender: TObject);
    Procedure LstFilesKeyPress(Sender: TObject; Var Key: Char);
    Procedure LstFiles2KeyPress(Sender: TObject; Var Key: Char);
    Procedure SpdStepBackLeftClick(Sender: TObject);
    Procedure SpdStepBackRightClick(Sender: TObject);
    Procedure LeftUpDateClick(Sender: TObject);
    Procedure RightUpdateClick(Sender: TObject);
    Procedure LeftChangeDirClick(Sender: TObject);
    Procedure RightChangeDirClick(Sender: TObject);
    Procedure FormCreate(Sender: TObject);
    Procedure SelectionAllClick(Sender: TObject);
    Procedure SelectionNoneClick(Sender: TObject);
    Procedure SelectionInvertClick(Sender: TObject);
    Procedure SelectionGroupClick(Sender: TObject);
    Procedure SelectionUnGroupClick(Sender: TObject);
    Procedure FileViewClick(Sender: TObject);
    Procedure FileNewDirectoryClick(Sender: TObject);
    Procedure OptionsDriveBarClick(Sender: TObject);
    Procedure OptionsStatusBarClick(Sender: TObject);
    procedure FormClose(Sender: TObject; Var Action: TCloseAction);
    procedure OptionsSettingsClick(Sender: TObject);
    procedure FileAboutClick(Sender: TObject);
    procedure SplitThisMoved(Sender: TObject);
    procedure LstFilesCompare(Sender: TObject; Item1, Item2: TListItem;
      Data: Integer; var Compare: Integer);
    procedure LstFiles2Compare(Sender: TObject; Item1, Item2: TListItem;
      Data: Integer; var Compare: Integer);
    procedure MnuLeftClick(Sender: TObject);
    procedure MnuRightClick(Sender: TObject);
    procedure LeftReportClick(Sender: TObject);
    procedure RightReportClick(Sender: TObject);
    procedure LeftSortDateClick(Sender: TObject);
    procedure RightSortDateClick(Sender: TObject);
    procedure LeftSortDirUpClick(Sender: TObject);
    procedure RightSortDirUpClick(Sender: TObject);
    procedure MnuFileClick(Sender: TObject);
    procedure FileCreateLinkClick(Sender: TObject);
    procedure FileFindClick(Sender: TObject);
    procedure LeftShowFileListClick(Sender: TObject);
    procedure LeftShowFindResultClick(Sender: TObject);
    procedure RightShowFileListClick(Sender: TObject);
    procedure RightShowFindResultClick(Sender: TObject);
    procedure FileClearFindResultClick(Sender: TObject);
    procedure MnuPathClick(Sender: TObject);
    procedure PathEditClick(Sender: TObject);
    procedure PathRootDirClick(Sender: TObject);
    procedure PathGoToClick(Sender: TObject);
    procedure OptionsToggleFullscreenClick(Sender: TObject);
    procedure OptionsFiftyFiftyClick(Sender: TObject);
    procedure SpdRootLeftClick(Sender: TObject);
    procedure SpdRootRightClick(Sender: TObject);
    procedure CboDrive1Enter(Sender: TObject);
    procedure CboDrive2Enter(Sender: TObject);
    procedure OptionsQuickViewClick(Sender: TObject);
    procedure OptionsQuickViewFleesClick(Sender: TObject);
    procedure LstFilesClick(Sender: TObject);
    procedure LstFiles2Click(Sender: TObject);
    procedure MenuOptionsClick(Sender: TObject);
    procedure LstFilesKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure LstFiles2KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure OptionsStretchClick(Sender: TObject);
    procedure OptionsWordWrapClick(Sender: TObject);
    procedure LstFilesColumnClick(Sender: TObject; Column: TListColumn);
    procedure LstFiles2ColumnClick(Sender: TObject; Column: TListColumn);
    procedure OptionsDefaultColumnsWidthClick(Sender: TObject);
    procedure LeftFilterClick(Sender: TObject);
    procedure RightFilterClick(Sender: TObject);
    procedure LeftUseFilterClick(Sender: TObject);
    procedure RightUseFilterClick(Sender: TObject);
    procedure TmrChangeNotificationTimer(Sender: TObject);
    procedure FileCopyClick(Sender: TObject);
    procedure FileMoveClick(Sender: TObject);
    procedure FileDeleteClick(Sender: TObject);
    procedure PopListsPopup(Sender: TObject);
    procedure LstFilesMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure PopReportClick(Sender: TObject);
    procedure PopSortDateClick(Sender: TObject);
    procedure PopShowFileListClick(Sender: TObject);
    procedure PopShowFindResultClick(Sender: TObject);
    procedure PopUpdateClick(Sender: TObject);
    procedure PopSortDirUpClick(Sender: TObject);
    procedure LstFilesEdited(Sender: TObject; Item: TListItem;
      var S: String);
    procedure LstFiles2Edited(Sender: TObject; Item: TListItem;
      var S: String);
    procedure FileRenameClick(Sender: TObject);
    procedure FileAttrClick(Sender: TObject);
    procedure PopCopyClick(Sender: TObject);
    procedure PopMoveClick(Sender: TObject);
    procedure PopRenameClick(Sender: TObject);
    procedure PopDeleteClick(Sender: TObject);
    procedure PopSetAttributesClick(Sender: TObject);
    procedure FilePropertiesClick(Sender: TObject);
    procedure PopPropertiesClick(Sender: TObject);
    procedure PopViewClick(Sender: TObject);
    procedure PathAddClick(Sender: TObject);
    procedure SpdPathListLeftClick(Sender: TObject);
    procedure PopPathListPopup(Sender: TObject);
    procedure SpdPathListRightClick(Sender: TObject);
    procedure PathAdjustClick(Sender: TObject);
    procedure MediaFormatClick(Sender: TObject);
    procedure PopFilesPopup(Sender: TObject);
    procedure MediaInformationClick(Sender: TObject);
    procedure MediaRenameClick(Sender: TObject);
    procedure LstFilesKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure LstFiles2KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure LstFilesMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FileCompareDirectoriesClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure OptionsMaintainAspectRatioClick(Sender: TObject);
    procedure MediaStartScanDiskClick(Sender: TObject);
    procedure MediaStartDefragClick(Sender: TObject);
    procedure HelpContentsClick(Sender: TObject);
    procedure HelpTheMainWindowClick(Sender: TObject);
    procedure HelpListOfMenuItemsClick(Sender: TObject);
    procedure LstFilesContextPopup(Sender: TObject; MousePos: TPoint;
      var Handled: Boolean);
    procedure LstFiles2ContextPopup(Sender: TObject; MousePos: TPoint;
      var Handled: Boolean);
    procedure FormDestroy(Sender: TObject);
    procedure LstFilesMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure LstFilesInfoTip(Sender: TObject; Item: TListItem;
      var InfoTip: String);
    procedure LstFiles2InfoTip(Sender: TObject; Item: TListItem;
      var InfoTip: String);
    procedure MediaDiskCopyClick(Sender: TObject);
    procedure FileEditNewFileClick(Sender: TObject);
    procedure PopOpenClick(Sender: TObject);
    procedure PopQuickViewClick(Sender: TObject);
    procedure FileQuickViewClick(Sender: TObject);
    procedure FileDivideJoinClick(Sender: TObject);
    procedure PopMoveHereClick(Sender: TObject);
    procedure PopCopyHereClick(Sender: TObject);
    procedure PopCreateLinksHereClick(Sender: TObject);
    procedure LblDirectoryLeftClick(Sender: TObject);
    procedure LblDirectoryRightClick(Sender: TObject);
    procedure OptionsDirectoryBarClick(Sender: TObject);
    procedure SpdUpdateBothListsClick(Sender: TObject);
    procedure OptionsSetColumnWidthAsStandardClick(Sender: TObject);
    procedure SpdDirBackLeftClick(Sender: TObject);
    procedure SpdDirForwardLeftClick(Sender: TObject);
    procedure SpdDirBackRightClick(Sender: TObject);
    procedure SpdDirForwardRightClick(Sender: TObject);
    procedure SpdDirListLeftClick(Sender: TObject);
    procedure SpdDirListRightClick(Sender: TObject);
    procedure PathDirBackClick(Sender: TObject);
    procedure PathDirForwardClick(Sender: TObject);
    procedure MnuSelectionClick(Sender: TObject);
    procedure PopChangeToThisDirectoryClick(Sender: TObject);
    procedure MediaConncectNetworkDriveClick(Sender: TObject);
    procedure MediaDisconnectNetworkDriveClick(Sender: TObject);
    procedure FileExecuteWithParamClick(Sender: TObject);
    procedure PopExecuteWithParamClick(Sender: TObject);
    procedure LstFilesEditing(Sender: TObject; Item: TListItem;
      var AllowEdit: Boolean);
    procedure LstFiles2Editing(Sender: TObject; Item: TListItem;
      var AllowEdit: Boolean);
    procedure LstFilesSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure LstFiles2SelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure OptionsCommandLineBarClick(Sender: TObject);
    procedure PnlCommandLineBarResize(Sender: TObject);
    procedure PopCmdCutClick(Sender: TObject);
    procedure PopCmdCopyClick(Sender: TObject);
    procedure PopCmdPasteClick(Sender: TObject);
    procedure PopCmdDeleteClick(Sender: TObject);
    procedure PopCommandLinePopup(Sender: TObject);
    procedure PopCmdInsertPathClick(Sender: TObject);
    procedure PopCmdInsertFilenameClick(Sender: TObject);
    procedure PopCmdInsertPathAndFilenameClick(Sender: TObject);
    procedure PopCmdCloseWindowAfterExecutionClick(Sender: TObject);
    procedure CboCommandLineKeyPress(Sender: TObject; var Key: Char);
    procedure MediaShowRecycleBinClick(Sender: TObject);
    procedure MediaEmptyRecycleBinClick(Sender: TObject);
    procedure PopExplorerMenuClick(Sender: TObject);
  private
    { Private-Deklarationen }
    Procedure WMDeviceChange(Var Message: TMessage); Message WM_DEVICECHANGE;
    Procedure WMNotify(Var Message: TLVNGetDispInfo); Message WM_NOTIFY;
    Procedure WMGetMinMaxInfo(var Message: TWMGetMinMaxInfo); Message WM_GETMINMAXINFO;
    Procedure ETATime(Sender: TObject);
    Procedure ClearList(List: Integer);
    Procedure WMHelp(Var Message: TWMHelp); Message WM_HELP;
  public
    { Public-Deklarationen }
    LblDirectoryLeft, LblDirectoryRight: TStaticTextEx;
    Lists: Array[0..1] Of TListView;
    FetchSysIconsThreads: Array[0..1] Of TFetchSysIcons;
    ThreadTerminated: Array[0..1] Of Boolean;
    DriveLists: Array[0..1] Of TBJDrive;
    ChangeNotificationHandlers: Array[0..1] Of THandle;
    DrpTargetDummies: Array[0..1] Of TDropTarget;
    DrpTargets: Array[0..1] Of IDropTarget;
    DrpSourceDummies: Array[0..1] Of TDropSource;
    DrpSources: Array[0..1] Of IDropSource;
    MouseInfos: Array[0..1] Of TMouseInfo;
    RecentDirLists: Array[0..1] Of TRecentDirList;
    Busy: Integer;
    PathNum: Integer;
    Paths: Array[0..MaxPaths] Of TPath;
    TmpSide: Integer;
    DragSourceSide: Integer;
    DragTargetPath: String;
    MinWindowSize: TPoint;
    LogPixels: TPoint;
    OleInitialized: Boolean;
    SavedWindowState: TWindowState;
    ExplorerMenu: Record
       Side: Integer;
       p: TPoint;
    End;
    // Dateien einlesen
    Procedure ReadFindResult(Side: Longint; Lst: TListView);
    Procedure ReadDirectory(Side: Longint; LV: TListView);
    Procedure GetSysIcon(ItemData: Pointer; Side: Integer);
    // Change-Notification
    Procedure BeginBusy;
    Procedure EndBusy;
    Procedure UpdateChangeNotificationHandler(Side: Integer);
    Procedure StopChangeNotification(Side: Integer);
    Procedure ApplicationActivate(Sender: TObject);
    Procedure ApplicationDeactivate(Sender: TObject);
    Procedure UpdateList(Side: Integer);
    Procedure UpdateLists;
    // Pfadliste
    Procedure PathDoesNotExist(Dir: String);
    Procedure AddPath(Path: String; ShortCut: TShortCut);
    Procedure AddPathPopup(Sender: TObject);
    Procedure AddPathsToPathMenu;
    Procedure RemovePathsFromPathMenu;
    Procedure ChangeToPath(Sender: TObject);
    Procedure ChangeToPathPopup(Sender: TObject);
    Procedure SortPathList;
    // Einstellungen
    Procedure GetOptions;
    Procedure SetOptions;
    Procedure SaveOptions;
    Procedure LoadOptions;
    // Verlaufslisten
    Procedure AddRecentDirEntry(Const Dir: String; Side: Integer);
    Procedure GoToRecentDirEntry(Index, Side: Integer);
    Procedure GotoLastRecentDirEntry(Side: Integer);
    Procedure GotoNextRecentDirEntry(Side: Integer);
    Procedure ClearRecentDirList(Side: Integer);
    Procedure RemoveRecentDirEntry(Index, Side: Integer);
    Procedure UpdateRecentDirButtons(Side: Integer);
    Procedure AddRecentDirListToPopupMenu(Menu: TPopUpMenu; AutoClear: Boolean; Side: Integer);
    Procedure AddRecentDirListToMenuItem(Menu: TMenuItem; AutoClear: Boolean; Side: Integer);
    Procedure ChangeToRecentDir(Sender: TObject);
    // Andere
    Procedure ViewTextFile(Filename: String);
    Procedure ShowTheHint(Sender: TObject);
    Procedure ShowMediaInformation(Drive: Char);
    Function GetFileInfo(Item: TListItem; Side: Integer): String;
    Procedure OLEDragDrop(Side: Integer; LeftButton: Boolean);
    Procedure UpdateDirectoryBar;
    Procedure ResizeDirectoryBar;
    Procedure ResizeFileWindows;
    Procedure UpdateCommandLineBar;
    Procedure ResizeCommandLineBar;
    Procedure CorrectBars;
    Procedure UpdateColumnHeaderImagesSide(Side: Integer);
    Procedure UpdateColumnHeaderImages;
    Procedure ApplyDefaultColumnsWidth(Side: Integer);
    Procedure SetListFocus(Side: Longint);
    Procedure SelectAll(Side: Integer);
    Procedure SelectNone(Side: Integer);
    Procedure InvertSelection(Side: Integer);
    Procedure ExecuteWithParam(Side: Integer);
    Procedure SetDoubleBuffering;
    Procedure ExecuteCommandLine;
    Procedure ShowExplorerMenu(Side: Integer; p: TPoint);
  End;

Procedure SetUpUseSimpleIcons(Drive: Char; List: Integer);
Function DeleteCharFromString(Const s: String; ch: Char): String;
Procedure CallBackFiles(Side: Integer; TheSD: TSearchDirectory; CallBack: TSearchDirectoryCallBack; CallBacks: Integer; Filter: TFilterRec; OnlyFocused, UseFilter, Recursive: Boolean);
Procedure DirInfo(OnlyFocused, Recursive, UseFilter: Boolean; Side: Longint; Var FileNum, SubDirs: Longint; Var SizeInBytes: Int64);
Procedure DirInfoEx(OnlyFocused, Recursive, UseFilter: Boolean; Side: Longint; Var FileNum, SubDirs: Integer; Var SizeInBytes: Int64; Var SysFiles, HiddenFiles, ReadOnlyFiles, ArchiveFiles: Longint);
Procedure UpDateDir(Side: Longint);
Procedure APIError;
Function BrowseDir(Title: String; Handle: HWND): String;
Function CreateLink(LinkName, Path, Description: String): Boolean;
Function Formatted(Zahl: Int64): String;
Function DirectoryExists(Directory: String): Boolean;
Function CopyFile(Source, Dest: String; SourceSize: Integer; AllFilesSize: Int64; Var Progress: Int64): Integer;
Function ExecFile(Filename: String): Boolean;
Function RenameFile(Const SourceDir, DestDir: String): Boolean;
Function ValidDataFormat(DataObj: IDataObject): Boolean;
Procedure AddFilenameToList(Filename: String);
Procedure ClearFilenamesList;
Function GetFilenamesFromDataObject(DataObj: IDataObject): Boolean;
Function GetFilenames_IDLIST(DataObj: IDataObject): Boolean;
Function GetFilenames_HDROP(DataObj: IDataObject): Boolean;
Function GetMappedFilenames_FILENAMEMAP(DataObj: IDataObject): Boolean;
Procedure FreeDropData;
Function CreateData_IDLIST(Var output: TStgMedium; AllocateMemory: Boolean; Const fmt: TFormatEtc; Side: Integer): HResult;
Function CreateData_HDROP(Var output: TStgMedium; AllocateMemory: Boolean; Const fmt: TFormatEtc; Side: Integer): HResult;
Function CreateData(Var output: TStgMedium; AllocateMemory: Boolean; Const fmt: TFormatEtc; Side: Integer): HResult;
Function DragDropCopyFile(Source, Dest: String; SourceSize: Integer): Integer;
Function DragDropCopyMove(Target: String; Action: Integer): Boolean;
Function DragDropCreateLinks(Target: String): Boolean;
Function RecycleFile(s: String): Boolean;
Function DeleteDirectory(Filename: String): Boolean;
Function IsDirectoryEmpty(Dir: String): Boolean;
Function PathExists(Path: String; CreateIfNotExist: Boolean): Boolean;
Function DelFile(FileName: String): Boolean;
Function Kill(Const s: String): Boolean;
Function GetLastErrorString: String;
Function GetDiskFreeBytes(RootDir: String): Int64;

Var
   FrmMain: TFrmMain;
   verInfo: TOSVERSIONINFO;
   ProgPath: String;
   Options: TOptions;
   EditorOptions: TEditorOptions;
   DesktopItemIdList: PItemIdList;
   SysImageListSmall, SysImageListLarge: HImageList;
   UseSimpleIcons: Array[0..1] Of Boolean;
   Canceled, OverwriteAll, Overwrite, DeleteAll, DontRemoveEmptyDirectories: Boolean;
   CopyOnlyNewFiles, AlwaysOverwriteOldFiles: Boolean;
   Data: Array[0..1] Of DataType;
   ColumnsWidthStandard: TColumnsWidth;
   CurrentList: Longint;
   SD, SDDirInfo, SDCopyMove, SDDelete, SDAttributes: TSearchDirectory;
   FilterAllFiles: TFilterRec;
   DIFileNum, DISubDirs, DIObjNum: Integer;
   DISizeInBytes, AllFilesSize, Progress: Int64;
   DISysFiles, DIHiddenFiles, DIReadOnlyFiles, DIArchiveFiles: Integer;
   SourceDir, DestDir, MappedDestDir: String;
   cmAction: Integer;
   OleInitialized: Boolean;
   OldTickCount: Integer;
   CurrentTickCount: Integer;
   ETA: TTimer;
   ClearReadOnly: Boolean;
   DontDrag: Boolean;
   ValidDataFormatFound: Boolean;
   FilenamesList, MappedFilenamesList: TFilenamesList;
   UseMappedFilenames: Boolean;
   DropData: TStgMedium;
   DropTargetDir: String;
   FORMATETCs: Array[0..MaxFormatEtc] Of TFormatEtc;
   FILENAMEMAP_FormatEtc: TFormatEtc;
   CF_IDLIST, CF_FILENAMEMAP: Cardinal;
   ForceLabelEditing: Boolean;
   WinIsOSR2: Boolean;

Implementation

Uses FormDrive, SelForm, aboutform, formprog1, formprog2, newdirform,
     attrstatusform, settingsform, createlinkform, findfileform,
     EditPathListForm, GoToForm, quickviewform, FilterForm, CopyMoveForm,
     DeleteForm, SetAttrForm, TextEditForm, FormatForm,
     MediaInformationForm, RenameMediaForm, LinkForm,
     ProgDragDropForm, DivideFileForm, CompareDirectoriesForm,
     ExecuteWithParamForm, ConcatFileForm;

{$R *.DFM}

Procedure TFrmMain.WMHelp;
Begin
     With Message Do Begin
          If HelpInfo.iContextType <> HELPINFO_WINDOW Then Inherited;
     End;
End;

Function GetLastErrorString: String;
Var
   s: Array[0..1023] Of Char;
Begin
     FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, Nil, GetLastError(), GetSystemDefaultLangID, s, 1023, Nil);
     Result:=String(s);
End;

Procedure TFrmMain.SetDoubleBuffering;
Var
   i: Integer;
Begin
     FrmMain.DoubleBuffered:=Options.UseDoubleBuffer;
     For i:=0 To 1 Do Lists[i].DoubleBuffered:=Options.UseDoubleBuffer;
End;

Function GetDiskFreeBytes;
Var
   BytesPerSector, SectorsPerCluster, FreeClusters, TotalClusters: Cardinal;
   FreeAvail, TotalBytes, TotalFree: Int64;
Begin
     TotalFree:=0;
     If WinIsOSR2 Then Begin
        GetDiskFreeSpaceEx(PChar(RootDir), FreeAvail, TotalBytes, @TotalFree);
     End Else Begin
        GetDiskFreeSpace(PChar(RootDir), SectorsPerCluster, BytesPerSector, FreeClusters, TotalClusters);
        TotalFree:=LongWord(BytesPerSector);
        TotalFree:=TotalFree*LongWord(SectorsPerCluster);
        TotalFree:=TotalFree*LongWord(FreeClusters);
     End;
     Result:=TotalFree;
End;

Function FormattedComp(Zahl: Int64): String;
Var
   s: String;
   i: Byte;
   counter: Byte;
Begin
     Str(Zahl:20,s);
     s:=Trim(s);
     Counter:=0;
     For i:=Length(s) DownTo 1 Do Begin
         Inc(Counter);
         If Counter >= 3 Then Begin
            If i > 1 Then Begin
               Insert('.',s,i);
               Counter:=0;
            End;
         End;
     End;
     Result:=s;
End;

Function BytesToString(Bytes: Int64): String;
Var
   s: String;
Begin
     If Bytes >= 1024*1024*1024 Then Begin
        Str(Bytes/(1024*1024*1024):3:2, s);
        s:=s+' GB ('+FormattedComp(Bytes)+' Bytes)';
     End Else If Bytes >= 1024*1024 Then Begin
        Str(Bytes/(1024*1024):3:2, s);
        s:=s+' MB ('+FormattedComp(Bytes)+' Bytes)';
     End Else If Bytes >= 1024 Then Begin
        Str(Bytes/1024:3:2, s);
        s:=s+' KB ('+FormattedComp(Bytes)+' Bytes)';
     End Else
        s:=FormattedComp(Bytes)+' Bytes';
     Result:=s;
End;

Procedure SetUpUseSimpleIcons;
Var
   DriveType: Longint;
Begin
     Case Options.UseIcons Of
          uiStandardIcons: UseSimpleIcons[List]:=False;
          uiSimpleIcons: UseSimpleIcons[List]:=True;
          uiUserDefined:
             Begin
                  DriveType:=GetDriveType(PChar(Drive+':\'));
                  Case DriveType Of
                       DRIVE_REMOVABLE: UseSimpleIcons[List]:=Options.usi_FloppyDrive;
                       DRIVE_FIXED: UseSimpleIcons[List]:=Options.usi_Harddisk;
                       DRIVE_REMOTE: UseSimpleIcons[List]:=Options.usi_NetworkDrive;
                       DRIVE_CDROM: UseSimpleIcons[List]:=Options.usi_CDROM;
                       Else UseSimpleIcons[List]:=Options.usi_Other;
                  End;
             End;
     End;
End;

Procedure TFrmMain.ClearList;
Var
   i: Integer;
Begin
     If (Not ThreadTerminated[List]) And Assigned(FetchSysIconsThreads[List]) Then Begin
        FetchSysIconsThreads[List].Terminate;
        FetchSysIconsThreads[List].WaitFor;
     End;
     For i:=0 To Lists[List].Items.Count-1 Do Begin
         FreeMem(Lists[List].Items[i].Data, SizeOf(Dat));
     End;
     Lists[List].Items.Clear;
End;

Function RenameFile;
Begin
     // Ein wenig umstndlich, aber mit MoveFileEx klappt es aus irgendeinem Grund nicht!
     If ExpandFileName(SourceDir)[1] = ExpandFilename(DestDir)[1] Then
        Result:=(Longint(Windows.MoveFile(PChar(SourceDir), PChar(DestDir))) <> 0)
     Else
        Result:=False;
End;

Function DirectoryExists;
Begin
     {$I-}
     ChDir(Directory);
     Result:=(IOResult = 0);
End;

Procedure TFrmMain.BeginBusy;
Begin
     Inc(Busy);
End;

Procedure TFrmMain.EndBusy;
Begin
     Dec(Busy);
     If Busy < 0 Then Busy:=0;
End;

Procedure TFrmMain.ApplicationActivate;
Begin
     TmrChangeNotification.Enabled:=True;
     TmrChangeNotificationTimer(Sender);
End;

Procedure TFrmMain.ApplicationDeactivate;
Begin
     TmrChangeNotification.Enabled:=False;
End;

Procedure TFrmMain.WMGetMinMaxInfo;
Begin
     With Message.MinMaxInfo^ Do Begin
          ptMinTrackSize.x:=MinWindowSize.x;
          ptMinTrackSize.y:=MinWindowSize.y;
     End;
End;

Procedure TFrmMain.StopChangeNotification;
Begin
     If ChangeNotificationHandlers[Side] <> INVALID_HANDLE_VALUE Then Begin
        FindCloseChangeNotification(ChangeNotificationHandlers[Side]);
        ChangeNotificationHandlers[Side]:=INVALID_HANDLE_VALUE;
     End;
End;

Procedure TFrmMain.UpdateChangeNotificationHandler;
Var
   Tmp: String;
Begin
     StopChangeNotification(Side);
     Tmp:=Data[Side].Directory;
     If Length(Tmp) = 2 Then Tmp:=Tmp+'\';
     ChangeNotificationHandlers[Side]:=FindFirstChangeNotification(PChar(Tmp), LongBool(False),
        FILE_NOTIFY_CHANGE_FILE_NAME+
        FILE_NOTIFY_CHANGE_DIR_NAME+
        FILE_NOTIFY_CHANGE_ATTRIBUTES+
        FILE_NOTIFY_CHANGE_SIZE+
        FILE_NOTIFY_CHANGE_LAST_WRITE);
End;

Procedure TFrmMain.UpdateList;
Begin
     If Busy = 0 Then Begin
        If ChangeNotificationHandlers[Side] <> INVALID_HANDLE_VALUE Then
           If WaitForSingleObject(ChangeNotificationHandlers[Side], 0) = WAIT_OBJECT_0 Then
              UpdateDir(Side);
     End;
End;

procedure TFrmMain.TmrChangeNotificationTimer(Sender: TObject);
Var
   i: Integer;
begin
     For i:=0 To 1 Do Begin
         UpdateList(i);
     End;
end;

Procedure TFrmMain.UpdateLists;
Begin
     TmrChangeNotificationTimer(Nil);
End;

Procedure APIError;
Begin
     MessageDlg('Fehler beim Aufruf einer Windows-API Funktion.',mtError,[mbOK],0);
End;

Function BrowseDir;
Var
   BrowseInfo: TBrowseInfo;
   DisplayName: Array[0..MAX_PATH] Of Char;
   Pansen: PItemIDList;
   Alloc: IMAlloc;
Begin
     with BrowseInfo do begin
          hWndOwner:=Handle;
          pidlRoot:=Nil;
          pszDisplayName:=DisplayName;
          lpszTitle:=PChar(Title);
          ulFlags:=BIF_RETURNONLYFSDIRS;
          lpfn:=nil;
          lParam:=0;
     end;
     Pansen:=SHBrowseForFolder(BrowseInfo);
     If Pansen = Nil Then Begin
        Result:='';
        Exit;
     End;
     Result:='';
     If SHGetPathFromIDList(Pansen,DisplayName) = True Then
        Result:=String(DisplayName)
     Else APIError;
     SHGetMalloc(Alloc);
     Alloc._AddRef;
     Alloc.Free(Pansen);
     Alloc._Release;
End;

Function Formatted(Zahl: Int64): String;
Var
   s: String;
   i: Byte;
   counter: Byte;
Begin
     Str(Zahl:20,s);
     s:=TrimLeft(s);
     Counter:=0;
     For i:=Length(s) DownTo 1 Do Begin
         Inc(Counter);
         If Counter >= 3 Then Begin
            If i > 1 Then Begin
               Insert('.',s,i);
               Counter:=0;
            End;
         End;
     End;
     formatted:=s;
End;

Function GetFullName(ItemData: Pointer; Side: Integer): String;
Begin
     With Dat(ItemData^) Do Begin
          If Length(fPath) = 0 Then
             Result:=Data[Side].Directory+'\'+fName
          Else
             Result:=fPath+fName;
     End;
End;

Function GetPath(ItemData: Pointer; Side: Integer): String;
Begin
     With Dat(ItemData^) Do Begin
          If Length(fPath) = 0 Then
             Result:=Data[Side].Directory+'\'
          Else
             Result:=fPath;
     End;
End;

Function GetName(ItemData: Pointer; Side: Integer): String;
Begin
     With Dat(ItemData^) Do Begin
          Result:=fName;
     End;
End;

Procedure CallBackFiles;
Var
   i, count: Integer;
   item: TLVItem;

Procedure Call(ptr: Pointer);
Var
   FindData: TWin32FindData;
   FindHandle: THandle;
Begin
     FindHandle:=FindFirstFile(PChar(GetFullName(ptr, Side)), FindData);
     If FindHandle <> INVALID_HANDLE_VALUE Then Begin
        If ((FindData.dwFileAttributes And faDirectory) > 0) And Recursive Then Begin
           If ((CallBacks And cbBeforeRecurse) > 0) Then CallBack(GetPath(ptr, Side), FindData, ctEnteringDir);
           TheSD.Canceled:=False;
           TheSD.CallBack:=CallBack;
           If UseFilter Then
              TheSD.Search(GetFullName(ptr, Side)+'\', Filter, True, True)
           Else
              TheSD.Search(GetFullName(ptr, Side)+'\', FilterAllFiles, True, True);
           If ((CallBacks And cbAfterRecurse) > 0) Then CallBack(GetPath(ptr, Side), FindData, ctLeavingDir);
        End Else CallBack(GetPath(ptr, Side), FindData, ctNormal);
        Windows.FindClose(FindHandle);
     End;
End;

Begin
     With FrmMain Do Begin

          TheSD.CallBacks:=CallBacks;
          TheSD.Canceled:=False;

          count:=Lists[Side].Items.Count-1;

          If count < 0 Then Exit;

          If OnlyFocused Then Begin

             If Lists[Side].ItemFocused = Nil Then Exit;
             Call(Lists[Side].ItemFocused.Data);

          End Else Begin

             For i:=0 To count Do Begin

                 item.iItem:=i;
                 item.iSubItem:=0;
                 item.mask:=LVIF_STATE Or LVIF_PARAM;
                 item.stateMask:=LVIS_SELECTED;
                 ListView_GetItem(Lists[Side].Handle, item);

                 If (item.state And LVIS_SELECTED) = LVIS_SELECTED Then Begin
                    Call(TListItem(Pointer(item.lParam)).Data);
                 End;

                 If TheSD.Canceled Then Begin
                    Exit;
                 End;

             End;

          End;

     End;
End;

Procedure TFrmMain.GetSysIcon;
Var
   fi: TSHFILEINFO;
   ext: String;
Begin
     With Dat(ItemData^) Do Begin
          If Not IconLoaded Then Begin
             If UseSimpleIcons[Side] Then Begin
                If (Dat(ItemData^).fAttr And faDirectory) <> 0 Then Begin
                   Icon:=siDirectory;
                   IconLoaded:=True;
                End Else Begin
                   ext:=AnsiUpperCase(ExtractFileExt(Dat(ItemData^).fName));
                   If (ext = '.EXE') Or (ext = '.COM') Or (ext = '.BAT') Or (ext = '.PIF') Then
                      Icon:=siApplication
                   Else
                      Icon:=siFile;
                   IconLoaded:=True;
                End;
             End Else Begin
                FI.iIcon:=-1;
                SHGetFileInfo(PChar(GetFullName(ItemData, Side)), 0, FI, SizeOf(FI), SHGFI_SYSICONINDEX);
                If FI.iIcon <= 0 Then Begin
                   If (Dat(ItemData^).fAttr And faDirectory) <> 0 Then
                      SHGetFileInfo(PChar(GetFullName(ItemData, Side)), FILE_ATTRIBUTE_DIRECTORY, FI, SizeOf(FI), SHGFI_SYSICONINDEX Or SHGFI_USEFILEATTRIBUTES)
                   Else
                      SHGetFileInfo(PChar(GetFullName(ItemData, Side)), FILE_ATTRIBUTE_NORMAL, FI, SizeOf(FI), SHGFI_SYSICONINDEX Or SHGFI_USEFILEATTRIBUTES);
                End;
                If FI.iIcon >= 0 Then Begin
                   Icon:=FI.iIcon;
                End Else Begin
                   Icon:=0;
                End;
                IconLoaded:=True;
             End;
          End;
     End;
End;

Procedure TFrmMain.WMNotify;
Var
   i: Integer;
   ptr: Pointer;
Begin
     Inherited;
     Case Message.NMHdr.Hdr.code Of
          LVN_GETDISPINFO:
             Begin
                  If Message.NMHdr.Hdr.hwndFrom = LstFiles.Handle Then Begin
                     If Message.NMHdr.Item.iSubItem = 0 Then Begin
                        If (Message.NMHdr.Item.Mask And LVIF_IMAGE) <> 0 Then Begin
                           ptr:=TListItem(Pointer(Message.NMHdr.item.lParam)).Data;
                           If Dat(ptr^).IconLoaded Then
                              Message.NMHdr.Item.iImage:=Dat(ptr^).Icon
                           Else Begin
                              Try
                                 GetSysIcon(ptr, LeftList);
                                 Message.NMHdr.Item.iImage:=Dat(ptr^).Icon;
                                 Message.NMHdr.Item.Mask:=Message.NMHdr.Item.Mask Or LVIF_DI_SETITEM;
                              Except
                                 On EAccessViolation Do Begin
                                    Exit;
                                 End;
                              End;
                           End;
                        End;
                     End;
                  End Else If Message.NMHdr.Hdr.hwndFrom = LstFiles2.Handle Then Begin
                     If Message.NMHdr.Item.iSubItem = 0 Then With Dat(LstFiles2.Items[Message.NMHdr.Item.iItem].Data^) Do Begin
                        If (Message.NMHdr.Item.Mask And LVIF_IMAGE) <> 0 Then Begin
                           ptr:=TListItem(Pointer(Message.NMHdr.item.lParam)).Data;
                           If Dat(ptr^).IconLoaded Then
                              Message.NMHdr.Item.iImage:=Dat(ptr^).Icon
                           Else Begin
                              Try
                                 GetSysIcon(ptr, RightList);
                                 Message.NMHdr.Item.iImage:=Dat(ptr^).Icon;
                                 Message.NMHdr.Item.Mask:=Message.NMHdr.Item.Mask Or LVIF_DI_SETITEM;
                              Except
                                 On EAccessViolation Do Begin
                                    Exit;
                                 End;
                              End;
                           End;
                        End;
                     End;
                  End;
                  Exit;
             End;
          HDN_ENDTRACK, HDN_ENDTRACKW, HDN_DIVIDERDBLCLICK, HDN_DIVIDERDBLCLICKW:
             Begin
                  If Message.NMHdr.Hdr.hwndFrom = GetDlgItem(LstFiles.Handle, 0) Then Begin
                     If Options.SynchronizeColumnWidth Then Begin
                        If Data[LeftList].DataType = Data[RightList].DataType Then Begin
                           LstFiles2.Columns.BeginUpdate;
                           For i:=0 To LstFiles.Columns.Count-1 Do
                               LstFiles2.Columns[i].Width:=ListView_GetColumnWidth(LstFiles.Handle, i);
                           LstFiles2.Columns.EndUpdate;
                        End;
                     End;
                     UpdateColumnHeaderImages;
                  End Else If Message.NMHdr.Hdr.hwndFrom = GetDlgItem(LstFiles2.Handle, 0) Then Begin
                     If Options.SynchronizeColumnWidth Then Begin
                        If Data[LeftList].DataType = Data[RightList].DataType Then Begin
                           LstFiles.Columns.BeginUpdate;
                           For i:=0 To LstFiles2.Columns.Count-1 Do
                               LstFiles.Columns[i].Width:=ListView_GetColumnWidth(LstFiles2.Handle, i);
                           LstFiles.Columns.EndUpdate;
                        End;
                     End;
                     UpdateColumnHeaderImages;
                  End;
                  Exit;
             End;
     End;
End;

Function  AttrToString(Attr: Longint): String;
Begin
     Result:='----';
     If (Attr And faReadOnly) > 0 Then Result[1]:='R';
     If (Attr And faSysFile) > 0 Then Result[2]:='S';
     If (Attr And faHidden) > 0 Then Result[3]:='H';
     If (Attr And faArchive) > 0 Then Result[4]:='A';
End;

Procedure TwoCharNumber(Num: Longint; Var Stri: ShortString);
Begin
     Str(Num,Stri);
     If Length(Stri) = 1 Then Stri:='0'+Stri;
End;

Function Stri(i: Longint): String;
Var
   Txt: String;
Begin
     Str(i,Txt);
     Stri:=Txt;
End;

Function GetFilename(Const fd: TWin32FindData): String;
Begin
     Case Options.CharCase Of
          ccLowerCase: Result:=AnsiLowerCase(String(fd.cFilename));
          ccUpperCase: Result:=AnsiUpperCase(String(fd.cFilename));
          ccMixed: Result:=AnsiUpperCase(String(fd.cFileName[0]))+AnsiLowerCase(String(@fd.cFileName[1]));
          ccMixedIfMSDOS:
             Begin
                  If fd.cAlternateFileName = '' Then
                     Result:=fd.cFileName[0]+AnsiLowerCase(String(@fd.cFileName[1]))
                  Else
                     Result:=fd.cFileName;
             End;
          ccAsStoredOndisk: Result:=String(fd.cFilename);
     End;
End;

Procedure AddFileToLeftList(Const Path: String; Const FindData: TWin32FindData; CallBackType: Integer);
Var
   NewItem: TListItem;
   Dummy: Pointer;
   LocalFT: TFiletime;
   ST: TSystemTime;
   Year, Month, Day, Hour, Min: String[2];
Begin
     With FrmMain Do Begin
          NewItem:=LstFiles.Items.Add;
          GetMem(Dummy, SizeOf(Dat));
          NewItem.Data:=Dummy;
          With Dat(Dummy^) Do Begin
               fPath:=Path;
               fName:=String(FindData.cFileName);
               fAttr:=FindData.dwFileAttributes;
               fSize:=FindData.nFileSizeLow;
               FileTimeToLocalFileTime(FindData.ftLastWriteTime, LocalFT);
               fTime:=LocalFT;
               IconLoaded:=False;
               UpDir:=False;
               If Options.GhostHiddenFiles Then If (fAttr And faHidden) = faHidden Then NewItem.Cut:=True;
          End;
          NewItem.Caption:=GetFilename(FindData);
          If (FindData.dwFileAttributes And faDirectory) <> 0 Then Begin
             If Options.MarkDirectories Then
                NewItem.SubItems.Add('>SUB-DIR<')
             Else
                Newitem.SubItems.Add('');
          End Else
             NewItem.SubItems.Add(Formatted(FindData.nFileSizeLow));
          FileTimeToSystemTime(LocalFT, ST);
          TwoCharNumber(ST.wYear Mod 100,Year);
          TwoCharNumber(ST.wMonth,Month);
          TwoCharNumber(ST.wDay,Day);
          TwoCharNumber(ST.wHour,Hour);
          TwoCharNumber(ST.wMinute,Min);
          NewItem.SubItems.Add(Day+'.'+Month+'.'+Year+' '+Hour+':'+Min);
          NewItem.SubItems.Add(AttrToString(FindData.dwFileAttributes));
     End;
End;

Procedure AddFileToRightList(Const Path: String; Const FindData: TWin32FindData; CallBackType: Integer);
Var
   NewItem: TListItem;
   Dummy: Pointer;
   LocalFT: TFiletime;
   ST: TSystemTime;
   Year, Month, Day, Hour, Min: String[2];
Begin
     With FrmMain Do Begin
          NewItem:=LstFiles2.Items.Add;
          GetMem(Dummy, SizeOf(Dat));
          NewItem.Data:=Dummy;
          With Dat(Dummy^) Do Begin
               fPath:=Path;
               fName:=String(FindData.cFileName);
               fAttr:=FindData.dwFileAttributes;
               fSize:=FindData.nFileSizeLow;
               FileTimeToLocalFileTime(FindData.ftLastWriteTime, LocalFT);
               fTime:=LocalFT;
               IconLoaded:=False;
               UpDir:=False;
               If Options.GhostHiddenFiles Then If (fAttr And faHidden) = faHidden Then NewItem.Cut:=True;
          End;
          NewItem.Caption:=GetFilename(FindData);
          If (FindData.dwFileAttributes And faDirectory) <> 0 Then Begin
             If Options.MarkDirectories Then
                NewItem.SubItems.Add('>SUB-DIR<')
             Else
                Newitem.SubItems.Add('');
          End Else
             NewItem.SubItems.Add(Formatted(FindData.nFileSizeLow));
          FileTimeToSystemTime(LocalFT, ST);
          TwoCharNumber(ST.wYear Mod 100,Year);
          TwoCharNumber(ST.wMonth,Month);
          TwoCharNumber(ST.wDay,Day);
          TwoCharNumber(ST.wHour,Hour);
          TwoCharNumber(ST.wMinute,Min);
          NewItem.SubItems.Add(Day+'.'+Month+'.'+Year+' '+Hour+':'+Min);
          NewItem.SubItems.Add(AttrToString(FindData.dwFileAttributes));
     End;
End;

Procedure ReadColumnsWidth(Side: Longint);
Begin
     With Data[Side], FrmMain.Lists[Side] Do Begin
          Case DataType Of
               dtFileList:
                  Begin
                       ColumnsWidth.NameWidth:=Columns[ColumnName].Width;
                       ColumnsWidth.SizeWidth:=Columns[ColumnSize].Width;
                       ColumnsWidth.DateWidth:=Columns[ColumnDate].Width;
                       ColumnsWidth.AttrWidth:=Columns[ColumnAttr].Width;
                  End;
               dtFindResult:
                  Begin
                       ColumnsWidth.Name2Width:=Columns[ColumnName2].Width;
                       ColumnsWidth.PathWidth:=Columns[ColumnPath].Width;
                  End;
          End;
     End;
End;

Procedure ReadDefaultColumnsWidth;
Begin
     With ColumnsWidthStandard, FrmMain.Lists[CurrentList], Data[CurrentList] Do Begin
          Case DataType Of
               dtFileList:
                  Begin
                       NameWidth:=Columns[ColumnName].Width;
                       SizeWidth:=Columns[ColumnSize].Width;
                       DateWidth:=Columns[ColumnDate].Width;
                       AttrWidth:=Columns[ColumnAttr].Width;
                  End;
               dtFindResult:
                  Begin
                       Name2Width:=Columns[ColumnName2].Width;
                       PathWidth:=Columns[ColumnPath].Width;
                  End;
          End;
     End;
End;

Procedure SetDefaultColumnsWidth(Side: Longint);
Begin
     With Data[Side].ColumnsWidth Do Begin
          NameWidth:=ColumnsWidthStandard.NameWidth;
          SizeWidth:=ColumnsWidthStandard.SizeWidth;
          AttrWidth:=ColumnsWidthStandard.AttrWidth;
          DateWidth:=ColumnsWidthStandard.DateWidth;
          Name2Width:=ColumnsWidthStandard.Name2Width;
          PathWidth:=ColumnsWidthStandard.PathWidth;
     End;
End;

Procedure QuickView(Item: TListItem; Side: Integer);
Begin
     If FrmQuickView.Visible And (Item <> Nil) Then Begin
        If (Not Dat(Item.Data^).UpDir) Then
           FrmQuickView.LoadFile(GetFullName(Item.Data, Side),Side);
     End;
End;

Procedure TFrmMain.ReadDirectory;
Var
   NewColumn: TListColumn;
   NewItem: TListItem;
   FI: TSHFileInfo;
   DataPtr: Pointer;
   SizeStr: String;
   FreeSpace: Int64;
Begin
     If Busy > 0 Then Exit;
     Try
        BeginBusy;
        SetUpUseSimpleIcons(Data[Side].Directory[1], Side);
        Screen.Cursor:=crHourGlass;
        LV.Items.BeginUpdate;
        ClearList(Side);
        // Falls Sortierung nach Pfad, auf Sortierung nach Namen setzen.
        If Data[Side].SortType = SortPath Then
           Data[Side].SortType:=SortName;
        // berschriften anpassen
        If Data[Side].DataType <> dtFileList Then Begin
           ReadColumnsWidth(Side);
           LV.Columns.Clear;
           NewColumn:=LV.Columns.Add;
           NewColumn.Caption:='Name';
           NewColumn.Width:=Data[Side].ColumnsWidth.NameWidth;
           NewColumn:=LV.Columns.Add;
           NewColumn.Caption:='Gre';
           NewColumn.Width:=Data[Side].ColumnsWidth.SizeWidth;
           NewColumn:=LV.Columns.Add;
           NewColumn.Caption:='Gendert';
           NewColumn.Width:=Data[Side].ColumnsWidth.DateWidth;
           NewColumn:=LV.Columns.Add;
           NewColumn.Caption:='Attr.';
           NewColumn.Width:=Data[Side].ColumnsWidth.AttrWidth;
           Data[Side].DataType:=dtFileList;
        End;
        // Ggf. bergeordnetes Verz. hinzufgen
        If Length(Data[Side].Directory) > 2 Then Begin
           NewItem:=LV.Items.Add;
           NewItem.Caption:='..';
           If UseSimpleIcons[Side] Then
              FI.iIcon:=siDirectoryOpen
           Else Begin
              FI.iIcon:=-1;
              SHGetFileInfo(PChar(Data[Side].Directory), 0, FI, SizeOf(FI), SHGFI_SYSICONINDEX Or SHGFI_OPENICON);
              If FI.iIcon < 0 Then
                 SHGetFileInfo(PChar(Data[Side].Directory), FILE_ATTRIBUTE_DIRECTORY, FI, SizeOf(FI), SHGFI_USEFILEATTRIBUTES Or SHGFI_SYSICONINDEX Or SHGFI_OPENICON);
              If FI.iIcon < 0 Then
                 FI.iIcon:=siDirectoryOpen;
           End;
           If Options.MarkDirectories Then
              NewItem.SubItems.Add('>UP-DIR<')
           Else
              NewItem.SubItems.Add('');
           GetMem(DataPtr,SizeOf(Dat));
           NewItem.Data:=DataPtr;
           With Dat(DataPtr^) Do Begin
                fPath:=Data[Side].Directory+'\';
                fName:='..';
                fAttr:=faDirectory;
                fSize:=0;
                FillChar(fTime,SizeOf(TFileTime),#0);
                Icon:=FI.iIcon;
                IconLoaded:=True;
                UpDir:=True;
           End;
        End;
        // Callback-Prozedur laden
        If Side = LeftList Then
           SD.CallBack:=AddFileToLeftList
        Else
           SD.CallBack:=AddFileToRightList;
        // Dateien einlesen
        SD.CallBacks:=cbBeforeRecurse;
        SD.Canceled:=False;
        SD.ProcessMessages:=False;
        If Data[Side].UseFilter Then
           SD.Search(Data[Side].Directory+'\', Data[Side].Filter, False, True)
        Else
           SD.Search(Data[Side].Directory+'\', FilterAllFiles, False, True);

        If (Not ThreadTerminated[Side]) And Assigned(FetchSysIconsThreads[Side]) Then Begin
           FetchSysIconsThreads[Side].Terminate;
           FetchSysIconsThreads[Side].WaitFor;
        End;
        FetchSysIconsThreads[Side]:=TFetchSysIcons.Create(Side);
        AddRecentDirentry(Data[Side].Directory, Side);
        FreeSpace:=GetDiskFreeBytes(Data[Side].Directory[1]+':\');
        SizeStr:=BytesToString(FreeSpace);
        SizeStr:=Trim(SizeStr);
        If FreeSpace >= 1024*1024*1024 Then Begin
           Str(FreeSpace/LongWord(1024*1024*1024):3:2, SizeStr);
           SizeStr:=SizeStr+' GB frei';
        End Else If FreeSpace >= 1024*1024 Then Begin
           Str(FreeSpace/LongWord(1024*1024):3:1, SizeStr);
           SizeStr:=SizeStr+' MB frei';
        End Else If FreeSpace >= 1024 Then Begin
           Str(FreeSpace/LongWord(1024):3:1, SizeStr);
           SizeStr:=SizeStr+' KB frei';
        End Else
           SizeStr:=FormattedComp(FreeSpace)+' Bytes frei';
        If Data[Side].UseFilter Then Begin
           StsBar.Panels[Side].Text:=SizeStr+', Filter aktiv';
        End Else
           StsBar.Panels[Side].Text:=SizeStr;

     Finally
        LV.Items.EndUpdate;
        UpdateDirectoryBar;
        UpdateColumnHeaderImagesSide(Side);
        UpdateCommandLineBar;
        Screen.Cursor:=crDefault;
        EndBusy;
     End;
End;


Procedure TFrmMain.ReadFindResult;
Var
   i: Longint;
   NewItem: TListItem;
   NewColumn: TListColumn;
   FileInfo: TSearchRec;
   Dummy: Pointer;
Begin
     If Busy > 0 Then Exit;

     Try
        BeginBusy;
        Screen.Cursor:=crHourGlass;
        Lst.Items.BeginUpdate;

        // Liste lschen
//        Lst.Items.Clear;
        ClearList(Side);

        // Listenberschrift anpassen
        If Data[Side].DataType <> dtFindResult Then Begin
           ReadColumnsWidth(Side);
           Lst.Columns.Clear;
           NewColumn:=Lst.Columns.Add;
           NewColumn.Caption:='Name';
           NewColumn.Width:=Data[Side].ColumnsWidth.Name2Width;
           NewColumn:=Lst.Columns.Add;
           NewColumn.Caption:='Pfad';
           NewColumn.Width:=Data[Side].ColumnsWidth.PathWidth;
           Data[Side].DataType:=dtFindResult;
        End;
        UpdateRecentDirButtons(Side);

        If FrmFindFile.LstResult.Items.Count > 0 Then With FrmFindFile.LstResult Do Begin
           SetUpUseSimpleIcons(Items[0].SubItems[0][1], Side);
           // Liste fllen
           For i:=0 To Items.Count - 1 Do Begin
               If FindFirst(Items[i].SubItems[0]+Items[i].Caption,faAnyFile,FileInfo) = 0 Then Begin
                  NewItem:=Lst.Items.Add;
                  NewItem.Caption:=GetFilename(FileInfo.FindData);
                  NewItem.SubItems.Add(Items[i].SubItems[0]);
                  GetMem(Dummy,SizeOf(Dat));
                  NewItem.Data:=Dummy;
                  With Dat(NewItem.Data^) Do Begin
                       fName:=FileInfo.Name;
                       fAttr:=FileInfo.Attr;
                       fSize:=FileInfo.Size;
                       fPath:=NewItem.SubItems[0];
                       fTime:=FileInfo.FindData.ftLastWriteTime;
                       IconLoaded:=False;
                       UpDir:=False;
                  End;
               End;
               FindClose(FileInfo);
           End;
        End;

        If (Not ThreadTerminated[Side]) And Assigned(FetchSysIconsThreads[Side]) Then Begin
           FetchSysIconsThreads[Side].Terminate;
           FetchSysIconsThreads[Side].WaitFor;
        End;
        FetchSysIconsThreads[Side]:=TFetchSysIcons.Create(Side);

     Finally
        StsBar.Panels[Side].Text:='';
        UpdateDirectoryBar;
        Lst.Items.EndUpdate;
        Screen.Cursor:=crDefault;
        UpdateColumnHeaderImagesSide(Side);
        EndBusy;
     End;
End;

Procedure UpDateDir(Side: Longint);
{Var
   SizeStr: String;
   FreeSpace: Int64;}
Begin
     With Data[Side], FrmMain Do Begin
          If Not DirectoryExists(Directory+'\') Then Begin
             Directory:=ProgPath[1]+':';
             DriveLists[Side].Drive:=ProgPath[1];
          End;
          Case QueryDataType Of
               dtFileList:
                  Begin
                       ReadDirectory(Side, Lists[Side]);
{                       FreeSpace:=GetDiskFreeBytes(Data[Side].Directory[1]+':\');
                       SizeStr:=BytesToString(FreeSpace);
                       SizeStr:=Trim(SizeStr);
                       If FreeSpace >= 1024*1024*1024 Then Begin
                          Str(FreeSpace/LongWord(1024*1024*1024):3:2, SizeStr);
                          SizeStr:=SizeStr+' GB frei';
                       End Else If FreeSpace >= 1024*1024 Then Begin
                          Str(FreeSpace/LongWord(1024*1024):3:1, SizeStr);
                          SizeStr:=SizeStr+' MB frei';
                       End Else If FreeSpace >= 1024 Then Begin
                          Str(FreeSpace/LongWord(1024):3:1, SizeStr);
                          SizeStr:=SizeStr+' KB frei';
                       End Else
                          SizeStr:=FormattedComp(FreeSpace)+' Bytes frei';
                    If Data[Side].UseFilter Then Begin
                          StsBar.Panels[Side].Text:=SizeStr+', Filter aktiv';
                       End Else
                          StsBar.Panels[Side].Text:=SizeStr;}
                       FrmMain.UpdateChangeNotificationHandler(Side);
                  End;
               dtFindResult:
                  Begin
                       ReadFindResult(Side,Lists[Side]);
//                       StsBar.Panels[Side].Text:='';
                       FrmMain.StopChangeNotification(Side);
                  End;
          End;
          UpdateDirectoryBar;
     End;
End;

Procedure TFrmMain.CorrectBars;
Begin
     If (PnlDriveBar.Visible And PnlDirectoryBar.Visible) Then Begin
        If PnlDriveBar.Top > 0 Then Begin
           PnlDriveBar.Align:=alNone;
           PnlDirectoryBar.Align:=alNone;
           PnlDriveBar.Top:=0;
           PnlDirectoryBar.Top:=PnlDriveBar.Height;
           PnlDriveBar.Align:=alTop;
           PnlDirectoryBar.Align:=alTop;
        End;
     End;
     If (PnlCommandLineBar.Visible And StsBar.Visible) Then Begin
        If StsBar.Top < PnlCommandLineBar.Top Then Begin
           StsBar.Align:=alNone;
           PnlCommandLineBar.Align:=alNone;
           PnlCommandLineBar.Top:=ClientHeight - StsBar.Height - PnlCommandLineBar.Height;
           StsBar.Top:=ClientHeight - StsBar.Height;
           StsBar.Align:=alBottom;
           PnlCommandLineBar.Align:=alBottom;
        End;
     End;
End;

Procedure TFrmMain.UpdateDirectoryBar;
Begin
     Case Data[LeftList].DataType Of
          dtFileList: LblDirectoryLeft.Caption:=Data[LeftList].Directory+'\';
          dtFindResult: LblDirectoryLeft.Caption:='Suchergebnis';
     End;
     Case Data[RightList].DataType Of
          dtFileList: LblDirectoryRight.Caption:=Data[RightList].Directory+'\';
          dtFindResult: LblDirectoryRight.Caption:='Suchergebnis';
     End;
     SpdUseFilterLeft.Down:=Data[LeftList].UseFilter;
     SpdUseFilterRight.Down:=Data[RightList].UseFilter;
     Case CurrentList Of
          LeftList:
             Begin
                  LblDirectoryLeft.Down:=True;
                  LblDirectoryRight.Down:=False;
             End;
          RightList:
             Begin
                  LblDirectoryLeft.Down:=False;
                  LblDirectoryRight.Down:=True;
             End;
     End;
End;

Procedure TFrmMain.ResizeDirectoryBar;
Var
   CenteredTop: Integer;
   CenteredLeft: Integer;
   ButtonWidth: Integer;
Begin
     ButtonWidth:=SpdUseFilterLeft.Width+SpdUseFilterRight.Width+SpdUpdateBothLists.Width;
     CenteredTop:=((PnlDirectoryBar.ClientHeight - BvlBetweenDriveAndDirectoryBar.Height - SpdUseFilterLeft.Height) Div 2) + BvlBetweenDriveAndDirectoryBar.Height;
     CenteredLeft:=Round(PnlDirectoryBar.ClientWidth * Data[LeftList].Width) - (ButtonWidth Div 2);

     LblDirectoryLeft.Left:=1;
     LblDirectoryLeft.Top:=BvlBetweenDriveAndDirectoryBar.Height + 1;
     LblDirectoryLeft.Height:=PnlDirectoryBar.ClientHeight-LblDirectoryLeft.Top-1;
     LblDirectoryLeft.Width:=CenteredLeft-LblDirectoryLeft.Left-1;

     LblDirectoryRight.Left:=CenteredLeft+ButtonWidth+2;
     LblDirectoryRight.Top:=LblDirectoryLeft.Top;
     LblDirectoryRight.Height:=LblDirectoryLeft.Height;
     LblDirectoryRight.Width:=PnlDirectoryBar.ClientWidth - LblDirectoryRight.Left - 1;

     SpdUseFilterLeft.Top:=CenteredTop;
     SpdUseFilterLeft.Left:=CenteredLeft;
     SpdUpdateBothLists.Top:=CenteredTop;
     SpdUpdateBothLists.Left:=SpdUseFilterLeft.Left+SpdUseFilterLeft.Width;
     SpdUseFilterRight.Top:=CenteredTop;
     SpdUseFilterRight.Left:=SpdUpdateBothLists.Left+SpdUpdateBothLists.Width;
End;

Procedure TFrmMain.ResizeFileWindows;
Begin
     // Laufwerkslisten
     DriveLists[1].Left:=PnlDriveBar.ClientWidth-DriveLists[1].Width-DriveLists[0].Left;
     // Speed-Buttons
     SpdDirForwardRight.Left:=DriveLists[1].Left-SpdDirForwardRight.Width-3;
     SpdDirListRight.Left:=SpdDirForwardRight.Left-SpdDirListRight.Width;
     SpdDirBackRight.Left:=SpdDirListRight.Left-SpdDirBackRight.Width;
     SpdStepBackRight.Left:=SpdDirBackRight.Left-SpdStepBackRight.Width;
     SpdRootRight.Left:=SpdStepBackRight.Left-SpdRootRight.Width;
     SpdPathListRight.Left:=SpdRootRight.Left-SpdPathListRight.Width;
     // Statusleiste
     StsBar.Panels[0].Width:=LstFiles.Width;
     // Verzeichnis-Leiste
     ResizeDirectoryBar;
End;

procedure TFrmMain.SplitThisMoved(Sender: TObject);
begin
     Data[0].Width:=Lists[0].Width/(FrmMain.ClientWidth-SplitThis.Width);
     Data[1].Width:=1-Data[0].Width;
     ReSizeFileWindows;
end;

Procedure TFrmMain.FormResize(Sender: TObject);
Begin
     If Data[0].Width = 0 Then Data[0].Width:=0.5;
     LstFiles.Width:=Round(Data[0].Width*(FrmMain.ClientWidth - SplitThis.Width));
     ResizeFileWindows;
End;

Procedure InitProgram;
Var
   i: Integer;
   FileInfo: TSHFileInfo;
   Dummy: HResult;
   ShowSettingsAfterStartUp: Boolean;
Begin
     // Feststellen der System-Bilderlisten und des Desktop-Icons:
     SHGetSpecialFolderLocation(FrmMain.Handle, CSIDL_DESKTOP, DesktopItemIdList);
     SysImageListSmall:=SHGetFileInfo(PChar(DesktopItemIdList), 0, FileInfo, SizeOf(FileInfo),
                                      SHGFI_PIDL Or SHGFI_SYSICONINDEX Or SHGFI_SMALLICON);
     SysImageListLarge:=SHGetFileInfo(PChar(DesktopItemIdList), 0, FileInfo, SizeOf(FileInfo),
                                      SHGFI_PIDL Or SHGFI_SYSICONINDEX);
     // Verbinden der Views mit den Systembilderlisten:
     ListView_SetImageList(FrmMain.LstFiles.Handle, SysImageListLarge, LVSIL_NORMAL);
     ListView_SetImageList(FrmMain.LstFiles.Handle, SysImageListSmall, LVSIL_NORMAL Or LVSIL_SMALL);
     ListView_SetImageList(FrmMain.LstFiles2.Handle, SysImageListLarge, LVSIL_NORMAL);
     ListView_SetImageList(FrmMain.LstFiles2.Handle, SysImageListSmall, LVSIL_NORMAL Or LVSIL_SMALL);

     With FrmMain Do Begin

          // Variablen initialisieren
          PathNum:=0;

          // Die Objekte zweckmigerweise in Arrays bertragen
          Lists[0]:=LstFiles;
          Lists[1]:=LstFiles2;
          DriveLists[0]:=CboDrive1;
          DriveLists[1]:=CboDrive2;

          // "Kein Filter"-Filter initialisieren
          With FilterAllFiles Do Begin
               Include:='*.*';
               Exclude:='';
               ReadOnly:=True;
               SysFile:=True;
               Hidden:=True;
               Directory:=True;
               MinSize:=0;
               MaxSize:=0;
               UseDate:=False;
               MinDate:=DateTimeToFileTime(Date);
               MaxDate:=DateTimeToFileTime(Date);
          End;

          // Standardmig ist die linke Liste aktiviert
          CurrentList:=LeftList;

          // Optionen laden
          ShowSettingsAfterStartup:=Not FileExists(ProgPath+IniFileName);
          FrmFilter.LoadFromFile(ProgPath+FilterListFilename);
          LoadOptions;

          // Objekte richtig anordnen
          ResizeFileWindows;

          // OLE initialisieren (fr Drag & Drop)
          Dummy:=OleInitialize(Nil);
          OleInitialized:=((Dummy = S_OK) Or (Dummy = S_FALSE));

          // Verzeichnis-Fenster initialisieren
          For i:=0 To 1 Do Begin
              FrmMain.ChangeNotificationHandlers[i]:=INVALID_HANDLE_VALUE;
              DriveLists[i].Drive:=Data[i].Directory[1];
              Lists[i].ViewStyle:=TViewStyle(Data[i].ListType);
              // Die Werte mssen direkt eingestellt werden, sonst
              // werden wieder die Standardwerte aus Columns gelesen
              // (ReadDirectory -> ReadColumnsWidth)
              // und die gespeicherten Werte berschrieben
              Lists[i].Columns[ColumnName].Width:=Data[i].ColumnsWidth.NameWidth;
              Lists[i].Columns[ColumnSize].Width:=Data[i].ColumnsWidth.SizeWidth;
              Lists[i].Columns[ColumnDate].Width:=Data[i].ColumnsWidth.DateWidth;
              Lists[i].Columns[ColumnAttr].Width:=Data[i].ColumnsWidth.AttrWidth;
              Data[i].QueryDataType:=Data[i].DataType;
              // Dateien einlesen
              ClearRecentDirList(i);
              UpDateDir(i);
              If OleInitialized Then Begin
                 // IDropSource-Objekte erstellen
                 DrpSourceDummies[i]:=TDropSource.Create(i);
                 DrpSources[i]:=DrpSourceDummies[i];
                 // IDropTarget-Objekte erstellen
                 DrpTargetDummies[i]:=TDropTarget.Create(Lists[i], i);
                 DrpTargets[i]:=DrpTargetDummies[i];
                 // Als Drop-Target registrieren
                 RegisterDragDrop(DrpTargetDummies[i].wnd, DrpTargets[i]);
              End;
          End;

     End;

     // Damit auch alles bei GROSSEN Schriftarten funktioniert...
     FrmEditPathList.BorderStyle:=bsSizeable;
     FrmEditPathList.Constraints.MinHeight:=Round(FrmEditPathList.Constraints.MinHeight / StdPixelsPerInch * FrmMain.LogPixels.y);
     FrmEditPathList.Constraints.MinWidth:=Round(FrmEditPathList.Constraints.MinWidth / StdPixelsPerInch * FrmMain.LogPixels.x);
     FrmConcatFile.BorderStyle:=bsSizeable;
     FrmConcatFile.Constraints.MinHeight:=Round(FrmConcatFile.Constraints.MinHeight / StdPixelsPerInch * FrmMain.LogPixels.y);
     FrmConcatFile.Constraints.MinWidth:=Round(FrmConcatFile.Constraints.MinWidth / StdPixelsPerInch * FrmMain.LogPixels.x);

     // Fertig!
     FrmMain.SetDoubleBuffering;
     FrmMain.UpdateDirectoryBar;
     FrmMain.UpdateColumnHeaderImages;
     FrmMain.SetListFocus(LeftList);
     FrmMain.UpdateCommandLineBar;
     If ShowSettingsAfterStartUp Then Begin
        MessageDlg('eXec startet zum ersten Mal. Daher werden die Einstellungen angezeigt, damit Sie sie Ihren Wnschen entsprechend ndern knnen. Die Einstellungen knnen Sie spter ber das Ansicht-Men erreichen.', mtInformation, [mbOk], 0);
        FrmMain.OptionsSettingsClick(Nil);
     End;
End;

Procedure TFrmMain.FormShow(Sender: TObject);
Begin
     InitProgram;
     WindowState:=SavedWindowState;
End;

Function IsSomethingSelected(Side: Integer): Boolean;
Begin
     Result:=(ListView_GetSelectedCount(FrmMain.Lists[Side].Handle) > 0);
End;

Procedure TFrmMain.LstFilesEnter(Sender: TObject);
Begin
     CurrentList:=LeftList;
     UpdateDirectoryBar;
     UpdateCommandLineBar;
End;

Procedure TFrmMain.LstFiles2Enter(Sender: TObject);
Begin
     CurrentList:=RightList;
     UpdateDirectoryBar;
     UpdateCommandLineBar;
End;

Procedure TFrmMain.FileExitClick(Sender: TObject);
Begin
     Close;
End;

Procedure TFrmMain.CboDrive1Change(Sender: TObject);
Var
   Dr: Char;
   Dummy, Result: Integer;
Begin
     {$I-}
     Dr:=UpCase(CboDrive1.Drive);
     IOResult;
     Repeat
           Dummy:=mrRetry;
           ChDir(Dr+':\');
           Result:=IOResult;
           If Result = 0 Then Begin
              Data[LeftList].QueryDataType:=dtFileList;
              Data[LeftList].Directory:=Dr+':';
              UpDateDir(LeftList);
           End Else Begin
              Dummy:=MessageDlg('Vom Datentrger in Laufwerk '+Dr+': kann nicht gelesen werden.',
                                mtError, [mbRetry, mbCancel], 0);
           End;
     Until (Result = 0) Or (Dummy <> mrRetry);
     If Result <> 0 Then CboDrive1.Drive:=Data[LeftList].Directory[1];
     {$I+}
End;

Procedure TFrmMain.CboDrive2Change(Sender: TObject);
Var
   Dr: Char;
   Dummy, Result: Integer;
Begin
     {$I-}
     Dr:=UpCase(CboDrive2.Drive);
     IOResult;
     Repeat
           Dummy:=mrRetry;
           ChDir(Dr+':\');
           Result:=IOResult;
           If Result = 0 Then Begin
              Data[RightList].QueryDataType:=dtFileList;
              Data[RightList].Directory:=Dr+':';
              UpDateDir(RightList);
           End Else Begin
              Dummy:=MessageDlg('Vom Datentrger in Laufwerk '+Dr+': kann nicht gelesen werden.',
                                mtError, [mbRetry, mbCancel], 0);
           End;
     Until (Result = 0) Or (Dummy <> mrRetry);
     If Result <> 0 Then CboDrive2.Drive:=Data[1].Directory[1];
     {$I+}
End;

Function StepBack(Dir: String): String;
Var
   i: Integer;
Begin
     i:=Length(Dir);
     Result:=Dir;
     If (i = 0) Or (Dir[i] = ':') Then Exit;
     Repeat
           Dec(i);
     Until Dir[i] = '\';
     Result:=Copy(Dir,1,i-1);
End;

Procedure SetFirstItem(Side: Integer);
Begin
     With FrmMain Do Begin
          If Lists[Side].Items.Count > 0 Then Begin
             Lists[Side].Items[0].Focused:=True;
             Lists[Side].Items[0].Selected:=True;
          End;
     End;
End;

Procedure StepBackAndFocusOldDir(Side: Integer; Var Dir: String);
Var
   PansenDir: String;
   OldDir: String;
   i: Integer;
Begin
     If Length(Dir) < 4 Then Exit;
     PansenDir:=Dir;
     OldDir:=Dir;
     i:=Length(OldDir)-1;
     Repeat
           Dec(i);
     Until OldDir[i] = '\';
     OldDir:=Copy(OldDir,i+1,Length(OldDir)-i);
     Dir:=StepBack(Dir);
     If Dir = PansenDir Then Exit;
     UpDateDir(Side);
     If FrmMain.Lists[Side].Items.Count = 0 Then Exit;
     For i:=0 To FrmMain.Lists[Side].Items.Count-1 Do With FrmMain.Lists[Side] Do Begin
         If AnsiCompareText(OldDir,Items[i].Caption) = 0 Then Begin
            Items[i].MakeVisible(False);
            Items[i].Focused:=True;
            Items[i].Selected:=True;
            Exit;
         End;
     End;
End;

Procedure DoSomething(Side: Longint; Item: TListItem);
Begin
     If Item = Nil Then Exit;
     With FrmMain, Data[Side], Dat(Item.Data^) Do Begin
          If ((fAttr And faDirectory) > 0) And (Data[Side].DataType = dtFileList) Then Begin
             If UpDir Then Begin
                StepBackAndFocusOldDir(Side,Directory);
             End Else Begin
                Directory:=Directory+'\'+GetName(Item.Data, Side);
                UpDateDir(Side);
                SetFirstItem(Side);
             End;
          End Else Begin
             If ExecuteFile(Item.Caption,'',GetPath(Item.Data,Side),SW_SHOW) <= 32 Then
                If (fAttr And faDirectory) = 0 Then ViewTextFile(GetFullName(Item.Data, Side));
          End;
     End;
End;

Procedure TFrmMain.LstFilesDblClick(Sender: TObject);
Var
   pt: TPoint;
Begin
     pt:=LstFiles.ScreenToClient(Mouse.CursorPos);
     If LstFiles.GetItemAt(pt.x, pt.y) = Nil Then Exit;
     If LstFiles.ItemFocused <> Nil Then Begin
        DontDrag:=True;
        DoSomething(LeftList,LstFiles.ItemFocused);
     End;
End;

Procedure TFrmMain.LstFiles2DblClick(Sender: TObject);
Var
   pt: TPoint;
Begin
     pt:=LstFiles2.ScreenToClient(Mouse.CursorPos);
     If LstFiles2.GetItemAt(pt.x, pt.y) = Nil Then Exit;
     If LstFiles2.ItemFocused <> Nil Then Begin
        DontDrag:=True;
        DoSomething(RightList,LstFiles2.ItemFocused);
     End;
End;

Procedure TFrmMain.LstFilesKeyPress(Sender: TObject; Var Key: Char);
Begin
     If LstFiles.IsEditing Then Exit;
     Case Key Of
        #13: If LstFiles.ItemFocused <> Nil Then
                DoSomething(LeftList,LstFiles.ItemFocused);
        #8:  StepBackAndFocusOldDir(LeftList,Data[LeftList].Directory);
     End;
End;

Procedure TFrmMain.LstFiles2KeyPress(Sender: TObject; Var Key: Char);
Begin
     If LstFiles2.IsEditing Then Exit;
     Case Key Of
        #13: If LstFiles2.ItemFocused <> Nil Then
                DoSomething(RightList,LstFiles2.ItemFocused);
        #8:  StepBackAndFocusOldDir(RightList,Data[RightList].Directory);
     End;
End;

Procedure TFrmMain.SpdStepBackLeftClick(Sender: TObject);
Var
   Path: String;
Begin
     With FrmMain, Data[LeftList] Do Begin
          Path:=StepBack(Directory);
          If Path <> Directory Then Begin
             StepBackAndFocusOldDir(LeftList,Directory);
          End;
     End;
End;

Procedure TFrmMain.SpdStepBackRightClick(Sender: TObject);
Var
   Path: String;
Begin
     With FrmMain, Data[RightList] Do Begin
          Path:=StepBack(Directory);
          If Path <> Directory Then Begin
             StepBackAndFocusOldDir(RightList,Directory);
          End;
     End;
End;

Procedure TFrmMain.LeftUpDateClick(Sender: TObject);
Begin
     UpDateDir(LeftList);
     DriveLists[LeftList].UpdateDriveList;
End;

Procedure TFrmMain.RightUpdateClick(Sender: TObject);
Begin
     UpDateDir(RightList);
     DriveLists[RightList].UpdateDriveList;
End;

Procedure TFrmMain.SetListFocus;
Begin
     With FrmMain Do Begin
          If (Lists[Side].ItemFocused = Nil) And (Lists[Side].Items.Count > 0) Then Begin
             Lists[Side].ItemFocused:=Lists[Side].Items[0];
             Lists[Side].Items[0].Selected:=True;
          End;
          Lists[Side].SetFocus;
     End;
End;

Procedure ChangeDrive(Side: Longint);
Var
   Tmp: String;
Begin
     With FrmMain, FrmChangeDriveDir Do Begin
          {$I-}

          // Prfen, ob das aktuelle Verzeichnis noch gltig ist
          ChDir(Data[Side].Directory+'\');
          If IOResult <> 0 Then Begin
             Tmp:=ProgPath[1]+':\';
             ChDir(Tmp);
             IOResult;
             LstDir.Directory:=Tmp;
             CboDrive.Drive:=ProgPath[1];
          End Else Begin
             LstDir.Directory:=Data[Side].Directory+'\';
             CboDrive.Drive:=Data[Side].Directory[1];
          End;

          // Fenster anzeigen und ggf. Laufwerk/Verzeichnis wechseln
          If FrmChangeDriveDir.ShowModal = mrOK Then Begin
             DriveLists[Side].Drive:=LstDir.Directory[1];
             Data[Side].Directory:=LstDir.Directory;
             If Data[Side].Directory[Length(Data[Side].Directory)] = '\' Then
                Data[Side].Directory:=Copy(Data[Side].Directory,1,Length(Data[Side].Directory)-1);
             Data[Side].QueryDataType:=dtFileList;
             UpDateDir(Side);
          End;
     End;
End;

Procedure TFrmMain.LeftChangeDirClick(Sender: TObject);
Begin
     ChangeDrive(LeftList);
End;

Procedure TFrmMain.RightChangeDirClick(Sender: TObject);
Begin
     ChangeDrive(RightList);
End;

Procedure TFrmMain.ShowTheHint(Sender: TObject);
Begin
     If Length(Application.Hint) > 0 Then Begin
        StsBar.SimplePanel:=True;
        StsBar.SimpleText:=GetLongHint(Application.Hint);
     End Else Begin
        StsBar.SimplePanel:=False;
     End;
End;

Procedure TFrmMain.FormCreate(Sender: TObject);
Var
   DC: Integer;
   i: Integer;
Begin
     Application.Title:=eXec_Caption;
     FrmMain.Caption:=exec_Caption;
     // Threads
     For i:=0 To 1 Do Begin
         FetchSysIconsThreads[i]:=Nil;
         ThreadTerminated[i]:=True;
     End;
     // Fr OLE-Drag&Drop...
     OleInitialized:=False;
     DontDrag:=False;
     DropTargetDir:='';
     FilenamesList.FileNum:=0;
     MappedFilenamesList.FileNum:=0;
     UseMappedFilenames:=False;
     With FORMATETCs[HDROP_FormatEtc] Do Begin
          cfFormat:=CF_HDROP;
          ptd:=Nil;
          dwAspect:=DVASPECT_CONTENT;
          lindex:=-1;
          tymed:=TYMED_HGLOBAL;
     End;
     With FORMATETCs[IDList_FormatEtc] Do Begin
          cfFormat:=CF_IDLIST;
          ptd:=Nil;
          dwAspect:=DVASPECT_CONTENT;
          lindex:=-1;
          tymed:=TYMED_HGLOBAL;
     End;
     With FILENAMEMAP_FormatEtc Do Begin
          cfFormat:=CF_FILENAMEMAP;
          ptd:=Nil;
          dwAspect:=DVASPECT_CONTENT;
          lindex:=-1;
          tymed:=TYMED_HGLOBAL;
     End;
     // Diverse Variablen initialisieren
     ForceLabelEditing:=False;
     For i:=0 To 1 Do UseSimpleIcons[i]:=False;
     ETA:=Nil;
     Busy:=0;
     DC:=GetDC(0);
     Try
        LogPixels.x:=GetDeviceCaps(DC, LOGPIXELSX);
        LogPixels.y:=GetDeviceCaps(DC, LOGPIXELSY);
     Finally
        ReleaseDC(0, DC);
     End;
     // Programm-Pfad auslesen
     ProgPath:=ExtractFilePath(ParamStr(0));
     // Hilfedatei zuweisen
     Application.HelpFile:=ProgPath+HelpFilename;
     // Minimale Gre des Fensters berechnen
     MinWindowSize.x:=Round(StdMinWindowWidth / StdPixelsPerInch * LogPixels.x);
     MinWindowSize.y:=Round(StdMinWindowHeight / StdPixelsPerInch * LogPixels.y);;
     // Ereignis-Handler zuweisen
     Application.OnHint:=ShowTheHint;
     Application.OnActivate:=ApplicationActivate;
     Application.OnDeactivate:=ApplicationDeactivate;
     // Objekte erstellen
     LblDirectoryLeft:=TStaticTextEx.Create(PnlDirectoryBar);
     LblDirectoryLeft.Parent:=PnlDirectoryBar;
     LblDirectoryLeft.AutoSize:=False;
     LblDirectoryLeft.OnClick:=LblDirectoryLeftClick;
     LblDirectoryRight:=TStaticTextEx.Create(PnlDirectoryBar);
     LblDirectoryRight.Parent:=PnlDirectoryBar;
     LblDirectoryRight.AutoSize:=False;
     LblDirectoryRight.OnClick:=LblDirectoryRightClick;
End;

Procedure TFrmMain.SelectAll;
Begin
     ListView_SetItemState(Lists[Side].Handle, -1, LVIS_SELECTED, LVIS_SELECTED);
End;

Procedure TFrmMain.SelectNone;
Begin
     ListView_SetItemState(Lists[Side].Handle, -1, 0, LVIS_SELECTED);
End;

Procedure TFrmMain.InvertSelection;
Var
   i, count: Integer;
   item: TLVItem;
   ptr: Pointer;
Begin
     count:=Lists[Side].Items.Count-1;
     If count >= 0 Then With Lists[Side] Do Begin
        For i:=0 To count Do Begin
            item.iItem:=i;
            item.iSubItem:=0;
            item.Mask:=LVIF_PARAM Or LVIF_STATE;
            item.stateMask:=LVIS_SELECTED;
            ListView_GetItem(Handle, item);
            ptr:=TListItem(Pointer(item.lParam)).Data;
            If Not (((Dat(ptr^).fAttr And faDirectory) = faDirectory) And (Not Options.SelectDirectories)) Then Begin
               If (item.state And LVIS_SELECTED) <> 0 Then
                  ListView_SetItemState(Handle, i, 0, LVIS_SELECTED)
               Else
                  ListView_SetItemState(Handle, i, LVIS_SELECTED, LVIS_SELECTED);
            End;
        End;
     End;
End;

Procedure TFrmMain.SelectionAllClick(Sender: TObject);
Begin
     SelectAll(CurrentList);
End;

Procedure TFrmMain.SelectionNoneClick(Sender: TObject);
Begin
     SelectNone(CurrentList);
End;

Procedure TFrmMain.SelectionInvertClick(Sender: TObject);
Begin
     InvertSelection(CurrentList);
End;

Procedure GroupSelect(Mask: String; Selection: Boolean; Side: Integer);
Var
   i, m: Integer;
   ptr: Pointer;
   count: Integer;
   Filename: String;
   lvis_mask: Cardinal;
   Masks: Array[0..127] Of String;
   MaskNum: Integer;
   StartCopy, Len: Integer;
Begin
     count:=FrmMain.Lists[Side].Items.Count-1;
     If  count >= 0 Then With FrmMain.Lists[Side] Do Begin

        If Selection Then Begin
           lvis_mask:=LVIS_SELECTED;
           If FrmSelectionMask.ChkDestroyOldSelection.Checked Then FrmMain.SelectNone(Side);
        End Else Begin
           lvis_mask:=0;
        End;

        Mask:=AnsiUpperCase(Trim(Mask));
        MaskNum:=0;
        i:=0;
        StartCopy:=1;
        Len:=Length(Mask);
        Repeat
              Inc(i);
              If i > Len Then Begin
                 Masks[MaskNum]:=Trim(Copy(Mask, StartCopy, i-StartCopy));
                 Inc(MaskNum);
              End Else If (Mask[i] = ';') Then Begin
                 Masks[MaskNum]:=Trim(Copy(Mask, StartCopy, i-StartCopy));
                 Inc(MaskNum);
                 StartCopy:=i+1;
              End;
        Until i > Len;
        Dec(MaskNum); // Damit man in der For-Schleife das -1 weglassen kann, hab keine
                      // Ahnung, ob Delphi dies VOR Schleifenbeginn einmal macht, oder
                      // bei jedem Schleifendurchlauf...

        Try
           Items.BeginUpdate;

           For i:=0 To count Do Begin

               ptr:=Items[i].Data;
               Filename:=AnsiUpperCase(Dat(ptr^).fName);
               If ExtractFileExt(Filename) = '' Then Filename:=Filename+'.';

               For m:=0 To MaskNum Do Begin
                   If Like(Filename, Masks[m]) Then Begin
                        If Not (((Dat(ptr^).fAttr And faDirectory) = faDirectory) And (Not Options.SelectDirectories)) Then Begin
                           ListView_SetItemState(Handle, i, lvis_mask, LVIS_SELECTED);
                           Break;
                        End;
                   End;
               End;

           End;

        Finally
            Items.EndUpdate;
        End;

     End;
End;

Procedure TFrmMain.SelectionGroupClick(Sender: TObject);
Begin
     FrmSelectionMask.HelpContext:=IDH_SelectionGroupSelect;
     FrmSelectionMask.Caption:='Gruppe selektieren';
     FrmSelectionMask.ChkDestroyOldSelection.Visible:=True;
     If FrmSelectionMask.ShowModal = mrOk Then
        GroupSelect(FrmSelectionMask.EdtSelectionMask.Text, True, CurrentList);
End;

Procedure TFrmMain.SelectionUnGroupClick(Sender: TObject);
Begin
     FrmSelectionMask.HelpContext:=IDH_SelectionGroupUnSelect;
     FrmSelectionMask.Caption:='Gruppe deselektieren';
     FrmSelectionMask.ChkDestroyOldSelection.Visible:=False;
     If FrmSelectionMask.ShowModal = mrOk Then
        GroupSelect(FrmSelectionMask.EdtSelectionMask.Text, False, CurrentList);
End;

Procedure DirInfoProcessFile(Const Path: String; Const FindData: TWin32FindData; CallBackType: Integer);
Begin
     If (FindData.dwFileAttributes And faDirectory) = faDirectory Then Begin
        Inc(DISubDirs);
     End Else Begin
        Inc(DIFileNum);
        DISizeInBytes:=DISizeInBytes+FindData.nFileSizeLow;
     End;
End;

Procedure DirInfo(OnlyFocused, Recursive, UseFilter: Boolean; Side: Longint; Var FileNum, SubDirs: Longint; Var SizeInBytes: Int64);
Begin
     FrmMain.BeginBusy;
     DIFileNum:=0;
     DISubDirs:=0;
     DISizeInBytes:=0;
     SDDirInfo.ProcessMessages:=False;
     CallBackFiles(Side, SDDirinfo, DirInfoProcessFile, cbBeforeRecurse, Data[Side].Filter, OnlyFocused, UseFilter, Recursive);
     FileNum:=DIFileNum;
     SubDirs:=DISubDirs;
     SizeInBytes:=DISizeInBytes;
     FrmMain.EndBusy;
End;

Procedure DirInfoProcessFileEx(Const Path: String; Const FindData: TWin32FindData; CallBackType: Integer);
Begin
     If (FindData.dwFileAttributes And faDirectory) = faDirectory Then Begin
        Inc(DIsubDirs);
     End Else Begin
        Inc(DIFileNum);
        DISizeInBytes:=DISizeInBytes+FindData.nFileSizeLow;
     End;
     If (FindData.dwFileAttributes And faSysFile) = faSysFile Then Inc(DISysFiles);
     If (FindData.dwFileAttributes And faReadOnly) = faReadOnly Then Inc(DIReadOnlyFiles);
     If (FindData.dwFileAttributes And faHidden) = faHidden Then Inc(DIHiddenFiles);
     If (FindData.dwFileAttributes And faArchive) = faArchive Then Inc(DIArchiveFiles);
End;

Procedure DirInfoEx(OnlyFocused, Recursive, UseFilter: Boolean; Side: Longint; Var FileNum, SubDirs: Integer; Var SizeInBytes: Int64; Var SysFiles, HiddenFiles, ReadOnlyFiles, ArchiveFiles: Longint);
Begin
     FrmMain.BeginBusy;
     DIObjNum:=0;
     DIFileNum:=0;
     DISubDirs:=0;
     DISizeInBytes:=0;
     DISysFiles:=0;
     DIArchiveFiles:=0;
     DIHiddenFiles:=0;
     DIReadOnlyFiles:=0;
     SDDirInfo.ProcessMessages:=False;
     CallBackFiles(Side, SDDirinfo, DirInfoProcessFileEx, cbBeforeRecurse, Data[Side].Filter, OnlyFocused, UseFilter, Recursive);
     DIObjNum:=DIFileNum + DISubDirs;
     FileNum:=DIFileNum;
     SubDirs:=DISubDirs;
     SizeInBytes:=DISizeInBytes;
     SysFiles:=DISysFiles;
     ArchiveFiles:=DIArchiveFiles;
     HiddenFiles:=DIHiddenFiles;
     ReadOnlyFiles:=DIReadOnlyFiles;
     FrmMain.EndBusy;
End;

Function DelFile(FileName: String): Boolean;
Begin
     FileSetAttr(FileName,faArchive);
     Result:=SysUtils.DeleteFile(FileName);
End;

Function RemDir(FileName: String): Boolean;
Var
   Attr: Integer;
Begin
     Attr:=FileGetAttr(Filename);
     FileSetAttr(FileName, faDirectory);
     Result:=RemoveDir(FileName);
     If (Not Result) Then FileSetAttr(Filename, Attr);
End;

Function RecycleFile;
Var
   SHFileOpStruct: TSHFileOpStruct;
Begin
     With SHFileOpStruct Do Begin
          Wnd:=0;
          wFunc:=FO_DELETE;
          pFrom:=PChar(s+#0);
          pTo:=Nil;
          fFlags:=FOF_ALLOWUNDO Or FOF_NOCONFIRMATION Or FOF_SILENT Or FOF_RENAMEONCOLLISION;
          hNameMappings:=Nil;
          lpszProgressTitle:=Nil;
     End;
     Result:=(SHFileOperation(SHFileOpStruct) = 0);
End;

Function Kill(Const s: String): Boolean;
Begin
     If Options.UseRecycleBin Then
        Result:=RecycleFile(s)
     Else
        Result:=DelFile(s);
End;

Function IsDirectoryEmpty;
Var
   Dummy: TWin32FindData;
   h: THandle;
   Res: Longbool;
Begin
     If Dir[Length(Dir)] <> '\' Then Dir:=Dir+'\';
     h:=FindFirstFile(PChar(Dir+'*.*'), Dummy);
     If h <> INVALID_HANDLE_VALUE Then Begin
        Repeat
              If ((String(Dummy.cFileName) <> '.') And (String(Dummy.cFilename) <> '..')) Then Begin
                 Windows.FindClose(h);
                 Result:=False;
                 Exit;
              End;
              Res:=FindNextFile(h, Dummy);
        Until Res = False;
        Windows.FindClose(h);
        Result:=True;
     End Else
        Result:=True;
End;

Function DeleteDirectory;
Begin
     If Options.UseRecycleBin Then Begin
        If IsDirectoryEmpty(Filename) Then
           Result:=RecycleFile(Filename)
        Else
           Result:=False;
     End Else
        Result:=RemDir(Filename)
End;

Function MakeDir(Const Dir, NewDir: String): Integer;
{
  Diese Funktion erstellt im Verzeichnis Dir das neue Verzeichnis
  NewDir.
  Rckgabewerte:
     1 - Erfolgreich
     0 - Verzeichnis bestand schon
    -1 - Verzeichnis konnte nicht erstellt werden
}
Var
   Res, Mes: Integer;
Begin
     {$I-}
     IOResult;
     ChDir(Dir);
     If IOResult <> 0 Then Begin
        Result:=-1;
        Exit;
     End;
     Repeat
           MkDir(NewDir);
           Res:=IOResult;
           If Res <> 0 Then Begin
              ChDir(NewDir);
              If IOResult = 0 Then Begin
                 Result:=0;
                 Exit;
              End;
              Mes:=MessageDlg('Fehler beim Erstellen von '+NewDir+' in '+Dir+'.'+#13+#10+GetLastErrorString,mtError,[mbRetry,mbCancel],0);
              If Mes = MrCancel Then Begin
                 Result:=-1;
                 Exit;
              End;
           End;
     Until Res = 0;
     Result:=1;
     IOResult;
End;

Function CopyDir(Const SrcDir, DestDir: String): Boolean;
Begin
     {$I-}
     MkDir(DestDir);
     IOResult;
     SetFileAttributes(PChar(DestDir), GetFileAttributes(PChar(SrcDir)));
     Result:=True;
End;

Function DeleteFile(FileName: String; Var Progress: Int64; FileNum: Longint): Longint;
{
  Diese Funktion lscht die Datei FileName und erneuert die Anzeige im
  Statusfenster.
  Rckegabewerte:
    1 - Datei erfolgreich gelscht
    0 - Datei bersprungen
   -1 - Fehler beim Lschen
}
Var
   Mes: Longint;
Begin
     If Canceled Then Begin
        Result:=-1;
        Exit;
     End;
     If (Not DeleteAll) Then Begin
        Mes:=MessageDlg('Soll die Datei "'+FileName+'" wirklich gelscht werden?',mtConfirmation,[mbYes,mbNo,mbAll,mbCancel],0);
        Case Mes Of
             mrNo:     Begin
                            Result:=0;
                            Exit;
                       End;
             mrAll:    DeleteAll:=True;
             mrCancel: Begin
                            Canceled:=True;
                            Result:=-1;
                            Exit;
                       End;
        End;
     End;
     FrmDeleteStatus.LblDeleteFile.Caption:=FileName;
     While (Not Kill(FileName)) Do Begin
           Mes:=MessageDlg('Fehler beim Lschen von '+FileName+'.'+#13+#10+GetLastErrorString,mtError,[mbRetry,mbIgnore,mbCancel],0);
           Case Mes Of
                mrCancel: Begin
                               Result:=-1;
                               Canceled:=True;
                               Exit;
                          End;
                mrIgnore: Begin
                               Result:=0;
                               Exit;
                          End;
           End;
     End;
     Progress:=Progress+1;
     If FileNum <> 0 Then FrmDeleteStatus.PrgAllFiles.Position:=Round(Progress / FileNum * 100);
     Application.ProcessMessages;
     Result:=1;
End;

Procedure TFrmMain.FileNewDirectoryClick(Sender: TObject);
Begin
     {$I-}
     IOResult;
     ChDir(Data[CurrentList].Directory+'\');
     If IOResult <> 0 Then Begin
        MessageDlg('Das aktuelle Verzeichnis ist ungltig.',mtError,[mbOK],0);
        Exit;
     End;
     FrmNewDir.EdtNewDir.Text:='';
     If FrmNewDir.ShowModal = mrOK Then Begin
        IOResult;
        MkDir(FrmNewDir.EdtNewDir.Text);
        If IOResult <> 0 Then Begin
           MessageDlg('Konnte '+FrmNewDir.EdtNewDir.Text+' nicht erstellen.'+#13+#10+'Der Name ist ungltig, oder das Verzeichnis existiert bereits.',mtError,[mbOK],0);
           Exit;
        End;
        UpdateLists;
     End;
     IOResult;
     {$I+}
End;

Procedure TFrmMain.OptionsDriveBarClick(Sender: TObject);
Begin
     PnlDriveBar.Visible:=Not PnlDriveBar.Visible;
     CorrectBars;
End;

Procedure TFrmMain.OptionsStatusBarClick(Sender: TObject);
Begin
     StsBar.Visible:=Not StsBar.Visible;
     CorrectBars;
End;

procedure TFrmMain.FormClose(Sender: TObject; Var Action: TCloseAction);
Var
   i: Integer;
begin
     Try
        For i:=0 To 1 Do StopChangeNotification(i);
        FrmFilter.SaveToFile(ProgPath+FilterListFilename);
        SaveOptions;
     Except
        Else Halt;
     End;
end;

Procedure TFrmMain.OptionsSettingsClick(Sender: TObject);
Var
   OldCharCase: Integer;
   OldUseSimpleIcons: Array[0..1] Of Boolean;
   OldGhostHiddenFiles: Boolean;
   OldMarkDirectories: Boolean;
   i: Integer;

Procedure UpdateUseSimpleIcons(i: Integer);
Begin
     If Data[i].DataType = dtFileList Then
        SetUpUseSimpleIcons(Data[i].Directory[1], i)
     Else If Data[i].DataType = dtFindResult Then Begin
        If Lists[i].Items.Count > 0 Then
           SetUpUseSimpleIcons(GetPath(Lists[i].Items[0].Data, i)[1], i);
     End;
End;

Begin
     With FrmSettings Do Begin
          GetOptions;
          OptionsToSettingsForm;
          OldCharCase:=Options.CharCase;
          For i:=0 To 1 Do Begin
              UpdateUseSimpleIcons(i);
              OldUseSimpleIcons[i]:=UseSimpleIcons[i];
          End;
          OldGhostHiddenFiles:=Options.GhostHiddenFiles;
          OldMarkDirectories:=Options.markDirectories;
          // Dialogfeld anzeigen
          If FrmSettings.ShowModal = mrOK Then Begin
             SettingsFormToOptions;
             SetOptions;
             For i:=0 To 1 Do Begin
                 UpdateUseSimpleIcons(i);
                 If (Options.CharCase <> OldCharCase) Or
                    (OldUseSimpleIcons[i] <> UseSimpleIcons[i]) Or
                    (OldGhostHiddenFiles <> Options.GhostHiddenFiles) Or
                    (OldMarkDirectories <> Options.MarkDirectories)
                 Then Begin
                    UpdateDir(i);
                 End;
             End;
          End;
     End;
End;

procedure TFrmMain.FileAboutClick(Sender: TObject);
begin
     FrmAbout.ShowModal;
end;

Function DriveIsValid(Drive: Char): Boolean;
Var
   Tmp: String;
Begin
     {$I-}
     IOResult;
     GetDir(0,Tmp);
     ChDir(Drive+':\');
     Result:=(IOResult = 0);
     ChDir(Tmp);
     IOResult;
     {$I+}
End;

Function FindValidDrive(StartDrive, EndDrive: Char): Char;
Var
   Tmp: String;
Begin
     {$I-}
     IOResult;
     StartDrive:=UpCase(StartDrive);
     EndDrive:=UpCase(EndDrive);
     GetDir(0,Tmp);
     While StartDrive <= EndDrive Do Begin
           ChDir(StartDrive+':\');
           If IOResult = 0 Then Begin
              Result:=StartDrive;
              Exit;
           End;
           Inc(StartDrive);
     End;
     Result:=#0;
     ChDir(Tmp);
     IOResult;
     {$I+}
End;

Procedure TFrmMain.WMDeviceChange;
Var
   TmpUserOnChange: Boolean;
   TmpDrive: Char;
   i: Integer;
Begin
     For i:=0 To 1 Do Begin
         TmpUserOnChange:=DriveLists[i].UserOnChange;
         TmpDrive:=DriveLists[i].Drive;
         DriveLists[i].UpdateDriveList;
         If (Not DriveIsValid(TmpDrive)) Then Begin
            ClearRecentDirList(i);
            DriveLists[i].UserOnChange:=True;
            TmpDrive:=FindValidDrive('c','z');
         End;
         DriveLists[i].Drive:=TmpDrive;
         DriveLists[i].UserOnChange:=TmpUserOnChange;
     End;
End;

procedure TFrmMain.LstFilesCompare(Sender: TObject; Item1,
  Item2: TListItem; Data: Integer; var Compare: Integer);
Begin
     If ((Dat(Item1.Data^).fAttr And faDirectory) = faDirectory) And ((Dat(Item2.Data^).fAttr And faDirectory) <> faDirectory) Then
        Compare:=-1
     Else If ((Dat(Item1.Data^).fAttr And faDirectory) <> faDirectory) And ((Dat(Item2.Data^).fAttr And faDirectory) = faDirectory) Then
        Compare:=1
     Else Begin
        If Dat(Item1.Data^).UpDir Then
           Compare:=-1
        Else If Dat(Item2.Data^).UpDir Then
           Compare:=-1
        Else Begin
           Case MainForm.Data[0].SortType Of
                SortName:
                   Begin
                        Compare:=AnsiCompareText(Item1.Caption, Item2.Caption);
                   End;
                SortExt:
                   Begin
                        Compare:=AnsiCompareText(ExtractFileExt(Dat(Item1.Data^).fName), ExtractFileExt(Dat(Item2.Data^).fName));
                        If Compare = 0 Then
                           Compare:=AnsiCompareText(Dat(Item1.Data^).fName, Dat(Item2.Data^).fName);
                   End;
                SortSize:
                   Begin
                        If (Dat(Item1.Data^).fSize < Dat(Item2.Data^).fSize) Then
                           Compare:=-1
                        Else If (Dat(Item1.Data^).fSize > Dat(Item2.Data^).fSize) Then
                           Compare:=1
                        Else
                           Compare:=AnsiCompareText(Item1.Caption, Item2.Caption);
                   End;
                SortDate:
                   Begin
                        Compare:=CompareFileTime(Dat(Item1.Data^).fTime,Dat(Item2.Data^).fTime);
                        If Compare = 0 Then
                           Compare:=AnsiCompareText(Item1.Caption, Item2.Caption);
                   End;
                SortPath:
                   Begin
                        Compare:=AnsiCompareText(GetPath(Item1.Data, LeftList), GetPath(Item2.Data, LeftList));
                        If Compare = 0 Then
                           Compare:=AnsiCompareText(Dat(Item1.Data^).fName, Dat(Item2.Data^).fName);
                   End;
           End;
           If MainForm.Data[0].SortDir = SortDirDown Then Compare:= -Compare;
        End;
     End;
End;

procedure TFrmMain.LstFiles2Compare(Sender: TObject; Item1,
  Item2: TListItem; Data: Integer; var Compare: Integer);
begin
     If ((Dat(Item1.Data^).fAttr And faDirectory) = faDirectory) And ((Dat(Item2.Data^).fAttr And faDirectory) <> faDirectory) Then
        Compare:=-1
     Else If ((Dat(Item1.Data^).fAttr And faDirectory) <> faDirectory) And ((Dat(Item2.Data^).fAttr And faDirectory) = faDirectory) Then
        Compare:=1
     Else Begin
        If Dat(Item1.Data^).UpDir Then
           Compare:=-1
        Else If Dat(Item2.Data^).UpDir Then
           Compare:=-1
        Else Begin
           Case MainForm.Data[1].SortType Of
                SortName:
                   Begin
                        Compare:=AnsiCompareText(Item1.Caption, Item2.Caption);
                   End;
                SortExt:
                   Begin
                        Compare:=AnsiCompareText(ExtractFileExt(Dat(Item1.Data^).fName), ExtractFileExt(Dat(Item2.Data^).fName));
                        If Compare = 0 Then
                           Compare:=AnsiCompareText(Dat(Item1.Data^).fName, Dat(Item2.Data^).fName);
                   End;
                SortSize:
                   Begin
                        If (Dat(Item1.Data^).fSize < Dat(Item2.Data^).fSize) Then
                           Compare:=-1
                        Else If (Dat(Item1.Data^).fSize > Dat(Item2.Data^).fSize) Then
                           Compare:=1
                        Else
                           Compare:=AnsiCompareText(Item1.Caption, Item2.Caption);
                   End;
                SortDate:
                   Begin
                        Compare:=CompareFileTime(Dat(Item1.Data^).fTime,Dat(Item2.Data^).fTime);
                        If Compare = 0 Then
                           Compare:=AnsiCompareText(Item1.Caption, Item2.Caption);
                   End;
                SortPath:
                   Begin
                        Compare:=AnsiCompareText(GetPath(Item1.Data, RightList), GetPath(Item2.Data, RightList));
                        If Compare = 0 Then
                           Compare:=AnsiCompareText(Dat(Item1.Data^).fName, Dat(Item2.Data^).fName);
                   End;
           End;
           If MainForm.Data[1].SortDir = SortDirDown Then Compare:= -Compare;
        End;
     End;
End;

procedure TFrmMain.MnuLeftClick(Sender: TObject);
begin
     With Data[LeftList] Do Begin
          LeftSortPath.Visible:=(DataType = dtFindResult);
          Case TViewStyle(ListType) Of
               vsReport: LeftReport.Checked:=True;
               vsList: LeftShort.Checked:=True;
               vsSmallIcon: LeftSmallIcons.Checked:=True;
               vsIcon: LeftIcons.Checked:=True;
          End;
          Case SortType Of
             SortName: LeftSortName.Checked:=True;
             SortExt: LeftSortExt.Checked:=True;
             SortSize: LeftSortSize.Checked:=True;
             SortDate: LeftSortDate.Checked:=True;
             SortPath: LeftSortPath.Checked:=True;
          End;
          If Data[LeftList].SortDir = SortDirUp Then
             LeftSortDirUp.Checked:=True
          Else
             LeftSortDirUp.Checked:=False;
          If Data[LeftList].DataType = dtFileList Then Begin
             LeftShowFileList.Checked:=True;
             LeftFilter.Enabled:=True;
             LeftUseFilter.Enabled:=True;
          End Else Begin
             LeftShowFindResult.Checked:=True;
             LeftFilter.Enabled:=False;
             LeftUseFilter.Enabled:=False;
          End;
          LeftUseFilter.Checked:=UseFilter
     End;
end;

procedure TFrmMain.MnuRightClick(Sender: TObject);
begin
     With Data[RightList] Do Begin
          RightSortPath.Visible:=(DataType = dtFindResult);
          Case TViewStyle(ListType) Of
               vsReport: RightReport.Checked:=True;
               vsList: RightShort.Checked:=True;
               vsSmallIcon: RightSmallIcons.Checked:=True;
               vsIcon: RightIcons.Checked:=True;
          End;
          Case SortType Of
             SortName: RightSortName.Checked:=True;
             SortExt: RightSortExt.Checked:=True;
             SortSize: RightSortSize.Checked:=True;
             SortDate: RightSortDate.Checked:=True;
             SortPath: RightSortPath.Checked:=True;
          End;
          If Data[RightList].SortDir = SortDirUp Then
             RightSortDirUp.Checked:=True
          Else
             RightSortDirUp.Checked:=False;
          If Data[RightList].DataType = dtFileList Then Begin
             RightShowFileList.Checked:=True;
             RightFilter.Enabled:=True;
             RightUseFilter.Enabled:=True;
          End Else Begin
             RightShowFindResult.Checked:=True;
             RightFilter.Enabled:=False;
             RightUseFilter.Enabled:=False;
          End;
          RightUseFilter.Checked:=UseFilter;
     End;
end;

procedure TFrmMain.LeftReportClick(Sender: TObject);
begin
     With Data[LeftList] Do Begin
          ListType:=Longint((Sender As TMenuItem).Tag);
          Lists[LeftList].ViewStyle:=TViewStyle((Sender As TMenuItem).Tag);
     End;
     UpdateColumnHeaderImagesSide(LeftList);
end;

procedure TFrmMain.RightReportClick(Sender: TObject);
begin
     With Data[RightList] Do Begin
          ListType:=Longint((Sender As TMenuItem).Tag);
          Lists[RightList].ViewStyle:=TViewStyle((Sender As TMenuItem).Tag);
     End;
     UpdateColumnHeaderImagesSide(RightList);
end;

procedure TFrmMain.LeftSortDateClick(Sender: TObject);
begin
     Data[LeftList].SortType:=(Sender As TMenuItem).Tag;
     Lists[LeftList].AlphaSort;
     UpdateColumnHeaderImagesSide(LeftList);
end;

procedure TFrmMain.RightSortDateClick(Sender: TObject);
begin
     Data[RightList].SortType:=(Sender As TMenuItem).Tag;
     Lists[RightList].AlphaSort;
     UpdateColumnHeaderImagesSide(RightList);
end;

procedure TFrmMain.LeftSortDirUpClick(Sender: TObject);
begin
     LeftSortDirUp.Checked:=Not LeftSortDirUp.Checked;
     If LeftSortDirUp.Checked Then
        Data[LeftList].SortDir:=SortDirUp
     Else
        Data[LeftList].SortDir:=SortDirDown;
     Lists[LeftList].AlphaSort;
     UpdateColumnHeaderImagesSide(LeftList);
end;

procedure TFrmMain.RightSortDirUpClick(Sender: TObject);
begin
     RightSortDirUp.Checked:=Not RightSortDirUp.Checked;
     If RightSortDirUp.Checked Then
        Data[RightList].SortDir:=SortDirUp
     Else
        Data[RightList].SortDir:=SortDirDown;
     Lists[RightList].AlphaSort;
     UpdateColumnHeaderImagesSide(RightList);
end;

procedure TFrmMain.MnuFileClick(Sender: TObject);
Var
   ext: String;
begin
     If Lists[CurrentList].ItemFocused <> Nil Then Begin
        If (Dat(Lists[CurrentList].ItemFocused.Data^).fAttr And faDirectory) = faDirectory Then Begin
           FileView.Enabled:=False;
        End Else Begin
           FileView.Enabled:=True;
        End;
        If (Not Dat(Lists[CurrentList].ItemFocused.Data^).UpDir) Then Begin
           FileProperties.Enabled:=True;
           FileRename.Enabled:=True;
           FileQuickView.Enabled:=True;
        End Else Begin
           FileProperties.Enabled:=False;
           FileRename.Enabled:=False;
           FileQuickView.Enabled:=False;
        End;
        If (Dat(Lists[CurrentList].ItemFocused.Data^).fAttr And faDirectory) <> faDirectory Then Begin
           If (Not Dat(Lists[CurrentList].ItemFocused.Data^).UpDir) Then Begin
              ext:=AnsiLowerCase(ExtractFileExt(GetName(Lists[CurrentList].ItemFocused.Data, CurrentList)));
              If (ext = '.exe') Or (ext = '.com') Or (ext = '.bat') Or (ext = '.pif') Then
                 FileExecuteWithParam.Enabled:=True
              Else
                 FileExecuteWithParam.Enabled:=False;
           End Else FileExecuteWithParam.Enabled:=False;
        End Else FileExecuteWithParam.Enabled:=False;
     End Else Begin
        FileView.Enabled:=False;
        FileProperties.Enabled:=False;
        FileRename.Enabled:=False;
        FileQuickView.Enabled:=False;
        FileExecuteWithParam.Enabled:=False;
     End;

     If IsSomethingSelected(CurrentList) Then Begin
        FileCopy.Enabled:=True;
        FileMove.Enabled:=True;
        FileDelete.Enabled:=True;
        FileCreateLink.Enabled:=True;
        FileAttr.Enabled:=True;
        FileDivideJoin.Enabled:=True;
     End Else Begin
        FileCopy.Enabled:=False;
        FileMove.Enabled:=False;
        FileDelete.Enabled:=False;
        FileCreateLink.Enabled:=False;
        FileAttr.Enabled:=False;
        FileDivideJoin.Enabled:=False;
     End;

     If FrmFindFile.LstResult.Items.Count > 0 Then
        FileClearFindResult.Enabled:=True
     Else
        FileClearFindResult.Enabled:=False;
end;

Function PathExists(Path: String; CreateIfNotExist: Boolean): Boolean;
Begin
     {$I-}
     IOResult;
     ChDir(Path);
     Result:=(IOResult = 0);
     If Result = False Then Begin
        If MessageDlg('Das Verzeichnis "'+Path+'" existiert nicht. Soll es erstellt werden?',mtConfirmation,[mbYes, mbNo],0) = mrYes Then Begin
           ForceDirectories(Path);
           Result:=DirectoryExists(Path);
           If Result = False Then Begin
              MessageDlg('Fehler beim Erstellen von "'+Path+'".'+#13+#10+GetLastErrorString,mtError,[mbOK],0);
           End;
        End;
     End;
End;

Function CreateLink;
Var
   psl: IShellLink;
   ppf: IPersistFile;
   hres: HRESULT;
   wsz: Array[0..MAX_PATH] Of Word;
Begin
     hres:=CoInitialize(Nil);
     If Succeeded(hres) Then Begin
        hres:=CoCreateInstance(CLSID_ShellLink, Nil, CLSCTX_INPROC_SERVER, IID_IShellLinkA, psl);
        If Succeeded(hres) Then Begin
           psl._AddRef;
           psl.SetPath(PChar(Path));
           psl.SetDescription(PChar(Description));
           hres:=psl.QueryInterface(IID_IPersistFile, ppf);
           If Succeeded(hres) Then Begin
               ppf._AddRef;
               MultiByteToWideChar(CP_ACP, 0, PChar(LinkName), -1,
                   PWideChar(@wsz), MAX_PATH);
               hres:=ppf.Save(PWideChar(@wsz), LongBool(True));
               ppf._Release;
           End;
           psl._Release;
        End;
        CoUninitialize;
     End;
     Result:=Succeeded(hres);
End;

Procedure CreateLinks(Side: Integer; Dir: String);
Var
   i: Integer;
   Path: String;
Begin
     FrmCreateLink.SourceList:=Side;
     If Length(Dir) > 0 Then
        FrmCreateLink.EdtDest.Text:=Dir
     Else
        FrmCreateLink.EdtDest.Text:=Data[Side].Directory+'\';
     If FrmCreateLink.ShowModal = mrOK Then With FrmMain.Lists[Side] Do Begin
        Path:=FrmCreateLink.EdtDest.Text;
        If Path[Length(Path)] <> '\' Then Path:=Path+'\';
        If Not PathExists(Path, True) Then Exit;
        For i:=0 To Items.Count - 1 Do Begin
            If Items[i].Selected Then
               CreateLink(Path+DefaultLinkText+GetName(Items[i].Data, Side)+'.LNK',GetFullname(Items[i].Data, Side),GetPath(Items[i].Data, Side));
        End;
        FrmMain.UpdateLists;
     End;
End;

Procedure TFrmMain.FileCreateLinkClick(Sender: TObject);
Begin
     CreateLinks(CurrentList, '');
End;

Procedure OpenFiles(Side: Integer);
Var
   i: Integer;
Begin
     With FrmMain.Lists[Side] Do Begin
          If Items.Count > 0 Then Begin
             For i:=0 To Items.Count - 1 Do Begin
                 If Items[i].Selected Then Begin
                    If ExecuteFile(GetFullName(Items[i].Data,Side),'',GetPath(Items[i].Data,Side),SW_SHOW) <= 32 Then Begin
                       FrmMain.ViewTextFile(GetFullName(Items[i].Data, Side));
                    End;
                 End;
             End;
          End;
     End;
End;

procedure TFrmMain.FileFindClick(Sender: TObject);
begin
     FrmFindFile.ShowModal;
end;

procedure TFrmMain.LeftShowFileListClick(Sender: TObject);
begin
     If Data[LeftList].DataType <> dtFileList Then Begin
        Data[LeftList].QueryDataType:=dtFileList;
        UpdateDir(LeftList);
     End;
end;

procedure TFrmMain.LeftShowFindResultClick(Sender: TObject);
begin
     If Data[LeftList].DataType <> dtFindResult Then Begin
        Data[LeftList].QueryDataType:=dtFindResult;
        UpdateDir(LeftList);
     End;
end;

procedure TFrmMain.RightShowFileListClick(Sender: TObject);
begin
     If Data[RightList].DataType <> dtFileList Then Begin
        Data[RightList].QueryDataType:=dtFileList;
        UpdateDir(RightList);
     End;
end;

procedure TFrmMain.RightShowFindResultClick(Sender: TObject);
begin
     If Data[RightList].DataType <> dtFindResult Then Begin
        Data[RightList].QueryDataType:=dtFindResult;
        UpdateDir(RightList);
     End;
end;

procedure TFrmMain.FileClearFindResultClick(Sender: TObject);
Var
   i: Integer;
begin
     If MessageDlg('Aktuelles Suchergebnis lschen?',mtConfirmation,[mbYes,mbNo],0) = mrYes Then Begin
        FrmFindFile.LstResult.Items.Clear;
        For i:=0 To 1 Do Begin
            If Data[i].DataType = dtFindResult Then Begin
               Data[i].QueryDataType:=dtFileList;
               UpdateDir(i);
            End;
        End;
     End;
end;

procedure TFrmMain.OptionsToggleFullscreenClick(Sender: TObject);
begin
     Case FrmMain.WindowState Of
          wsNormal: FrmMain.WindowState:=wsMaximized;
          wsMaximized: FrmMain.WindowState:=wsNormal;
     End;
end;

procedure TFrmMain.OptionsFiftyFiftyClick(Sender: TObject);
begin
     Data[LeftList].Width:=0.5;
     Data[RightList].Width:=0.5;
     FormResize(Nil);
end;


procedure TFrmMain.SpdRootLeftClick(Sender: TObject);
begin
     If Length(Data[LeftList].Directory) > 2 Then Begin
        Data[LeftList].Directory:=Data[LeftList].Directory[1]+':';
        UpdateDir(LeftList);
     End;
end;

procedure TFrmMain.SpdRootRightClick(Sender: TObject);
begin
     If Length(Data[RightList].Directory) > 2 Then Begin
        Data[RightList].Directory:=Data[RightList].Directory[1]+':';
        UpdateDir(RightList);
     End;
end;

procedure TFrmMain.CboDrive1Enter(Sender: TObject);
begin
     CurrentList:=LeftList;
     UpdateDirectoryBar;
end;

procedure TFrmMain.CboDrive2Enter(Sender: TObject);
begin
     CurrentList:=RightList;
     UpdateDirectoryBar;
end;

procedure TFrmMain.OptionsQuickViewClick(Sender: TObject);
begin
     If (Not FrmQuickView.Visible) Then Begin
        FrmQuickView.LoadFile('',0);
        FrmQuickView.AlignToFileList(Longint(Not Boolean(CurrentList)));
        FrmQuickView.Show;
     End Else Begin
        FrmQuickView.Hide;
     End;
     If Lists[CurrentList].ItemFocused <> Nil Then
        QuickView(Lists[CurrentList].ItemFocused, CurrentList);
end;

procedure TFrmMain.OptionsQuickViewFleesClick(Sender: TObject);
begin
     OptionsQuickViewFlees.Checked:=Not OptionsQuickViewFlees.Checked;
end;

procedure TFrmMain.LstFilesClick(Sender: TObject);
begin
     QuickView(LstFiles.ItemFocused, LeftList);
end;

procedure TFrmMain.LstFiles2Click(Sender: TObject);
begin
     QuickView(LstFiles2.ItemFocused, RightList);
end;

procedure TFrmMain.MenuOptionsClick(Sender: TObject);
begin
     OptionsDriveBar.Checked:=PnlDriveBar.Visible;
     OptionsDirectoryBar.Checked:=PnlDirectoryBar.Visible;
     OptionsCommandLineBar.Checked:=PnlCommandLineBar.Visible;
     OptionsStatusBar.Checked:=StsBar.Visible;
     OptionsQuickView.Checked:=FrmQuickView.Visible;
     OptionsStretch.Checked:=FrmQuickView.FitToImage;
     OptionsMaintainAspectRatio.Checked:=FrmQuickView.MaintainAspectRatio;
     OptionsWordWrap.Checked:=FrmQuickView.TextFile.WordWrap;
end;

procedure TFrmMain.LstFilesKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     If (Not LstFiles.IsEditing) Then FrmMain.LstFilesClick(Sender);
end;

procedure TFrmMain.LstFiles2KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     If LstFiles2.IsEditing Then Exit;
     FrmMain.LstFiles2Click(Sender);
end;

procedure TFrmMain.OptionsStretchClick(Sender: TObject);
begin
     FrmQuickView.FitToImage:=Not FrmQuickView.FitToImage;
end;

procedure TFrmMain.OptionsWordWrapClick(Sender: TObject);
begin
     FrmQuickView.TextFile.WordWrap:=Not FrmQuickView.TextFile.WordWrap;
end;

Procedure TFrmMain.ApplyDefaultColumnsWidth;
Begin
     SetDefaultColumnsWidth(Side);
     With Lists[Side], Data[Side].ColumnsWidth Do Begin
          Columns.BeginUpdate;
          Case Data[Side].DataType Of
               dtFileList:
                  Begin
                       Columns[ColumnName].Width:=NameWidth;
                       Columns[ColumnSize].Width:=SizeWidth;
                       Columns[ColumnDate].Width:=DateWidth;
                       Columns[ColumnAttr].Width:=AttrWidth;
                  End;
               dtFindResult:
                  Begin
                       Columns[ColumnName2].Width:=Name2Width;
                       Columns[ColumnPath].Width:=PathWidth;
                  End;
          End;
          Columns.EndUpdate;
     End;
     UpdateColumnHeaderImagesSide(Side);
End;

procedure TFrmMain.OptionsDefaultColumnsWidthClick(Sender: TObject);
begin
     ApplyDefaultColumnsWidth(CurrentList);
     If Options.SynchronizeColumnWidth Then
        ApplyDefaultColumnsWidth(Integer(Not Boolean(CurrentList)));
end;

Procedure ApplyFilter(Side: Integer);
Begin
     FrmFilter.Filter:=Data[Side].Filter;
     If FrmFilter.ShowModal = mrOK Then Begin
        Data[Side].Filter:=FrmFilter.Filter;
        Data[Side].UseFilter:=True;
        UpdateDir(Side);
     End;
End;

procedure TFrmMain.LeftFilterClick(Sender: TObject);
begin
     ApplyFilter(LeftList);
end;

procedure TFrmMain.RightFilterClick(Sender: TObject);
begin
     ApplyFilter(RightList);
end;

procedure TFrmMain.LeftUseFilterClick(Sender: TObject);
begin
     Data[LeftList].UseFilter:=Not Data[LeftList].UseFilter;
     UpdateDir(LeftList);
end;

procedure TFrmMain.RightUseFilterClick(Sender: TObject);
begin
     Data[RightList].UseFilter:=Not Data[RightList].UseFilter;
     UpdateDir(RightList);
end;

Procedure TFrmMain.GetOptions;
Begin
     With Options Do Begin
          FontName:=LstFiles.Font.Name;
          FontColor:=LstFiles.Font.Color;
          FontStyles:=LstFiles.Font.Style;
          FontSize:=LstFiles.Font.Size;
          Options.Color:=LstFiles.Color;
          GridLines:=LstFiles.GridLines;
     End;
End;

Procedure TFrmMain.SetOptions;
Begin
     With Options Do Begin
          LstFiles.Font.Name:=FontName;
          LstFiles.Font.Color:=FontColor;
          LstFiles.Font.Style:=FontStyles;
          LstFiles.Font.Size:=FontSize;
          LstFiles.Color:=Options.Color;
          LstFiles2.Font.Name:=FontName;
          LstFiles2.Font.Color:=FontColor;
          LstFiles2.Font.Style:=FontStyles;
          LstFiles2.Font.Size:=FontSize;
          LstFiles2.Color:=Options.Color;
          LstFiles.GridLines:=GridLines;
          LstFiles2.GridLines:=GridLines;
          If ClickToOpen Then Begin
             LstFiles.HotTrack:=True;
             LstFiles.HoverTime:=Integer($FFFFFFF);
             LstFiles2.HotTrack:=True;
             LstFiles2.HoverTime:=Integer($FFFFFFF);
          End Else Begin
             LstFiles.HotTrack:=False;
             LstFiles.HoverTime:=-1;
             LstFiles2.HotTrack:=False;
             LstFiles2.HoverTime:=-1;
          End;
     End;
     SetDoubleBuffering;
End;

Procedure CopyMoveCallBack(Const Path: String; Const FindData: TWin32FindData; CallBackType: Integer);
Var
   RelativeDir: String;
   Len: Integer;
   Result: Integer;
   Attr: Integer;
Begin
     If Canceled Then Begin
        SDCopyMove.Canceled:=True;
        Exit;
     End;
     Len:=Length(SourceDir);
     RelativeDir:=Copy(Path, Len+1, Length(Path)-Len);
     Case CallBackType Of
          ctEnteringDir:
             Begin
                  MakeDir(DestDir+RelativeDir, FindData.cFileName);
//                  CopyDir(SourceDir+RelativeDir+FindData.cFileName, DestDir+RelativeDir+FindData.cFileName);
                  Attr:=FindData.dwFileAttributes;
                  If ClearReadOnly Then
                     Attr:=(Attr And (Not faReadOnly));
                  FileSetAttr(DestDir+RelativeDir+FindData.cFileName, Attr);
             End;
          ctLeavingDir:
             Begin
                  If cmAction = cmMove Then
                     If (Not DontRemoveEmptyDirectories) Then RemDir(SourceDir+RelativeDir+FindData.cFileName);
             End;
          ctNormal:
             Begin
                  If (FindData.dwFileAttributes And faDirectory) > 0 Then Begin
                     MakeDir(DestDir+RelativeDir, FindData.cFileName);
//                     CopyDir(SourceDir+RelativeDir+FindData.cFileName, DestDir+RelativeDir+FindData.cFileName);
                     Attr:=FindData.dwFileAttributes;
                     If ClearReadOnly Then
                        Attr:=(Attr And (Not faReadOnly));
                     FileSetAttr(DestDir+RelativeDir+FindData.cFileName, Attr);
                     If cmAction = cmMove Then Begin
                        If (Not DontRemoveEmptyDirectories) Then RemDir(SourceDir+RelativeDir+FindData.cFileName);
                     End;
                  End Else Begin
                     If cmAction = cmCopy Then Begin
                        CopyFile(SourceDir+RelativeDir+FindData.cFileName, DestDir+RelativeDir+FindData.cFileName, FindData.nFileSizeLow, DISizeInBytes, Progress);
                     End Else If cmAction = cmMove Then Begin
                        FrmCopyMoveStatus.LblSource.Caption:=SourceDir+RelativeDir+FindData.cFileName;
                        FrmCopyMoveStatus.LblDest.Caption:=DestDir+RelativeDir+FindData.cFileName;
                        If Not RenameFile(SourceDir+RelativeDir+FindData.cFileName, DestDir+RelativeDir+FindData.cFileName) Then Begin
                           Result:=CopyFile(SourceDir+RelativeDir+FindData.cFileName, DestDir+RelativeDir+FindData.cFileName, FindData.nFileSizeLow, DISizeInBytes, Progress);
                           If Result > 0 Then Begin
                              FileSetAttr(SourceDir+RelativeDir+FindData.cFileName, faArchive);
                              SysUtils.DeleteFile(SourceDir+RelativeDir+FindData.cFileName);
                           End;
                        End Else Begin
                           Progress:=Progress+FindData.nFileSizeLow;
                           If DISizeInBytes <> 0 Then FrmCopyMoveStatus.PrgAllFiles.Position:=Round(Progress/DISizeInBytes*100);
                        End;
                        Application.ProcessMessages;
                     End;
                  End;
             End;
     End;
End;

Procedure CopyMove(Action, Side: Integer; DragAndDrop: Boolean; Target: String);
Var
   i: Longint;
   Result: Longint;
Begin
     If FrmMain.Busy > 0 Then Exit;

     // Anzeige richtigstellen
     cmAction:=Action;
     With FrmCopyMove Do Begin
          SourceList:=Side;
          Case cmAction Of
               cmCopy:
                  Begin
                       HelpContext:=IDH_FileCopy;
                       Caption:='Kopieren';
                       ImgCopyMove.Picture:=ImgCopy.Picture;
                       FrmCopyMoveStatus.LblCopyMove.Caption:='Kopiere:';
                       ChkCopyOnlyNewFiles.Visible:=True;
                       ChkAlwaysOverwriteOldFiles.Visible:=True;
                       ChkDontRemoveEmptyDirectories.Visible:=False;
                  End;
               cmMove:
                  Begin
                       HelpContext:=IDH_FileMove;
                       Caption:='Verschieben';
                       ImgCopyMove.Picture:=ImgMove.Picture;
                       FrmCopyMoveStatus.LblCopyMove.Caption:='Verschiebe:';
                       ChkCopyOnlyNewFiles.Visible:=False;
                       ChkAlwaysOverwriteOldFiles.Visible:=False;
                       ChkDontRemoveEmptyDirectories.Visible:=True;
                  End;
          End;
     End;
     FrmCopyMove.ChkUseFilter.Checked:=Data[Side].UseFilter;

     // Verzeichnisse in temp. Var. laden
     If Data[Side].DataType = dtFileList Then
        SourceDir:=Data[Side].Directory+'\'
     Else
        SourceDir:='';
     If Target = '' Then
        DestDir:=Data[Integer(Not Boolean(Side))].Directory+'\'
     Else
        DestDir:=Target;
     // Dialogbox anzeigen
     FrmCopyMove.EdtTarget.Text:=DestDir;
     If FrmCopyMove.ShowModal = mrOK Then Begin
        DestDir:=Trim(FrmCopyMove.EdtTarget.Text);
        If DestDir[Length(DestDir)] <> '\' Then DestDir:=DestDir+'\';
        // Testen, ob es berhaupt mglich ist, in das angegebene Verz. zu kopieren
        If AnsiCompareText(DestDir,SourceDir) = 0 Then Begin
           MessageDlg('Dateien oder Verzeichnisse knnen nicht auf sich selbst kopiert werden.',mtError,[mbOK],0);
           Exit;
        End;
        If FrmMain.Lists[Side].Items.Count > 0 Then With FrmMain.Lists[Side] Do Begin
           For i:=0 To Items.Count-1 Do Begin
               If Items[i].Selected Then Begin
                  If AnsiCompareText(GetFullName(Items[i].Data,Side),DestDir+GetName(Items[i].Data,Side)) = 0 Then Begin
                     MessageDlg('Dateien oder Verzeichnisse knnen nicht auf sich selbst kopiert werden.',mtError,[mbOK],0);
                     Exit;
                  End;
               End;
           End;
        End;
        If FrmMain.Lists[Side].Items.Count > 0 Then With FrmMain.Lists[Side] Do Begin
           For i:=0 To Items.Count-1 Do Begin
               If Items[i].Selected Then Begin
                  If Pos(AnsiUpperCase(GetFullName(Items[i].Data,Side)+'\'),AnsiUpperCase(DestDir)) > 0 Then Begin
                     MessageDlg('Ein bergeordnetes Verzeichnis kann nicht in eines seiner untergeordneten Verzeichnisse kopiert werden. Das wrde eine Endlos-Schleife verursachen.',mtError,[mbOK],0);
                     Exit;
                  End;
               End;
           End;
        End;
        // Kopieren vorbereiten (Variablen, Objekte initialisieren usw.)
        If (Not PathExists(DestDir, True)) Then Exit;
        DontRemoveEmptyDirectories:=(FrmCopyMove.ChkDontRemoveEmptyDirectories.Checked And FrmCopyMove.ChkDontRemoveEmptyDirectories.Enabled);
        OverwriteAll:=Not Options.ConfirmOverwrite;
        CopyOnlyNewFiles:=FrmCopyMove.ChkCopyOnlyNewFiles.Checked And (Action = cmCopy);
        AlwaysOverwriteOldFiles:=FrmCopyMove.ChkAlwaysOverwriteOldFiles.Checked And (Action = cmCopy);
        With SDCopyMove Do Begin
             ProcessMessages:=True;
             CallBacks:=cbBeforeRecurse+cbAfterRecurse;
        End;
        With FrmCopyMoveStatus Do Begin
             LblSource.Caption:='';
             LblDest.Caption:='';
             PrgFile.Position:=0;
             PrgAllFiles.Position:=0;
             LblTimeLeft.Caption:='';
             LblETA.Visible:=False;
        End;
        Canceled:=False;
        Progress:=0;
        AllFilesSize:=DISizeInBytes;
        CurrentTickCount:=GetTickCount;
        OldTickCount:=CurrentTickCount;
        If Assigned(ETA) Then ETA.Free;
        ETA:=TTimer.Create(FrmMain);
        ETA.OnTimer:=FrmMain.ETATime;
        ETA.Interval:=5000;
        // Herausfinden, ob ReadOnly-Attribut gelscht werden soll
        If ((Action = cmCopy) And Options.ClearReadOnlyAttribute) Then Begin
           If (Data[Side].DataType = dtFileList) Then
              ClearReadOnly:=(GetDriveType(PChar(Data[Side].Directory[1]+':\')) = DRIVE_CDROM)
           Else Begin
              If FrmMain.Lists[Side].Items.Count > 0 Then Begin
                 // Da alle Dateien im Suchergebnis sich auf dem selben Laufwerk
                 // befinden, brauchen wir nur eine (z.B. die erste) zu berprfen
                 ClearReadOnly:=(GetDriveType(PChar(Dat(FrmMain.Lists[Side].Items[0].Data^).fPath[1]+':\')) = DRIVE_CDROM);
              End Else ClearReadOnly:=False;
           End;
        End Else ClearReadOnly:=False;
        // Windows kann ein Verzeichnis nicht lschen, wenn es das aktive Verz. ist
        ChDir(Copy(Data[Side].Directory, 1, 2)+'\');
        If Data[Side].DataType = dtFileList Then Begin
           Try
              FrmMain.BeginBusy;
              FrmCopyMoveStatus.Show;
              Case cmAction Of
                   cmMove: CallBackFiles(Side, SDCopyMove, CopyMoveCallBack, cbBeforeRecurse+cbAfterRecurse, Data[Side].Filter, False, FrmCopyMove.ChkUseFilter.Checked, FrmCopyMove.ChkRecursive.Checked);
                   cmCopy: CallBackFiles(Side, SDCopyMove, CopyMoveCallBack, cbBeforeRecurse, Data[Side].Filter, False, FrmCopyMove.ChkUseFilter.Checked, FrmCopyMove.ChkRecursive.Checked);
              End;
           Finally
              ETA.Free;
              ETA:=Nil;
              FrmCopyMoveStatus.Close;
              FrmMain.EndBusy;
              FrmMain.UpdateLists;
           End;
        End Else If Data[Side].DataType = dtFindResult Then With FrmMain.Lists[Side] Do Try
           FrmMain.BeginBusy;
           FrmCopyMoveStatus.Show;
           With SDCopyMove Do Begin
                Init;
                CallBack:=CopyMoveCallBack;
                ProcessMessages:=True;
                Canceled:=False;
           End;
           Case cmAction Of
              cmCopy:
                 Begin
                    SDCopyMove.CallBacks:=cbBeforeRecurse;
                    For i:=0 To FrmMain.Lists[Side].Items.Count-1 Do If Items[i].Selected Then Begin
                        If (Not Canceled) Then Begin
                           If Dat(Items[i].Data^).fAttr And faDirectory = 0 Then Begin
                              CopyFile(GetFullName(Items[i].Data, Side), DestDir+GetName(Items[i].Data, Side), Dat(Items[i].Data^).fSize, DISizeInBytes, Progress);
                           End Else Begin
                              MakeDir(DestDir, GetName(Items[i].Data, Side));
                              FileSetAttr(DestDir+GetName(Items[i].Data, Side), Dat(Items[i].Data^).fAttr);
                              If FrmCopyMove.ChkRecursive.Checked Then Begin
                                 SourceDir:=GetPath(Items[i].Data, Side);
                                 If FrmCopyMove.ChkUseFilter.Checked Then
                                    SDCopyMove.Search(GetFullName(Items[i].Data, Side)+'\', Data[Side].Filter, True, True)
                                 Else
                                    SDCopyMove.Search(GetFullName(Items[i].Data, Side)+'\', FilterAllFiles, True, True);
                              End;
                           End;
                           Application.ProcessMessages;
                        End;
                    End;
                 End;
              cmMove:
                 Begin
                    SDCopyMove.CallBacks:=cbBeforeRecurse+cbAfterRecurse;
                    For i:=0 To FrmMain.Lists[Side].Items.Count-1 Do If Items[i].Selected Then Begin
                        If (Not Canceled) Then Begin
                           If Dat(Items[i].Data^).fAttr And faDirectory = 0 Then Begin
                              FrmCopyMoveStatus.LblSource.Caption:=GetFullName(Items[i].Data, Side);
                              FrmCopyMoveStatus.LblDest.Caption:=DestDir+GetName(Items[i].Data, Side);
                              If Not RenameFile(GetFullName(Items[i].Data, Side), DestDir+GetName(Items[i].Data, Side)) Then Begin
                                 Result:=CopyFile(GetFullName(Items[i].Data, Side), DestDir+GetName(Items[i].Data, Side), Dat(Items[i].Data^).fSize, DISizeInBytes, Progress);
                                 If Result > 0 Then Begin
                                    FileSetAttr(GetFullName(Items[i].Data, Side), faArchive);
                                    SysUtils.DeleteFile(GetFullName(Items[i].Data, Side));
                                 End;
                              End Else Begin
                                 Progress:=Progress+Dat(Items[i].Data^).fSize;
                                 If DISizeInBytes <> 0 Then FrmCopyMoveStatus.PrgAllFiles.Position:=Round(Progress/DISizeInBytes*100);
                              End;
                           End Else Begin
                              MakeDir(DestDir, GetName(Items[i].Data, Side));
                              FileSetAttr(DestDir+GetName(Items[i].Data, Side), Dat(Items[i].Data^).fAttr);
                              If FrmCopyMove.ChkRecursive.Checked Then Begin
                                 SourceDir:=GetPath(Items[i].Data, Side);
                                 If FrmCopyMove.ChkUseFilter.Checked Then
                                    SDCopyMove.Search(GetFullName(Items[i].Data, Side)+'\', Data[Side].Filter, True, True)
                                 Else
                                    SDCopyMove.Search(GetFullName(Items[i].Data, Side)+'\', FilterAllFiles, True, True);
                              End;
                              If (Not Canceled) Then
                                 If (Not DontRemoveEmptyDirectories) Then
                                    RemDir(GetFullName(Items[i].Data, Side));
                           End;
                           Application.ProcessMessages;
                        End;
                    End;
                 End;
              End;
        Finally
           ETA.Free;
           ETA:=Nil;
           FrmCopyMoveStatus.Close;
           FrmMain.EndBusy;
           FrmMain.UpdateList(Integer(Not Boolean(Side)));
           UpdateDir(Side);
        End;
     End;
End;

procedure TFrmMain.FileCopyClick(Sender: TObject);
begin
     CopyMove(cmCopy, CurrentList, False, '');
end;

procedure TFrmMain.FileMoveClick(Sender: TObject);
begin
     CopyMove(cmMove, CurrentList, False, '');
end;

Procedure DeleteFilesCallBack(Const Path: String; Const FindData: TWin32FindData; CallBackType: Integer);
Var
   Mes: Integer;
Begin
     If Canceled Then Begin
        SDDelete.Canceled:=True;
        Exit;
     End;
     Case CallBackType Of
          ctLeavingDir:
             Begin
                  If (Not DeleteAll) And ((FindData.dwFileAttributes And faDirectory) > 0) Then Begin
                     If Options.ConfirmDeleteDirectory Then Begin
                        Mes:=MessageDlg('Soll das Verzeichnis "'+Path+FindData.cFileName+'" wirklich gelscht werden?',mtConfirmation,[mbYes,mbNo,mbAll,mbCancel],0);
                        Case Mes Of
                             mrNo:     Begin
                                            Exit;
                                       End;
                             mrAll:    DeleteAll:=True;
                             mrCancel: Begin
                                            Canceled:=True;
                                            SDDelete.Canceled:=True;
                                            Exit;
                                       End;
                        End;
                     End;
                  End;
                  If (Not DontRemoveEmptyDirectories) Then DeleteDirectory(Path+FindData.cFileName);
             End;
          ctNormal:
             Begin
                  DeleteFile(Path+FindData.cFileName, Progress, DIFileNum);
             End;
     End;
End;

Procedure DeleteFiles(Side: Integer);
Begin
     If FrmMain.Busy > 0 Then Exit;
     FrmDelete.ChkUseFilter.Checked:=Data[Side].UseFilter;
     FrmDelete.SourceList:=Side;
     If FrmDelete.ShowModal = mrOK Then Begin
        Try
           // Windows kann ein Verzeichnis nicht lschen, wenn es das aktive Verz. ist
           ChDir(Copy(Data[Side].Directory, 1, 2)+'\');
           FrmMain.BeginBusy;
           With SDDelete Do Begin
                Init;
                ProcessMessages:=True;
                Canceled:=False;
           End;
           With FrmDeleteStatus Do Begin
                LblDeleteFile.Caption:='';
                PrgAllFiles.Position:=0;
           End;
           DontRemoveEmptyDirectories:=(FrmDelete.ChkDontRemoveEmptyDirectories.Checked And FrmDelete.ChkDontRemoveEmptyDirectories.Enabled);
           Progress:=0;
           Canceled:=False;
           DeleteAll:=Not Options.ConfirmDeleteFile;
           FrmDeleteStatus.Show;
           CallBackFiles(Side, SDDelete, DeleteFilesCallBack, cbAfterRecurse, Data[Side].Filter, False, FrmDelete.ChkUseFilter.Checked, True);
           FrmDeleteStatus.Close;
        Finally
           FrmMain.EndBusy;
           FrmMain.UpdateLists;
           If Data[Side].DataType = dtFindResult Then UpdateDir(Side);
        End;
     End;
End;

Procedure TFrmMain.FileDeleteClick(Sender: TObject);
Begin
     DeleteFiles(CurrentList);
End;

procedure TFrmMain.PopListsPopup(Sender: TObject);
begin
     With Data[CurrentList] Do Begin
          PopSortPath.Visible:=(DataType = dtFindResult);
          Case TViewStyle(ListType) Of
               vsReport: PopReport.Checked:=True;
               vsList: PopList.Checked:=True;
               vsSmallIcon: PopSmallIcons.Checked:=True;
               vsIcon: PopIcons.Checked:=True;
          End;
          Case SortType Of
             SortName: PopSortName.Checked:=True;
             SortExt: PopSortExt.Checked:=True;
             SortSize: PopSortSize.Checked:=True;
             SortDate: PopSortDate.Checked:=True;
             SortPath: PopSortPath.Checked:=True;
          End;
          If Data[CurrentList].SortDir = SortDirUp Then
             PopSortDirUp.Checked:=True
          Else
             PopSortDirUp.Checked:=False;
          If Data[CurrentList].DataType = dtFileList Then Begin
             PopShowFileList.Checked:=True;
          End Else Begin
             PopShowFindResult.Checked:=True;
          End;
     End;
end;

procedure TFrmMain.PopReportClick(Sender: TObject);
begin
     With Data[CurrentList] Do Begin
          ListType:=Longint((Sender As TMenuItem).Tag);
          Lists[CurrentList].ViewStyle:=TViewStyle((Sender As TMenuItem).Tag);
     End;
     UpdateColumnHeaderImagesSide(CurrentList);
end;

procedure TFrmMain.PopSortDateClick(Sender: TObject);
begin
     Data[CurrentList].SortType:=(Sender As TMenuItem).Tag;
     Lists[CurrentList].AlphaSort;
     UpdateColumnHeaderImagesSide(CurrentList);
end;

procedure TFrmMain.PopShowFileListClick(Sender: TObject);
begin
     If Data[CurrentList].DataType <> dtFileList Then Begin
        Data[CurrentList].QueryDataType:=dtFileList;
        UpdateDir(CurrentList);
     End;
end;

procedure TFrmMain.PopShowFindResultClick(Sender: TObject);
begin
     If Data[CurrentList].DataType <> dtFindResult Then Begin
        Data[CurrentList].QueryDataType:=dtFindResult;
        UpdateDir(CurrentList);
     End;
end;

procedure TFrmMain.PopUpdateClick(Sender: TObject);
begin
     UpDateDir(CurrentList);
     DriveLists[CurrentList].UpdateDriveList;
end;

procedure TFrmMain.PopSortDirUpClick(Sender: TObject);
begin
     PopSortDirUp.Checked:=Not PopSortDirUp.Checked;
     If PopSortDirUp.Checked Then
        Data[CurrentList].SortDir:=SortDirUp
     Else
        Data[CurrentList].SortDir:=SortDirDown;
     Lists[CurrentList].AlphaSort;
     UpdateColumnHeaderImagesSide(CurrentList);
end;

Procedure SetNewFilename(Side: Integer; Item: TListItem; Var NewName: String);
Var
   p: Integer;
Begin
     FrmMain.BeginBusy;
     Try
        If NewName = '' Then Begin
           NewName:=Item.Caption;
           FrmMain.EndBusy;
           Exit;
        End;
        p:=0;
        Repeat
              Inc(p);
              If Pos(SpecialChars[p], NewName) > 0 Then Begin
                 MessageDlg('Der neue Name darf keins der folgenden Zeichen enthalten:'+#13+#10+SpecialChars, mtError, [mbOK], 0);
                 NewName:=Item.Caption;
                 FrmMain.EndBusy;
                 Exit;
              End;
        Until p = Length(SpecialChars);
        While (Not RenameFile(GetFullName(Item.Data, Side), GetPath(Item.Data, Side)+NewName)) Do Begin
              If MessageDlg('"'+GetFullName(Item.Data, Side)+'" konnte nicht in'+#13+#10+'"'+GetPath(Item.Data, Side)+NewName+'" umbenannt werden.'+#13+#10+GetLastErrorString, mtError, [mbRetry, mbCancel], 0) = mrCancel Then Begin
                 NewName:=Item.Caption;
                 FrmMain.EndBusy;
                 Exit;
              End;
        End;
        Dat(Item.Data^).fName:=NewName;
        If Not DirectoryExists(Data[Integer(Not Boolean(Side))].Directory+'\') Then UpdateDir(Integer(Not Boolean(Side)));
     Finally
        FrmMain.EndBusy;
        FrmMain.UpdateChangeNotificationHandler(Side);
        FrmMain.UpdateList(Integer(Not Boolean(Side)));
     End;
End;

procedure TFrmMain.LstFilesEdited(Sender: TObject; Item: TListItem;
  var S: String);
begin
     SetNewFilename(LeftList, Item, s);
     ForceLabelEditing:=False;
end;

procedure TFrmMain.LstFiles2Edited(Sender: TObject; Item: TListItem;
  var S: String);
begin
     SetNewFilename(RightList, Item, s);
end;

procedure TFrmMain.FileRenameClick(Sender: TObject);
begin
     If Lists[CurrentList].ItemFocused <> Nil Then Try
        ForceLabelEditing:=True;
        Lists[CurrentList].ItemFocused.EditCaption;
     Finally
        ForceLAbelEditing:=False;
     End;
end;

Procedure SetAttrCallBack(Const Path: String; Const FindData: TWin32FindData; CallBackType: Integer);
Var
   NewAttr: Longint;
   Mes, Res: Longint;
   NewASys, NewAHidden, NewAReadOnly, NewAArchive: Boolean;
Begin
     If Canceled Then Exit;
     FrmSetAttrStatus.LblActFile.Caption:=Path+FindData.cFilename;
     Application.ProcessMessages;
     NewASys:=False;
     NewAHidden:=False;
     NewAReadOnly:=False;
     NewAArchive:=False;
     // Neue Attribute bilden
     Case FrmSetAttr.ChkSysFile.State Of
          cbChecked: NewASys:=True;
          cbUnchecked: NewASys:=False;
          cbGrayed: NewASys:=((FindData.dwFileAttributes And faSysFile) > 0);
     End;
     Case FrmSetAttr.ChkHidden.State Of
          cbChecked: NewAHidden:=True;
          cbUnchecked: NewAHidden:=False;
          cbGrayed: NewAHidden:=((FindData.dwFileAttributes And faHidden) > 0);
     End;
     Case FrmSetAttr.ChkReadOnly.State Of
          cbChecked: NewAReadOnly:=True;
          cbUnchecked: NewAReadOnly:=False;
          cbGrayed: NewAReadOnly:=((FindData.dwFileAttributes And faReadOnly) > 0);
     End;
     Case FrmSetAttr.ChkArchive.State Of
          cbChecked: NewAArchive:=True;
          cbUnchecked: NewAArchive:=False;
          cbGrayed: NewAArchive:=((FindData.dwFileAttributes And faArchive) > 0);
     End;
     NewAttr:=0;
     If NewASys Then Inc(NewAttr, faSysFile);
     If NewAHidden Then Inc(NewAttr, faHidden);
     If NewAReadOnly Then Inc(NewAttr, faReadOnly);
     If NewAArchive Then Inc(NewAttr, faArchive);
     If (FindData.dwFileAttributes And faDirectory) > 0 Then Inc(NewAttr, faDirectory);
     // Attribute setzen
     Res:=FileSetAttr(Path+FindData.cFileName, NewAttr);
     While Res <> 0 Do Begin
           Mes:=MessageDlg('Fehler beim Setzen der Attribute von '+Path+FindData.cFileName+'.'+#13+#10+GetLastErrorString, mtError, [mbRetry, mbIgnore, mbCancel], 0);
           Case Mes Of
                mrCancel: Begin
                               Canceled:=True;
                               SDAttributes.Canceled:=True;
                               Exit;
                          End;
                mrIgnore: Begin
                               Exit;
                          End;
           End;
           Res:=FileSetAttr(Path+FindData.cFileName, NewAttr);
     End;
     // Prozent-Balken aktualisieren
     Progress:=Progress+1;
     If DIObjNum > 0 Then FrmSetAttrStatus.PrgAllFiles.Position:=Round(Progress / DIObjNum * 100);
     Application.ProcessMessages;
End;

Procedure SetAttr(Side: Integer);
Begin
     If FrmMain.Busy > 0 Then Exit;
     With FrmSetAttr Do Begin
          SourceList:=Side;
          ChkUseFilter.Checked:=Data[Side].UseFilter;
          If ShowModal = mrOK Then Begin
             // Gucken, ob berhaupt was zu tun ist...
             If (ChkArchive.State = cbGrayed) And
                (ChkHidden.State = cbGrayed) And
                (ChkReadOnly.State = cbGrayed) And
                (ChkSysFile.State = cbGrayed) Then Exit;
             FrmMain.BeginBusy;
             Try
                SDAttributes.Init;
                SDAttributes.Canceled:=False;
                SDAttributes.ProcessMessages:=False;
                FrmSetAttrStatus.PrgAllFiles.Position:=0;
                FrmSetAttrStatus.Show;
                Progress:=0;
                CallBackFiles(Side, SDAttributes, SetAttrCallBack, cbAfterRecurse, Data[Side].Filter, False, ChkUseFilter.Checked, ChkRecursive.Checked);
             Finally
                FrmMain.EndBusy;
                FrmSetAttrStatus.Close;
                FrmMain.UpdateLists;
                If Data[Side].DataType = dtFindResult Then UpdateDir(Side);
             End;
          End;
     End;
End;

procedure TFrmMain.FileAttrClick(Sender: TObject);
begin
     SetAttr(CurrentList);
end;

procedure TFrmMain.PopCopyClick(Sender: TObject);
begin
     CopyMove(cmCopy, CurrentList, False, Data[Integer(Not Boolean(CurrentList))].Directory+'\');
end;

procedure TFrmMain.PopMoveClick(Sender: TObject);
begin
     CopyMove(cmMove, CurrentList, False, Data[Integer(Not Boolean(CurrentList))].Directory+'\');
end;

procedure TFrmMain.PopRenameClick(Sender: TObject);
begin
     FileRenameClick(Sender);
end;

procedure TFrmMain.PopDeleteClick(Sender: TObject);
begin
     DeleteFiles(CurrentList);
end;

procedure TFrmMain.PopSetAttributesClick(Sender: TObject);
begin
     SetAttr(CurrentList);
end;

Procedure ShowPropertySheet(Side: Integer);
Var
   Desktop: IShellFolder;
   Drive: String;
   ReferenceFolderItemIDList: PItemIDList;
   ReferenceFolder: IShellFolder;
   MAlloc: IMAlloc;
   Wide: Array[0..MAX_PATH] Of WideChar;
   Dummy: Cardinal;
   Context: IContextMenu;
   CommandInfo: TCMINVOKECOMMANDINFO;
   i, ItemsCounter: Integer;
   Filename: String;
   Items: Array[0..16383] Of PItemIDList;
Begin
     If Not IsSomethingSelected(Side) Then Exit;

     // Desktop-ShellFolder allokieren
     If Succeeded(SHGetDesktopFolder(Desktop)) Then Begin
        Desktop._AddRef;

        // Referenz-Shellfolder allokieren
        If Data[Side].DataType = dtFileList Then
           Drive:=Copy(Data[Side].Directory, 1, 2)+'\'
        Else If Data[Side].DataType = dtFindResult Then
           Drive:=Copy(GetPath(FrmMain.Lists[Side].Items[0].Data, Side), 1, 2)+'\';
        MultiByteToWideChar(CP_ACP, 0, PChar(Drive), -1, Wide, MAX_PATH);
        If Succeeded(Desktop.ParseDisplayName(FrmMain.Handle, Nil, Wide, Dummy, ReferenceFolderItemIDList, Dummy)) Then Begin
           If Succeeded(Desktop.BindToObject(ReferenceFolderItemIDList, Nil, IID_IShellFolder, Pointer(ReferenceFolder))) Then Begin
              ReferenceFolder._AddRef;

              // ItemIDLists fr alle markierten Objekte erstellen
              ItemsCounter:=0;
              For i:=0 To FrmMain.Lists[Side].Items.Count-1 Do Begin
                  If FrmMain.Lists[Side].Items[i].Selected Then Begin
                     Filename:=GetFullName(FrmMain.Lists[Side].Items[i].Data, Side);
                     MultiByteToWideChar(CP_ACP, 0, PChar(Copy(Filename, 4, Length(Filename)-3)), -1, Wide, MAX_PATH);
                     If Succeeded(ReferenceFolder.ParseDisplayName(0, Nil, Wide, Dummy, Items[ItemsCounter], Dummy)) Then
                        If ItemsCounter < 16383 Then Inc(ItemsCounter);
                  End;
              End;

              // "Eigenschaften" aus dem Shell-Men aufrufen
              If Succeeded(ReferenceFolder.GetUIObjectOf(0, ItemsCounter, Items[0], IID_IContextMenu, Nil, Pointer(Context))) Then Begin
                 Context._AddRef;
                 CommandInfo.cbSize:=SizeOf(CommandInfo);
                 CommandInfo.fMask:=0;
                 CommandInfo.hwnd:=FrmMain.Handle;
                 CommandInfo.lpVerb:=PChar('Properties');
                 CommandInfo.nShow:=SW_SHOWNORMAL;
                 Context.InvokeCommand(CommandInfo);
                 Context._Release;
              End;

              // ItemIDLists wieder freigeben
              If Succeeded(SHGetMAlloc(MAlloc)) Then Begin
                 MAlloc._AddRef;
                 For i:=0 To ItemsCounter-1 Do MAlloc.Free(Items[i]);
                 MAlloc.Free(ReferenceFolderItemIDList);
                 MAlloc._Release;
              End;

              // ggf. Listen updaten
              FrmMain.UpdateLists;

              ReferenceFolder._Release;
           End;

        End;

        Desktop._Release;
     End;

End;

Procedure TFrmMain.ShowExplorerMenu;
Var
   Desktop: IShellFolder;
   Drive: String;
   ReferenceFolderItemIDList: PItemIDList;
   ReferenceFolder: IShellFolder;
   MAlloc: IMAlloc;
   Wide: Array[0..MAX_PATH] Of WideChar;
   Dummy: Cardinal;
   Context: IContextMenu;
   i, ItemsCounter: Integer;
   Filename: String;
   Items: Array[0..16383] Of PItemIDList;
   popupmenu: HMenu;
   Cmd: Cardinal;
   CommandInfo: TCMINVOKECOMMANDINFO;
Begin
     If Not IsSomethingSelected(Side) Then Exit;

     // Desktop-ShellFolder allokieren
     If Succeeded(SHGetDesktopFolder(Desktop)) Then Begin
        Desktop._AddRef;

        // Referenz-Shellfolder allokieren
        If Data[Side].DataType = dtFileList Then
           Drive:=Copy(Data[Side].Directory, 1, 2)+'\'
        Else If Data[Side].DataType = dtFindResult Then
           Drive:=Copy(GetPath(FrmMain.Lists[Side].Items[0].Data, Side), 1, 2)+'\';
        MultiByteToWideChar(CP_ACP, 0, PChar(Drive), -1, Wide, MAX_PATH);
        If Succeeded(Desktop.ParseDisplayName(FrmMain.Handle, Nil, Wide, Dummy, ReferenceFolderItemIDList, Dummy)) Then Begin
           If Succeeded(Desktop.BindToObject(ReferenceFolderItemIDList, Nil, IID_IShellFolder, Pointer(ReferenceFolder))) Then Begin
              ReferenceFolder._AddRef;

              // ItemIDLists fr alle markierten Objekte erstellen
              ItemsCounter:=0;
              For i:=0 To FrmMain.Lists[Side].Items.Count-1 Do Begin
                  If FrmMain.Lists[Side].Items[i].Selected Then Begin
                     Filename:=GetFullName(FrmMain.Lists[Side].Items[i].Data, Side);
                     MultiByteToWideChar(CP_ACP, 0, PChar(Copy(Filename, 4, Length(Filename)-3)), -1, Wide, MAX_PATH);
                     If Succeeded(ReferenceFolder.ParseDisplayName(0, Nil, Wide, Dummy, Items[ItemsCounter], Dummy)) Then
                        If ItemsCounter < 16383 Then Inc(ItemsCounter);
                  End;
              End;

              If Succeeded(ReferenceFolder.GetUIObjectOf(0, ItemsCounter, Items[0], IID_IContextMenu, Nil, Pointer(Context))) Then Begin
                 Context._AddRef;

                 Try
                    popupmenu:=CreatePopUpMenu;
                    Context.QueryContextMenu(popupmenu, 0, 1, 500, CMF_NORMAL);
                    Cmd:=Cardinal(TrackPopupMenuEx(PopupMenu, TPM_LEFTALIGN Or TPM_RIGHTBUTTON Or TPM_RETURNCMD, p.x, p.y, Handle, Nil));

                    If Cmd > 0 Then Begin
                       CommandInfo.cbSize:=SizeOf(CommandInfo);
                       CommandInfo.fMask:=0;
                       CommandInfo.hwnd:=FrmMain.Handle;
                       CommandInfo.lpVerb:=MakeIntResource(Cmd - 1);
                       CommandInfo.nShow:=SW_SHOWNORMAL;
                       Context.InvokeCommand(CommandInfo);
                    End;
                 Except
                    Exit;
                 End;

                 DestroyMenu(popupmenu);
                 Context._Release;

              End;

              // ItemIDLists wieder freigeben
              If Succeeded(SHGetMAlloc(MAlloc)) Then Begin
                 MAlloc._AddRef;
                 For i:=0 To ItemsCounter-1 Do MAlloc.Free(Items[i]);
                 MAlloc.Free(ReferenceFolderItemIDList);
                 MAlloc._Release;
              End;

              // ggf. Listen updaten
              FrmMain.UpdateLists;

              ReferenceFolder._Release;
           End;

        End;

        Desktop._Release;
     End;

End;

procedure TFrmMain.FilePropertiesClick(Sender: TObject);
begin
     ShowPropertySheet(CurrentList);
end;

procedure TFrmMain.PopPropertiesClick(Sender: TObject);
begin
     ShowPropertySheet(CurrentList);
end;

Procedure TFrmMain.ViewTextFile;
Var
   Params: String;
   p: Integer;
Begin
     Filename:=Trim(Filename);
     Application.Hint:='';
     ShowTheHint(Nil);
     If Options.UseInternalTextEdit Then Begin
        // Internen Text-Editor aufrufen
        Application.CreateForm(TFrmTextEdit, FrmTextEdit);
        If Length(Filename) > 0 Then Begin
           FrmTextEdit.MmoText.Lines.LoadFromFile(Filename);
           FrmTextEdit.Caption:=Filename;
        End Else
           FrmTextEdit.Caption:=TextEditForm.NewFile;
        ActFile:=FrmTextEdit.Caption;
        FrmTextEdit.MmoText.Modified:=False;
        FrmTextEdit.StsBar.Panels[3].Text:='';
        // Einstellungen bertragen
        FrmTextEdit.OptionsToolBar.Checked:=EditorOptions.ShowToolBar;
        FrmTextEdit.OptionsStatusBar.Checked:=EditorOptions.ShowStatusBar;
        FrmTextEdit.OptionsWordWrap.Checked:=EditorOptions.WordWrap;
        FrmTextEdit.FindWordAtCursor.Checked:=EditorOptions.FindTextAtCursor;
        FrmTextEdit.TlbTools.Visible:=EditorOptions.ShowToolBar;
        FrmTextEdit.StsBar.Visible:=EditorOptions.ShowStatusBar;
        FrmTextEdit.MmoText.WordWrap:=EditorOptions.WordWrap;
        // Form anzeigen
        FrmTextEdit.ShowModal;
        // Einstellungen auslesen
        EditorOptions.ShowToolBar:=FrmTextEdit.OptionsToolBar.Checked;
        EditorOptions.ShowStatusBar:=FrmTextEdit.OptionsStatusBar.Checked;
        EditorOptions.WordWrap:=FrmTextEdit.OptionsWordWrap.Checked;
        EditorOptions.FindTextAtCursor:=FrmtextEdit.FindWordAtCursor.Checked;
        // Form wieder freigeben
        Application.OnHint:=ShowTheHint;
        FrmTextEdit.Release;
     End Else Begin
        Params:=Options.ExternalTextEditParams;
        // Alle Vorkommnisse von %Name% durch Filename ersetzen
        p:=Pos('%NAME%', AnsiUpperCase(Params));
        While p > 0 Do Begin
              Delete(Params, p, 6);
              If Length(Filename) > 0 Then
                 Insert('"'+Filename+'"', Params, p);
              p:=Pos('%NAME%', AnsiUpperCase(Params));
        End;
        // Programm ausfhren
        If ExecuteFile(Options.ExternalTextEditPath, Params, '', SW_SHOW) <= 32 Then
           MessageDlg('"'+Options.ExternalTextEditPath+'" konnte nicht ausgefhrt werden.'+#13+#10+GetLastErrorString, mtError, [mbOK], 0);
     End;
End;

Procedure TFrmMain.FileViewClick(Sender: TObject);
Begin
     If Lists[CurrentList].ItemFocused <> Nil Then Begin
        ViewTextFile(GetFullName(Lists[CurrentList].ItemFocused.Data, CurrentList));
     End;
End;

Procedure TFrmMain.SaveOptions;
Var
   f: TIniFile;
   i: Integer;
   winplacement: TWindowPlacement;
   res: Boolean;
Begin
     FrmMain.GetOptions;
     f:=TIniFile.Create(ProgPath+IniFileName);
     With Options do Begin
          // Start
          f.WriteBool(StartupSection, 'RestoreDirectories', RestoreDirectories);
          f.WriteString(StartupSection, 'StdDirLeft', StdDirLeft);
          f.WriteString(StartupSection, 'StdDirRight', StdDirRight);
          f.WriteBool(StartupSection, 'RestoreWindow', RestoreWindow);
          // Fenster
          winplacement.length:=SizeOf(TWindowPlacement);
          res:=GetWindowPlacement(Self.Handle, @winplacement);
          f.WriteInteger(WindowSection, 'WindowState', Integer(FrmMain.WindowState));
          If res Then Begin
             f.WriteInteger(WindowSection, 'Left', winplacement.rcNormalPosition.Left);
             f.WriteInteger(WindowSection, 'Top', winplacement.rcNormalPosition.Top);
             f.WriteInteger(WindowSection, 'Width', Abs(winplacement.rcNormalPosition.Right-winplacement.rcNormalPosition.Left));
             f.WriteInteger(WindowSection, 'Height', Abs(winplacement.rcNormalPosition.Bottom-winplacement.rcNormalPosition.Top));
          End;
          // Leisten
          f.WriteBool(WindowSection, 'DriveBar', PnlDriveBar.Visible);
          f.WriteBool(WindowSection, 'StatusBar', StsBar.Visible);
          f.WriteBool(WindowSection, 'DirectoryBar', PnlDirectoryBar.Visible);
          f.WriteBool(WindowSection, 'CommandLineBar', PnlCommandLineBar.Visible);
          // DOS-Fenster nach Ausfhrung schlieen
          f.WriteBool(WindowSection, 'CloseDOSWindowAfterExecution', CloseDOSWindowAfterExecution);
          // Besttigen
          f.WriteBool(ConfirmSection, 'ConfirmOverwrite', ConfirmOverwrite);
          f.WriteBool(ConfirmSection, 'ConfirmDeleteFile', ConfirmDeleteFile);
          f.WriteBool(ConfirmSection, 'ConfirmDeleteDirectory', ConfirmDeleteDirectory);
          f.WriteBool(ConfirmSection, 'ConfirmExit', ConfirmExit);
          // Sonstiges
          f.WriteBool(MiscSection, 'SelectDirectories', SelectDirectories);
          f.WriteBool(MiscSection, 'ClearReadOnlyAttribute', ClearReadOnlyAttribute);
          // Dateianzeige
          f.WriteInteger(FilePanelsSection, 'CharCase', CharCase);
          f.WriteBool(FilePanelsSection, 'SynchronizeColumnWidth', SynchronizeColumnWidth);
          f.WriteBool(FilePanelsSection, 'ClickToRename', ClickToRename);
          f.WriteInteger(FilePanelsSection, 'UseIcons', UseIcons);
          f.WriteBool(FilePanelsSection, 'usi_Harddisk', usi_Harddisk);
          f.WriteBool(FilePanelsSection, 'usi_FloppyDrive', usi_FloppyDrive);
          f.WriteBool(FilePanelsSection, 'usi_NetworkDrive', usi_NetworkDrive);
          f.WriteBool(FilePanelsSection, 'usi_CDROM', usi_CDROM);
          f.WriteBool(FilePanelsSection, 'usi_Other', usi_Other);
          f.WriteBool(FilePanelsSection, 'GridLines', GridLines);
          f.WriteBool(FilePanelsSection, 'ClickToOpen', ClickToOpen);
          f.WriteBool(FilePanelsSection, 'GhostHiddenFiles', GhostHiddenFiles);
          f.WriteBool(FilePanelsSection, 'MarkDirectories', MarkDirectories);
          // Schriftart/Farben
          f.WriteInteger(ViewSection, 'Color', Integer(Options.Color));
          f.WriteInteger(ViewSection, 'FontColor', Integer(FontColor));
          f.WriteInteger(ViewSection, 'FontStyles', Integer(Byte(FontStyles)));
          f.WriteInteger(ViewSection, 'FontSize', FontSize);
          f.WriteString(ViewSection, 'FontName', FontName);
          // Papierkorb
          f.WriteBool(RecycleBinSection, 'UseRecycleBin', UseRecycleBin);
          // Text-Editor
          f.WriteBool(TextEditSection, 'UseInternalTextEdit', UseInternalTextEdit);
          f.WriteString(TextEditSection, 'ExternalTextEditPath', ExternalTextEditPath);
          f.WriteString(TextEditSection, 'ExternalTextEditParams', ExternalTextEditParams);
          f.WriteBool(TextEditSection, 'ShowToolBar', EditorOptions.ShowToolBar);
          f.WriteBool(TextEditSection, 'ShowStatusBar', EditorOptions.ShowStatusBar);
          f.WriteBool(TextEditSection, 'WordWrap', EditorOptions.WordWrap);
          f.WriteBool(TextEditSection, 'FindTextAtCursor', EditorOptions.FindTextAtCursor);
          // Drag&Drop
          f.WriteBool(DragDropSection, 'ConfirmDDMove', ConfirmDDMove);
          f.WriteBool(DragDropSection, 'ConfirmDDCopy', ConfirmDDCopy);
          f.WriteBool(DragDropSection, 'ConfirmDDCreateLinks', ConfirmDDCreateLinks);
          f.WriteInteger(DragDropSection, 'DDStandardAction', DDStandardAction);
          // Erweitert
          f.WriteBool(EnhancedSection, 'WindowClientDraggable', WindowClientDraggable);
          f.WriteBool(EnhancedSection, 'PreventMultiInstances', PreventMultiInstances);
          f.WriteBool(EnhancedSection, 'UseDoubleBuffer', UseDoubleBuffer);
          // QuickView
          f.WriteBool(QuickViewSection, 'QuickViewFlees', FrmMain.OptionsQuickViewFlees.Checked);
          f.WriteBool(QuickViewSection, 'Stretch', FrmQuickView.FitToImage);
          f.WriteBool(QuickViewSection, 'MaintainAspectRatio', FrmQuickView.MaintainAspectRatio);
          f.WriteBool(QuickViewSection, 'WordWrap', FrmQuickView.TextFile.WordWrap);
          // Standard-Spaltenbreiten
          With ColumnsWidthStandard Do Begin
               f.WriteInteger(ColumnsWidthStandardSection, 'NameWidth', NameWidth);
               f.WriteInteger(ColumnsWidthStandardSection, 'SizeWidth', SizeWidth);
               f.WriteInteger(ColumnsWidthStandardSection, 'AttrWidth', AttrWidth);
               f.WriteInteger(ColumnsWidthStandardSection, 'DateWidth', DateWidth);
               f.WriteInteger(ColumnsWidthStandardSection, 'Name2Width', Name2Width);
               f.WriteInteger(ColumnsWidthStandardSection, 'PathWidth', PathWidth);
          End;
          // Einstellungen der Dateifenster
          For i:=0 To 1 Do With Data[i] Do Begin
              // Data[i]
              f.WriteInteger(FileListSections[i], 'ListType', ListType);
              f.WriteInteger(FileListSections[i], 'SortType', SortType);
              f.WriteInteger(FileListSections[i], 'SortDir', SortDir);
              f.WriteInteger(FileListSections[i], 'Width', Round(Data[i].Width*WidthMulFac));
              f.WriteString(FileListSections[i], 'Directory', Directory);
              f.WriteBool(FileListSections[i], 'UseFilter', UseFilter);
              // Filter
              f.WriteString(FileListSections[i], 'Include', Filter.Include);
              f.WriteString(FileListSections[i], 'Exclude', Filter.Exclude);
              f.WriteBool(FileListSections[i], 'faReadOnly', Filter.ReadOnly);
              f.WriteBool(FileListSections[i], 'faHidden', Filter.Hidden);
              f.WriteBool(FileListSections[i], 'faSysFile', Filter.SysFile);
              f.WriteBool(FileListSections[i], 'faDirectory', Filter.Directory);
              f.WriteInteger(FileListSections[i], 'MinSize', Filter.MinSize);
              f.WriteInteger(FileListSections[i], 'MaxSize', Filter.MaxSize);
              f.WriteBool(FileListSections[i], 'UseDate', Filter.UseDate);
              f.WriteInteger(FileListSections[i], 'MinDateLow', Integer(Filter.MinDate.dwLowDateTime));
              f.WriteInteger(FileListSections[i], 'MinDateHigh', Integer(Filter.MinDate.dwHighDateTime));
              f.WriteInteger(FileListSections[i], 'MaxDateLow', Integer(Filter.MaxDate.dwLowDateTime));
              f.WriteInteger(FileListSections[i], 'MaxDateHigh', Integer(Filter.MaxDate.dwHighDateTime));
              // ColumnsWidth
              ReadColumnsWidth(i);
              f.WriteInteger(FileListSections[i], 'NameWidth', ColumnsWidth.NameWidth);
              f.WriteInteger(FileListSections[i], 'SizeWidth', ColumnsWidth.SizeWidth);
              f.WriteInteger(FileListSections[i], 'AttrWidth', ColumnsWidth.AttrWidth);
              f.WriteInteger(FileListSections[i], 'DateWidth', ColumnsWidth.DateWidth);
              f.WriteInteger(FileListSections[i], 'Name2Width', ColumnsWidth.Name2Width);
              f.WriteInteger(FileListSections[i], 'PathWidth', ColumnsWidth.PathWidth);
          End;
          // Pfad-Liste
          f.EraseSection(PathListSection);
          f.WriteBool(PathListSection, 'AutoSort', FrmEditPathList.ChkAutoSort.Checked);
          For i:=0 To FrmMain.PathNum-1 Do Begin
              f.WriteString(PathListSection, 'Path'+Stri(i), FrmMain.Paths[i].Path);
              f.WriteString(PathListSection, 'ShortCut'+Stri(i), ShortCutToText(FrmMain.Paths[i].ShortCut));
          End;
     End;
     f.Free;
End;

Function RemoveEndingBackslash(Const s: String): String;
Begin
     If s <> '' Then Begin
        If s[Length(s)] = '\' Then Begin
           Result:=Copy(s, 1, Length(s)-1);
        End Else Result:=s;
     End Else Result:='';
End;

Procedure TFrmMain.LoadOptions;
Var
   f: TIniFile;
   i: Integer;
   Dummy: TFileTime;
   s: String;
Begin
     f:=TIniFile.Create(ProgPath+IniFileName);
     With Options do Begin
          // Start
          RestoreDirectories:=f.ReadBool(StartupSection, 'RestoreDirectories', True);
          StdDirLeft:=f.ReadString(StartupSection, 'StdDirLeft', 'C:\');
          StdDirRight:=f.ReadString(StartupSection, 'StdDirRight', 'C:\');
          RestoreWindow:=f.ReadBool(StartupSection, 'RestoreWindow', True);
          // Fenster
          If RestoreWindow Then Begin
             FrmMain.Left:=f.ReadInteger(WindowSection, 'Left', Left);
             FrmMain.Top:=f.ReadInteger(WindowSection, 'Top', Top);
             FrmMain.Width:=f.ReadInteger(WindowSection, 'Width', Width);
             FrmMain.Height:=f.ReadInteger(WindowSection, 'Height', Height);
             // Wenn man's direkt setzt, klappt's nicht. Darum warten wir damit,
             // bis alles erledigt ist und setzen es dann in FormShow()
             SavedWindowState:=TWindowState(f.ReadInteger(WindowSection, 'WindowState', Integer(WindowState)));
          End;
          // DOS-Fenster nach Ausfhrung schlieen
          CloseDOSWindowAfterExecution:=f.ReadBool(WindowSection, 'CloseDOSWindowAfterExecution', True);
          // Leisten
          PnlDriveBar.Visible:=f.ReadBool(WindowSection, 'DriveBar', True);
          StsBar.Visible:=f.ReadBool(WindowSection, 'StatusBar', True);
          PnlDirectoryBar.Visible:=f.ReadBool(WindowSection, 'DirectoryBar', True);
          PnlCommandLineBar.Visible:=f.ReadBool(WindowSection, 'CommandLineBar', False);
          // Besttigen
          ConfirmOverwrite:=f.ReadBool(ConfirmSection, 'ConfirmOverwrite', True);
          ConfirmDeleteFile:=f.ReadBool(ConfirmSection, 'ConfirmDeleteFile', True);
          ConfirmDeleteDirectory:=f.ReadBool(ConfirmSection, 'ConfirmDeleteDirectory', True);
          ConfirmExit:=f.ReadBool(ConfirmSection, 'ConfirmExit', True);
          // Sonstiges
          SelectDirectories:=f.ReadBool(MiscSection, 'SelectDirectories', True);
          ClearReadOnlyAttribute:=f.ReadBool(MiscSection, 'ClearReadOnlyAttribute', True);
          // Dateianzeige
          CharCase:=f.ReadInteger(FilePanelsSection, 'CharCase', ccMixedIfMSDOS);
          SynchronizeColumnWidth:=f.ReadBool(FilePanelsSection, 'SynchronizeColumnWidth', True);
          ClickToRename:=f.ReadBool(FilePanelsSection, 'ClickToRename', True);
          UseIcons:=f.ReadInteger(FilePanelsSection, 'UseIcons', uiStandardIcons);
          usi_Harddisk:=f.ReadBool(FilePanelsSection, 'usi_Harddisk', False);
          usi_FloppyDrive:=f.ReadBool(FilePanelsSection, 'usi_FloppyDrive', True);
          usi_NetworkDrive:=f.ReadBool(FilePanelsSection, 'usi_NetworkDrive', False);
          usi_CDROM:=f.ReadBool(FilePanelsSection, 'usi_CDROM', False);
          usi_Other:=f.ReadBool(FilePanelsSection, 'usi_Other', False);
          GridLines:=f.ReadBool(FilePanelsSection, 'GridLines', False);
          ClickToOpen:=f.ReadBool(FilePanelsSection, 'ClickToOpen', False);
          GhostHiddenFiles:=f.ReadBool(FilePanelsSection, 'GhostHiddenFiles', True);
          MarkDirectories:=f.ReadBool(FilePanelsSection, 'MarkDirectories', True);
          // Schriftart/Farben
          Options.Color:=TColor(f.ReadInteger(ViewSection, 'Color', Integer(clWhite)));
          FontColor:=TColor(f.ReadInteger(ViewSection, 'FontColor', Integer(clBlack)));
          FontStyles:=TFontStyles(Byte(f.ReadInteger(ViewSection, 'FontStyles', 0)));
          FontSize:=f.ReadInteger(ViewSection, 'FontSize', 8);
          FontName:=f.ReadString(ViewSection, 'FontName', 'MS Sans Serif');
          // Papierkorb
          UseRecycleBin:=f.ReadBool(RecycleBinSection, 'UseRecycleBin', True);
          // Text-Editor
          UseInternalTextEdit:=f.ReadBool(TextEditSection, 'UseInternalTextEdit', True);
          ExternalTextEditPath:=f.ReadString(TextEditSection, 'ExternalTextEditPath', '');
          ExternalTextEditParams:=f.ReadString(TextEditSection, 'ExternalTextEditParams', '%Name%');
          EditorOptions.ShowToolBar:=f.ReadBool(TextEditSection, 'ShowToolBar', True);
          EditorOptions.ShowStatusBar:=f.ReadBool(TextEditSection, 'ShowStatusBar', True);
          EditorOptions.WordWrap:=f.ReadBool(TextEditSection, 'WordWrap', False);
          EditorOptions.FindTextAtCursor:=f.ReadBool(TextEditSection, 'FindTextAtCursor', True);
          // Drag&Drop
          ConfirmDDMove:=f.ReadBool(DragDropSection, 'ConfirmDDMove', True);
          ConfirmDDCopy:=f.ReadBool(DragDropSection, 'ConfirmDDCopy', True);
          ConfirmDDCreateLinks:=f.ReadBool(DragDropSection, 'ConfirmDDCreateLinks', True);
          DDStandardAction:=f.ReadInteger(DragDropSection, 'DDStandardAction', saMove);
          // Erweitert
          WindowClientDraggable:=f.ReadBool(EnhancedSection, 'WindowClientDraggable', False);
          PreventMultiInstances:=f.ReadBool(EnhancedSection, 'PreventMultiInstances', False);
          UseDoubleBuffer:=f.ReadBool(EnhancedSection, 'UseDoubleBuffer', False);
          // QuickView
          FrmMain.OptionsQuickViewFlees.Checked:=f.ReadBool(QuickViewSection, 'QuickViewFlees', False);
          FrmQuickView.FitToImage:=f.ReadBool(QuickViewSection, 'Stretch', False);
          FrmQuickView.MaintainAspectRatio:=f.ReadBool(QuickViewSection, 'MaintainAspectRatio', True);
          FrmQuickView.TextFile.WordWrap:=f.ReadBool(QuickViewSection, 'WordWrap', False);
          // Standard-Spaltenbreiten
          With ColumnsWidthStandard Do Begin
               NameWidth:=f.ReadInteger(ColumnsWidthStandardSection, 'NameWidth', 120);
               SizeWidth:=f.ReadInteger(ColumnsWidthStandardSection, 'SizeWidth', 70);
               AttrWidth:=f.ReadInteger(ColumnsWidthStandardSection, 'AttrWidth', 50);
               DateWidth:=f.ReadInteger(ColumnsWidthStandardSection, 'DateWidth', 100);
               Name2Width:=f.ReadInteger(ColumnsWidthStandardSection, 'Name2Width', 150);
               PathWidth:=f.ReadInteger(ColumnsWidthStandardSection, 'PathWidth', 300);
          End;
          // Einstellungen der Dateifenster
          Dummy:=DateTimeToFileTime(Date);
          For i:=0 To 1 Do With Data[i] Do Begin
              // Data[i]
              ListType:=f.ReadInteger(FileListSections[i], 'ListType', Integer(vsReport));
              SortType:=f.ReadInteger(FileListSections[i], 'SortType', SortName);
              SortDir:=f.ReadInteger(FileListSections[i], 'SortDir', SortDirUp);
              DataType:=dtFileList;
              QueryDataType:=dtFileList;
              Data[i].Width:=f.ReadInteger(FileListSections[i], 'Width', Round(0.5*WidthMulFac)) / WidthMulFac;
              If RestoreDirectories Then Begin
                 Directory:=f.ReadString(FileListSections[i], 'Directory', Copy(ProgPath, 1, 2));
              End Else Begin
                 Case i Of
                      LeftList: Directory:=RemoveEndingBackslash(Options.StdDirLeft);
                      RightList: Directory:=RemoveEndingBackslash(Options.StdDirRight);
                 End;
              End;
              If Directory = '' Then Directory:=Copy(ProgPath, 1, 2);
              UseFilter:=f.ReadBool(FileListSections[i], 'UseFilter', False);
              // Filter
              Filter.Include:=f.ReadString(FileListSections[i], 'Include', '*.*');
              Filter.Exclude:=f.ReadString(FileListSections[i], 'Exclude', '');
              Filter.ReadOnly:=f.ReadBool(FileListSections[i], 'faReadOnly', True);
              Filter.Hidden:=f.ReadBool(FileListSections[i], 'faHidden', True);
              Filter.SysFile:=f.ReadBool(FileListSections[i], 'faSysFile', True);
              Filter.Directory:=f.ReadBool(FileListSections[i], 'faDirectory', True);
              Filter.MinSize:=f.ReadInteger(FileListSections[i], 'MinSize', 0);
              Filter.MaxSize:=f.ReadInteger(FileListSections[i], 'MaxSize', 0);
              Filter.UseDate:=f.ReadBool(FileListSections[i], 'UseDate', False);
              If Filter.UseDate Then Begin
                 Filter.MinDate.dwLowDateTime:=f.ReadInteger(FileListSections[i], 'MinDateLow', Dummy.dwLowDateTime);
                 Filter.MinDate.dwHighDateTime:=f.ReadInteger(FileListSections[i], 'MinDateHigh', Dummy.dwHighDateTime);
                 Filter.MaxDate.dwLowDateTime:=f.ReadInteger(FileListSections[i], 'MaxDateLow', Dummy.dwLowDateTime);
                 Filter.MaxDate.dwHighDateTime:=f.ReadInteger(FileListSections[i], 'MaxDateHigh', Dummy.dwHighDateTime);
              End Else Begin
                 Filter.MinDate:=Dummy;
                 Filter.MaxDate:=Dummy;
              End;
              // ColumnsWidth
              SetDefaultColumnsWidth(i);
              ColumnsWidth.NameWidth:=f.ReadInteger(FileListSections[i], 'NameWidth', ColumnsWidth.NameWidth);
              ColumnsWidth.SizeWidth:=f.ReadInteger(FileListSections[i], 'SizeWidth', ColumnsWidth.SizeWidth);
              ColumnsWidth.AttrWidth:=f.ReadInteger(FileListSections[i], 'AttrWidth', ColumnsWidth.AttrWidth);
              ColumnsWidth.DateWidth:=f.ReadInteger(FileListSections[i], 'DateWidth', ColumnsWidth.DateWidth);
              ColumnsWidth.Name2Width:=f.ReadInteger(FileListSections[i], 'Name2Width', ColumnsWidth.Name2Width);
              ColumnsWidth.PathWidth:=f.ReadInteger(FileListSections[i], 'PathWidth', ColumnsWidth.PathWidth);
          End;
          // Pfad-Liste
          FrmEditPathList.ChkAutoSort.Checked:=f.ReadBool(PathListSection, 'AutoSort', False);
          i:=0;
          Repeat
                s:=f.ReadString(PathListSection, 'Path'+Stri(i), '');
                If s <> '' Then Begin
                   FrmMain.Paths[i].Path:=s;
                   FrmMain.Paths[i].ShortCut:=TextToShortCut(f.ReadString(PathListSection, 'ShortCut'+Stri(i), ''));
                   Inc(i);
                End;
          Until s = '';
          FrmMain.PathNum:=i;
          If FrmEditPathList.ChkAutoSort.Checked Then SortPathList;
     End;
     FrmMain.SetOptions;
     f.Free;
End;

procedure TFrmMain.PopViewClick(Sender: TObject);
begin
     FileViewClick(Sender);
end;

procedure TFrmMain.MnuPathClick(Sender: TObject);
begin
     RemovePathsFromPathMenu;
     AddPathsToPathMenu;
     If PathNum > 0 Then Begin
        PathDivider.Visible:=True;
        PathEdit.Enabled:=True;
     End Else Begin
        PathDivider.Visible:=False;
        PathEdit.Enabled:=False;
     End;
     If (RecentDirLists[CurrentList].EntryNum <= 1) Or (Data[CurrentList].DataType <> dtFileList) Then Begin
        PathDirBack.Enabled:=False;
        PathDirForward.Enabled:=False;
        PathDirList.Enabled:=False;
     End Else Begin
        AddRecentDirListToMenuItem(PathDirList, True, CurrentList);
        PathDirList.Enabled:=True;
        If RecentDirLists[CurrentList].ActEntry > 0 Then
           PathDirBack.Enabled:=True
        Else
           PathDirBack.Enabled:=False;
        If RecentDirLists[CurrentList].ActEntry < RecentDirLists[CurrentList].EntryNum-1 Then
           PathDirForward.Enabled:=True
        Else
           PathDirForward.Enabled:=False;
     End;
end;

procedure TFrmMain.PathEditClick(Sender: TObject);
begin
     RemovePathsFromPathMenu;
     FrmEditPathList.UpdatePathList;
     If FrmEditPathList.ShowModal = mrOK Then Begin
        FrmEditPathList.SetNewPathList;
        RemovePathsFromPathMenu;
        AddPathsToPathMenu;
     End;
end;

procedure TFrmMain.PathRootDirClick(Sender: TObject);
begin
     If Length(Data[CurrentList].Directory) > 2 Then Begin
        Data[CurrentList].Directory:=Data[CurrentList].Directory[1]+':';
        UpdateDir(CurrentList);
     End;
end;

procedure TFrmMain.PathGoToClick(Sender: TObject);
Var
   TmpPath: String;
begin
     {$I-}
     With FrmGoTo Do Begin
          EdtGoTo.Text:=Data[CurrentList].Directory+'\';
          ChDir(Data[CurrentList].Directory+'\');
          IOResult;
          If FrmGoTo.ShowModal = mrOK Then Begin
             TmpPath:=EdtGoTo.Text;
             ChDir(TmpPath);
             If IOResult = 0 Then Begin
                GetDir(0,TmpPath);
                If TmpPath[Length(TmpPath)] = '\' Then
                   TmpPath:=Copy(TmpPath,1,Length(TmpPath)-1);
                Data[CurrentList].Directory:=TmpPath;
                DriveLists[CurrentList].Drive:=TmpPath[1];
                UpdateDir(CurrentList);
             End Else
                MessageDlg('Der Pfad ist ungltig.',mtError,[mbOK],0);
          End;
     End;
end;

Function DeleteCharFromString;
Var
   i, m: Integer;
   Count: Integer;
Begin
     Count:=0;
     For i:=1 To Length(s) Do Begin
         If s[i] <> ch Then Inc(Count);
     End;
     If count > 0 Then Begin
        SetLength(Result, Count);
        m:=1;
        For i:=1 To Length(s) Do Begin
            If s[i] <> ch Then Begin
               Result[m]:=s[i];
               Inc(m);
            End;
        End;
     End Else
        Result:='';
End;

Procedure TFrmMain.PathDoesNotExist;
Begin
     MessageDlg(Dir+#13+#10+'konnte nicht gefunden werden.'+#13+#10+'Entweder ist der Pfad nicht mehr existent, oder es handelt sich dabei um einen austauschbaren Datentrger.', mtError, [mbOk], 0);
End;

Procedure TFrmMain.ChangeToPath;
Var
   Path: String;
Begin
     Path:=DeleteCharFromString((Sender As TMenuItem).Caption, '&');
     Path:=Copy(Path,1,Length(Path)-1);
     If Path = '' Then Exit;
     If AnsiUpperCase(Path) = AnsiUpperCase(Data[CurrentList].Directory) Then Exit;
     {$I-}
     ChDir(Path+'\');
     If IOResult <> 0 Then Begin
        PathDoesNotExist(Path+'\');
        Exit;
     End;
     Data[CurrentList].Directory:=Path;
     Data[CurrentList].QueryDataType:=dtFileList;
     DriveLists[CurrentList].Drive:=Path[1];
     UpdateDir(CurrentList);
End;

Procedure TFrmMain.ChangeToPathPopup;
Var
   Path: String;
Begin
     Path:=DeleteCharFromString((Sender As TMenuItem).Caption, '&');
     Path:=Copy(Path,1,Length(Path)-1);
     If Path = '' Then Exit;
     If AnsiUpperCase(Path) = AnsiUpperCase(Data[TmpSide].Directory) Then Exit;
     {$I-}
     ChDir(Path+'\');
     If IOResult <> 0 Then Begin
        PathDoesNotExist(Path+'\');
        Exit;
     End;
     Data[TmpSide].Directory:=Path;
     Data[TmpSide].QueryDataType:=dtFileList;
     DriveLists[TmpSide].Drive:=Path[1];
     UpdateDir(TmpSide);
End;

Procedure TFrmMain.AddPathPopup;
Begin
     AddPath(Data[TmpSide].Directory+'\', TShortCut(0));
     RemovePathsFromPathMenu;
     AddPathsToPathMenu;
End;

Procedure TFrmMain.AddPath;
Var
   i: Integer;
   Dummy: String;
Begin
     If Length(Path) = 0 Then Exit;
     Dummy:=AnsiUpperCase(DeleteCharFromString(Path, '&'));
     If Dummy[Length(Dummy)] <> '\' Then Dummy:=Dummy+'\';
     For i:=0 To PathNum-1 Do Begin
         If AnsiUpperCase(DeleteCharFromString(Paths[i].Path, '&')) = Dummy Then Exit;
     End;
     If PathNum < MaxPaths Then Begin
        Paths[PathNum].Path:=Path;
        Paths[PathNum].ShortCut:=ShortCut;
        Inc(PathNum);
        If FrmEditPathList.ChkAutoSort.Checked Then SortPathList;
     End Else MessageDlg('Die Anzahl der speicherbaren Pfade betrgt '+Stri(MaxPaths)+
                         '. Lschen Sie einen oder mehrere Pfade, bevor sie einen neuen der Liste hinzufgen.',
                         mtError, [mbOK], 0);
End;

Procedure TFrmMain.AddPathsToPathMenu;
Var
   NewItem: TMenuItem;
   i: Integer;
Begin
     For i:=0 To PathNum-1 Do Begin
         NewItem:=TMenuItem.Create(FrmMain);
         NewItem.Caption:=Paths[i].Path;
         NewItem.ShortCut:=Paths[i].ShortCut;
         NewItem.Tag:=PathTag;
         NewItem.Hint:='Wechselt in das angegebene Verzeichnis.';
         NewItem.OnClick:=ChangeToPath;
         NewItem.ImageIndex:=DirectoryImageIndex;
         NewItem.Visible:=True;
         MnuPath.Add(NewItem);
     End;
End;

Procedure TFrmMain.RemovePathsFromPathMenu;
Var
   i: Integer;
   Dummy: TMenuItem;
Begin
     i:=0;
     While i < MnuPath.Count Do Begin
           If MnuPath.Items[i].Tag = PathTag Then Begin
              Dummy:=MnuPath.Items[i];
              MnuPath.Delete(i);
              Dummy.Free;
           End Else Inc(i);
     End;
End;

procedure TFrmMain.PathAddClick(Sender: TObject);
begin
     AddPath(Data[CurrentList].Directory+'\', TShortCut(0));
     RemovePathsFromPathMenu;
     AddPathsToPathMenu;
end;

Procedure TFrmMain.PopPathListPopup(Sender: TObject);
Var
   NewItem: TMenuItem;
   i: Integer;
   Dummy: TMenuItem;
Begin
     While PopPathList.Items.Count > 0 Do Begin
           Dummy:=PopPathList.Items[0];
           PopPathList.Items.Delete(0);
           Dummy.Free;
     End;
     // "In Liste aufnehmen" hinzufgen
     NewItem:=TMenuItem.Create(Self);
     NewItem.Caption:='In Liste aufnehmen';
     NewItem.Hint:='Nimmt den aktuellen Pfad in die Liste der Pfade auf.';
     NewItem.Enabled:=True;
     NewItem.Visible:=True;
     NewItem.OnClick:=AddPathPopup;
     PopPathList.Items.Add(NewItem);
     // Trennstrich hinzufgen
     NewItem:=TMenuItem.Create(Self);
     NewItem.Caption:='-';
     NewItem.Enabled:=False;
     NewItem.Visible:=True;
     PopPathList.Items.Add(NewItem);
     // Pfadliste hinzufgen
     If PathNum <= 0 Then Begin
        NewItem:=TMenuItem.Create(Self);
        NewItem.Caption:='Keine Eintrge';
        NewItem.Hint:='Benutzen Sie den Befehl "In Liste aufnehmen", um Eintrge hinzuzufgen.';
        NewItem.Enabled:=False;
        NewItem.Visible:=True;
        PopPathList.Items.Add(NewItem);
     End Else Begin
        For i:=0 To PathNum-1 Do Begin
            NewItem:=TMenuItem.Create(Self);
            NewItem.Caption:=Paths[i].Path;
            NewItem.Hint:='Wechselt in das angegebene Verzeichnis.';
            NewItem.OnClick:=ChangeToPathPopup;
            NewItem.ImageIndex:=DirectoryImageIndex;
            NewItem.Visible:=True;
            PopPathList.Items.Add(NewItem);
        End;
     End;
End;

Procedure TFrmMain.SortPathList;
Var
   i: Integer;
   Ok: Boolean;
   Dummy: TPath;
Begin
     // Bubble-Sort: Lahm wie eine rheumatische Schildkrte, aber simpel...
     If PathNum > 1 Then Begin
        Repeat
              Ok:=True;
              For i:=0 To PathNum-2 Do Begin
                  If Paths[i].Path > Paths[i+1].Path Then Begin
                     Ok:=False;
                     Dummy:=Paths[i];
                     Paths[i]:=Paths[i+1];
                     Paths[i+1]:=Dummy;
                  End;
              End;
        Until Ok;
     End;
End;

procedure TFrmMain.SpdPathListLeftClick(Sender: TObject);
Var
   p: TPoint;
begin
     TmpSide:=LeftList;
     p:=PnlDriveBar.ClientToScreen(Point(SpdPathListLeft.Left, SpdPathListLeft.Top+SpdPathListLeft.Height));
     PopPathList.PopUp(p.x, p.y);
end;

procedure TFrmMain.SpdPathListRightClick(Sender: TObject);
Var
   p: TPoint;
begin
     TmpSide:=RightList;
     p:=PnlDriveBar.ClientToScreen(Point(SpdPathListRight.Left, SpdPathListRight.Top+SpdPathListRight.Height));
     PopPathList.PopUp(p.x, p.y);
end;

procedure TFrmMain.PathAdjustClick(Sender: TObject);
Var
   Tmp: String;
begin
     Tmp:=Data[Integer(Not Boolean(CurrentList))].Directory;
     If Tmp <> Data[CurrentList].Directory Then Begin
        Data[CurrentList].Directory:=Tmp;
        UpdateDir(CurrentList);
        DriveLists[CurrentList].Drive:=Tmp[1];
     End;
end;

procedure TFrmMain.MediaFormatClick(Sender: TObject);
Var
   i: Integer;
   Tmp: String[255];
begin
     If FrmFormat.ShowModal = mrOK Then Begin
        Tmp[0]:=Char(GetWindowsDirectory(PChar(@Tmp[1]), 255));
        For i:=0 To 1 Do Begin
            If UpCase(Data[i].Directory[1]) = UpCase(FrmFormat.BjdFormat.Drive) Then Begin
               Data[i].Directory:=Tmp[1]+':';
               DriveLists[i].Drive:=Tmp[1];
               UpDateDir(i);
            End;
        End;
        SHFormatDrive(Handle, Ord(Upcase(FrmFormat.BjdFormat.Drive))-Ord('A'), 0, 0);
     End;
end;

procedure TFrmMain.PopFilesPopup(Sender: TObject);
Var
   ext: String;
begin
     If IsSomeThingSelected(CurrentList) Then Begin
        PopCopy.Enabled:=True;
        PopMove.Enabled:=True;
        PopDelete.Enabled:=True;
        PopSetAttributes.Enabled:=True;
        PopProperties.Enabled:=True;
     End Else Begin
        PopView.Enabled:=False;
        PopCopy.Enabled:=False;
        PopMove.Enabled:=False;
        PopDelete.Enabled:=False;
        PopSetAttributes.Enabled:=False;
        PopProperties.Enabled:=False;
     End;
     If Lists[CurrentList].ItemFocused <> Nil Then Begin
        If (Dat(Lists[CurrentList].ItemFocused.Data^).fAttr And faDirectory) = 0 Then
           PopView.Enabled:=True
        Else
           PopView.Enabled:=False;
        If Dat(Lists[CurrentList].ItemFocused.Data^).UpDir Then Begin
           PopRename.Enabled:=False;
           PopQuickView.Enabled:=False;
        End Else Begin
           PopRename.Enabled:=True;
           PopQuickView.Enabled:=True;
        End;
        PopOpen.Enabled:=True;
        If (Dat(Lists[CurrentList].ItemFocused.Data^).fAttr And faDirectory) <> faDirectory Then Begin
           If (Not Dat(Lists[CurrentList].ItemFocused.Data^).UpDir) Then Begin
              ext:=AnsiLowerCase(ExtractFileExt(GetName(Lists[CurrentList].ItemFocused.Data, CurrentList)));
              If (ext = '.exe') Or (ext = '.com') Or (ext = '.bat') Or (ext = '.pif') Then
                 PopExecuteWithParam.Enabled:=True
              Else
                 PopExecuteWithParam.Enabled:=False;
           End Else PopExecuteWithParam.Enabled:=False;
        End Else PopExecuteWithParam.Enabled:=False;
     End Else Begin
        PopView.Enabled:=False;
        PopRename.Enabled:=False;
        PopOpen.Enabled:=False;
        PopQuickView.Enabled:=False;
        PopExecuteWithParam.Enabled:=False;
     End;
     If (Data[CurrentList].DataType = dtFindResult) And (Lists[CurrentList].ItemFocused <> Nil) Then Begin
        PopChangeToThisDirectory.Visible:=((Dat(Lists[CurrentList].ItemFocused.Data^).fAttr And faDirectory) <> 0);
     End Else
        PopChangeToThisDirectory.Visible:=False;
end;

Procedure TFrmMain.ShowMediaInformation;
Var
   MediaName: Array[0..255] Of Char;
   FileSystemName: Array[0..255] Of Char;
   MaxLength, FileSystemFlags: Cardinal;
   SerialNumber: Cardinal;
   FlagStr: String;
   DriveType: Integer;
   BytesPerSector, SectorsPerCluster, FreeClusters, TotalClusters: Cardinal;
   FreeAvailable, FreeSpace, UsedSpace, TotalSpace: Int64;
Procedure AddComma;
Begin
     If Length(FlagStr) > 0 Then FlagStr:=FlagStr+', ';
End;
Begin
     With FrmMediaInformation Do Begin
          // GetVolumeInformation
          GetVolumeInformation(PChar(Drive+':\'), MediaName, 256, @SerialNumber, MaxLength, FileSystemFlags, FileSystemName, 256);
          LblDrive.Caption:=Drive+':\';
          LblName.Caption:=String(MediaName);
          LblFileSystem.Caption:=String(FileSystemName);
          If MaxLength >= 255 Then LblLongFilenames.Caption:='Ja' Else LblLongFilenames.Caption:='Nein';
          If (FileSystemFlags And FS_CASE_IS_PRESERVED) > 0 Then
             FlagStr:='Erhlt Gro-/Kleinschreibung' Else FlagStr:='';
          If (FileSystemFlags And FS_CASE_SENSITIVE) > 0 Then Begin
             AddComma;
             FlagStr:=FlagStr+'Unterscheidet Gro-/Kleinschreibung';
          End;
          If (FileSystemFlags And FS_UNICODE_STORED_ON_DISK) > 0 Then Begin
             AddComma;
             FlagStr:=FlagStr+'Untersttzt Unicode';
          End;
          If (FileSystemFlags And FS_PERSISTENT_ACLS) > 0 Then Begin
             AddComma;
             FlagStr:=FlagStr+'Erhlt ACLs';
          End;
          If (FileSystemFlags And FS_FILE_COMPRESSION) > 0 Then Begin
             Addcomma;
             FlagStr:=FlagStr+'Untersttzt komprimierte Dateien';
          End;
          If (FileSystemFlags And FS_VOL_IS_COMPRESSED) > 0 Then Begin
             AddComma;
             FlagStr:=FlagStr+'Datentrger ist komprimiert';
          End;
          LblFileSystemFlags.Caption:=FlagStr;
          // GetDriveType
          DriveType:=GetDriveType(PChar(Drive+':\'));
          Case DriveType Of
               DRIVE_REMOVABLE:
                  Begin
                       ImgType.Picture:=ImgDisk.Picture;
                       LblType.Caption:='Diskette';
                  End;
               DRIVE_FIXED:
                  Begin
                       ImgType.Picture:=ImgFixed.Picture;
                       LblType.Caption:='Festplatte';
                  End;
               DRIVE_CDROM:
                  Begin
                       ImgType.Picture:=ImgCDROM.Picture;
                       LblType.Caption:='CD-ROM';
                  End;
               DRIVE_REMOTE:
                  Begin
                       ImgType.Picture:=ImgNetwork.Picture;
                       LblType.Caption:='Netzlaufwerk';
                  End;
               DRIVE_RAMDISK:
                  Begin
                       ImgType.Picture:=ImgFixed.Picture;
                       LblType.Caption:='RAM-Disk';
                  End;
               Else
                  Begin
                       ImgType.Picture:=ImgFixed.Picture;
                       LblType.Caption:='Unbekannt';
                  End;
          End;
          // GetDiskFreeSpace
          If WinIsOSR2 Then Begin
             GetDiskFreeSpaceEx(PChar(Drive+':\'), FreeAvailable, TotalSpace, @FreeSpace);
             UsedSpace:=TotalSpace - FreeSpace;
          End Else Begin
             GetDiskFreeSpace(PChar(Drive+':\'), SectorsPerCluster, BytesPerSector, FreeClusters, TotalClusters);
             TotalSpace:=BytesPerSector * SectorsPerCluster * TotalClusters;
             FreeSpace:=BytesPerSector * SectorsPerCluster * FreeClusters;
             UsedSpace:=TotalSpace - FreeSpace;
          End;
          LblCapacity.Caption:=BytesToString(TotalSpace);
          LblFree.Caption:=BytesToString(FreeSpace);
          LblUsed.Caption:=BytesToString(UsedSpace);
     End;
     FrmMediaInformation.ShowModal;
End;

procedure TFrmMain.MediaInformationClick(Sender: TObject);
begin
     ShowMediaInformation(Data[CurrentList].Directory[1]);
end;

procedure TFrmMain.MediaRenameClick(Sender: TObject);
Var
   MediaName: Array[0..255] Of Char;
   FileSystemName: Array[0..255] Of Char;
   SerialNumber, MaxLength, FileSystemFlags: Cardinal;
begin
     If Not GetVolumeInformation(PChar(Data[CurrentList].Directory[1]+':\'), MediaName, 256, @SerialNumber, MaxLength, FileSystemFlags, FileSystemName, 256) Then Exit;
     FrmRenameMedia.EdtName.Text:=String(MediaName);
     If FrmRenameMedia.ShowModal = mrOk Then Begin
        SetVolumeLabel(PChar(Data[CurrentList].Directory[1]+':\'), PChar(FrmRenameMedia.EdtName.Text));
        DriveLists[0].UpdateDriveList;
        DriveLists[1].UpdateDriveList;
     End;
end;

procedure TFrmMain.LstFilesKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     If Not Lists[LeftList].IsEditing Then
        If Key = vk_Delete Then FileDeleteClick(Nil);
end;

procedure TFrmMain.LstFiles2KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     If Not Lists[RightList].IsEditing Then
     If Key = vk_Delete Then FileDeleteClick(Nil);
end;

Procedure TFrmMain.FileCompareDirectoriesClick(Sender: TObject);
Const
   MaxInfo = 16383;
Var
   info: Packed Array[0..MaxInfo] Of Packed Record
      FirstChar: Char;
      FoundEqual: Boolean;
      PData: Pointer;
   End;
   itemCount1, itemCount2: Integer;
   item: TLVItem;
   ptr: Pointer;
   chr: Char;
   ShorterList, LongerList: Integer;
   i, i1, i2: Integer;
   Ok, AllOk: Boolean;
   MatchingAllCriteria: Boolean;
   UpperCaseFilename: String;
Begin
     If Data[LeftList].Directory = Data[RightList].Directory Then Begin
        MessageDlg('Beide Fenster zeigen das selbe Verzeichnis an.', mtError, [mbOk], 0);
        Exit;
     End;

     If (Lists[LeftList].Items.Count >= MaxInfo+1) Or (Lists[RightList].Items.Count >= MaxInfo+1) Then Begin
        MessageDlg('Mehr als '+Stri(MaxInfo+1)+' Dateien pro Fenster knnen nicht verglichen werden. Sorry!', mtError, [mbOk], 0);
        Exit;
     End;

     If FrmCompareDirectories.ShowModal = mrOk Then With FrmCompareDirectories Do Try
        Screen.Cursor:=crHourGlass;
        For i:=0 To 1 Do Lists[i].Items.BeginUpdate;

        If ChkDestroyOldSelection.Checked Then
           For i:=0 To 1 Do SelectNone(i);

        If  Lists[LeftList].Items.Count <= Lists[RightList].Items.Count Then Begin
           ShorterList:=LeftList;
           LongerList:=RightList;
        End Else Begin
           ShorterList:=RightList;
           LongerList:=LeftList;
        End;

        With Lists[LongerList] Do Begin
             itemCount1:=Items.Count-1;
             For i:=0 To itemCount1 Do Begin
                 item.iItem:=i;
                 item.iSubItem:=0;
                 item.Mask:=LVIF_PARAM;
                 ListView_GetItem(Lists[LongerList].Handle, item);
                 ptr:=TListItem(Pointer(item.lParam)).Data;
                 info[i].PData:=ptr;
                 info[i].FoundEqual:=False;
                 info[i].FirstChar:=AnsiUpperCase(Dat(ptr^).fName)[1];
             End;
        End;

        AllOk:=True;

        With Lists[ShorterList] Do Begin
             itemCount2:=Items.Count-1;
             For i1:=0 To itemCount2 Do Begin
                 Ok:=False;
                 item.iItem:=i1;
                 item.iSubItem:=0;
                 item.Mask:=LVIF_PARAM;
                 ListView_GetItem(Lists[ShorterList].Handle, item);
                 ptr:=TListItem(Pointer(item.lParam)).Data;
                 If (Not Dat(ptr^).UpDir) Then Begin
                    UpperCaseFilename:=AnsiUpperCase(Dat(ptr^).fName);
                    chr:=UpperCaseFileName[1];

                    For i2:=0 To itemCount1 Do Begin
                        If chr = info[i2].FirstChar Then Begin
                           If UpperCaseFilename = AnsiUpperCase(Dat(info[i2].PData^).fName) Then Begin

                              MatchingAllCriteria:=True;
                              If ChkCompareSize.Checked Then Begin
                                 If Dat(ptr^).fSize <> Dat(info[i2].PData^).fSize Then
                                    MatchingAllCriteria:=False;
                              End;
                              If ChkCompareAttributes.Checked Then Begin
                                 If Dat(ptr^).fAttr <> Dat(info[i2].PData^).fAttr Then
                                    MatchingAllCriteria:=False;
                              End Else Begin
                                 If (Dat(ptr^).fAttr And faDirectory) <> (Dat(info[i2].PData^).fAttr And faDirectory) Then
                                    MatchingAllCriteria:=False;
                              End;
                              If ChkCompareFiletime.Checked Then Begin
                                 If CompareFileTime(Dat(ptr^).fTime, Dat(info[i2].PData^).fTime) <> 0 Then
                                    MatchingAllCriteria:=False;
                              End;

                              If MatchingAllCriteria Then Begin
                                 Ok:=True;
                                 info[i2].FoundEqual:=True;
                                 Break;
                              End;
                           End;
                        End;
                    End;

                 End;
                 If (Not Ok) Then Begin
                    If Not (((Dat(ptr^).fAttr And faDirectory) <> 0) And (Not Options.SelectDirectories)) Then Begin
                       If (Not Dat(ptr^).UpDir) Then Begin
                          AllOk:=False;
                          ListView_SetItemState(Lists[ShorterList].Handle, i1, LVIS_SELECTED, LVIS_SELECTED);
                       End;
                    End;
                 End;
             End;
        End;

        With Lists[LongerList] Do Begin
             For i:=0 To itemCount1 Do Begin
                 If Not info[i].FoundEqual Then Begin
                    If (Not Dat(info[i].PData^).UpDir) Then Begin
                       If Not (((Dat(info[i].PData^).fAttr And faDirectory) <> 0) And (Not Options.SelectDirectories)) Then Begin
                          AllOk:=False;
                          ListView_SetItemState(Lists[LongerList].Handle, i, LVIS_SELECTED, LVIS_SELECTED);
                       End;
                    End;
                 End;
             End;
        End;

        If AllOk Then MessageDlg('Die Verzeichnisse scheinen identisch zu sein.', mtInformation, [mbOk], 0);

     Finally
        For i:=0 To 1 Do Lists[i].Items.EndUpdate;
        Screen.Cursor:=crDefault;
     End;
End;

procedure TFrmMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
     If Options.ConfirmExit Then Begin
        CanClose:=(MessageDlg('Programm beenden?', mtConfirmation, [mbYes, mbNo], 0) = mrYes);
     End;
end;

procedure TFrmMain.OptionsMaintainAspectRatioClick(Sender: TObject);
begin
     FrmQuickView.MaintainAspectRatio:=Not FrmQuickView.MaintainAspectRatio;
end;

Function CopyFile;
{
   Diese Prozedur kopiert die Datei Source in das Verzeichnis Dest.
   Falls sie dort schon exisitiert, fragt die Prozedur nach, ob sie
   berschrieben werden soll.
   Rckgabewerte:
      1 - erfolgreich
      0 - Nicht berschrieben
     -1 - Fehler ist aufgetreten
}
Const
   SourceOlderThanDest = -1;
   SourceEqualToDest = 0;
   SourceNewerThanDest = 1;
   CouldNotCompareFileTime = 2;
Type
   ft = Record
      CreationTime, LastAccessTime, LastWriteTime: TFiletime;
   End;
Var
   Buf: Array[0..BufSize-1] Of Byte;
   CopyAttr: Longint;
   s, d, tmp: THandle;
   Res: Longint;
   BytesRead: Cardinal;
   BytesWritten: Cardinal;
   Mes: Longint;
   FileProgress: Longint;
   Time_Dest: ft;
   TimeSrcForCmp, TimeDstForCmp: TFileTime;
   TimeSrcForCmp_Valid, TimeDstForCmp_Valid: Boolean;
   TimeIsValid_Dest: Boolean;
   DestFileExists: Boolean;
   FileTimeComparison: Integer;
   TimeSrcStr, TimeDstStr: String;
   Year, Month, Day, Hour, Min: String[2];
   ST: TSystemTime;
   MessageStr, FileTimeComparisonStr: String;
Begin
     {$I-}
     FileProgress:=0;
     IOResult;
     Result:=0;
     If Canceled Then Exit;

     // Dateinamen im Fortschrittsfenster anzeigen
     With FrmCopyMoveStatus Do Begin
          LblSource.Caption:=Source;
          LblDest.Caption:=Dest;
          PrgFile.Position:=0;
     End;
     Application.ProcessMessages;

     // Quell-Datei ffnen
     Repeat
           s:=CreateFile(PChar(Source), GENERIC_READ, FILE_SHARE_READ, Nil, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, 0);
           If (s = INVALID_HANDLE_VALUE) Then Begin
              Mes:=MessageDlg('Fehler beim ffnen von '+Source+'.'+#13+#10+GetLastErrorString,mtError,mbAbortRetryIgnore,0);
              Case Mes Of
                   mrAbort: Begin
                                 Result:=-1;
                                 Canceled:=True;
                                 Exit;
                            End;
                   mrIgnore:Begin
                                 Result:=0;
                                 Exit;
                            End;
              End;
           End;
     Until s <> INVALID_HANDLE_VALUE;

     // Datum und Zeit der Quelldatei merken
     TimeIsValid_Dest:=Boolean(GetFileTime(s, @Time_Dest.CreationTime, @Time_Dest.LastAccessTime, @Time_Dest.LastWriteTime));
     TimeSrcForCmp_Valid:=Boolean(GetFileTime(s, Nil, Nil, @TimeSrcForCmp));

     // Testen, ob Zieldatei schon existiert, ggf. Zeitstempel vergleichen
     tmp:=CreateFile(PChar(Dest), GENERIC_READ, FILE_SHARE_READ, Nil, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, 0);
     If tmp <> INVALID_HANDLE_VALUE Then Begin
        DestFileExists:=True;
        TimeDstForCmp_Valid:=Boolean(GetFileTime(tmp, Nil, Nil, @TimeDstForCmp));
        CloseHandle(tmp);
        If (TimeDstForCmp_Valid And TimeSrcForCmp_Valid And DestFileExists) Then Begin
           FileTimeToLocalFileTime(TimeSrcForCmp, TimeSrcForCmp);
           FileTimeToLocalFileTime(TimeDstForCmp, TimeDstForCmp);
           FileTimeComparison:=CompareFileTime(TimeSrcForCmp, TimeDstForCmp);
        End Else FileTimeComparison:=CouldNotCompareFileTime;
     End Else Begin
        DestFileExists:=False;
        TimeDstForCmp_Valid:=False;
        FileTimeComparison:=CouldNotCompareFileTime;
     End;

     // ggf. Meldung ausgeben und auf Antwort warten
     If DestFileExists Then Begin

        // Wenn zu kopierende Datei lter ist und "Nur neue Dateien Kopieren" aktiviert ist, EXIT!
        If (CopyOnlyNewFiles And ((FileTimeComparison = SourceOlderThanDest) Or (FileTimeComparison = SourceEqualToDest))) Then Begin
           CloseHandle(s);
           Result:=0;
           Exit;
        End;

        // Wenn nicht alle bzw. alle neuen Dateien autom. berschrieben werden sollen, nachfragen,
        // was passieren soll.
        If (Not OverwriteAll) And (Not ((FileTimeComparison = SourceNewerThanDest) And AlwaysOverwriteOldFiles)) Then Begin

           If (TimeSrcForCmp_Valid And TimeDstForCmp_Valid) Then Begin
              FileTimeToSystemTime(TimeSrcForCmp, ST);
              TwoCharNumber(ST.wYear Mod 100, Year);
              TwoCharNumber(ST.wMonth, Month);
              TwoCharNumber(ST.wDay, Day);
              TwoCharNumber(ST.wHour, Hour);
              TwoCharNumber(ST.wMinute, Min);
              TimeSrcStr:=Day+'.'+Month+'.'+Year+' '+Hour+':'+Min;

              FileTimeToSystemTime(TimeDstForCmp, ST);
              TwoCharNumber(ST.wYear Mod 100, Year);
              TwoCharNumber(ST.wMonth, Month);
              TwoCharNumber(ST.wDay, Day);
              TwoCharNumber(ST.wHour, Hour);
              TwoCharNumber(ST.wMinute, Min);
              TimeDstStr:=Day+'.'+Month+'.'+Year+' '+Hour+':'+Min;

              Case FileTimeComparison Of
                   SourceNewerThanDest: FileTimeComparisonStr:=#13+#10+'Die zu kopierende Datei ist neuer als die existierende.';
                   SourceOlderThanDest: FileTimeComparisonStr:=#13+#10+'Die zu kopierende Datei ist lter als die existierende.';
                   SourceEqualToDest: FileTimeComparisonStr:=#13+#10+'Beide Dateien weisen das selbe nderungsdatum auf.';
                   Else FileTimeComparisonStr:='';
              End;

              MessageStr:=Source+' (gendert '+TimeSrcStr+')'+#13+#10
                          +'existiert schon im Zielverzeichnis.'+#13+#10
                          +'Soll die bestehende Datei (gendert '+TimeDstStr+') berschrieben werden?'+#13+#10
                          +FileTimeComparisonStr;

           End Else Begin
              MessageStr:=Source+#13+#10+'existiert schon im Zielverzeichnis. Soll die bestehende Datei berschrieben werden?';
           End;

           Res:=MessageDlg(MessageStr, mtConfirmation, [mbYes, mbNo, mbAll, mbCancel], 0);
           Case Res Of
                mrCancel: Begin
                   CloseHandle(s);
                   Result:=0;
                   Canceled:=True;
                   FrmCopyMoveStatus.Close;
                   Exit;
                End;
                mrAll: Begin
                   OverWriteAll:=True;
                End;
                mrNo: Begin
                   CloseHandle(s);
                   Result:=0;
                   Exit;
                End;
           End;


        End;

     End;

     // Ziel-Datei erstellen
     Repeat
           FileSetAttr(Dest,faArchive);
           d:=CreateFile(PChar(Dest), GENERIC_WRITE, FILE_SHARE_WRITE, Nil, CREATE_ALWAYS, FILE_FLAG_SEQUENTIAL_SCAN, 0);
           If d = INVALID_HANDLE_VALUE Then Begin
              Mes:=MessageDlg('Fehler beim Erstellen von '+Dest+'.'+#13+#10+GetLastErrorString,mtError,mbAbortRetryIgnore,0);
              Case Mes Of
                   mrAbort: Begin
                                 CloseHandle(s);
                                 IOResult;
                                 Result:=-1;
                                 Canceled:=True;
                                 Exit;
                            End;
                   mrIgnore:Begin
                                 CloseHandle(s);
                                 IOResult;
                                 Result:=0;
                                 Exit;
                            End;
              End;
           End;
     Until d <> INVALID_HANDLE_VALUE;

     // Daten kopieren
     If SourceSize > 0 Then Begin
        Repeat
              If Canceled Then Begin
                 CloseHandle(s);
                 CloseHandle(d);
                 IOResult;
                 Result:=0;
                 Exit;
              End;
              ReadFile(s, Buf, BufSize, BytesRead, Nil);
              WriteFile(d, Buf, BytesRead, BytesWritten, Nil);
              If (BytesRead <> BytesWritten) Then Begin
                 Mes:=MessageDlg('Fehler beim Kopieren von '+Source+'.'+#13+#10+GetLastErrorString,mtError,[mbIgnore,mbCancel],0);
                 Case Mes Of
                      mrCancel:Begin
                                    CloseHandle(s);
                                    CloseHandle(d);
                                    Canceled:=True;
                                    Result:=-1;
                                    Exit;
                               End;
                      mrIgnore:Begin
                                    CloseHandle(s);
                                    CloseHandle(d);
                                    Result:=0;
                                    Exit;
                               End;
                 End;
              End Else Begin
                 Progress:=Progress+BytesWritten;
                 Inc(FileProgress,BytesWritten);
                 With FrmCopyMoveStatus Do Begin
                      If SourceSize <> 0 Then PrgFile.Position:=Round(FileProgress/SourceSize*100);
                      If AllFilesSize <> 0 Then PrgAllFiles.Position:=Round(Progress/AllFilesSize*100);
                 End;
                 Application.ProcessMessages;
              End;
        Until (BytesRead < BufSize);
     End;

     // Datum und Zeit setzen
     If TimeIsValid_Dest Then SetFileTime(d, @Time_Dest.CreationTime, @Time_Dest.LastAccessTime, @Time_Dest.LastWriteTime);

     // Dateien schlieen
     CloseHandle(s);
     CloseHandle(d);

     // Dateiattribute kopieren
     CopyAttr:=FileGetAttr(Source);
     If ClearReadOnly Then
        CopyAttr:=(CopyAttr And (Not faReadOnly));
     FileSetAttr(Dest,CopyAttr);

     // Alles hat geklappt! (Naja, es scheint jedenfalls so...)
     Result:=1;
End;

Procedure TFrmMain.ETATime;
Var
   TicksElapsed: Integer;
   TimeLeft, BytesLeft: Int64;
   SecLeft, MinLeft, HourLeft: Integer;
   hl: String;
   ml, sl: String[2];
Begin
     Try
        If Progress <> 0 Then Begin
           CurrentTickCount:=GetTickCount;
           TicksElapsed:=Abs(CurrentTickCount - OldTickCount);
           BytesLeft:=AllFilesSize - Progress;
           TimeLeft:=Round((TicksElapsed / Progress) * BytesLeft);
           SecLeft:=Round(TimeLeft / 1000);
           MinLeft:=(SecLeft Div 60) Mod 60;
           HourLeft:=SecLeft Div 3600;
           SecLeft:=SecLeft Mod 60;
           FrmCopyMoveStatus.LblETA.Visible:=True;
           hl:=Stri(HourLeft);
           TwoCharNumber(MinLeft, ml);
           TwoCharNumber(SecLeft, sl);
           FrmCopyMoveStatus.LblTimeLeft.Caption:=hl+': '+ml+': '+sl;
           Application.ProcessMessages;
        End;
     Except On EInvalidOp Do Begin
               ETA.Free;
            End;
     End;
End;

Function ExecFile;
Var
   Res: Integer;
Begin
     Res:=ExecuteFile(Filename, '', ExtractFilePath(Filename), SW_SHOW);
     If Res <= 32 Then Begin
        MessageDlg(Filename+' konnte nicht gestartet werden.'+#13+#10+GetLastErrorString, mtError, [mbOk], 0);
        Result:=False;
     End Else Result:=True;
End;

procedure TFrmMain.MediaStartScanDiskClick(Sender: TObject);
begin
     ExecFile('scandskw.exe');
end;

procedure TFrmMain.MediaStartDefragClick(Sender: TObject);
begin
     ExecFile('defrag.exe');
end;

Function TFrmMain.GetFileInfo;
Var
   LocalFT: TFileTime;
   ST: TSystemTime;
   Year, Month, Day, Hour, Min: String[2];
   s: String;
Begin
     If Item <> Nil Then Begin
        If Data[Side].DataType = dtFileList Then Begin
           If Dat(Item.Data^).UpDir Then Result:='bergeordnet'
           Else Begin
              If (Dat(Item.Data^).fAttr And faDirectory) = faDirectory Then Begin
                 If Item.SubItems[0] <> '' Then
                    Result:=Item.SubItems[0]+' / '+Item.SubItems[1]+' / '+Item.SubItems[2]
                 Else
                    Result:='Verzeichnis'+' / '+Item.SubItems[1]+' / '+Item.SubItems[2];
              End Else
                 Result:=Item.SubItems[0]+' Bytes / '+Item.SubItems[1]+' / '+Item.SubItems[2];
           End;
        End Else If Data[Side].DataType = dtFindResult Then With Dat(Item.Data^) Do Begin
           FileTimeToLocalFileTime(fTime, LocalFT);
           FileTimeToSystemTime(LocalFT, ST);
           TwoCharNumber(ST.wYear Mod 100,Year);
           TwoCharNumber(ST.wMonth,Month);
           TwoCharNumber(ST.wDay,Day);
           TwoCharNumber(ST.wHour,Hour);
           TwoCharNumber(ST.wMinute,Min);
           If (fAttr And faDirectory) = faDirectory Then Begin
              If Options.MarkDirectories Then
                 s:='>SUB-DIR<'
              Else
                 s:='Verzeichnis';
           End Else
              s:=Formatted(fSize);
           If (Dat(Item.Data^).fAttr And faDirectory) = faDirectory Then
              Result:=s+' / '+AttrToString(fAttr)+' / '+Day+'.'+Month+'.'+Year+' '+Hour+':'+Min
           Else
              Result:=s+' Bytes / '+AttrToString(fAttr)+' / '+Day+'.'+Month+'.'+Year+' '+Hour+':'+Min;
        End Else Result:='';
     End Else Result:='';
End;

procedure TFrmMain.HelpContentsClick(Sender: TObject);
begin
     Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TFrmMain.HelpTheMainWindowClick(Sender: TObject);
begin
     Application.HelpCommand(HELP_CONTEXT, IDH_TheMainWindow);
end;

procedure TFrmMain.HelpListOfMenuItemsClick(Sender: TObject);
begin
     Application.HelpCommand(HELP_CONTEXT, IDH_IndexOfMenuItems);
end;

procedure TFrmMain.LstFilesContextPopup(Sender: TObject; MousePos: TPoint;
  var Handled: Boolean);
Var
   Dummy: TPoint;
begin
     Dummy:=LstFiles.ClientToScreen(MousePos);
     If LstFiles.GetItemAt(MousePos.x, MousePos.y) = Nil Then
        PopLists.PopUp(Dummy.x, Dummy.y)
     Else Begin
        ExplorerMenu.Side:=LeftList;
        ExplorerMenu.p:=Dummy;
        If ((GetKeyState(VK_CONTROL) And 128) = 0) Then
           PopFiles.PopUp(Dummy.x, Dummy.y)
        Else
           ShowExplorerMenu(LeftList, Point(Dummy.x, Dummy.y));
     End;
end;

procedure TFrmMain.LstFiles2ContextPopup(Sender: TObject; MousePos: TPoint;
  var Handled: Boolean);
Var
   Dummy: TPoint;
begin
     Dummy:=LstFiles2.ClientToScreen(MousePos);
     If LstFiles2.GetItemAt(MousePos.x, MousePos.y) = Nil Then
        PopLists.PopUp(Dummy.x, Dummy.y)
     Else Begin
        ExplorerMenu.Side:=RightList;
        ExplorerMenu.p:=Dummy;
        If ((GetKeyState(VK_CONTROL) And 128) = 0) Then
           PopFiles.PopUp(Dummy.x, Dummy.y)
        Else
           ShowExplorerMenu(RightList, Point(Dummy.x, Dummy.y));
     End;
end;

procedure TFrmMain.LstFilesMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
Var
   Index: Integer;
begin
     If Sender = Lists[0] Then Index:=0 Else Index:=1;
     If DontDrag Then Begin
        MouseInfos[Index].State:=msNoDrag;
        DontDrag:=False;
        Exit;
     End;
     If (mbLeft In [Button]) Then Begin
        MouseInfos[Index].pt:=Point(x, y);
        MouseInfos[Index].State:=msLeftDrag;
     End Else If (mbRight In [Button]) Then Begin
        MouseInfos[Index].pt:=Point(x, y);
        MouseInfos[Index].State:=msRightDrag;
     End;
end;

procedure TFrmMain.LstFilesMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
Var
   Index: Integer;
begin
     If Sender = Lists[0] Then Index:=0 Else Index:=1;
     If (ssLeft In Shift) Then Begin
        If MouseInfos[Index].State = msLeftDrag Then Begin
           If (Abs(x - MouseInfos[Index].pt.x) >= MinXYDiff) Or
              (Abs(y - MouseInfos[Index].pt.y) >= MinXYDiff) Then Begin
                 OLEDragDrop(Index, True);
                 MouseInfos[Index].State:=msNoDrag;
           End;
        End;
     End Else If (ssRight In Shift) Then Begin
        If MouseInfos[Index].State = msRightDrag Then Begin
           If (Abs(x - MouseInfos[Index].pt.x) >= MinXYDiff) Or
              (Abs(y - MouseInfos[Index].pt.y) >= MinXYDiff) Then Begin
                 OLEDragDrop(Index, False);
                 MouseInfos[Index].State:=msNoDrag;
           End;
        End;
     End;
end;

procedure TFrmMain.LstFilesMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
Var
   Index: Integer;
   pt: TPoint;
begin
     If Sender = Lists[0] Then Index:=0 Else Index:=1;
     MouseInfos[Index].State:=msNoDrag;

     If Options.ClickToOpen Then Begin

        If (Button = mbLeft) And
           // Aus irgendeinem Grund funktioniert die Abfrage ber Shift nicht,
           // also mssen wir uns selbst helfen (as usual).
           ((GetKeyState(VK_SHIFT) And 128) = 0) And
           ((GetKeyState(VK_CONTROL) And 128) = 0) Then
        Begin

           pt:=Lists[Index].ScreenToClient(Mouse.CursorPos);
           If Lists[Index].GetItemAt(pt.x, pt.y) = Nil Then Exit;
           If Lists[Index].ItemFocused <> Nil Then Begin
              DoSomething(Index, Lists[Index].ItemFocused);
           End;

        End;

     End;
end;

procedure TFrmMain.FormDestroy(Sender: TObject);
Var
   i: Integer;
begin
     Application.ProcessMessages;
     If OleInitialized Then Begin
        // Fenster aus der Liste der Drop-Targets entfernen
        For i:=0 To 1 Do Begin
            If Assigned(DrpTargetDummies[i]) Then Begin
               RevokeDragDrop(DrpTargetDummies[i].wnd);
//               DrpTargetDummies[i].Free;
            End;
        End;
        // OLE de-initialisieren
        OleUninitialize;
     End;
     ClearList(LeftList);
     ClearList(RightList);
end;

// *****************************************************************************************
// *****************************************************************************************
// Anfang der Drag & Drop - Prozeduren
// *****************************************************************************************
// *****************************************************************************************

Function ValidDataFormat;
Begin
     If (DataObj.QueryGetData(FORMATETCs[IDLIST_FormatEtc]) = S_OK) Then
        Result:=True
     Else If (DataObj.QueryGetData(FORMATETCs[HDROP_FormatEtc]) = S_OK) Then
        Result:=True
     Else Result:=False;
End;

Procedure AddFilenameToList;
Begin
     If FilenamesList.FileNum <= MaxFilenames Then Begin
        If Filename[Length(Filename)] = '\' Then Filename:=Copy(Filename, 1, Length(Filename)-1);
        FilenamesList.Files[FilenamesList.FileNum]:=Filename;
        Inc(FilenamesList.FileNum);
     End;
End;

Procedure ClearFilenamesList;
Var
   i: Integer;
Begin
     For i:=0 To FilenamesList.FileNum-1 Do Begin
         FilenamesList.Files[i]:='';
     End;
     FilenamesList.FileNum:=0;
     For i:=0 To MappedFilenamesList.FileNum-1 Do Begin
         MappedFilenamesList.Files[i]:='';
     End;
     MappedFilenamesList.FileNum:=0;
     UseMappedFilenames:=False;
End;

Function GetFilenamesFromDataObject;
Var
   Res: Boolean;
Begin
     Res:=GetFilenames_HDROP(DataObj);
     If Not Res Then
        Result:=GetFilenames_IDLIST(DataObj)
     Else
        Result:=Res;
End;

{*******************************************************************************************
   Diese Funktionen stammen nicht von mir, sondern von Angus Johnson und Anders Melander.
   (Ich habe sie aus ihrer "Drag&Drop-Suite" entnommen, die als PublicDomain zu haben ist.)
 *******************************************************************************************}
function GetSizeOfPidl(pidl: PItemIDList): integer;
var
  i: integer;
begin
  result := SizeOf(Word);
  repeat
    i := pSHItemID(pidl)^.cb;
    inc(result,i);
    inc(longint(pidl),i);
  until i = 0;
end;

function PidlToString(pidl: PItemIDList): String;
var
  PidlLength: integer;
begin
  PidlLength := GetSizeOfPidl(pidl);
  setlength(result,PidlLength);
  Move(pidl^,pchar(result)^,PidlLength);
end;

function JoinPidlStrings(pidl1,pidl2: string): String;
var
  PidlLength: integer;
begin
  if Length(pidl1) <= 2 then PidlLength := 0
  else PidlLength := Length(pidl1)-2;
  setlength(result,PidlLength+length(pidl2));
  if PidlLength > 0 then Move(pidl1[1],result[1],PidlLength);
  Move(pidl2[1],result[PidlLength+1],length(pidl2));
end;
{*******************************************************************************************
    Der Rest stammt wieder von mir selbst (und zwar ganz allein, jawoll!).
 *******************************************************************************************}

Function GetFilenames_IDLIST;
Var
   i, Count: Integer;
   StrBuf: Array[0..MAX_PATH] Of Char;
   pInt: ^UINT;
   pCIDA: PIDA;
   BasePIDLString, PIDLString, AbsolutePIDL: String;
Begin
     ClearFilenamesList;
     Result:=True;

     If DataObj.GetData(FORMATETCs[IDLIST_FormatEtc], DropData) = S_OK Then Begin
        If DropData.tymed = TYMED_HGLOBAL Then Begin

           pCIDA:=PIDA(GlobalLock(DropData.hGlobal));
           pInt:=@(pCIDA^.aOffset[0]);

           Count:=pCIDA^.cidl;
           If Count > 0 Then Begin
              BasePIDLString:=pIDLtoString(Pointer(UINT(pCIDA)+pInt^));
              Inc(pInt);
              For i:=0 To Count-1 Do Begin
                  PIDLString:=pIDLtoString(pointer(UINT(pCIDA)+pInt^));
                  AbsolutePIDL:=JoinPIDLStrings(BasePIDLString, PIDLString);
                  If SHGetPathFromIDList(PItemIDList(PChar(AbsolutePIDL)), StrBuf) Then
                     AddFileNameToList(String(StrBuf));
                  Inc(pInt);
              End;
           End Else Result:=False;

           GlobalUnlock(DropData.hGlobal);

        End Else Result:=False;
        FreeDropData;
     End Else Result:=False;
End;

Function GetFilenames_HDROP;
Var
   i, Count: Integer;
   StrBuf: Array[0..MAX_PATH] Of Char;
   res: Boolean;
Begin
     ClearFilenamesList;
     Result:=True;
     If DataObj.GetData(FORMATETCs[HDROP_FormatEtc], DropData) = S_OK Then Begin
        If DropData.tymed = TYMED_HGLOBAL Then Begin

           Count:=DragQueryFile(Integer(DropData.hGlobal), $FFFFFFFF, Nil, 0);
           For i:=0 To Count-1 Do Begin
               DragQueryFile(Integer(DropData.hGlobal), i, StrBuf, SizeOf(StrBuf));
               AddFilenameToList(String(StrBuf));
           End;

           res:=GetMappedFilenames_FILENAMEMAP(DataObj);
           UseMappedFilenames:=(res And (FilenamesList.FileNum = MappedFilenamesList.FileNum));

        End Else Result:=False;
        FreeDropData;
     End Else Result:=False;
End;

Function GetMappedFilenames_FILENAMEMAP;
Var
   i: Integer;
   StrBuf: Array[0..MAX_PATH] Of Char;
   ptr: ^Char;
   LastFile: Boolean;
Begin
     Result:=True;
     If DataObj.GetData(FILENAMEMAP_FormatEtc, DropData) = S_OK Then Begin
        If DropData.tymed = TYMED_HGLOBAL Then Begin
           ptr:=GlobalLock(DropData.hGlobal);
           LastFile:=False;
           MappedFilenamesList.FileNum:=0;
           Repeat
                 i:=0;
                 Repeat
                       StrBuf[i]:=ptr^;
                       Inc(i);
                       Inc(ptr);
                 Until StrBuf[i-1] = #0;
                 MappedFilenamesList.Files[MappedFilenamesList.FileNum]:=String(StrBuf);
                 Inc(MappedFilenamesList.FileNum);
                 If ptr^ = #0 Then LastFile:=True;
           Until LastFile;
           GlobalUnLock(DropData.hglobal);
        End Else Result:=False;
     End Else Result:=False;
End;

Procedure FreeDropData;
Begin
     ReleaseStgMedium(DropData);
End;

{ *****************************************************************************************
  *****************************************************************************************
  TDropTarget
  *****************************************************************************************
  ***************************************************************************************** }

Constructor TDropTarget.Create;
Begin
     ListView:=AOwner;
     wnd:=AOwner.Handle;
     HighlightedItem:=-1;
     Side:=ListNr;
     ScrollMargin:=Abs(ListView.Font.Height);
     CursorPos:=Point(0, 0);
     Timer:=TTimer.Create(Nil);
     Timer.Enabled:=False;
     Timer.Interval:=150;
     Timer.OnTimer:=DoScroll;
End;

Destructor TDropTarget.Destroy;
Begin
     Timer.Enabled:=False;
     Timer.Free;
     Inherited Destroy;
End;

Procedure TDropTarget.DoScroll;
Begin
     If CursorPos.y < ScrollMargin Then
        ListView.Perform(WM_VSCROLL, SB_LINEUP, 0)
     Else If CursorPos.y > (ListView.ClientHeight - ScrollMargin) Then
        ListView.Perform(WM_VSCROLL,SB_LINEDOWN,0);
     If CursorPos.x < ScrollMargin Then
        ListView.Perform(WM_HSCROLL, SB_LINEUP, 0)
     Else If CursorPos.x > (ListView.ClientWidth - ScrollMargin) Then
        ListView.Perform(WM_HSCROLL,SB_LINEDOWN,0);
End;

Function TDropTarget.DragEnter;
Var
   Hittest: TLVHittestInfo;
   Effect: Longint;
Begin
     Timer.Enabled:=True;
     ScrollMargin:=Abs(ListView.Font.Height);
     CursorPos:=ListView.ScreenToClient(pt);
     If DataObj = Nil Then Begin
        ValidDataFormatFound:=False;
        Result:=E_INVALIDARG;
        Exit;
     End;
     ValidDataFormatFound:=ValidDataFormat(DataObj);
     HighlightedItem:=-1;
     Hittest.pt:=ListView.ScreenToClient(pt);
     ListView_Hittest(ListView.Handle, Hittest);
     Effect:=GetDragEffect(grfKeyState, dwEffect, Hittest.iItem);
     If (Hittest.flags And LVHT_ONITEM) <> 0 Then Begin
        If Effect <> DROPEFFECT_NONE Then Begin
           HighlightedItem:=Hittest.iItem;
           If HighlightedItem >= 0 Then
              ListView_SetItemState(ListView.Handle, HighlightedItem, LVIS_DROPHILITED, LVIS_DROPHILITED);
        End;
     End;
     If (grfKeyState And MK_RBUTTON) = MK_RBUTTON Then
        DraggedWithRightButton:=True
     Else
        DraggedWithRightButton:=False;
     dwEffect:=Effect;
     Result:=S_OK;
End;

Function TDropTarget.DragOver;
Var
   Hittest: TLVHittestInfo;
   NewHighlightedItem: Integer;
   Effect: Longint;
Begin
     CursorPos:=ListView.ScreenToClient(pt);
     Hittest.pt:=ListView.ScreenToClient(pt);
     ListView_Hittest(ListView.Handle, Hittest);
     Effect:=GetDragEffect(grfKeyState, dwEffect, Hittest.iItem);
     If (Hittest.flags And LVHT_ONITEM) <> 0 Then Begin
        NewHighlightedItem:=Hittest.iItem;
        If NewHighlightedItem <> HighlightedItem Then Begin
           If HighlightedItem >= 0 Then Begin
              ListView_SetItemState(ListView.Handle, HighlightedItem, 0, LVIS_DROPHILITED);
              HighlightedItem:=-1;
           End;
           If Effect <> DROPEFFECT_NONE Then Begin
              HighlightedItem:=NewHighlightedItem;
              If HighlightedItem >= 0 Then
                 ListView_SetItemState(ListView.Handle, HighlightedItem, LVIS_DROPHILITED, LVIS_DROPHILITED);
           End;
        End;
     End Else Begin
        If HighlightedItem >= 0 Then Begin
           ListView_SetItemState(ListView.Handle, HighlightedItem, 0, LVIS_DROPHILITED);
           HighlightedItem:=-1;
        End;
     End;
     dwEffect:=Effect;
     If (grfKeyState And MK_RBUTTON) = MK_RBUTTON Then
        DraggedWithRightButton:=True
     Else
        DraggedWithRightButton:=False;
     Result:=S_OK;
End;

Function TDropTarget.DragLeave;
Begin
     Timer.Enabled:=False;
     If HighlightedItem >= 0 Then Begin
        ListView_SetItemState(ListView.Handle, HighlightedItem, 0, LVIS_DROPHILITED);
        HighlightedItem:=-1;
     End;
     Result:=S_OK;
End;

Procedure TDropTarget.ShowDragPopUp;
Begin
     FrmMain.PopCopyHere.Default:=False;
     FrmMain.PopMoveHere.Default:=False;
     FrmMain.PopCreateLinksHere.Default:=False;
     FrmMain.PopCancel.Default:=False;

     If ((Effect And DROPEFFECT_COPY) = DROPEFFECT_COPY) Then FrmMain.PopCopyHere.Default:=True
     Else If ((Effect And DROPEFFECT_MOVE) = DROPEFFECT_MOVE) Then FrmMain.PopMoveHere.Default:=True
     Else If ((Effect And DROPEFFECT_LINK) = DROPEFFECT_LINK) Then FrmMain.PopCreateLinksHere.Default:=True
     Else FrmMain.PopCancel.Default:=True;

     FrmMain.PopDrag.PopUp(pt.x, pt.y);
End;

Function TDropTarget.Drop;
Var
   Hittest: TLVHittestInfo;
   Effect: Integer;
   Target: String;
   Res: Boolean;
Begin
     DragLeave;
     If DataObj = Nil Then Begin
        Result:=E_INVALIDARG;
        Exit;
     End;
     Hittest.pt:=ListView.ScreenToClient(pt);
     ListView_Hittest(ListView.Handle, Hittest);
     Effect:=GetDragEffect(grfKeyState, dwEffect, Hittest.iItem);
     If Effect <> DROPEFFECT_NONE Then Begin
        If GetFilenamesFromDataObject(DataObj) Then Begin
           Target:='';
           If Hittest.iItem >= 0 Then Begin
              If (Dat(ListView.Items[Hittest.iItem].Data^).fAttr And faDirectory) = faDirectory Then Begin
                 If (Not Dat(ListView.Items[Hittest.iItem].Data^).UpDir) Then Begin
                    Target:=GetFullName(ListView.Items[Hittest.iItem].Data, Side);
                 End Else Begin
                    Target:=StepBack(Data[Side].Directory);
                 End;
              End;
           End Else Begin
              If Data[Side].DataType = dtFileList Then
                 Target:=Data[Side].Directory;
           End;

           If Target <> '' Then Begin

              If Target[Length(Target)] <> '\' Then Target:=Target+'\';

              If DraggedWithRightButton Then Begin

                 // Drag&Drop mit rechter Maustaste: Men anzeigen
                 DropTargetDir:=Target;
                 ShowDragPopUp(Effect, pt);
                 dwEffect:=DROPEFFECT_NONE; // Nicht sehr elegant, aber was soll ich machen?

              End Else Begin

                 // Normal
                 Res:=False;
                 If ((Effect And DROPEFFECT_COPY) = DROPEFFECT_COPY) Then Res:=DragDropCopyMove(Target, cmCopy)
                 Else If ((Effect And DROPEFFECT_MOVE) = DROPEFFECT_MOVE) Then Res:=DragDropCopyMove(Target, cmMove)
                 Else If ((Effect And DROPEFFECT_LINK) = DROPEFFECT_LINK) Then Res:=DragDropCreateLinks(Target);
                 If Res Then dwEffect:=Effect Else dwEffect:=DROPEFFECT_NONE;

              End;

           End Else dwEffect:=DROPEFFECT_NONE;

        End;
     End;
     Result:=S_OK;
End;

Function TDropTarget.GetDragEffect;
Begin
     If (((grfKeyState And MK_CONTROL) = MK_CONTROL) And ((grfKeyState And MK_SHIFT) = MK_SHIFT)) Then Begin
        If (dwEffect And DROPEFFECT_LINK) <> 0 Then dwEffect:=DROPEFFECT_LINK;
     End Else If ((grfKeyState And MK_CONTROL) = MK_CONTROL) Then Begin
        If (dwEffect And DROPEFFECT_COPY) <> 0 Then dwEffect:=DROPEFFECT_COPY;
     End Else If ((grfKeyState And MK_SHIFT) = MK_SHIFT) Then Begin
        If (dwEffect And DROPEFFECT_MOVE) <> 0 Then dwEffect:=DROPEFFECT_MOVE;
     End Else Begin
        Case Options.DDStandardAction Of
             saMove: If (dwEffect And DROPEFFECT_MOVE) <> 0 Then dwEffect:=DROPEFFECT_MOVE;
             saCopy: If (dwEffect And DROPEFFECT_COPY) <> 0 Then dwEffect:=DROPEFFECT_COPY;
             saCreateLinks: If (dwEffect And DROPEFFECT_LINK) <> 0 Then dwEffect:=DROPEFFECT_LINK;
             Else dwEffect:=DROPEFFECT_NONE;
        End;
     End;
     If ItemIndex >= 0 Then Begin
        If ((Dat(ListView.Items[ItemIndex].Data^).fAttr And faDirectory) <> faDirectory) Then
           dwEffect:=DROPEFFECT_NONE;
     End Else
        If Data[Side].DataType = dtFindResult Then dwEffect:=DROPEFFECT_NONE;
     If ValidDataFormatFound Then Result:=dwEffect Else Result:=DROPEFFECT_NONE;
End;

{ *****************************************************************************************
  *****************************************************************************************
  TDropSource
  *****************************************************************************************
  ***************************************************************************************** }

Constructor TDropSource.Create;
Begin
     IndexOfList:=Side;
     dataobj:=TDataObject.Create(Side);
     DataObject:=dataobj;
End;

Function TDropSource.QueryContinueDrag;
Begin
     If fEscapePressed Then Begin
        Result:=DRAGDROP_S_CANCEL;
        Exit;
     End;

     If LeftButtonDrag Then Begin

        If ((grfKeyState And MK_LBUTTON) = MK_LBUTTON) Then Begin
           If ((grfKeyState And MK_RBUTTON) = MK_RBUTTON) Then
              Result:=DRAGDROP_S_CANCEL
           Else
              Result:=S_OK;
        End Else
           Result:=DRAGDROP_S_DROP;

     End Else Begin

        If ((grfKeyState And MK_RBUTTON) = MK_RBUTTON) Then Begin
           If ((grfKeyState And MK_LBUTTON) = MK_LBUTTON) Then
              Result:=DRAGDROP_S_CANCEL
           Else
              Result:=S_OK;
        End Else
           Result:=DRAGDROP_S_DROP;

     End;
End;

Function TDropSource.GiveFeedback;
Begin
     Result:=DRAGDROP_S_USEDEFAULTCURSORS;
End;

{ *****************************************************************************************
  *****************************************************************************************
  TDataObject
  *****************************************************************************************
  ***************************************************************************************** }

Constructor TDataObject.Create;
Begin
     IndexOfList:=Side;
End;

Function TDataObject.GetData;
Begin
     Result:=CreateData(medium, True, formatetc, IndexOfList);
End;

Function TDataObject.GetDataHere;
Begin
     Result:=CreateData(medium, False, formatetc, IndexOfList);
End;

Function TDataObject.QueryGetData;
Var
   i: Integer;
Begin
     For i:=0 To MaxFormatEtc Do Begin
         If ((formatetc.cfFormat = FORMATETCs[i].cfFormat) And
             (formatetc.ptd = Nil) And
             (formatetc.dwAspect = FORMATETCs[i].dwAspect) And
             (formatetc.lindex = FORMATETCs[i].lindex) And
             (formatetc.tymed = FORMATETCs[i].tymed)) Then Begin
               Result:=S_OK;
               Exit;
         End;
     End;
     Result:=DV_E_FORMATETC;
End;

Function TDataObject.SetData;
Begin
     Result:=E_NOTIMPL;
End;

Function TDataObject.GetCanonicalFormatEtc;
Begin
     Result:=DATA_S_SAMEFORMATETC;
End;

Function TDataObject.EnumFormatEtc;
Var
   Dummy: TEnumFormatEtc;
Begin
     If dwDirection = DATADIR_GET Then Begin
        Dummy:=TEnumFormatEtc.Create;
        EnumFormatEtc:=Dummy;
        Result:=S_OK;
     End Else Result:=E_NOTIMPL;
End;

Function TDataObject.DAdvise;
Begin
     Result:=OLE_E_ADVISENOTSUPPORTED;
End;

Function TDataObject.DUnadvise;
Begin
     Result:=OLE_E_ADVISENOTSUPPORTED;
End;

Function TDataObject.EnumDAdvise;
Begin
     Result:=OLE_E_ADVISENOTSUPPORTED;
End;

{ *****************************************************************************************
  *****************************************************************************************
  TEnumFormatEtc
  *****************************************************************************************
  ***************************************************************************************** }

Constructor TEnumFormatEtc.Create;
Begin
     ActFormatEtc:=0;
End;

Function TEnumFormatEtc.Next;
Var
   i, count: Integer;
Begin
     If celt <= 0 Then Begin
        Result:=S_OK;
        Exit;
     End;

     If ActFormatEtc > MaxFormatEtc Then Begin
        Result:=S_FALSE;
        Exit;
     End;

     If celt+ActFormatEtc > MaxFormatEtc Then
        count:=MaxFormatEtc - ActFormatEtc + 1
     Else
        count:=celt;

     If count > 0 Then Begin
        For i:=0 To count-1 Do Begin
            TFormatEtc(Pointer(Cardinal(@elt) + Cardinal(i * SizeOf(TFormatEtc)))^) := FORMATETCs[ActFormatEtc + i];
        End;
        Inc(ActFormatEtc, count);
     End;

     If Assigned(pceltFetched) Then
        pceltFetched^:=count;

     If count = celt Then
        Result:=S_OK
     Else
        Result:=S_FALSE;
End;

Function TEnumFormatEtc.Skip;
Var
   count: Integer;
Begin
     If celt <= 0 Then Begin
        Result:=S_OK;
        Exit;
     End;

     If celt+ActFormatEtc > MaxFormatEtc Then
        count:=MaxFormatEtc - ActFormatEtc + 1
     Else
        count:=celt;

     If count > 0 Then
        Inc(ActFormatEtc, count);

     If count = celt Then
        Result:=S_OK
     Else
        Result:=S_FALSE;
End;

Function TEnumFormatEtc.Reset;
Begin
     ActFormatEtc:=0;
     Result:=S_OK;
End;

Function TEnumFormatEtc.Clone;
Var
   Dummy: TEnumFormatEtc;
Begin
     Dummy:=TEnumFormatEtc.Create;
     Dummy.ActFormatEtc:=Self.ActFormatEtc;
     Enum:=Dummy;
     Result:=S_OK;
End;

Procedure TFrmMain.OLEDragDrop;
Var
   Effect: Integer;
   EffectAllowed: Integer;
Begin
     EffectAllowed:=$FFFFFFFFFFFFFFFF; // DROPEFFECT_COPY+DROPEFFECT_MOVE+DROPEFFECT_LINK
     DrpSourceDummies[Side].LeftButtonDrag:=LeftButton;
     If DoDragDrop(DrpSourceDummies[Side].DataObject, DrpSources[Side], EffectAllowed, Effect) = DRAGDROP_S_DROP Then Begin
     End;
End;

Function CreateData_IDLIST;
Var
   required: Cardinal;
   ptr: Pointer;
   pIDL_Array: Array[0..MaxPIDL] Of PItemIDList;
   pIDL_Count: Integer;
   SourceDir, Filename: String;
   DesktopFolder, ParentFolder: IShellFolder;
   i: Integer;
   refIDL: PItemIDList;
   Wide: Array[0..MAX_PATH] Of WideChar;
   Dummy: Cardinal;
   MAlloc: ImAlloc;
   RelOfs: Cardinal;
Begin
     // IDLists ins Array bertragen
     pIDL_Count:=0;
     If Succeeded(SHGetDesktopFolder(DesktopFolder)) Then Begin
        If Data[Side].DataType = dtFileList Then
           SourceDir:=Data[Side].Directory[1]+':\'
        Else If Data[Side].DataType = dtFindResult Then
           SourceDir:=GetPath(FrmMain.Lists[Side].Items[0].Data, Side)[1]+':\';
        MultiByteToWideChar(CP_ACP, 0, PChar(SourceDir), -1, Wide, MAX_PATH);
        If Succeeded(DesktopFolder.ParseDisplayName(FrmMain.Handle, Nil, Wide, Dummy, refIDL, Dummy)) Then Begin
           pIDL_Array[0]:=refIDL;
           pIDL_Count:=1;
           If Succeeded(DesktopFolder.BindToObject(refIDL, Nil, IID_IShellFolder, Pointer(ParentFolder))) Then Begin
              // ItemIDLists fr alle markierten Objekte erstellen
              For i:=0 To FrmMain.Lists[Side].Items.Count-1 Do Begin
                  If FrmMain.Lists[Side].Items[i].Selected Then Begin
                     Filename:=GetFullName(FrmMain.Lists[Side].Items[i].Data, Side);
                     MultiByteToWideChar(CP_ACP, 0, PChar(Copy(Filename, 4, Length(Filename)-3)), -1, Wide, MAX_PATH);
                     If Succeeded(ParentFolder.ParseDisplayName(0, Nil, Wide, Dummy, pIDL_Array[pIDL_Count], Dummy)) Then
                        If pIDL_Count < MaxPIDL Then
                           Inc(pIDL_Count);
                  End;
              End;
           End;
        End;
     End Else Begin
        Result:=E_UNEXPECTED;
        Exit;
     End;

     // Bentigte Anzahl Bytes berechnen
     required:=0;
     Inc(required, SizeOf(UINT));                  // CIDA-Struktur
     Inc(required, SizeOf(UINT) * pIDL_Count);     // dito
     For i:=0 To pIDL_Count-1 Do
         Inc(required, GetSizeOfPIDL(pIDL_Array[i]));     // Eigentliche Daten

     // ggf. Speicher allokieren
     If AllocateMemory Then Begin
        output.hGlobal:=GlobalAlloc(GMEM_SHARE Or GMEM_ZEROINIT, required);
        If output.hGlobal = 0 Then Begin
           Result:=E_OUTOFMEMORY;
           Exit;
        End;
     End;

     // Prfen, ob Speicher ausreicht
     If GlobalSize(output.hGlobal) < required Then Begin
        Result:=E_OUTOFMEMORY;
        Exit;
     End;

     // Speicherblock festsetzen (Zeiger auf den Block holen)
     ptr:=GlobalLock(output.hGlobal);
     If ptr = Nil Then Begin
        Result:=E_UNEXPECTED;
        Exit;
     End;

     {$R-}
     RelOfs:=SizeOf(UINT) * (pIDL_Count + 1); // Gesamte Gre der CIDA-Strktur
     CIDA(ptr^).cidl:=pIDL_Count-1;
     For i:=0 To pIDL_Count-1 Do Begin
         Move(pIDL_Array[i]^, Pointer(RelOfs + Cardinal(ptr))^, GetSizeOfPIDL(pIDL_Array[i]));
         CIDA(ptr^).aoffset[i]:=RelOfs;
         Inc(RelOfs, GetSizeOfPIDL(pIDL_Array[i]));
     End;

     // Speicherblock wieder beweglich machen
     GlobalUnlock(output.hGlobal);

     // ItemIDLists wieder freigeben
     If Succeeded(SHGetMAlloc(MAlloc)) Then Begin
        For i:=0 To pIDL_Count-1 Do MAlloc.Free(pIDL_Array[i]);
        MAlloc.Free(refIDL);
     End;

     // Alles hat geklappt
     output.tymed:=TYMED_HGLOBAL;
     output.unkForRelease:=Nil;
     Result:=S_OK;
End;

Procedure WriteNull(p: Pointer); Assembler;
Asm
   push ebx
   mov  ebx, p
   mov  Byte ptr [ebx], 0
   pop  ebx
End;

Function CreateData_HDROP;
Var
   required: Cardinal;
   i: Integer;
   ptr: Pointer;
   Offset: Cardinal;
   Filename: String;
Begin
     // Bentigte Anzahl Bytes berechnen
     required:=0;
     For i:=0 To FrmMain.Lists[Side].Items.Count-1 Do Begin
         If FrmMain.Lists[Side].Items[i].Selected Then Begin
            If (Not Dat(FrmMain.Lists[Side].Items[i].Data^).UpDir) Then
               Inc(required, Length(GetFullName(FrmMain.Lists[Side].Items[i].Data, Side)) + 1);
               // +1, weil Nullterminierte Strings erwartet werden
         End;
     End;
     Inc(required, SizeOf(TDropFiles)); // Vor der Dateinamensliste kommt eine DROPFILES-Struktur
     Inc(required, 1); // Die Liste ist doppelt-Null-terminiert

     // ggf. Speicher allokieren
     If AllocateMemory Then Begin
        output.hGlobal:=GlobalAlloc(GMEM_SHARE Or GMEM_ZEROINIT, required);
        If output.hGlobal = 0 Then Begin
           Result:=E_OUTOFMEMORY;
           Exit;
        End;
     End;

     // Prfen, ob Speicher ausreicht
     If GlobalSize(output.hGlobal) < required Then Begin
        Result:=E_OUTOFMEMORY;
        Exit;
     End;

     // Speicherblock festsetzen (Zeiger auf den Block holen)
     ptr:=GlobalLock(output.hGlobal);
     If ptr = Nil Then Begin
        Result:=E_UNEXPECTED;
        Exit;
     End;

     // DROPFILES-Struktur mit anstndigen Werten fllen
     With TDropFiles(ptr^) Do Begin
          pFiles:=SizeOf(TDropFiles);
          pt:=Point(0, 0);
          fNC:=False;
          fWide:=False;
     End;

     // Dateinamen kopieren und mit Null "terminieren"
     Offset:=TDropFiles(ptr^).pFiles;
     For i:=0 To FrmMain.Lists[Side].Items.Count-1 Do Begin
         If FrmMain.Lists[Side].Items[i].Selected Then Begin
            If (Not Dat(FrmMain.Lists[Side].Items[i].Data^).Updir) Then Begin

               Filename:=GetFullName(FrmMain.Lists[Side].Items[i].Data, Side);
               Move((@Filename[1])^, Pointer(Cardinal(ptr) + Offset)^, Length(Filename));
               Inc(Offset, Length(Filename));
               WriteNull(Pointer(Cardinal(ptr) + Offset));
               Inc(Offset, 1);

            End;
         End;
     End;
     WriteNull(Pointer(Cardinal(ptr) + Offset)); // Die Liste mu doppelt-Null-terminiert werden

     // Speicherblock wieder beweglich machen
     GlobalUnlock(output.hGlobal);

     // Alles hat geklappt
     output.tymed:=TYMED_HGLOBAL;
     output.unkForRelease:=Nil;
     Result:=S_OK;
End;

Function CreateData;
Var
   Res: HResult;
Begin
     Res:=FrmMain.DrpSourceDummies[Side].dataobj.QueryGetData(fmt);
     If Res = S_OK Then Begin
        If (fmt.cfFormat = CF_IDLIST) Then
           Result:=CreateData_IDLIST(output, AllocateMemory, fmt, Side)
        Else If (fmt.cfFormat = CF_HDROP) Then
           Result:=CreateData_HDROP(output, AllocateMemory, fmt, Side)
        Else
           Result:=DV_E_FORMATETC;
     End Else Result:=Res;
End;

Function DragDropCopyFile;
Const
   SourceOlderThanDest = -1;
   SourceEqualToDest = 0;
   SourceNewerThanDest = 1;
   CouldNotCompareFileTime = 2;
Type
   ft = Record
      CreationTime, LastAccessTime, LastWriteTime: TFiletime;
   End;
Var
   Buf: Array[0..BufSize-1] Of Byte;
   CopyAttr: Longint;
   s, d, tmp: THandle;
   Res: Longint;
   BytesRead: Cardinal;
   BytesWritten: Cardinal;
   Mes: Longint;
   FileProgress: Longint;
   Time_Dest: ft;
   TimeSrcForCmp, TimeDstForCmp: TFileTime;
   TimeSrcForCmp_Valid, TimeDstForCmp_Valid: Boolean;
   TimeIsValid_Dest: Boolean;
   DestFileExists: Boolean;
   FileTimeComparison: Integer;
   TimeSrcStr, TimeDstStr: String;
   Year, Month, Day, Hour, Min: String[2];
   ST: TSystemTime;
   MessageStr, FileTimeComparisonStr: String;
Begin
     {$I-}
     FileProgress:=0;
     IOResult;
     Result:=0;
     If Canceled Then Exit;

     // Dateinamen im Fortschrittsfenster anzeigen
     With FrmProgDragDrop Do Begin
          LblSource.Caption:=Source;
          LblDest.Caption:=Dest;
          PrgFile.Position:=0;
     End;
     Application.ProcessMessages;


     // Quell-Datei ffnen
     Repeat
           s:=CreateFile(PChar(Source), GENERIC_READ, FILE_SHARE_READ, Nil, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, 0);
           If (s = INVALID_HANDLE_VALUE) Then Begin
              Mes:=MessageDlg('Fehler beim ffnen von '+Source+'.'+#13+#10+GetLastErrorString,mtError,mbAbortRetryIgnore,0);
              Case Mes Of
                   mrAbort: Begin
                                 Result:=-1;
                                 Canceled:=True;
                                 Exit;
                            End;
                   mrIgnore:Begin
                                 Result:=0;
                                 Exit;
                            End;
              End;
           End;
     Until s <> INVALID_HANDLE_VALUE;

     // Datum und Zeit der Quelldatei merken
     TimeIsValid_Dest:=Boolean(GetFileTime(s, @Time_Dest.CreationTime, @Time_Dest.LastAccessTime, @Time_Dest.LastWriteTime));
     TimeSrcForCmp_Valid:=Boolean(GetFileTime(s, Nil, Nil, @TimeSrcForCmp));

     // Testen, ob Zieldatei schon existiert, ggf. Zeitstempel vergleichen
     tmp:=CreateFile(PChar(Dest), GENERIC_READ, FILE_SHARE_READ, Nil, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, 0);
     If tmp <> INVALID_HANDLE_VALUE Then Begin
        DestFileExists:=True;
        TimeDstForCmp_Valid:=Boolean(GetFileTime(tmp, Nil, Nil, @TimeDstForCmp));
        CloseHandle(tmp);
        If (TimeDstForCmp_Valid And TimeSrcForCmp_Valid And DestFileExists) Then Begin
           FileTimeToLocalFileTime(TimeSrcForCmp, TimeSrcForCmp);
           FileTimeToLocalFileTime(TimeDstForCmp, TimeDstForCmp);
           FileTimeComparison:=CompareFileTime(TimeSrcForCmp, TimeDstForCmp);
        End Else FileTimeComparison:=CouldNotCompareFileTime;
     End Else Begin
        DestFileExists:=False;
        TimeDstForCmp_Valid:=False;
        FileTimeComparison:=CouldNotCompareFileTime;
     End;

     // ggf. Meldung ausgeben und auf Antwort warten
     If DestFileExists Then Begin

        // Wenn zu kopierende Datei lter ist und "Nur neue Dateien Kopieren" aktiviert ist, EXIT!
        If (CopyOnlyNewFiles And ((FileTimeComparison = SourceOlderThanDest) Or (FileTimeComparison = SourceEqualToDest))) Then Begin
           CloseHandle(s);
           Result:=0;
           Exit;
        End;

        // Wenn nicht alle bzw. alle neuen Dateien autom. berschrieben werden sollen, nachfragen,
        // was passieren soll.
        If (Not OverwriteAll) And (Not ((FileTimeComparison = SourceNewerThanDest) And AlwaysOverwriteOldFiles)) Then Begin

           If (TimeSrcForCmp_Valid And TimeDstForCmp_Valid) Then Begin
              FileTimeToSystemTime(TimeSrcForCmp, ST);
              TwoCharNumber(ST.wYear Mod 100, Year);
              TwoCharNumber(ST.wMonth, Month);
              TwoCharNumber(ST.wDay, Day);
              TwoCharNumber(ST.wHour, Hour);
              TwoCharNumber(ST.wMinute, Min);
              TimeSrcStr:=Day+'.'+Month+'.'+Year+' '+Hour+':'+Min;

              FileTimeToSystemTime(TimeDstForCmp, ST);
              TwoCharNumber(ST.wYear Mod 100, Year);
              TwoCharNumber(ST.wMonth, Month);
              TwoCharNumber(ST.wDay, Day);
              TwoCharNumber(ST.wHour, Hour);
              TwoCharNumber(ST.wMinute, Min);
              TimeDstStr:=Day+'.'+Month+'.'+Year+' '+Hour+':'+Min;

              Case FileTimeComparison Of
                   SourceNewerThanDest: FileTimeComparisonStr:=#13+#10+'Die zu kopierende Datei ist neuer als die existierende.';
                   SourceOlderThanDest: FileTimeComparisonStr:=#13+#10+'Die zu kopierende Datei ist lter als die existierende.';
                   SourceEqualToDest: FileTimeComparisonStr:=#13+#10+'Beide Dateien weisen das selbe nderungsdatum auf.';
                   Else FileTimeComparisonStr:='';
              End;

              MessageStr:=Source+' (gendert '+TimeSrcStr+')'+#13+#10
                          +'existiert schon im Zielverzeichnis.'+#13+#10
                          +'Soll die bestehende Datei (gendert '+TimeDstStr+') berschrieben werden?'+#13+#10
                          +FileTimeComparisonStr;

           End Else Begin
              MessageStr:=Source+#13+#10+'existiert schon im Zielverzeichnis. Soll die bestehende Datei berschrieben werden?';
           End;

           Res:=MessageDlg(MessageStr, mtConfirmation, [mbYes, mbNo, mbAll, mbCancel], 0);
           Case Res Of
                mrCancel: Begin
                   CloseHandle(s);
                   Result:=0;
                   Canceled:=True;
                   FrmCopyMoveStatus.Close;
                   Exit;
                End;
                mrAll: Begin
                   OverWriteAll:=True;
                End;
                mrNo: Begin
                   CloseHandle(s);
                   Result:=0;
                   Exit;
                End;
           End;


        End;

     End;

     // Ziel-Datei erstellen
     Repeat
           FileSetAttr(Dest,faArchive);
           d:=CreateFile(PChar(Dest), GENERIC_WRITE, FILE_SHARE_WRITE, Nil, CREATE_ALWAYS, FILE_FLAG_SEQUENTIAL_SCAN, 0);
           If d = INVALID_HANDLE_VALUE Then Begin
              Mes:=MessageDlg('Fehler beim Erstellen von '+Dest+'.'+#13+#10+GetLastErrorString,mtError,mbAbortRetryIgnore,0);
              Case Mes Of
                   mrAbort: Begin
                                 CloseHandle(s);
                                 IOResult;
                                 Result:=-1;
                                 Canceled:=True;
                                 Exit;
                            End;
                   mrIgnore:Begin
                                 CloseHandle(s);
                                 IOResult;
                                 Result:=0;
                                 Exit;
                            End;
              End;
           End;
     Until d <> INVALID_HANDLE_VALUE;

     // Daten kopieren
     If SourceSize > 0 Then Begin
        Repeat
              If Canceled Then Begin
                 CloseHandle(s);
                 CloseHandle(d);
                 IOResult;
                 Result:=0;
                 Exit;
              End;
              ReadFile(s, Buf, BufSize, BytesRead, Nil);
              WriteFile(d, Buf, BytesRead, BytesWritten, Nil);
              If (BytesRead <> BytesWritten) Then Begin
                 Mes:=MessageDlg('Fehler beim Kopieren von '+Source+'.'+#13+#10+GetLastErrorString,mtError,[mbIgnore,mbCancel],0);
                 Case Mes Of
                      mrCancel:Begin
                                    CloseHandle(s);
                                    CloseHandle(d);
                                    Canceled:=True;
                                    Result:=-1;
                                    Exit;
                               End;
                      mrIgnore:Begin
                                    CloseHandle(s);
                                    CloseHandle(d);
                                    Result:=0;
                                    Exit;
                               End;
                 End;
              End Else Begin
                 Inc(FileProgress,BytesWritten);
                 With FrmProgDragDrop Do Begin
                      If SourceSize <> 0 Then PrgFile.Position:=Round(FileProgress/SourceSize*100);
                 End;
                 Application.ProcessMessages;
              End;
        Until (BytesRead < BufSize);
     End;

     // Datum und Zeit setzen
     If TimeIsValid_Dest Then SetFileTime(d, @Time_Dest.CreationTime, @Time_Dest.LastAccessTime, @Time_Dest.LastWriteTime);

     // Dateien schlieen
     CloseHandle(s);
     CloseHandle(d);

     // Dateiattribute kopieren
     CopyAttr:=FileGetAttr(Source);
     If ClearReadOnly Then
        CopyAttr:=(CopyAttr And (Not faReadOnly));
     FileSetAttr(Dest,CopyAttr);

     // Alles hat geklappt! (Naja, es scheint jedenfalls so...)
     Result:=1;
End;

Procedure DragDropCopyMoveCallBack(Const Path: String; Const FindData: TWin32FindData; CallBackType: Integer);
Var
   RelativeDir, Dest: String;
   Len: Integer;
   Result: Integer;
   Attr: Integer;
Begin
     If Canceled Then Begin
        SDCopyMove.Canceled:=True;
        Exit;
     End;
     Len:=Length(SourceDir);
     RelativeDir:=Copy(Path, Len+1, Length(Path)-Len);
     If UseMappedFilenames Then Dest:=MappedDestDir Else Dest:=DestDir;
     Case CallBackType Of
          ctEnteringDir:
             Begin
                  MakeDir(Dest+RelativeDir, FindData.cFileName);
                  Attr:=FindData.dwFileAttributes;
                  If ClearReadOnly Then
                     Attr:=(Attr And (Not faReadOnly));
                  FileSetAttr(Dest+RelativeDir+FindData.cFileName, Attr);
             End;
          ctLeavingDir:
             Begin
                  If cmAction = cmMove Then RemDir(SourceDir+RelativeDir+FindData.cFileName);
             End;
          ctNormal:
             Begin
                  If cmAction = cmCopy Then Begin
                     DragDropCopyFile(SourceDir+RelativeDir+FindData.cFileName, Dest+RelativeDir+FindData.cFileName, FindData.nFileSizeLow);
                  End Else If cmAction = cmMove Then Begin
                     FrmProgDragDrop.LblSource.Caption:=SourceDir+RelativeDir+FindData.cFileName;
                     FrmProgDragDrop.LblDest.Caption:=Dest+RelativeDir+FindData.cFileName;
                     If Not RenameFile(SourceDir+RelativeDir+FindData.cFileName, Dest+RelativeDir+FindData.cFileName) Then Begin
                        Result:=DragDropCopyFile(SourceDir+RelativeDir+FindData.cFileName, Dest+RelativeDir+FindData.cFileName, FindData.nFileSizeLow);
                        If Result > 0 Then Begin
                           FileSetAttr(SourceDir+RelativeDir+FindData.cFileName, faArchive);
                           SysUtils.DeleteFile(SourceDir+RelativeDir+FindData.cFileName);
                        End;
                     End;
                     Application.ProcessMessages;
                  End;
             End;
     End;
End;

Function DragDropCopyMove;
Var
   i: Longint;
   Res: Longint;
   fRes: TWin32FindData;
   Handle: THandle;
   Dest: String;
Begin
     Result:=False;
     If FrmMain.Busy > 0 Then Exit;
     If FilenamesList.FileNum < 1 Then Exit;

     Case Action Of
          cmCopy:
             Begin
                  If Options.ConfirmDDCreateLinks Then Begin
                     If FilenamesList.FileNum = 1 Then Begin
                        If MessageDlg('Soll '+ExtractFilename(FilenamesList.Files[0])+' nach '+
                                      Target+' kopiert werden?',
                                      mtConfirmation, [mbYes, mbNo], 0) <> mrYes Then
                        Begin
                             Result:=False;
                             Exit;
                        End;
                     End Else Begin
                        If MessageDlg('Sollen die '+Stri(FilenamesList.FileNum)+' Objekte nach '+
                                      Target+' kopiert werden?',
                                      mtConfirmation, [mbYes, mbNo], 0) <> mrYes Then
                        Begin
                             Result:=False;
                             Exit;
                        End;
                     End;
                  End;
             End;
          cmMove:
             Begin
                  If Options.ConfirmDDCreateLinks Then Begin
                     If FilenamesList.FileNum = 1 Then Begin
                        If MessageDlg('Soll '+ExtractFilename(FilenamesList.Files[0])+' nach '+
                                      Target+' verschoben werden?',
                                      mtConfirmation, [mbYes, mbNo], 0) <> mrYes Then
                        Begin
                             Result:=False;
                             Exit;
                        End;
                     End Else Begin
                        If MessageDlg('Sollen die '+Stri(FilenamesList.FileNum)+' Objekte nach '+
                                      Target+' verschoben werden?',
                                      mtConfirmation, [mbYes, mbNo], 0) <> mrYes Then
                        Begin
                             Result:=False;
                             Exit;
                        End;
                     End;
                  End;
             End;
          Else Exit;
     End;

     cmAction:=Action;
     SourceDir:='';
     MappedDestDir:='';
     DestDir:=Target;
     If DestDir[Length(DestDir)] <> '\' Then DestDir:=DestDir+'\';

     // berprfen, ob der Kopiervorgang berhaupt mglich ist
     If AnsiCompareText(DestDir,SourceDir) = 0 Then Begin
        MessageDlg('Dateien oder Verzeichnisse knnen nicht auf sich selbst kopiert werden.',mtError,[mbOK],0);
        Exit;
     End;
     If FilenamesList.FileNum > 0 Then With FilenamesList Do Begin
        For i:=0 To FileNum-1 Do Begin
            If AnsiCompareText(Files[i],DestDir+ExtractFileName(Files[i])) = 0 Then Begin
               MessageDlg('Dateien oder Verzeichnisse knnen nicht auf sich selbst kopiert werden.',mtError,[mbOK],0);
               Exit;
            End;
        End;
     End;
     If FilenamesList.FileNum > 0 Then With FilenamesList Do Begin
        For i:=0 To FileNum-1 Do Begin
            If Pos(AnsiUpperCase(Files[i]+'\'),AnsiUpperCase(DestDir)) > 0 Then Begin
               MessageDlg('Ein bergeordnetes Verzeichnis kann nicht in eines seiner untergeordneten Verzeichnisse kopiert werden. Das wrde eine Endlos-Schleife verursachen.',mtError,[mbOK],0);
               Exit;
            End;
        End;
     End;

     // Kopieren vorbereiten (Variablen, Objekte initialisieren usw.)
     If (Not PathExists(DestDir, True)) Then Exit;
     OverwriteAll:=Not Options.ConfirmOverwrite;
     With FrmProgDragDrop Do Begin
          Case cmAction Of
               cmCopy: LblCopyMove.Caption:='Kopiere:';
               cmMove: LblCopyMove.Caption:='Verschiebe:';
          End;
          LblSource.Caption:='';
          LblDest.Caption:='';
          PrgFile.Position:=0;
     End;
     Canceled:=False;
     Progress:=0;
     ClearReadOnly:=False;
     FrmProgDragDrop.Show;
     With SDCopyMove Do Begin
          Init;
          CallBack:=DragDropCopyMoveCallBack;
          ProcessMessages:=True;
          Canceled:=False;
          CallBacks:=cbBeforeRecurse+cbAfterRecurse;
     End;

     // Windows kann ein Verzeichnis nicht lschen, wenn es das aktive Verz. ist
     ChDir(Copy(Data[LeftList].Directory, 1, 2)+'\');

     // Dateien kopieren/verschieben
     FrmMain.BeginBusy;
     Try
        Case cmAction Of
           cmCopy:
              Begin
                 SDCopyMove.CallBacks:=cbBeforeRecurse;
                 For i:=0 To FilenamesList.FileNum-1 Do If (Not Canceled) Then Begin

                     Handle:=FindFirstFile(PChar(FilenamesList.Files[i]), fRes);
                     If Handle <> INVALID_HANDLE_VALUE Then Begin

                        If (fRes.dwFileAttributes And FILE_ATTRIBUTE_DIRECTORY) = 0 Then Begin
                           If UseMappedFilenames Then
                              DragDropCopyFile(FilenamesList.Files[i], DestDir+ExtractFilename(MappedFilenamesList.Files[i]), fRes.nFileSizeLow)
                           Else
                              DragDropCopyFile(FilenamesList.Files[i], DestDir+ExtractFilename(FilenamesList.Files[i]), fRes.nFileSizeLow);
                        End Else Begin
                           If UseMappedFilenames Then Begin
                              MakeDir(DestDir, ExtractFilename(MappedFilenamesList.Files[i]));
                              FileSetAttr(DestDir+ExtractFilename(MappedFilenamesList.Files[i]), fRes.dwFileAttributes);
                              MappedDestDir:=DestDir+ExtractFilename(MappedFilenamesList.Files[i]);
                              If MappedDestDir[Length(MappedDestDir)] <> '\' Then MappedDestDir:=MappedDestDir+'\';
                              SourceDir:=FilenamesList.Files[i]+'\';
                           End Else Begin
                              MakeDir(DestDir, ExtractFilename(FilenamesList.Files[i]));
                              FileSetAttr(DestDir+ExtractFilename(FilenamesList.Files[i]), fRes.dwFileAttributes);
                              SourceDir:=ExtractFilePath(FilenamesList.Files[i]);
                           End;
                           SDCopyMove.Search(FilenamesList.Files[i]+'\', FilterAllFiles, True, True);
                        End;
                        Windows.FindClose(Handle);

                     End;
                     Application.ProcessMessages;

                 End;
              End;
           cmMove:
              Begin
                 SDCopyMove.CallBacks:=cbBeforeRecurse+cbAfterRecurse;
                 For i:=0 To FilenamesList.FileNum-1 Do If (Not Canceled) Then Begin

                     Handle:=FindFirstFile(PChar(FilenamesList.Files[i]), fRes);
                     If Handle <> INVALID_HANDLE_VALUE Then Begin

                        If UseMappedFilenames Then
                           Dest:=DestDir+ExtractFilename(MappedFilenamesList.Files[i])
                        Else
                           Dest:=DestDir+ExtractFilename(FilenamesList.Files[i]);
                        If (fRes.dwFileAttributes And FILE_ATTRIBUTE_DIRECTORY) = 0 Then Begin
                           FrmProgDragDrop.LblSource.Caption:=FilenamesList.Files[i];
                           FrmProgDragDrop.LblDest.Caption:=Dest;
                           If Not RenameFile(FilenamesList.Files[i], Dest) Then Begin
                              Res:=DragDropCopyFile(FilenamesList.Files[i], Dest, fRes.nFileSizeLow);
                              If Res > 0 Then Begin
                                 FileSetAttr(FilenamesList.Files[i], faArchive);
                                 SysUtils.DeleteFile(FilenamesList.Files[i]);
                              End;
                           End;
                        End Else Begin
                           If Not RenameFile(FilenamesList.Files[i], Dest) Then Begin
                              If UseMappedFilenames Then Begin
                                 MakeDir(DestDir, ExtractFilename(MappedFilenamesList.Files[i]));
                                 FileSetAttr(DestDir+ExtractFilename(MappedFilenamesList.Files[i]), fRes.dwFileAttributes);
                                 MappedDestDir:=DestDir+ExtractFilename(MappedFilenamesList.Files[i]);
                                 If MappedDestDir[Length(MappedDestDir)] <> '\' Then MappedDestDir:=MappedDestDir+'\';
                                 SourceDir:=FilenamesList.Files[i]+'\';
                              End Else Begin
                                 MakeDir(DestDir, ExtractFilename(FilenamesList.Files[i]));
                                 FileSetAttr(DestDir+ExtractFilename(FilenamesList.Files[i]), fRes.dwFileAttributes);
                                 SourceDir:=ExtractFilePath(FilenamesList.Files[i]);
                              End;
                              SDCopyMove.Search(FilenamesList.Files[i]+'\', FilterAllFiles, True, True);
                              If (Not Canceled) Then Begin
                                 FileSetAttr(FilenamesList.Files[i], faDirectory);
                                 RemDir(FilenamesList.Files[i]);
                              End;
                           End;
                        End;
                        Windows.FindClose(Handle);

                     End;
                     Application.ProcessMessages;

                 End;
              End;
           End;
     Finally
        FrmProgDragDrop.Close;
        FrmMain.EndBusy;
        FrmMain.UpdateLists;
     End;
     Result:=False;
End;

Function DragDropCreateLinks;
Var
   i: Integer;
Begin
     If Options.ConfirmDDCreateLinks Then Begin
        If FilenamesList.FileNum = 1 Then Begin
           If MessageDlg('Soll eine Verknpfung mit '+ExtractFileName(FilenamesList.Files[0])+' in '+
                         Target+' erstellt werden?',
                         mtConfirmation, [mbYes, mbNo], 0) <> mrYes Then
           Begin
                Result:=False;
                Exit;
           End;
        End Else Begin
           If MessageDlg('Sollen die '+Stri(FilenamesList.FileNum)+' Verknpfungen in '+
                         Target+' erstellt werden?',
                         mtConfirmation, [mbYes, mbNo], 0) <> mrYes Then
           Begin
                Result:=False;
                Exit;
           End;
        End;
     End;
     For i:=0 To FilenamesList.FileNum - 1 Do Begin
         CreateLink(Target+DefaultLinkText+ExtractFilename(FilenamesList.Files[i])+'.LNK',
                    FilenamesList.Files[i],
                    ExtractFilePath(FilenamesList.Files[i]));
     End;
     FrmMain.UpdateLists;
     Result:=True;
End;

procedure TFrmMain.PopMoveHereClick(Sender: TObject);
begin
     DragDropCopyMove(DropTargetDir, cmMove)
end;

procedure TFrmMain.PopCopyHereClick(Sender: TObject);
begin
     DragDropCopyMove(DropTargetDir, cmCopy)
end;

procedure TFrmMain.PopCreateLinksHereClick(Sender: TObject);
begin
     DragDropCreateLinks(DropTargetDir);
end;

// *****************************************************************************************
// *****************************************************************************************
// Ende der Drag & Drop - Prozeduren
// *****************************************************************************************
// *****************************************************************************************

Procedure DiskCopyCommonDialog;
Begin
     ShellExecute(FrmMain.Handle, Nil, PChar('rundll32.exe'), PChar('diskcopy.dll,DiskCopyRunDll 1,1'), Nil, SW_NORMAL);
End;

procedure TFrmMain.MediaDiskCopyClick(Sender: TObject);
begin
     DiskCopyCommonDialog;
end;

procedure TFrmMain.FileEditNewFileClick(Sender: TObject);
begin
     ViewTextFile('');
end;

procedure TFrmMain.PopOpenClick(Sender: TObject);
begin
     If Lists[CurrentList].ItemFocused <> Nil Then Begin
        DontDrag:=True;
        DoSomething(CurrentList, Lists[CurrentList].ItemFocused);
        DontDrag:=False;
     End;
end;

procedure TFrmMain.PopQuickViewClick(Sender: TObject);
begin
     If (Not FrmQuickview.Visible) Then OptionsQuickViewClick(Nil);
     QuickView(Lists[CurrentList].ItemFocused, CurrentList);
end;

procedure TFrmMain.FileQuickViewClick(Sender: TObject);
begin
     PopQuickViewClick(Nil);
end;

Procedure TFrmMain.FileDivideJoinClick(Sender: TObject);
Var
   SelCount: Integer;
   i, Count: Integer;
   BaseName: String;
   Ptr: Pointer;
   ni: TListItem;
Begin
     SelCount:=ListView_GetSelectedCount(Lists[CurrentList].Handle);
     If SelCount <= 1 Then Begin

        If Lists[CurrentList].ItemFocused = Nil Then Exit;

        If (Dat(Lists[CurrentList].ItemFocused.Data^).fAttr And faDirectory) = faDirectory Then Begin
           MessageDlg('Diese Operation ist nicht auf Verzeichnisse anwendbar.', mtError, [mbOk], 0);
           Exit;
        End;

        With FrmDivideFile Do Begin

             FileToDivide:=GetFullName(Lists[CurrentList].ItemFocused.Data, CurrentList);
             LblFilename.Caption:=GetName(Lists[CurrentList].ItemFocused.Data, CurrentList);
             EdtTargetDir.Text:=GetPath(Lists[CurrentList].ItemFocused.Data, CurrentList);

             BaseName:=LblFilename.Caption;
             If Pos('.', BaseName) > 0 Then Begin
                For i:=Length(BaseName) DownTo 1 Do Begin
                    If BaseName[i] = '.' Then Begin
                       BaseName:=Copy(BaseName, 1, i - 1);
                       Break;
                    End;
                End;
             End;
             EdtBaseName.Text:=BaseName;

             If SpnSizeOfFilePart.Value > Dat(Lists[CurrentList].ItemFocused.Data^).fSize Then
                SpnSizeOfFilePart.Value:=Dat(Lists[CurrentList].ItemFocused.Data^).fSize;

             ShowModal;
        End;

     End Else If SelCount > 1 Then With FrmConcatFile Do Begin

         LstFileParts.Items.Clear;

         Count:=Lists[CurrentList].Items.Count-1;
         For i:=0 To Count Do If Lists[CurrentList].Items[i].Selected Then Begin

             Ptr:=Lists[CurrentList].Items[i].Data;

             If (Dat(Ptr^).fAttr And faDirectory) = faDirectory Then Begin
                MessageDlg('Verzeichnisse knnen nicht zusammengefgt werden!', mtError, [mbOk], 0);
                Exit;
             End;

             ni:=LstFileParts.Items.Add;
             ni.Caption:=GetFullName(Ptr, CurrentList);

         End;

         If LstFileParts.Items.Count > 0 Then Begin
            BaseName:=ExtractFileName(LstFileParts.Items[0].Caption);
            If Pos('.', BaseName) > 0 Then Begin
               For i:=Length(BaseName) DownTo 1 Do Begin
                   If BaseName[i] = '.' Then Begin
                      BaseName:=Copy(BaseName, 1, i - 1);
                      Break;
                   End;
               End;
            End;
            EdtOriginalFile.Text:=BaseName;
         End;

         EdtTargetDir.Text:=Data[Integer(Not Boolean(CurrentList))].Directory+'\';

         ShowModal;

     End;
End;

procedure TFrmMain.LblDirectoryLeftClick(Sender: TObject);
begin
     SetListFocus(LeftList);
end;

procedure TFrmMain.LblDirectoryRightClick(Sender: TObject);
begin
     SetListFocus(RightList);
end;

procedure TFrmMain.OptionsDirectoryBarClick(Sender: TObject);
begin
     PnlDirectoryBar.Visible:=Not PnlDirectoryBar.Visible;
     CorrectBars;
end;

procedure TFrmMain.SpdUpdateBothListsClick(Sender: TObject);
Var
   i: Integer;
begin
     For i:=0 To 1 Do Begin
         UpDateDir(i);
         DriveLists[i].UpdateDriveList;
     End;
end;

procedure TFrmMain.LstFilesColumnClick(Sender: TObject;
  Column: TListColumn);
Var
   OldSortType: Integer;
begin
     OldSortType:=Data[LeftList].SortType;
     Case Data[LeftList].DataType Of
          dtFileList:
             Begin
                  Case Column.Index Of
                       ColumnName: Data[LeftList].SortType:=SortName;
                       ColumnSize: Data[LeftList].SortType:=SortSize;
                       ColumnAttr: Exit;
                       ColumnDate: Data[LeftList].SortType:=SortDate;
                  End;
             End;
          dtFindResult:
             Begin
                  Case Column.Index Of
                       ColumnName2: Data[LeftList].SortType:=SortName;
                       ColumnPath: Data[LeftList].SortType:=SortPath;
                  End;
             End;
     End;
     If Data[LeftList].SortType = OldSortType Then Begin
        If Data[LeftList].SortDir = SortDirUp Then
           Data[LeftList].SortDir:=SortDirDown
        Else
           Data[LeftList].SortDir:=SortDirUp;
     End;
     Lists[LeftList].AlphaSort;
     UpdateColumnHeaderImagesSide(LeftList);
end;

procedure TFrmMain.LstFiles2ColumnClick(Sender: TObject;
  Column: TListColumn);
Var
   OldSortType: Integer;
begin
     OldSortType:=Data[RightList].SortType;
     Case Data[RightList].DataType Of
          dtFileList:
             Begin
                  Case Column.Index Of
                       ColumnName: Data[RightList].SortType:=SortName;
                       ColumnSize: Data[RightList].SortType:=SortSize;
                       ColumnAttr: Exit;
                       ColumnDate: Data[RightList].SortType:=SortDate;
                  End;
             End;
          dtFindResult:
             Begin
                  Case Column.Index Of
                       ColumnName2: Data[RightList].SortType:=SortName;
                       ColumnPath: Data[RightList].SortType:=SortPath;
                  End;
             End;
     End;
     If Data[RightList].SortType = OldSortType Then Begin
        If Data[RightList].SortDir = SortDirUp Then
           Data[RightList].SortDir:=SortDirDown
        Else
           Data[RightList].SortDir:=SortDirUp;
     End;
     Lists[RightList].AlphaSort;
     UpdateColumnHeaderImagesSide(RightList);
End;

Procedure TFrmMain.UpdateColumnHeaderImagesSide;
Var
   hdItem: ThdItem;
   i: Integer;
Begin
     If Data[Side].SortDir = SortDirUp Then
        hdItem.hbm:=ImgSortDirUp.Picture.Bitmap.Handle
     Else
        hdItem.hbm:=ImgSortDirDown.Picture.Bitmap.Handle;

     For i:=0 To Lists[Side].Columns.Count-1 Do Begin
         hdItem.Mask:=HDI_FORMAT;
         Header_GetItem(GetDlgItem(Lists[Side].Handle, 0), i, hdItem);

         hdItem.fmt:=hdItem.fmt And Not HDF_BITMAP;
         If Data[Side].DataType = dtFileList Then Begin
            Case i Of
                 ColumnName: If Data[Side].SortType = SortName Then hdItem.fmt:=hdItem.fmt Or HDF_BITMAP;
                 ColumnSize: If Data[Side].SortType = SortSize Then hdItem.fmt:=hdItem.fmt Or HDF_BITMAP;
                 ColumnDate: If Data[Side].SortType = SortDate Then hdItem.fmt:=hdItem.fmt Or HDF_BITMAP;
            End;
         End Else If Data[Side].DataType = dtFindResult Then Begin
            Case i Of
                 ColumnName2: If Data[Side].SortType = SortName Then hdItem.fmt:=hdItem.fmt Or HDF_BITMAP;
                 ColumnPath: If Data[Side].SortType = SortPath Then hdItem.fmt:=hdItem.fmt Or HDF_BITMAP;
            End;
         End;

         hdItem.Mask:=HDI_BITMAP Or HDI_FORMAT;
         Header_SetItem(GetDlgItem(Lists[Side].Handle, 0), i, hdItem);
     End;
End;

Procedure TFrmMain.UpdateColumnHeaderImages;
Begin
     UpdateColumnHeaderImagesSide(LeftList);
     UpdateColumnHeaderImagesSide(RightList);
End;

procedure TFrmMain.OptionsSetColumnWidthAsStandardClick(Sender: TObject);
begin
     ReadDefaultColumnsWidth;
end;

{ *****************************************************************************************
  *****************************************************************************************
  TFetchSysIcons
  *****************************************************************************************
  ***************************************************************************************** }

Constructor TFetchSysIcons.Create;
Begin
     Inherited Create(False);
     FreeOnTerminate:=True;
     FrmMain.ThreadTerminated[Side]:=False;
     ListNum:=Side;
     Priority:=tpLowest;
End;

Procedure TFetchSysIcons.Execute;
Var
   i, Count: Integer;
Begin
     If Terminated Then Exit;
     i:=0;
     Count:=FrmMain.Lists[ListNum].Items.Count;
     If Count <= 0 Then Exit;
     While ((Not Terminated) And (i < Count)) Do Begin

           FrmMain.GetSysIcon(FrmMain.Lists[ListNum].Items[i].Data, ListNum);
           Inc(i);

     End;
End;

Procedure TFetchSysIcons.Terminate;
Begin
     Inherited Terminate;
End;

Destructor TFetchSysIcons.Destroy;
Begin
     Inherited Destroy;
     FrmMain.ThreadTerminated[ListNum]:=True;
End;

{ *****************************************************************************************
  *****************************************************************************************
  Prozeduren zur Verwaltung der Verlaufslisten
  *****************************************************************************************
  ***************************************************************************************** }

Procedure TFrmMain.AddRecentDirEntry;
Var
   i: Integer;
Begin
     With RecentDirLists[Side] Do Begin
          If EntryNum <= 0 Then Begin
             EntryNum:=1;
             ActEntry:=0;
             Entries[ActEntry]:=Dir;
          End Else If AnsiCompareText(Entries[ActEntry], Dir) <> 0 Then Begin
             If ActEntry < (EntryNum-1) Then Begin
                For i:=ActEntry+1 To MaxRecentDirListEntries Do
                    Entries[i]:='';
                EntryNum:=ActEntry+1;
             End Else If EntryNum > MaxRecentDirListEntries Then Begin
                For i:=0 To MaxRecentDirListEntries-1 Do
                    Entries[i]:=Entries[i+1];
                Entries[MaxRecentDirListEntries]:='';
                ActEntry:=MaxRecentDirListEntries-1;
                EntryNum:=MaxRecentDirListEntries;
             End;
             Inc(EntryNum);
             Inc(ActEntry);
             Entries[ActEntry]:=Dir;
          End;
          UpdateRecentDirButtons(Side);
     End;
End;

Procedure TFrmMain.GoToRecentDirEntry;
Var
   Path: String;
Begin
     If (Index >= 0) And (Index <= MaxRecentDirListEntries) Then Begin
        Path:=RecentDirLists[Side].Entries[Index];
        {$I-}
        ChDir(Path+'\');
        If IOResult <> 0 Then Begin
           RemoveRecentDirEntry(Index, Side);
           Exit;
        End;
        RecentDirLists[Side].ActEntry:=Index;
        UpdateRecentDirButtons(Side);
        Data[Side].Directory:=Path;
        Data[Side].QueryDataType:=dtFileList;
        DriveLists[Side].Drive:=Path[1];
        UpdateDir(Side);
     End;
End;

Procedure TFrmMain.GotoLastRecentDirEntry;
Begin
     With RecentDirLists[Side] Do Begin
          If ActEntry > 0 Then GotoRecentDirEntry(ActEntry-1, Side);
     End;
End;

Procedure TFrmMain.GotoNextRecentDirEntry;
Begin
     With RecentDirLists[Side] Do Begin
          If ActEntry < MaxRecentDirListEntries Then GotoRecentDirEntry(ActEntry+1, Side);
     End;
End;

Procedure TFrmMain.ClearRecentDirList;
Var
   i: Integer;
Begin
     With RecentDirLists[Side] Do Begin
          For i:=0 To MaxRecentDirListEntries Do
              Entries[i]:='';
          EntryNum:=0;
          ActEntry:=-1;
     End;
     UpdateRecentDirButtons(Side);
End;

Procedure TFrmMain.RemoveRecentDirEntry;
Var
   i: Integer;
Begin
     With RecentDirLists[Side] Do Begin
          If (Index >= 0) And (Index < EntryNum) And (ActEntry <> Index) Then Begin
             If Index = EntryNum-1 Then Begin
                Entries[Index]:='';
             End Else Begin
                For i:=Index To EntryNum-2 Do
                    Entries[i]:=Entries[i+1];
                Entries[EntryNum-1]:='';
                If Index < ActEntry Then Dec(ActEntry);
             End;
             Dec(EntryNum);
             If ActEntry > Index Then Dec(ActEntry);
             If ActEntry >= EntryNum Then ActEntry:=EntryNum-1;
             If ActEntry < 0 Then ClearRecentDirList(Side);
          End;
     End;
     UpdateRecentDirButtons(Side);
End;

Procedure TFrmMain.UpdateRecentDirButtons;
Begin
     Case Side Of
          LeftList:
             Begin
                  If (RecentDirLists[LeftList].EntryNum <= 1) Or (Data[LeftList].DataType <> dtFileList) Then Begin
                     SpdDirBackLeft.Enabled:=False;
                     SpdDirListLeft.Enabled:=False;
                     SpdDirForwardLeft.Enabled:=False;
                  End Else Begin
                     SpdDirListLeft.Enabled:=True;
                     If RecentDirLists[LeftList].ActEntry > 0 Then
                        SpdDirBackLeft.Enabled:=True
                     Else
                        SpdDirBackLeft.Enabled:=False;
                     If RecentDirLists[LeftList].ActEntry < RecentDirLists[LeftList].EntryNum-1 Then
                        SpdDirForwardLeft.Enabled:=True
                     Else
                        SpdDirForwardLeft.Enabled:=False;
                  End;
             End;
          RightList:
             Begin
                  If (RecentDirLists[RightList].EntryNum <= 1) Or (Data[RightList].DataType <> dtFileList) Then Begin
                     SpdDirBackRight.Enabled:=False;
                     SpdDirListRight.Enabled:=False;
                     SpdDirForwardRight.Enabled:=False;
                  End Else Begin
                     SpdDirListRight.Enabled:=True;
                     If RecentDirLists[RightList].ActEntry > 0 Then
                        SpdDirBackRight.Enabled:=True
                     Else
                        SpdDirBackRight.Enabled:=False;
                     If RecentDirLists[RightList].ActEntry < RecentDirLists[RightList].EntryNum-1 Then
                        SpdDirForwardRight.Enabled:=True
                     Else
                        SpdDirForwardRight.Enabled:=False;
                  End;
             End;
     End;
End;

Procedure TFrmMain.ChangeToRecentDir;
Var
   Side: Integer;
Begin
     With (Sender As TMenuItem) Do Begin
          If (Tag And LEFTLIST_MASK) = LEFTLIST_MASK Then Side:=LeftList
          Else If (Tag And RIGHTLIST_MASK) = RIGHTLIST_MASK Then Side:=RightList
          Else Side:=CurrentList;
          GoToRecentDirEntry((Tag And (Not GETTAG_MASK)), Side);
     End;
End;

Procedure TFrmMain.AddRecentDirListToPopupMenu;
Var
   nmi: TMenuItem;
   i: Integer;
   Dummy: TMenuItem;
Begin
     If AutoClear Then Begin
        While Menu.Items.Count > 0 Do Begin
              Dummy:=Menu.Items[0];
              Menu.Items.Delete(0);
              Dummy.Free;
        End;
     End;
     For i:=RecentDirLists[Side].EntryNum-1 DownTo 0 Do Begin
         nmi:=TMenuItem.Create(Self);
         nmi.Caption:=RecentDirLists[Side].Entries[i]+'\';
         nmi.Hint:='Wechselt in das angegebene Verzeichnis.';
         nmi.OnClick:=ChangeToRecentDir;
         nmi.ImageIndex:=DirectoryImageIndex;
         nmi.Tag:=i;
         If Side = LeftList Then
            nmi.Tag:=nmi.Tag Or Longint(LEFTLIST_MASK)
         Else
            nmi.Tag:=nmi.Tag Or Longint(RIGHTLIST_MASK);
         If i = RecentDirLists[Side].ActEntry Then
            nmi.Default:=True;
         Menu.Items.Add(nmi);
     End;
End;

Procedure TFrmMain.AddRecentDirListToMenuItem;
Var
   nmi: TMenuItem;
   i: Integer;
   Dummy: TMenuItem;
Begin
     If AutoClear Then Begin
        While Menu.Count > 0 Do Begin
              Dummy:=Menu.Items[0];
              Menu.Delete(0);
              Dummy.Free;
        End;
     End;
     For i:=RecentDirLists[Side].EntryNum-1 DownTo 0 Do Begin
         nmi:=TMenuItem.Create(Self);
         nmi.Caption:=RecentDirLists[Side].Entries[i]+'\';
         nmi.Hint:='Wechselt in das angegebene Verzeichnis.';
         nmi.OnClick:=ChangeToRecentDir;
         nmi.ImageIndex:=DirectoryImageIndex;
         nmi.Tag:=i;
         If Side = LeftList Then
            nmi.Tag:=nmi.Tag Or Longint(LEFTLIST_MASK)
         Else
            nmi.Tag:=nmi.Tag Or Longint(RIGHTLIST_MASK);
         If i = RecentDirLists[Side].ActEntry Then
            nmi.Default:=True;
         Menu.Add(nmi);
     End;
End;

procedure TFrmMain.SpdDirBackLeftClick(Sender: TObject);
begin
     GotoLastRecentDirEntry(LeftList);
end;

procedure TFrmMain.SpdDirForwardLeftClick(Sender: TObject);
begin
     GoToNextRecentDirEntry(LeftList);
end;

procedure TFrmMain.SpdDirBackRightClick(Sender: TObject);
begin
     GotoLastRecentDirEntry(RightList);
end;

procedure TFrmMain.SpdDirForwardRightClick(Sender: TObject);
begin
     GoToNextRecentDirEntry(RightList);
end;

procedure TFrmMain.SpdDirListLeftClick(Sender: TObject);
Var
   p: TPoint;
begin
     AddRecentDirListToPopupMenu(PopRecentDirList, True, LeftList);
     p:=PnlDriveBar.ClientToScreen(Point(SpdDirListLeft.Left, SpdDirListLeft.Top+SpdDirListLeft.Height));
     PopRecentDirList.PopUp(p.x, p.y);
end;

procedure TFrmMain.SpdDirListRightClick(Sender: TObject);
Var
   p: TPoint;
begin
     AddRecentDirListToPopupMenu(PopRecentDirList, True, RightList);
     p:=PnlDriveBar.ClientToScreen(Point(SpdDirListRight.Left, SpdDirListRight.Top+SpdDirListRight.Height));
     PopRecentDirList.PopUp(p.x, p.y);
end;

procedure TFrmMain.PathDirBackClick(Sender: TObject);
begin
     GoToLastRecentDirEntry(CurrentList);
end;

procedure TFrmMain.PathDirForwardClick(Sender: TObject);
begin
     GoToNextRecentDirEntry(CurrentList);
end;

procedure TFrmMain.MnuSelectionClick(Sender: TObject);
begin
     If (Data[LeftList].DataType <> dtFileList) Or (Data[RightList].DataType <> dtFileList) Then
        SelectionCompareDirectories.Enabled:=False
     Else
        SelectionCompareDirectories.Enabled:=True;
end;

procedure TFrmMain.PopChangeToThisDirectoryClick(Sender: TObject);
begin
     If Lists[CurrentList].ItemFocused <> Nil Then Begin
        Data[CurrentList].QueryDataType:=dtFileList;
        Data[CurrentList].Directory:=GetFullName(Lists[CurrentList].ItemFocused.Data, CurrentList);
        ClearRecentDirList(CurrentList);
        UpdateDir(CurrentList);
     End;
end;

procedure TFrmMain.MediaConncectNetworkDriveClick(Sender: TObject);
begin
     WNetConnectionDialog(Self.Handle, RESOURCETYPE_DISK);
end;

procedure TFrmMain.MediaDisconnectNetworkDriveClick(Sender: TObject);
begin
     WNetDisconnectDialog(Self.Handle, RESOURCETYPE_DISK);
end;

procedure TFrmMain.ExecuteWithParam;
Var
   ProgFile: String;
begin
     If Lists[Side].ItemFocused = Nil Then Exit;
     ProgFile:=GetFullName(Lists[Side].ItemFocused.Data, Side);
     FrmExecuteWithParam.LblProgramFile.Caption:=ExtractFilename(ProgFile);
     If FrmExecuteWithParam.ShowModal = mrOk Then Begin
        ExecuteFile(ProgFile, FrmExecuteWithParam.EdtParam.Text, '', SW_SHOW);
     End;
end;

procedure TFrmMain.FileExecuteWithParamClick(Sender: TObject);
begin
     ExecuteWithParam(CurrentList);
end;

procedure TFrmMain.PopExecuteWithParamClick(Sender: TObject);
begin
     ExecuteWithParam(CurrentList);
end;

procedure TFrmMain.LstFilesEditing(Sender: TObject; Item: TListItem;
  var AllowEdit: Boolean);
begin
     If Dat(Item.Data^).UpDir Then
        AllowEdit:=False
     Else If Not Options.ClickToRename Then
        If Not ForceLabelEditing Then AllowEdit:=False;
end;

procedure TFrmMain.LstFiles2Editing(Sender: TObject; Item: TListItem;
  var AllowEdit: Boolean);
begin
     If Dat(Item.Data^).UpDir Then
        AllowEdit:=False
     Else If Not Options.ClickToRename Then
        If Not ForceLabelEditing Then AllowEdit:=False;
end;

procedure TFrmMain.LstFilesSelectItem(Sender: TObject; Item: TListItem;
  Selected: Boolean);
begin
     If Selected Then
        If Dat(Item.Data^).UpDir Then Item.Selected:=False;
end;

procedure TFrmMain.LstFiles2SelectItem(Sender: TObject; Item: TListItem;
  Selected: Boolean);
begin
     If Selected Then
        If Dat(Item.Data^).UpDir Then Item.Selected:=False;
end;

procedure TFrmMain.OptionsCommandLineBarClick(Sender: TObject);
begin
     PnlCommandLineBar.Visible:=Not PnlCommandLineBar.Visible;
     CorrectBars;
end;

Procedure TFrmMain.UpdateCommandLineBar;
Begin
     LblCommandLine.Caption:=Data[CurrentList].Directory+'> ';
     ResizeCommandLineBar;
End;

Procedure TFrmMain.ResizeCommandLineBar;
Begin
     LblCommandLine.Left:=0;
     LblCommandLine.Top:=(PnlCommandLineBar.ClientHeight - LblCommandLine.Height) Div 2;
     CboCommandLine.Left:=LblCommandLine.Width;
     CboCommandLine.Width:=PnlCommandLineBar.ClientWidth - CboCommandLine.Left;
End;

procedure TFrmMain.PnlCommandLineBarResize(Sender: TObject);
begin
     ResizeCommandLineBar;
end;

procedure TFrmMain.PopCmdCutClick(Sender: TObject);
begin
     SendMessage(CboCommandLine.Handle, WM_CUT, 0, 0);
end;

procedure TFrmMain.PopCmdCopyClick(Sender: TObject);
begin
     SendMessage(CboCommandLine.Handle, WM_COPY, 0, 0);
end;

procedure TFrmMain.PopCmdPasteClick(Sender: TObject);
begin
     SendMessage(CboCommandLine.Handle, WM_PASTE, 0, 0);
end;

procedure TFrmMain.PopCmdDeleteClick(Sender: TObject);
begin
     SendMessage(CboCommandLine.Handle, WM_CLEAR, 0, 0);
end;

procedure TFrmMain.PopCommandLinePopup(Sender: TObject);
begin
     If CboCommandLine.SelText <> '' Then Begin
        PopCmdCut.Enabled:=True;
        PopCmdCopy.Enabled:=True;
        PopCmdDelete.Enabled:=True;
     End Else Begin
        PopCmdCut.Enabled:=False;
        PopCmdCopy.Enabled:=False;
        PopCmdDelete.Enabled:=False;
     End;
     If Lists[CurrentList].ItemFocused <> Nil Then Begin
        PopCmdInsertFilename.Enabled:=True;
        PopCmdInsertPathAndFilename.Enabled:=True;
     End Else Begin
        PopCmdInsertFilename.Enabled:=False;
        PopCmdInsertPathAndFilename.Enabled:=False;
     End;
     PopCmdCloseWindowAfterExecution.Checked:=Options.CloseDOSWindowAfterExecution;
end;

procedure TFrmMain.PopCmdInsertPathClick(Sender: TObject);
begin
     CboCommandLine.SelText:=Data[CurrentList].Directory+'\';
end;

procedure TFrmMain.PopCmdInsertFilenameClick(Sender: TObject);
begin
     If Lists[CurrentList].ItemFocused <> Nil Then Begin
        CboCommandLine.SelText:=GetName(Lists[CurrentList].ItemFocused.Data, CurrentList);
     End;
end;

procedure TFrmMain.PopCmdInsertPathAndFilenameClick(Sender: TObject);
begin
     If Lists[CurrentList].ItemFocused <> Nil Then Begin
        CboCommandLine.SelText:=GetFullName(Lists[CurrentList].ItemFocused.Data, CurrentList);
     End;
end;

procedure TFrmMain.PopCmdCloseWindowAfterExecutionClick(Sender: TObject);
begin
     Options.CloseDOSWindowAfterExecution:=Not Options.CloseDOSWindowAfterExecution;
end;

Procedure TFrmMain.ExecuteCommandLine;
Begin
     // Befehl der History-Liste hinzufgen
     CboCommandLine.Items.Insert(0, CboCommandLine.Text);

     // Und ausfhren
     If Options.CloseDOSWindowAfterExecution Then Begin
        ExecuteFile('command.com', '/c '+CboCommandLine.Text, Data[CurrentList].Directory+'\', SW_SHOW);
     End Else Begin
        ExecuteFile('command.com', '/k '+CboCommandLine.Text, Data[CurrentList].Directory+'\', SW_SHOW);
     End;
End;

procedure TFrmMain.CboCommandLineKeyPress(Sender: TObject; var Key: Char);
begin
     If Key = #13 Then ExecuteCommandLine;
end;

procedure TFrmMain.MediaShowRecycleBinClick(Sender: TObject);
Var
   RecycleBin: PItemIDList;
   info: TShellExecuteInfo;
   dummy: IMAlloc;
begin
     SHGetSpecialFolderLocation(Handle, CSIDL_BITBUCKET, RecycleBin);
     With info Do Begin
          cbSize:=SizeOf(info);
          Wnd:=Handle;
          nShow:=SW_SHOW;
          fMask:=SEE_MASK_IDLIST;
          lpVerb:='open';
          lpIDList:=RecycleBin;
          lpFile:=Nil;
          lpParameters:=Nil;
          lpDirectory:=Nil;
     End;
     ShellExecuteEx(@info);
     SHGetMAlloc(dummy);
     dummy.Free(RecycleBin);
     dummy:=Nil;
end;

Procedure EmptyRecycleBin ;
Const
     SHERB_NOCONFIRMATION = $00000001;
     SHERB_NOPROGRESSUI   = $00000002;
     SHERB_NOSOUND        = $00000004;
Type
    TSHEmptyRecycleBin = Function(Wnd: HWND; LPCTSTR: PChar; DWORD: Word): Integer; StdCall;
Var
   SHEmptyRecycleBin: TSHEmptyRecycleBin;
   LibHandle: THandle;
Begin
     LibHandle:=LoadLibrary(PChar('Shell32.dll'));
     If LibHandle <> 0 Then
        @SHEmptyRecycleBin:=GetProcAddress(LibHandle, 'SHEmptyRecycleBinA')
     Else Begin
        MessageDlg('Failed to load Shell32.dll.', mtError, [mbOK], 0);
        Exit;
     End;
     If @SHEmptyRecycleBin <> Nil Then
        SHEmptyRecycleBin(Application.Handle, '', SHERB_NOCONFIRMATION Or SHERB_NOPROGRESSUI Or SHERB_NOSOUND);
     FreeLibrary(LibHandle);
     @SHEmptyRecycleBin:=Nil;
End ;

procedure TFrmMain.MediaEmptyRecycleBinClick(Sender: TObject);
begin
     If MessageDlg('Soll der Inhalt des Papierkorbs wirklich vernichtet werden? (Dies lt sich nicht rckgngig machen!)', mtConfirmation, [mbYes, mbNo], 0) = mrYes Then
        EmptyRecycleBin;
end;

procedure TFrmMain.LstFilesInfoTip(Sender: TObject; Item: TListItem;
  var InfoTip: String);
begin
     If ((Data[LeftList].DataType = dtFindResult) Or (Lists[LeftList].ViewStyle <> vsReport)) Then
        InfoTip:=GetFileInfo(Item, LeftList)
     Else
        InfoTip:='';
end;

procedure TFrmMain.LstFiles2InfoTip(Sender: TObject; Item: TListItem;
  var InfoTip: String);
begin
     If ((Data[RightList].DataType = dtFindResult) Or (Lists[RightList].ViewStyle <> vsReport)) Then
        InfoTip:=GetFileInfo(Item, RightList)
     Else
        InfoTip:='';
end;

procedure TFrmMain.PopExplorerMenuClick(Sender: TObject);
begin
     ShowExplorerMenu(ExplorerMenu.Side, ExplorerMenu.p);
end;

Initialization
   // Die Clip-Board-Formate, die fr Drag&Drop bentigt werden, registrieren
   CF_IDLIST:=RegisterClipboardFormat(CFSTR_SHELLIDLIST);
   CF_FILENAMEMAP:=RegisterClipboardFormat(CFSTR_FILENAMEMAP);

   // Feststellen, ob OSR2 vorliegt, damit wir GetDiskFreeSpaceEx verwenden knnen
   FillChar(verInfo, SizeOf(VerInfo), #0);
   verInfo.dwOSVersionInfoSize:=SizeOf(VerInfo);
   If GetVersionEx(verInfo) = False Then
      WinIsOSR2:=False
   Else Begin
      If (verInfo.dwPlatformId = VER_PLATFORM_WIN32_WINDOWS) And
         (LoWord(verInfo.dwBuildNumber) > 1000) Then
            WinIsOSR2:=True
      Else
            WinIsOSR2:=False;
   End;
End.

