Unit FindFileForm;

Interface

Uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, SearchDir;

Type
  TFrmFindFile = Class(TForm)
    PagFindOptions: TPageControl;
    TabNameAndFolder: TTabSheet;
    LblFind: TLabel;
    EdtFileNames: TEdit;
    LblStartAt: TLabel;
    EdtStartAt: TEdit;
    ChkRecursive: TCheckBox;
    BtnBrowse: TButton;
    TabAttributes: TTabSheet;
    GrpAttributes: TGroupBox;
    ChkDirectory: TCheckBox;
    ChkArchive: TCheckBox;
    ChkReadOnly: TCheckBox;
    ChkHidden: TCheckBox;
    ChkSysFile: TCheckBox;
    TabDate: TTabSheet;
    RdoAllDates: TRadioButton;
    RdoDatesBetween: TRadioButton;
    Label1: TLabel;
    Label2: TLabel;
    TabSize: TTabSheet;
    Label3: TLabel;
    EdtMinSize: TEdit;
    Label4: TLabel;
    EdtMaxSize: TEdit;
    Label5: TLabel;
    CboUnit: TComboBox;
    TabText: TTabSheet;
    Label6: TLabel;
    EdtText: TEdit;
    ChkMatchCase: TCheckBox;
    BtnStart: TButton;
    BtnStop: TButton;
    BtnNew: TButton;
    BtnClose: TButton;
    BtnCopyResultToWindow: TButton;
    Senseless: TAnimate;
    Label7: TLabel;
    LblFound: TLabel;
    Label8: TLabel;
    LstResult: TListView;
    DtpDateLow: TDateTimePicker;
    DtpDateHigh: TDateTimePicker;
    BtnHelp: TButton;
    procedure FormShow(Sender: TObject);
    procedure BtnBrowseClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure EdtMinSizeKeyPress(Sender: TObject; var Key: Char);
    procedure EdtMaxSizeKeyPress(Sender: TObject; var Key: Char);
    procedure RdoDatesBetweenClick(Sender: TObject);
    procedure RdoAllDatesClick(Sender: TObject);
    procedure BtnCloseClick(Sender: TObject);
    procedure BtnStartClick(Sender: TObject);
    procedure BtnStopClick(Sender: TObject);
    procedure BtnNewClick(Sender: TObject);
    procedure BtnCopyResultToWindowClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure BtnHelpClick(Sender: TObject);
  private
    { Private-Deklarationen }
    Space: Integer;
    BtnWidth: Integer;
    Procedure WMNCHitTest(Var Msg: TMessage); Message WM_NCHITTEST;
  public
    { Public-Deklarationen }
    MinWindowSize: TPoint;
    Procedure WMGetMinMaxInfo(var Message: TWMGetMinMaxInfo); Message WM_GETMINMAXINFO;
  end;

var
   FrmFindFile: TFrmFindFile;

implementation

{$R *.DFM}

Uses
   MainForm;

Const
   UnitByte = 0;
   UnitKB = 1;
   UnitMB = 2;
   StdWindowWidth = 520;
   StdWindowHeight = 400;
   StdMinWindowWidth = 520;
   StdMinWindowHeight = 300;

Var
   MinBytes, MaxBytes: Longint;
   MinDate, MaxDate: TFileTime;
   UseDate: Boolean;
   SearchFor: String;
   Found: Longint;
   Stopped: Boolean;
   FileNames: Array[0..127] Of String; // Nimmt die einzelnen einschliessenden Wildcards auf
   FileNameNum: Integer;               // Anzahl der Wildcards
   StartCopy, i, Len: Integer;         // Temporre Variablen

Procedure TFrmFindFile.WMGetMinMaxInfo;
Begin
     With Message.MinMaxInfo^ Do Begin
          ptMinTrackSize.x:=MinWindowSize.x;
          ptMinTrackSize.y:=MinWindowSize.y;
     End;
End;

Function Stri(i:Longint):String;
Var
   Txt:String;
Begin
     Str(i,Txt);
     Stri:=Txt;
End;

Procedure UpDateFound;
Begin
     FrmFindFile.LblFound.Caption:=Stri(Found)+' Datei(en) gefunden';
End;

procedure TFrmFindFile.FormShow(Sender: TObject);
begin
     EdtStartAt.Text:=Data[CurrentList].Directory+'\';
     PagFindOptions.ActivePage:=TabNameAndFolder;
     Found:=LstResult.Items.Count;
     UpdateFound;
end;

procedure TFrmFindFile.BtnBrowseClick(Sender: TObject);
Var
   Path: String;
begin
     Path:=BrowseDir('Whlen sie das Startverzeichnis!',Handle);
     If Path <> '' Then EdtStartAt.Text:=Path;
end;

procedure TFrmFindFile.FormCreate(Sender: TObject);
begin
     CboUnit.ItemIndex:=0;
     Space:=LstResult.Left;
     BtnWidth:=BtnStart.Width;
     HelpContext:=IDH_FileFindFile;
     MinWindowSize.x:=Round(StdMinWindowWidth / StdPixelsPerInch * FrmMain.LogPixels.x);
     MinWindowSize.y:=Round(StdMinWindowHeight / StdPixelsPerInch * FrmMain.LogPixels.y);;
     Width:=Round(StdWindowWidth / StdPixelsPerInch * FrmMain.LogPixels.x);
     Height:=Round(StdWindowHeight / StdPixelsPerInch * FrmMain.LogPixels.y);;
end;

procedure TFrmFindFile.EdtMinSizeKeyPress(Sender: TObject; var Key: Char);
begin
     If Pos(Key,'0123456789'+#8) = 0 Then Key:=#0;
end;

procedure TFrmFindFile.EdtMaxSizeKeyPress(Sender: TObject; var Key: Char);
begin
     If Pos(Key,'0123456789'+#8) = 0 Then Key:=#0;
end;

procedure TFrmFindFile.RdoDatesBetweenClick(Sender: TObject);
begin
     DtpDateLow.Enabled:=True;
     DtpDateHigh.Enabled:=True;
end;

procedure TFrmFindFile.RdoAllDatesClick(Sender: TObject);
begin
     DtpDateLow.Enabled:=False;
     DtpDateHigh.Enabled:=False;
end;

Procedure TFrmFindFile.BtnCloseClick(Sender: TObject);
Begin
     Close;
End;

Procedure FindFile(Dir: String);
Var
   FindData: TWin32FindData;
   FindHandle: THandle;
   FindResult: Boolean;
   i: Integer;
   f: Text;
   Line: String;
   TextFound: Boolean;
   NewItem: TListItem;
Label
   NameOK, FileNotOK;
Begin
     // Ggf Verzeichnisnamen korrigieren
     If Dir[Length(Dir)] <> '\' Then Dir:=Dir+'\';
     // Erste Datei im Verzeichnis suchen
     FindHandle:=FindFirstFile(PChar(Dir+'*.*'), FindData);
     If FindHandle <> INVALID_HANDLE_VALUE Then Begin
        FindResult:=True;
        While FindResult Do With FrmFindFile Do Begin

              If FindData.cFileName[0] = '.' Then Begin
                 If (String(FindData.cFilename) = '.') Or (String(FindData.cFilename) = '..') Then Goto FileNotOK;
              End;

              // Wenn die gefundene Datei ein Verzeichnis ist und Unterverzeichnisse
              // einbezogen werden sollen, dieses Verzeichnis durchsuchen
              If ChkRecursive.Checked And ((FindData.dwFileAttributes And faDirectory) > 0) Then
                 FindFile(Dir+String(FindData.cFileName)+'\');

              // Prfen, ob Attribute stimmen
              // wenn eines nicht stimmt, die restlichen Tests
              // berspringen
              If ChkReadOnly.State <> cbGrayed Then
                 If ((FindData.dwFileAttributes And faReadOnly) = faReadOnly) <>
                    ChkReadOnly.Checked Then GoTo FileNotOK;
              If ChkSysFile.State <> cbGrayed Then
                 If ((FindData.dwFileAttributes And faSysFile) = faSysFile) <>
                    ChkSysFile.Checked Then GoTo FileNotOK;
              If ChkHidden.State <> cbGrayed Then
                 If ((FindData.dwFileAttributes And faHidden) = faHidden) <>
                    ChkHidden.Checked Then GoTo FileNotOK;
              If ChkArchive.State <> cbGrayed Then
                 If ((FindData.dwFileAttributes And faArchive) = faArchive) <>
                    ChkArchive.Checked Then GoTo FileNotOK;
              If ChkDirectory.State <> cbGrayed Then
                 If ((FindData.dwFileAttributes And faDirectory) = faDirectory) <>
                    ChkDirectory.Checked Then GoTo FileNotOK;

              // Prfen, ob das Datum in Ordnung geht
              If UseDate Then Begin
                 If CompareFileTime(FindData.ftLastWriteTime, MinDate) < 0 Then GoTo FileNotOK;
                 If CompareFileTime(FindData.ftLastWriteTime, MaxDate) > 0 Then GoTo FileNotOK;
              End;

              // Prfen, ob die Dateigre in Ordnung geht
              If MinBytes >= 0 Then
                 If FindData.nFileSizeLow < Cardinal(MinBytes) Then GoTo FileNotOK;
              If MaxBytes >= 0 Then
                 If FindData.nFileSizeLow > Cardinal(MaxBytes) Then GoTo FileNotOK;

              // Namen berprfen
              For i:=0 To FileNameNum-1 Do
                  If Like(AnsiUpperCase(String(FindData.cFileName)), FileNames[i]) Then GoTo NameOK;
              GoTo FileNotOK;

        NameOK:
              // Ggf. noch die Datei nach einem Text durchsuchen...
              If Length(EdtText.Text) > 0 Then Begin
                 AssignFile(f,Dir+String(FindData.cFileName));
                 IOResult;
                 Reset(f);
                 TextFound:=False;
                 If IOResult <> 0 Then GoTo FileNotOK;
                 While ((Not Eof(f)) And (Not TextFound)) Do Begin
                       ReadLn(f,Line);
                       If IOResult <> 0 Then Begin
                          CloseFile(f);
                          IOResult;
                          GoTo FileNotOK;
                       End;
                       If ChkMatchCase.Checked Then Begin
                          TextFound:=(Pos(EdtText.Text,Line) <> 0);
                       End Else Begin
                          TextFound:=(Pos(AnsiUpperCase(EdtText.Text),AnsiUpperCase(Line)) <> 0);
                       End;
                 End;
                 If (Not TextFound) Then GoTo FileNotOK;
              End;

              // Alle Tests bestanden. Dateinamem in die Liste aufnehmen.
              NewItem:=FrmFindFile.LstResult.Items.Add;
              NewItem.Caption:=String(FindData.cFileName);
              NewItem.Subitems.Add(Dir);
              Inc(Found);

        // Ich wei, ich wei. Labels sind in Hochsprachen ein
        // verflucht schlechter Programmierstil, aber in diesem
        // Fall ist es einfach die einfachste und bersichtlichste
        // Lsung. Echt ehrlich!
        FileNotOK:

              // Nchste Datei
              FindResult:=FindNextFile(FindHandle, FindData);
              Application.ProcessMessages;
              If Stopped Then Begin
                 Windows.FindClose(FindHandle);
                 Exit;
              End;
        End;
        Windows.FindClose(FindHandle);
        UpDateFound;
     End;
End;

Procedure TFrmFindFile.BtnStartClick(Sender: TObject);
Var
   x: Longint;
   Code: Integer;
Begin
     If EdtFileNames.Text = '' Then Begin
        MessageDlg('Sie haben keine Dateinamen angegeben.',mtError,[mbOK],0);
        PagFindOptions.ActivePage:=TabNameAndFolder;
        EdtFileNames.SetFocus;
        Exit;
     End;
     If EdtStartAt.Text = '' Then Begin
        MessageDlg('Sie haben kein Startverzeichnis angegeben.',mtError,[mbOK],0);
        PagFindOptions.ActivePage:=TabNameAndFolder;
        EdtStartAt.SetFocus;
        Exit;
     End;
     If RdoDatesBetween.Checked Then Begin
        MinDate:=DateTimeToFileTime(DtpDateLow.Date);
        MaxDate:=DateTimeToFileTime(DtpDateHigh.Date);
        UseDate:=True;
     End Else Begin
        UseDate:=False;
     End;
     If EdtMinSize.Text <> '' Then Begin
        Val(EdtMinSize.Text,x,Code);
        If Code = 0 Then Begin
           Case CboUnit.ItemIndex Of
                UnitByte: MinBytes:=x;
                UnitKB: MinBytes:=x * 1024;
                UnitMB: MinBytes:=x * 1024 * 1024;
           End;
        End;
     End Else MinBytes:=-1;
     If EdtMaxSize.Text <> '' Then Begin
        Val(EdtMaxSize.Text,x,Code);
        If Code = 0 Then Begin
           Case CboUnit.ItemIndex Of
                UnitByte: MaxBytes:=x;
                UnitKB: MaxBytes:=x * 1024;
                UnitMB: MaxBytes:=x * 1024 * 1024;
           End;
        End;
     End Else MaxBytes:=-1;
     // Liste zurcksetzen
     LstResult.Items.Clear;
     Found:=0;
     UpDateFound;
     SearchFor:=Trim(EdtFileNames.Text);
     // Anzeige aktualisieren
     TabNameAndFolder.Enabled:=False;
     TabAttributes.Enabled:=False;
     TabDate.Enabled:=False;
     TabSize.Enabled:=False;
     TabText.Enabled:=False;
     BtnStart.Enabled:=False;
     BtnClose.Enabled:=False;
     BtnNew.Enabled:=False;
     BtnCopyResultToWindow.Enabled:=False;
     BtnStop.Enabled:=True;
     Senseless.Active:=True;
     // Wildcards auseinanderklamsern
     FileNameNum:=0;
     i:=0;
     StartCopy:=1;
     Len:=Length(EdtFileNames.Text);
     Repeat
           Inc(i);
           If i > Len Then Begin
              FileNames[FileNameNum]:=AnsiUpperCase(Trim(Copy(EdtFileNames.Text, StartCopy, i-StartCopy)));
              Inc(FileNameNum);
           End Else If (EdtFileNames.Text[i] = ';') Then Begin
              FileNames[FileNameNum]:=AnsiUpperCase(Trim(Copy(EdtFileNames.Text, StartCopy, i-StartCopy)));
              Inc(FileNameNum);
              StartCopy:=i+1;
           End;
     Until i > Len;
     // und Suchen!
     If FileNameNum > 0 Then Begin
        Stopped:=False;
        FindFile(Trim(EdtStartAt.Text));
     End;
     UpdateFound;
     // Ende!
     BtnStopClick(Sender);
End;

procedure TFrmFindFile.BtnStopClick(Sender: TObject);
begin
     Stopped:=True;
     TabNameAndFolder.Enabled:=True;
     TabAttributes.Enabled:=True;
     TabDate.Enabled:=True;
     TabSize.Enabled:=True;
     TabText.Enabled:=True;
     BtnStart.Enabled:=True;
     BtnClose.Enabled:=True;
     BtnNew.Enabled:=True;
     BtnStop.Enabled:=False;
     BtnCopyResultToWindow.Enabled:=True;
     Senseless.Active:=False;
end;

Procedure TFrmFindFile.BtnNewClick(Sender: TObject);
Begin
     If MessageDlg('Hiermit wird das aktuelle Ergebnis und alle eingestellten Suchoptionen gelscht. Fortfahren?',mtConfirmation,[mbYes,mbNo],0) = mrYes Then Begin
        PagFindOptions.ActivePage:=TabNameAndFolder;
        EdtFileNames.Text:='';
        EdtStartAt.Text:=Data[CurrentList].Directory+'\';
        ChkRecursive.Checked:=True;
        ChkReadOnly.State:=cbGrayed;
        ChkSysFile.State:=cbGrayed;
        ChkHidden.State:=cbGrayed;
        ChkDirectory.State:=cbGrayed;
        ChkArchive.State:=cbGrayed;
        RdoAllDates.Checked:=True;
        RdoDatesBetween.Checked:=False;
        RdoAllDatesClick(Sender);
        EdtMinSize.Text:='';
        EdtMaxSize.Text:='';
        CboUnit.ItemIndex:=UnitByte;
        EdtText.Text:='';
        ChkMatchCase.Checked:=False;
        LstResult.Items.Clear;
        Found:=0;
        UpdateFound;
     End;
End;

procedure TFrmFindFile.BtnCopyResultToWindowClick(Sender: TObject);
begin
     Data[CurrentList].QueryDataType:=dtFindResult;
     UpdateDir(CurrentList);
     Close;
end;

procedure TFrmFindFile.FormResize(Sender: TObject);
Var
   Wdt: Integer;
begin
     // Dateifenster
     LstResult.Width:=FrmFindFile.ClientWidth-(Space * 2);
     LstResult.Height:=FrmFindFile.ClientHeight-LstResult.Top - Space;
     // Buttons
     BtnStart.Left:=FrmFindFile.ClientWidth - BtnStart.Width - (BtnWidth + (Space * 2));
     BtnStop.Left:=FrmFindFile.ClientWidth - BtnStop.Width - Space;
     BtnClose.Left:=FrmFindFile.ClientWidth - BtnClose.Width - (BtnWidth + (Space * 2));
     BtnHelp.Left:=FrmFindFile.ClientWidth - BtnHelp.Width - Space;
     BtnNew.Left:=FrmFindFile.ClientWidth - BtnNew.Width - Space;
     BtnCopyResultToWindow.Left:=FrmFindFile.ClientWidth - BtnCopyResultToWindow.Width - (BtnWidth + (Space * 2));
     // Animation
     Wdt:=((BtnWidth * 2) + (Space * 3));
     Senseless.Left:=FrmFindFile.ClientWidth - Wdt + ((Wdt - Senseless.Width) Div 2);
     // Such-Optionen
     PagFindOptions.Width:=FrmFindFile.ClientWidth - PagFindOptions.Left - (4 * Space + 2 * BtnWidth);
     Wdt:=PagFindOptions.ActivePage.Width;
     EdtFileNames.Width:=Wdt - EdtFileNames.Left - Space;
     EdtStartAt.Width:=Wdt - EdtStartAt.Left - Space;
     BtnBrowse.Left:=Wdt - BtnBrowse.Width - Space;
     GrpAttributes.Width:=Wdt - GrpAttributes.Left - Space;
     EdtText.Width:=Wdt - EdtText.Left - Space;
end;

procedure TFrmFindFile.BtnHelpClick(Sender: TObject);
begin
     Application.HelpCommand(HELP_CONTEXT, HelpContext);
end;

Procedure TFrmFindFile.WMNCHitTest(Var Msg : TMessage);
Var
   i: Integer;
   r: TRect;
   ctrl: TControl;

Function LeftMouseButtonPressed: Boolean;
Begin
     If GetSystemMetrics(SM_SWAPBUTTON) = 0 Then
        Result:=(GetAsyncKeyState(VK_LBUTTON) < 0)
     Else
        Result:=(GetAsyncKeyState(VK_RBUTTON) < 0);
End;

Begin
     If Options.WindowClientDraggable And LeftMouseButtonPressed Then Begin
        If (Msg.LParamLo >= Self.ClientToScreen(Point(0, 0)).x) And
           (Msg.LParamHi >= Self.ClientToScreen(Point(0, 0)).y) And
           (Msg.LParamLo <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).x) And
           (Msg.LParamHi <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).y)
        Then Begin
             For i:=0 To Self.ComponentCount-1 Do Begin
                 Try
                    If Self.Components[i] Is TControl Then Begin
                       ctrl:=TControl(Self.Components[i]);
                       r:=ctrl.BoundsRect;
                       If (Msg.LParamLo >= Self.ClientToScreen(Point(r.Left, r.Top)).x) And
                          (Msg.LParamHi >= Self.ClientToScreen(Point(r.Left, r.Top)).y) And
                          (Msg.LParamLo <= Self.ClientToScreen(Point(r.Right, r.Bottom)).x) And
                          (Msg.LParamHi <= Self.ClientToScreen(Point(r.Right, r.Bottom)).y) And ctrl.Visible
                       Then Begin
                          Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                          Exit;
                       End;
                    End;
                 Except
                    Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                    Exit;
                 End;
             End;
             Msg.Result:=HTCAPTION
        End Else
           Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
     End Else
        Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
End;

End.
