unit createlinkform;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ShlObj, ExtCtrls;

type
  TFrmCreateLink = class(TForm)
    BtnOK: TButton;
    BtnCancel: TButton;
    EdtDest: TEdit;
    BtnLeft: TButton;
    BtnRight: TButton;
    BtnDesktop: TButton;
    BtnBrowse: TButton;
    Bevel1: TBevel;
    Label1: TLabel;
    Image1: TImage;
    BtnHelp: TButton;
    Label3: TLabel;
    Label4: TLabel;
    LblSubDirs: TLabel;
    LblFileNum: TLabel;
    Bevel2: TBevel;
    procedure BtnLeftClick(Sender: TObject);
    procedure BtnRightClick(Sender: TObject);
    procedure BtnDesktopClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure BtnBrowseClick(Sender: TObject);
    procedure EdtDestChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BtnHelpClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private-Deklarationen }
    Procedure WMNCHitTest(Var Msg: TMessage); Message WM_NCHITTEST;
  public
    { Public-Deklarationen }
    SourceList: Integer;
  end;

var
  FrmCreateLink: TFrmCreateLink;

implementation

{$R *.DFM}

Uses
    MainForm;

procedure TFrmCreateLink.BtnLeftClick(Sender: TObject);
begin
     EdtDest.Text:=Data[0].Directory+'\';
end;

procedure TFrmCreateLink.BtnRightClick(Sender: TObject);
begin
     EdtDest.Text:=Data[1].Directory+'\';
end;

procedure TFrmCreateLink.BtnDesktopClick(Sender: TObject);
Var
   Pansen: PItemIDList;
   DesktopDir: Array[0..MAX_PATH] Of Char;
begin
     DesktopDir:='';
     If SHGetSpecialFolderLocation(Handle,CSIDL_DESKTOPDIRECTORY,Pansen) = NOERROR Then Begin
        If SHGetPathFromIDList(Pansen,DesktopDir) = True Then
           EdtDest.Text:=String(DesktopDir)
        Else APIError;
     End Else APIError;
end;

procedure TFrmCreateLink.FormActivate(Sender: TObject);
begin
     EdtDestChange(Sender);
     EdtDest.SelStart:=0;
     EdtDest.SelLength:=Length(EdtDest.Text);
     EdtDest.SetFocus;
end;

procedure TFrmCreateLink.BtnBrowseClick(Sender: TObject);
Var
   Pansen: String;
begin
     Pansen:=BrowseDir('Whlen Sie das Zielverzeichnis...',Handle);
     If Pansen <> '' Then EdtDest.Text:=Pansen;
end;

procedure TFrmCreateLink.EdtDestChange(Sender: TObject);
begin
     If EdtDest.Text <> '' Then BtnOK.Enabled:=True Else BtnOK.Enabled:=False;
end;

procedure TFrmCreateLink.FormShow(Sender: TObject);
Var
   FileNum, DirNum: Longint;
   SizeInBytes: Int64;
begin
     DirInfo(False, False, False, SourceList, FileNum, DirNum, SizeInBytes);
     LblSubDirs.Caption:=Formatted(DirNum);
     LblFileNum.Caption:=Formatted(FileNum);
end;

procedure TFrmCreateLink.BtnHelpClick(Sender: TObject);
begin
     Application.HelpCommand(HELP_CONTEXT, HelpContext);
End;

procedure TFrmCreateLink.FormCreate(Sender: TObject);
begin
     HelpContext:=IDH_FileCreateLink;
end;

Procedure TFrmCreateLink.WMNCHitTest(Var Msg : TMessage);
Var
   i: Integer;
   r: TRect;
   ctrl: TControl;

Function LeftMouseButtonPressed: Boolean;
Begin
     If GetSystemMetrics(SM_SWAPBUTTON) = 0 Then
        Result:=(GetAsyncKeyState(VK_LBUTTON) < 0)
     Else
        Result:=(GetAsyncKeyState(VK_RBUTTON) < 0);
End;

Begin
     If Options.WindowClientDraggable And LeftMouseButtonPressed Then Begin
        If (Msg.LParamLo >= Self.ClientToScreen(Point(0, 0)).x) And
           (Msg.LParamHi >= Self.ClientToScreen(Point(0, 0)).y) And
           (Msg.LParamLo <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).x) And
           (Msg.LParamHi <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).y)
        Then Begin
             For i:=0 To Self.ComponentCount-1 Do Begin
                 Try
                    If Self.Components[i] Is TControl Then Begin
                       ctrl:=TControl(Self.Components[i]);
                       r:=ctrl.BoundsRect;
                       If (Msg.LParamLo >= Self.ClientToScreen(Point(r.Left, r.Top)).x) And
                          (Msg.LParamHi >= Self.ClientToScreen(Point(r.Left, r.Top)).y) And
                          (Msg.LParamLo <= Self.ClientToScreen(Point(r.Right, r.Bottom)).x) And
                          (Msg.LParamHi <= Self.ClientToScreen(Point(r.Right, r.Bottom)).y) And ctrl.Visible
                       Then Begin
                          Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                          Exit;
                       End;
                    End;
                 Except
                    Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                    Exit;
                 End;
             End;
             Msg.Result:=HTCAPTION
        End Else
           Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
     End Else
        Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
End;

end.
