unit TextEditForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ComCtrls, StdCtrls, ToolWin, Buttons, ExtCtrls, ImgList;

type
  TFrmTextEdit = class(TForm)
    StsBar: TStatusBar;
    MnuMain: TMainMenu;
    MnuFile: TMenuItem;
    FileExit: TMenuItem;
    N1: TMenuItem;
    FilePrinterOptions: TMenuItem;
    FilePrint: TMenuItem;
    N2: TMenuItem;
    FileSaveAs: TMenuItem;
    FileSave: TMenuItem;
    FileOpen: TMenuItem;
    FileNew: TMenuItem;
    MnuEdit: TMenuItem;
    EditPaste: TMenuItem;
    EditCopy: TMenuItem;
    EditCut: TMenuItem;
    EditPasteDateTime: TMenuItem;
    EditPasteFileName: TMenuItem;
    EditClear: TMenuItem;
    MnuOptions: TMenuItem;
    OptionsToolBar: TMenuItem;
    OptionsStatusBar: TMenuItem;
    OptionsWordWrap: TMenuItem;
    N5: TMenuItem;
    DlgOpen: TOpenDialog;
    DlgSave: TSaveDialog;
    DlgPrinterOptions: TPrinterSetupDialog;
    MmoText: TRichEdit;
    EditSelectAll: TMenuItem;
    N6: TMenuItem;
    TlbTools: TPanel;
    Bevel1: TBevel;
    TlbOpen: TSpeedButton;
    TlbSave: TSpeedButton;
    TlbNew: TSpeedButton;
    TlbCut: TSpeedButton;
    TlbCopy: TSpeedButton;
    TlbPaste: TSpeedButton;
    TlbFind: TSpeedButton;
    TlbReplace: TSpeedButton;
    FindFind: TMenuItem;
    FindReplace: TMenuItem;
    FindFindNext: TMenuItem;
    MnuFind: TMenuItem;
    N4: TMenuItem;
    EditUndo: TMenuItem;
    N7: TMenuItem;
    FindWordAtCursor: TMenuItem;
    ImgMenu: TImageList;
    procedure FormCreate(Sender: TObject);
    procedure FileOpenClick(Sender: TObject);
    procedure FileExitClick(Sender: TObject);
    procedure TlbExitClick(Sender: TObject);
    procedure TlbOpenClick(Sender: TObject);
    procedure FileNewClick(Sender: TObject);
    procedure TlbNewClick(Sender: TObject);
    procedure FilePrinterOptionsClick(Sender: TObject);
    procedure FilePrintClick(Sender: TObject);
    procedure FileSaveClick(Sender: TObject);
    procedure FileSaveAsClick(Sender: TObject);
    procedure TlbSaveClick(Sender: TObject);
    procedure MmoTextSelectionChange(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure OptionsToolBarClick(Sender: TObject);
    procedure OptionsStatusBarClick(Sender: TObject);
    procedure OptionsWordWrapClick(Sender: TObject);
    procedure EditCutClick(Sender: TObject);
    procedure EditCopyClick(Sender: TObject);
    procedure EditPasteClick(Sender: TObject);
    procedure EditClearClick(Sender: TObject);
    procedure EditSelectAllClick(Sender: TObject);
    procedure TlbCutClick(Sender: TObject);
    procedure TlbCopyClick(Sender: TObject);
    procedure TlbPasteClick(Sender: TObject);
    procedure EditPasteDateTimeClick(Sender: TObject);
    procedure EditPasteFileNameClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure MmoTextChange(Sender: TObject);
    procedure EditFindClick(Sender: TObject);
    procedure TlbFindClick(Sender: TObject);
    procedure EditFindNextClick(Sender: TObject);
    procedure EditReplaceClick(Sender: TObject);
    procedure TlbReplaceClick(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure MnuEditClick(Sender: TObject);
    procedure EditUndoClick(Sender: TObject);
    procedure FindWordAtCursorClick(Sender: TObject);
  private
    { Private-Deklarationen }
    Procedure ShowTheHint(Sender: TObject);
  public
    { Public-Deklarationen }
    Procedure UpdateCursorPos;
    Function GetWordAtCursor: String;
  end;

var
  FrmTextEdit: TFrmTextEdit;
  ActFile: String;
  Ins: Boolean;

Const
  CrgRet = #13+#10;
  NewFile = 'OhneName.txt';
  EM_CANPASTE = WM_USER + 50;
  EM_EXLINEFROMCHAR = WM_USER + 54;

implementation

uses findform, replaceform;

{$R *.DFM}

Procedure CheckKeys;
Begin
     With FrmTextEdit.StsBar Do Begin
          If (GetKeyState(VK_NumLock) And 1) > 0 Then Panels[0].Text:='NUM' Else Panels[0].Text:='';
          If (GetKeyState(VK_Capital) And 1) > 0 Then Panels[1].Text:='GROSS' Else Panels[1].Text:='';
     End;
End;

Procedure TFrmTextEdit.ShowTheHint(Sender: TObject);
Begin
     If Application.Hint <> '' Then Begin
        FrmTextEdit.StsBar.SimplePanel:=True;
        FrmTextEdit.StsBar.SimpleText:=GetLongHint(Application.Hint);
     End Else Begin
        FrmTextEdit.StsBar.SimpleText:='';
        FrmTextEdit.StsBar.SimplePanel:=False;
     End;
End;

procedure TFrmTextEdit.FormCreate(Sender: TObject);
begin
     Application.OnHint:=ShowTheHint;
     MmoText.Modified:=False;
     ActFile:=NewFile;
     MmoTextSelectionChange(Sender);
     CheckKeys;
     Ins:=True;
     StsBar.Panels[2].Text:='EINFGEN';
     StsBar.Panels[2].Text:='';
end;

Function SaveFileAs: Boolean;
Begin
     If FrmTextEdit.DlgSave.Execute Then Begin
        FrmTextEdit.MmoText.Lines.SaveToFile(FrmTextEdit.DlgSave.FileName);
        ActFile:=FrmTextEdit.DlgSave.FileName;
        FrmTextEdit.Caption:=ActFile;
        FrmTextEdit.MmoText.Modified:=False;
        FrmTextEdit.StsBar.Panels[2].Text:='';
        Result:=True;
     End Else Result:=False;
End;

Function SaveFile: Boolean;
Begin
     If ActFile = NewFile Then Begin
        If (Not SaveFileAs) Then Begin
           Result:=False;
           Exit;
        End Else Begin
           Result:=True;
           Exit;
        End;
     End;
     FrmTextEdit.MmoText.Lines.SaveToFile(ActFile);
     FrmTextEdit.MmoText.Modified:=False;
     FrmTextEdit.StsBar.Panels[2].Text:='';
     Result:=True;
End;

procedure TFrmTextEdit.FileOpenClick(Sender: TObject);
Var
   Result: Integer;
begin
     If MmoText.Modified Then Begin
        Result:=MessageDlg(ActFile+CrgRet+'wurde verndert.'+CrgRet+CrgRet+'nderung speichern?', mtWarning, [mbYes, mbNo, mbCancel], 0);
        Case Result Of
             mrYes: If (Not SaveFile) Then Exit;
             mrCancel: Exit;
        End;
     End;
     If DlgOpen.Execute Then Begin
        MmoText.Lines.LoadFromFile(DlgOpen.FileName);
        MmoText.Modified:=False;
        StsBar.Panels[2].Text:='';
        ActFile:=DlgOpen.FileName;
        FrmTextEdit.Caption:=ActFile;
     End;
end;

procedure TFrmTextEdit.FileExitClick(Sender: TObject);
begin
     Self.Close;
end;

procedure TFrmTextEdit.TlbExitClick(Sender: TObject);
begin
     FileExitClick(Sender);
end;

procedure TFrmTextEdit.TlbOpenClick(Sender: TObject);
begin
     FileOpenClick(Sender);
end;

procedure TFrmTextEdit.FileNewClick(Sender: TObject);
Var
   Result: Integer;
begin
     If MmoText.Modified Then Begin
        Result:=MessageDlg(ActFile+CrgRet+'wurde verndert.'+CrgRet+CrgRet+'nderung speichern?', mtWarning, [mbYes, mbNo, mbCancel], 0);
        Case Result Of
             mrYes: If (Not SaveFile) Then Exit;
             mrCancel: Exit;
        End;
     End;
     MmoText.Lines.Clear;
     StsBar.Panels[2].Text:='';
     ActFile:=NewFile;
     Self.Caption:=ActFile;
end;

procedure TFrmTextEdit.TlbNewClick(Sender: TObject);
begin
     FileNewClick(Sender);
end;

procedure TFrmTextEdit.FilePrinterOptionsClick(Sender: TObject);
begin
     DlgPrinterOptions.Execute;
end;

procedure TFrmTextEdit.FilePrintClick(Sender: TObject);
begin
     MmoText.Print(ActFile);
end;

procedure TFrmTextEdit.FileSaveClick(Sender: TObject);
begin
     SaveFile;
end;

procedure TFrmTextEdit.FileSaveAsClick(Sender: TObject);
begin
     SaveFileAs;
end;

procedure TFrmTextEdit.TlbSaveClick(Sender: TObject);
begin
     FileSaveClick(Sender);
end;

procedure TFrmTextEdit.MmoTextSelectionChange(Sender: TObject);
begin
     If MmoText.SelLength = 0 Then Begin
        EditCut.Enabled:=False;
        EditCopy.Enabled:=False;
        EditClear.Enabled:=False;
        TlbCut.Enabled:=False;
        TlbCopy.Enabled:=False;
     End Else Begin
        EditCut.Enabled:=True;
        EditCopy.Enabled:=True;
        EditClear.Enabled:=True;
        TlbCut.Enabled:=True;
        TlbCopy.Enabled:=True;
     End;
     UpdateCursorPos;
end;

procedure TFrmTextEdit.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
Var
   Result: Integer;
begin
     If MmoText.Modified Then Begin
        Result:=MessageDlg(ActFile+CrgRet+'wurde verndert.'+CrgRet+CrgRet+'nderung speichern?', mtWarning, [mbYes, mbNo, mbCancel], 0);
        Case Result Of
             mrYes: If (Not SaveFile) Then Begin
                       CanClose:=False;
                       Exit;
                    End;
             mrCancel: Begin
                            CanClose:=False;
                            Exit;
                       End;
        End;
     End;
     CanClose:=True;
end;

procedure TFrmTextEdit.OptionsToolBarClick(Sender: TObject);
begin
     OptionsToolBar.Checked:=(Not OptionsToolBar.Checked);
     TlbTools.Visible:=OptionsToolBar.Checked;
end;

procedure TFrmTextEdit.OptionsStatusBarClick(Sender: TObject);
begin
     OptionsStatusBar.Checked:=(Not OptionsStatusBar.Checked);
     StsBar.Visible:=OptionsStatusBar.Checked;
end;

procedure TFrmTextEdit.OptionsWordWrapClick(Sender: TObject);
begin
     OptionsWordWrap.Checked:=(Not OptionsWordWrap.Checked);
     MmoText.WordWrap:=OptionsWordWrap.Checked;
end;

procedure TFrmTextEdit.EditCutClick(Sender: TObject);
begin
     MmoText.CutToClipBoard;
end;

procedure TFrmTextEdit.EditCopyClick(Sender: TObject);
begin
     MmoText.CopyToClipBoard;
end;

procedure TFrmTextEdit.EditPasteClick(Sender: TObject);
begin
     MmoText.PasteFromClipBoard;
end;

procedure TFrmTextEdit.EditClearClick(Sender: TObject);
begin
     MmoText.ClearSelection;
end;

procedure TFrmTextEdit.EditSelectAllClick(Sender: TObject);
begin
     MmoText.SelectAll;
end;

procedure TFrmTextEdit.TlbCutClick(Sender: TObject);
begin
     EditCutClick(Sender);
end;

procedure TFrmTextEdit.TlbCopyClick(Sender: TObject);
begin
     EditCopyClick(Sender);
end;

procedure TFrmTextEdit.TlbPasteClick(Sender: TObject);
begin
     EditPasteClick(Sender);
end;

procedure TFrmTextEdit.EditPasteDateTimeClick(Sender: TObject);
begin
     MmoText.SelText:=TimeToStr(Time)+' '+DateToStr(Date);;
end;

procedure TFrmTextEdit.EditPasteFileNameClick(Sender: TObject);
begin
     MmoText.SelText:=ActFile;
end;

procedure TFrmTextEdit.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     CheckKeys;
end;

procedure TFrmTextEdit.MmoTextChange(Sender: TObject);
begin
     StsBar.Panels[2].Text:='Gendert';
end;

procedure TFrmTextEdit.EditFindClick(Sender: TObject);
Var
   FindType: TSearchTypes;
   StartPos: Longint;
   Result: Longint;
begin
     If FindWordAtCursor.Checked Then
        FrmFind.EdtFind.Text:=GetWordAtCursor;
     If FrmFind.ShowModal = mrOK Then With FrmFind Do Begin
        If RdgStart.ItemIndex = 0 Then StartPos:=0 Else StartPos:=MmoText.SelStart;
        FindType:=[];
        If ChkWholeWords.Checked Then FindType:=[stWholeWord];
        If ChkMatchCase.Checked Then FindType:=FindType+[stMatchCase];
        Result:=MmoText.FindText(EdtFind.Text,StartPos,Length(MmoText.Text),FindType);
        If Result > -1 Then Begin
           MmoText.SelStart:=Result;
           MmoText.SelLength:=Length(EdtFind.Text);
        End Else Begin
           MessageDlg('Die Zeichenkette "'+EdtFind.Text+'" wurde nicht gefunden.',mtInformation,[mbOK],0);
        End;
     End;
end;

procedure TFrmTextEdit.TlbFindClick(Sender: TObject);
begin
     EditFindClick(Sender);
end;

procedure TFrmTextEdit.EditFindNextClick(Sender: TObject);
Var
   FindType: TSearchTypes;
   Result: Longint;
begin
     If FrmFind.EdtFind.Text <> '' Then With FrmFind Do Begin
        FindType:=[];
        If ChkWholeWords.Checked Then FindType:=[stWholeWord];
        If ChkMatchCase.Checked Then FindType:=FindType+[stMatchCase];
        Result:=MmoText.FindText(EdtFind.Text,MmoText.SelStart+1,Length(MmoText.Text),FindType);
        If Result > -1 Then Begin
           MmoText.SelStart:=Result;
           MmoText.SelLength:=Length(EdtFind.Text);
        End;
     End;
end;

procedure TFrmTextEdit.EditReplaceClick(Sender: TObject);
Var
   Mes, Result: Integer;
   FindType: TSearchTypes;
   StartPos: Longint;
   Replace: Boolean;
begin
     If FindWordAtCursor.Checked Then
        FrmReplace.EdtFind.Text:=GetWordAtCursor;
     Result:=FrmReplace.ShowModal;
     If Result <> mrCancel Then With FrmReplace Do Begin
        If RdgStart.ItemIndex = 0 Then StartPos:=0 Else StartPos:=MmoText.SelStart;
        FindType:=[];
        If ChkWholeWords.Checked Then FindType:=[stWholeWord];
        If ChkMatchCase.Checked Then FindType:=FindType+[stMatchCase];
        Repeat
              StartPos:=MmoText.FindText(EdtFind.Text,StartPos,Length(MmoText.Text),FindType);
              If StartPos > -1 Then Begin
                 MmoText.SelStart:=StartPos;
                 MmoText.SelLength:=Length(EdtFind.Text);
                 Replace:=True;
                 If ChkConfirm.Checked Then Begin
                    Mes:=MessageDlg('Markierte Zeichenkette durch "'+EdtReplace.Text+'" ersetzen?',mtConfirmation,[mbYes, mbNo, mbCancel],0);
                    Case Mes Of
                         mrYes: Replace:=True;
                         mrNo: Replace:=False;
                         mrCancel: Exit;
                    End;
                 End Else Replace:=True;
                 If Replace Then Begin
                    MmoText.SelText:=EdtReplace.Text;
                    Inc(StartPos,Length(EdtReplace.Text));
                 End Else Inc(StartPos,Length(EdtFind.Text));
              End;
        Until (StartPos < 0);
     End;
End;

procedure TFrmTextEdit.TlbReplaceClick(Sender: TObject);
begin
     EditReplaceClick(Sender);
end;

procedure TFrmTextEdit.FormKeyPress(Sender: TObject; var Key: Char);
begin
     If Key = #27 Then Close;
end;

Procedure TFrmTextEdit.UpdateCursorPos;
Var
   CharPos: TPoint;
Begin
     CharPos.Y:=SendMessage(MmoText.Handle, EM_EXLINEFROMCHAR, 0, MmoText.SelStart);
     CharPos.X:=(MmoText.SelStart - SendMessage(MmoText.Handle, EM_LINEINDEX, CharPos.Y, 0));
     Inc(CharPos.Y);
     Inc(CharPos.X);
     StsBar.Panels[3].Text:=Format('%5d: %3d', [CharPos.Y, CharPos.X]);
End;

procedure TFrmTextEdit.MnuEditClick(Sender: TObject);
begin
     If SendMessage(MmoText.Handle, EM_CANUNDO, 0, 0) = 1 Then
        EditUndo.Enabled:=True
     Else
        EditUndo.Enabled:=False;
end;

procedure TFrmTextEdit.EditUndoClick(Sender: TObject);
begin
     PostMessage(MmoText.Handle, EM_UNDO, 0, 0);
end;

Function TFrmTextEdit.GetWordAtCursor;
Const
   Divider = ' =<>()[]{}!&/\^|,.;:-#*+~?'+#13+#10+#9;
Var
   Tmp: String;
   Start, LineNum, CharNum, i: Integer;
   Buffer: Array[0..65535] Of Char;
Begin
     If MmoText.SelLength > 0 Then Begin
        Result:=MmoText.SelText;
     End Else Begin
        Buffer[0]:=#255;
        Buffer[1]:=#255;
        LineNum:=SendMessage(MmoText.Handle, EM_EXLINEFROMCHAR, 0, MmoText.SelStart);
        CharNum:=SendMessage(MmoText.Handle, EM_GETLINE, LineNum, Integer(@Buffer));
        Start:=MmoText.SelStart-SendMessage(MmoText.Handle, EM_LINEINDEX, LineNum, 0);
        If Start < CharNum - 1 Then Begin
           If Pos(Buffer[Start], Divider) = 0 Then Begin
              i:=Start;
              Repeat
                    Dec(i);
                    If i < 0 Then Break;
              Until Pos(Buffer[i], Divider) > 0;
              Tmp:='';
              Inc(i);
              While Pos(Buffer[i], Divider) = 0 Do Begin
                    Tmp:=Tmp+Buffer[i];
                    Inc(i);
              End;
              Result:=Tmp;
           End Else Result:='';
        End Else Result:='';
     End;
End;

procedure TFrmTextEdit.FindWordAtCursorClick(Sender: TObject);
begin
     FindWordAtCursor.Checked:=Not FindWordAtCursor.Checked;
end;

end.
