Unit StcTxtEx;

Interface

Uses
    Messages, Windows, SysUtils, Classes, Controls, Forms, Menus, Graphics, StdCtrls;

Type
  TStaticTextEx = class(TCustomStaticText)
  Private
    fDown: Boolean;
    Procedure SetDown(Value: Boolean);
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
  Public
    constructor Create(AOwner: TComponent); override;
  published
    property Align;
    property Alignment;
    property AutoSize;
    property Caption;
    property Color;
    property DragCursor;
    property DragMode;
    property Enabled;
    property FocusControl;
    property Font;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowAccelChar;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDrag;
    Property Down: Boolean Read fDown Write SetDown;
  end;

Implementation

Constructor TStaticTextEx.Create;
Begin
     Inherited;
     fDown:=False;
     Color:=clBtnFace;
     Font.Color:=clBtnText;
     BorderStyle:=sbsNone;
End;

Procedure TStaticTextEx.CMMouseEnter;
Begin
     Inherited;
     If Down Then Begin
        Color:=clBtnFace;
        Font.Color:=clBtnText;
     End Else Begin
        Color:=clBtnShadow;
        Font.Color:=clHighLightText;
     End;
End;

Procedure TStaticTextEx.CMMouseLeave;
Begin
     Inherited;
     If Down Then Begin
        Color:=cl3DLight;
        Font.Color:=clBtnText;
     End Else Begin
        Color:=clBtnFace;
        Font.Color:=clBtnText;
     End;
End;

Procedure TStaticTextEx.SetDown;
Begin
     fDown:=Value;
     If Down Then Begin
        Color:=cl3DLight;
        Font.Color:=clBtnText;
        BorderStyle:=sbsSunken;
     End Else Begin
        Color:=clBtnFace;
        Font.Color:=clBtnText;
        BorderStyle:=sbsNone;
     End;
End;

end.
