unit SetAttrForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, MainForm;

type
  TFrmSetAttr = class(TForm)
    BvlLine: TBevel;
    Bevel1: TBevel;
    Label3: TLabel;
    Label4: TLabel;
    LblSubDirs: TLabel;
    LblFileNum: TLabel;
    ImgSetAttr: TImage;
    BtnOK: TButton;
    BtnCancel: TButton;
    GrpOptions: TGroupBox;
    ChkRecursive: TCheckBox;
    ChkUseFilter: TCheckBox;
    ChkArchive: TCheckBox;
    ChkReadOnly: TCheckBox;
    ChkHidden: TCheckBox;
    ChkSysFile: TCheckBox;
    BtnHelp: TButton;
    procedure FormActivate(Sender: TObject);
    procedure ChkRecursiveClick(Sender: TObject);
    procedure ChkUseFilterClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BtnHelpClick(Sender: TObject);
  private
    { Private-Deklarationen }
    Procedure WMNCHitTest(Var Msg: TMessage); Message WM_NCHITTEST;
  public
    { Public-Deklarationen }
    SourceList: Integer;
  end;

var
  FrmSetAttr: TFrmSetAttr;

implementation

{$R *.DFM}


procedure TFrmSetAttr.FormActivate(Sender: TObject);
begin
     BtnOK.SetFocus;
     ChkrecursiveClick(Nil);
end;

Procedure TFrmSetAttr.ChkRecursiveClick(Sender: TObject);
Var
   FileNum, DirNum, HiddenFiles, SysFiles, ReadOnlyFiles, ArchiveFiles: Longint;
   SizeInBytes: Int64;
   ObjNum: Integer;
Begin
     ChkUseFilter.Enabled:=ChkRecursive.Checked;
     HiddenFiles:=0;
     SysFiles:=0;
     ReadOnlyFiles:=0;
     ArchiveFiles:=0;
     DirInfoEx(False, ChkRecursive.Checked, ChkUseFilter.Checked, SourceList, FileNum, DirNum,
               SizeInBytes, SysFiles, HiddenFiles, ReadOnlyFiles, ArchiveFiles);
     ObjNum:=FileNum+DirNum;
     LblSubDirs.Caption:=Formatted(DirNum);
     LblFileNum.Caption:=Formatted(FileNum);
     If HiddenFiles >= ObjNum Then
        ChkHidden.State:=cbChecked
     Else If HiddenFiles = 0 Then
        ChkHidden.State:=cbUnchecked
     Else
        ChkHidden.State:=cbGrayed;
     If SysFiles >= ObjNum Then
        ChkSysFile.State:=cbChecked
     Else If SysFiles = 0 Then
        ChkSysFile.State:=cbUnchecked
     Else
        ChkSysFile.State:=cbGrayed;
     If ReadOnlyFiles >= ObjNum Then
        ChkReadOnly.State:=cbChecked
     Else If ReadOnlyFiles = 0 Then
        ChkReadOnly.State:=cbUnchecked
     Else
        ChkReadOnly.State:=cbGrayed;
     If ArchiveFiles >= ObjNum Then
        ChkArchive.State:=cbChecked
     Else If ArchiveFiles = 0 Then
        ChkArchive.State:=cbUnchecked
     Else
        ChkArchive.State:=cbGrayed;
End;

procedure TFrmSetAttr.ChkUseFilterClick(Sender: TObject);
begin
     ChkRecursiveClick(Nil);
end;

procedure TFrmSetAttr.FormCreate(Sender: TObject);
begin
     HelpContext:=IDH_FileSetAttr;
end;

procedure TFrmSetAttr.BtnHelpClick(Sender: TObject);
begin
     Application.HelpCommand(HELP_CONTEXT, HelpContext);
End;

Procedure TFrmSetAttr.WMNCHitTest(Var Msg : TMessage);
Var
   i: Integer;
   r: TRect;
   ctrl: TControl;

Function LeftMouseButtonPressed: Boolean;
Begin
     If GetSystemMetrics(SM_SWAPBUTTON) = 0 Then
        Result:=(GetAsyncKeyState(VK_LBUTTON) < 0)
     Else
        Result:=(GetAsyncKeyState(VK_RBUTTON) < 0);
End;

Begin
     If Options.WindowClientDraggable And LeftMouseButtonPressed Then Begin
        If (Msg.LParamLo >= Self.ClientToScreen(Point(0, 0)).x) And
           (Msg.LParamHi >= Self.ClientToScreen(Point(0, 0)).y) And
           (Msg.LParamLo <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).x) And
           (Msg.LParamHi <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).y)
        Then Begin
             For i:=0 To Self.ComponentCount-1 Do Begin
                 Try
                    If Self.Components[i] Is TControl Then Begin
                       ctrl:=TControl(Self.Components[i]);
                       r:=ctrl.BoundsRect;
                       If (Msg.LParamLo >= Self.ClientToScreen(Point(r.Left, r.Top)).x) And
                          (Msg.LParamHi >= Self.ClientToScreen(Point(r.Left, r.Top)).y) And
                          (Msg.LParamLo <= Self.ClientToScreen(Point(r.Right, r.Bottom)).x) And
                          (Msg.LParamHi <= Self.ClientToScreen(Point(r.Right, r.Bottom)).y) And ctrl.Visible
                       Then Begin
                          Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                          Exit;
                       End;
                    End;
                 Except
                    Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                    Exit;
                 End;
             End;
             Msg.Result:=HTCAPTION
        End Else
           Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
     End Else
        Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
End;

end.
