Unit SearchDir;

Interface

Uses
    Forms, Windows, Controls, SysUtils, dialogs;

Const
   // Fehlerkonstanten
   rsSuccessful    = 0;
   rsReadError     = 1;
   rsCanceled      = 2;
   rsInvalidFilter = 3;
   // CallBacks-Konstanten
   cbBeforeRecurse = 1;
   cbAfterRecurse  = 2;
   // CallBackType-Konstanten
   ctEnteringDir   =-1;
   ctNormal        = 0;
   ctLeavingDir    = 1;

Type
   // CallBack-Prozedur
   TSearchDirectoryCallBack = Procedure(Const Path: String; Const FindData: TWin32FindData; CallBackType: Integer);

   // Filter-Record
   TFilterRec = Record
      Include, Exclude: String[255];
      ReadOnly, SysFile, Hidden, Directory: Boolean;
      MinSize, MaxSize: Cardinal;
      UseDate: Boolean;
      MinDate, MaxDate: TFileTime;
   End;

   // SearchDirectory-Objekt
   TSearchDirectory = Object
      Private
         fCanceled: Boolean;
         fProcessMessages: Boolean;
         fCallBacks: Integer;
         Procedure SetCanceled(Cancel: Boolean);
         Procedure SetProcessMessages(ProcessMsg: Boolean);
         Procedure SetCallBacks(Value: Integer);
      Public
         CallBack: TSearchDirectoryCallBack;
         Constructor Init;
         Function Search(Path: String; Const Filter: TFilterRec; Recursive, ForceDirectory: Boolean): Integer;
         Property Canceled: Boolean Read fCanceled Write SetCanceled;
         Property ProcessMessages: Boolean Read fProcessMessages Write SetProcessMessages;
         Property CallBacks: Integer Read fCallBacks Write SetCallBacks;
   End;

Function FileTimeToDateTime(Const FileTime: TFileTime): TDateTime;
Function DateTimeToFileTime(Const DateTime: TDateTime): TFileTime;
Function Like(Const Expression, Mask: String): Boolean;

Implementation

Function FileTimeToDateTime;
Var
   SystemTime: TSystemTime;
Begin
     FileTimeToSystemTime(FileTime, SystemTime);
     Result:=SystemTimeToDateTime(SystemTime);
End;

Function DateTimeToFileTime;
Var
   SystemTime: TSystemTime;
Begin
     DateTimetoSystemTime(DateTime, SystemTime);
     SystemTimeToFileTime(SystemTime, Result);
End;

Constructor TSearchDirectory.Init;
Begin
     Inherited;
     CallBack:=Nil;
     fCanceled:=False;
     fProcessMessages:=False;
     fCallBacks:=cbBeforeRecurse;
End;

Procedure TSearchDirectory.SetCanceled(Cancel: Boolean);
Begin
     fCanceled:=Cancel;
End;

Procedure TSearchDirectory.SetProcessMessages(ProcessMsg: Boolean);
Begin
     fProcessMessages:=ProcessMsg;
     If ProcessMsg Then Application.ProcessMessages;
End;

Procedure TSearchDirectory.SetCallBacks;
Begin
     fCallBacks:=Value;
End;

Function Stri(i: Integer): String;
Begin
     Str(i, Result);
End;

Function Like(Const Expression, Mask: String): Boolean;
Var
   MaskChar: Char;
   i: Integer;
   ExpressionPos, ExpressionLen: Integer;
   Len: Integer;
Begin
     Len:=Length(Mask);
     If Len = 0 Then Begin
        Result:=True;
        Exit;
     End;
     Result:=False;
     i:=1;
     ExpressionPos:=1;
     ExpressionLen:=Length(Expression);
     Repeat
           MaskChar:=Mask[i];
           Case MaskChar Of
                '*': Begin
                          If i < Len Then Begin
                             MaskChar:=Mask[i+1];
                             While Expression[ExpressionPos] <> MaskChar Do Begin
                                   Inc(ExpressionPos);
                                   If ExpressionPos > ExpressionLen Then Exit;
                             End;
                          End Else If i > Len Then
                             Exit;
                     End;
                '?': Begin
                          If ExpressionPos <= ExpressionLen Then
                             Inc(ExpressionPos)
                          Else
                             Exit;
                     End;
                Else Begin
                     If ExpressionPos > ExpressionLen Then Exit;
                     If Expression[ExpressionPos] <> MaskChar Then Exit;
                     Inc(ExpressionPos);
                End;
           End;
           Inc(i);
     Until i > Len;
     If (ExpressionPos <= ExpressionLen) And (Mask[Len] <> '*') Then
        Result:=False
     Else
        Result:=True;
End;

Function TSearchDirectory.Search;
{
   Diese Funktion ist das Herzstck der Unit. Sie durchsucht unter Verwendung des
   angegebenen Filters das angegebene Verzeichnis (falls gewnscht, auch die der
   Unterverzeichnisse) und ruft die eingestellte CallBack-Funktion auf, wenn
   eine Datei gefunden wird, die dem Filter entspricht.
   Sie bricht ab, wenn whrend des Vorgangs die Canceled-Eigenschaft des
   Objekts auf True gesetzt wird.
}
Var
   Includes: Array[0..127] Of String; // Nimmt die einzelnen einschliessenden Wildcards auf
   Excludes: Array[0..127] Of String; //   "   "      "      auschliessenden     "       "
   IncludeNum, ExcludeNum: Integer;   // Jeweilige Anzahl der Wildcards
   StartCopy, i, Len: Integer;        // Temporre Variablen
   AttrMask, Attr: Cardinal;          // Werden zur Attribut-berpffung gebraucht
   CheckNeedless: Boolean;            // Ist True, wenn Include = '*.*';

Function RecurseSubDir(Const Path: String): Integer;
{
   Liest alle dem Filter entprechenden Dateien ein (ggf. einschlielich
   Unterverzeichnissen).
}
Label
   Included, // Hierhin wird gesprungen, wenn eine Datei eingeschlossen ist
   Worthy,   // Hierhin wird gesprungen, wenn eine Datei dem Filter entpricht
   Unworthy, // Hierhin wird gesprungen, wenn die Datei dem Filter nicht entspricht
   FuckOff;  // Hierhin wird gesprungen, wenn die "Datei" .. oder . heisst...
Var
   Handle: THandle;     // FindFirstFile und FindNextFile brauchen einen Handle
   Dat: TWin32FindData; //       "        "       "       benutzen diesen Record
   FindResult: Boolean; // Wurde eine Datei gefunden?
   i: Integer;          // Kann man immer brauchen...
Begin
     If Canceled Then Begin
        Result:=rsCanceled;
        Exit;
     End Else Result:=rsSuccessful;
     // Erste Datei einlesen
     Handle:=FindFirstFile(PChar(Path+'*.*'), Dat);
     If Handle <> INVALID_HANDLE_VALUE Then Begin
        // Alle Dateien nacheinander abklappern
        FindResult:=True;
        While FindResult Do Begin
              // Attribute berprfen
              If ((AttrMask And Dat.dwFileAttributes) Or Attr) <> Attr Then GoTo Unworthy;
              // Wenn Forcedirectory = True und die Datei ein Verzeichnis ist,
              // dann in jedem Fall die Callback-Funktion aufrufen
              If ForceDirectory And ((Dat.dwFileAttributes And FILE_ATTRIBUTE_DIRECTORY) > 0) Then Goto Worthy;
              // Dateigre berprfen
              If (Filter.MinSize <> 0) And (Dat.nFileSizeLow < Filter.MinSize) Then Goto Unworthy;
              If (Filter.Maxsize <> 0) And (Dat.nFileSizeLow > Filter.MaxSize) Then Goto Unworthy;
              // berprfen, ob der Name eingeschlossen ist
              If Not CheckNeedless Then Begin
                 For i:=0 To IncludeNum-1 Do
                     If Like(AnsiUpperCase(Dat.cFileName), Includes[i]) Then Goto Included;
                 Goto Unworthy;
              End;
        Included:
              // Datei-Datum berprfen
              If Filter.UseDate Then Begin
                 If CompareFileTime(Dat.ftLastWriteTime, Filter.MinDate) < 0 Then Goto Unworthy;
                 If CompareFileTime(Dat.ftLastWriteTime, Filter.MaxDate) > 0 Then Goto Unworthy;
              End;
              // berprfen, ob der Name ausgeschlossen wurde
              If ExcludeNum > 0 Then Begin
                 For i:=0 To ExcludeNum-1 Do
                     If Like(AnsiUpperCase(Dat.cFileName), Excludes[i]) Then Goto Unworthy;
              End;
        Worthy:
              // berprfen, ob der Name "." oder ".." ist
              If Dat.cFileName[0] = '.' Then Begin
                 If (String(Dat.cFilename) = '.') Or (String(Dat.cFilename) = '..') Then Goto FuckOff;
              End;
              // Ggf. die Callback-Funktion ausfhren
              If ((Dat.dwFileAttributes And faDirectory) > 0) And Recursive Then Begin
                 If ((CallBacks And cbBeforeRecurse) > 0) And Assigned(CallBack) Then
                    CallBack(Path, Dat, ctEnteringDir);
              End Else If Assigned(CallBack) Then CallBack(Path, Dat, ctNormal);
        Unworthy:
              // Windows-Nachrichten abarbeiten, damit das Programm nicht
              // durch das Einlesen der Dateien blockiert wird
              // (so kann z.B. ein Abbruch-Schalter bettigt werden...
              If ProcessMessages Then Application.ProcessMessages;
              // Falls ein Abbruch gewnscht wird, diesen Wunsch erfllen...
              If Canceled Then Begin
                 Result:=rsCanceled;
                 Windows.FindClose(Handle);
                 Exit;
              End;
              // Falls gewnscht, Unterverzeichnisse rekursiv durchsuchen
              If Recursive Then If ((Dat.dwFileAttributes And FILE_ATTRIBUTE_DIRECTORY) <> 0) Then Begin
                 Result:=RecurseSubDir(Path+String(Dat.cFileName)+'\');
                 // Falls irgendwas schiefgegangen ist, abbrechen
                 If Result <> rsSuccessful Then Begin
                    Windows.FindClose(Handle);
                    Exit;
                 End;
              End;
              // Ggf. die Callback-Funktion ausfhren
              If ((CallBacks And cbAfterRecurse) > 0) And Assigned(CallBack) Then Begin
                 If ((Dat.dwFileAttributes And faDirectory) > 0) Then Begin
                    If Recursive Then
                       CallBack(Path, Dat, ctLeavingDir)
                    Else
                       CallBack(Path, Dat, ctNormal);
                 End;
              End;
        FuckOff:
              // Nchste Datei einlesen
              FindResult:=FindNextFile(Handle, Dat);
        End;
        // Handle wieder freigeben
        Windows.FindClose(Handle);
     End;
End;

Begin
     // ggf. Pfadangabe korrigieren
     If Length(Path) > 0 Then
        If Path[Length(Path)] <> '\' Then Path:=Path+'\';

     // Wenn kein Einschliessen-String, abbrechen
     If Length(Trim(Filter.Include)) = 0 Then Begin
        Result:=rsInvalidFilter;
        Exit;
     End;

     // Einschliessen-String zerlegen
     IncludeNum:=0;
     i:=0;
     StartCopy:=1;
     Len:=Length(Filter.Include);
     Repeat
           Inc(i);
           If i > Len Then Begin
              Includes[IncludeNum]:=AnsiUpperCase(Trim(Copy(Filter.Include, StartCopy, i-StartCopy)));
              Inc(IncludeNum);
           End Else If (Filter.Include[i] = ';') Then Begin
              Includes[IncludeNum]:=AnsiUpperCase(Trim(Copy(Filter.Include, StartCopy, i-StartCopy)));
              Inc(IncludeNum);
              StartCopy:=i+1;
           End;
     Until i > Len;

     // Ausschliessen-String zerlegen
     ExcludeNum:=0;
     If Length(Trim(Filter.Exclude)) > 0 Then Begin
        i:=0;
        StartCopy:=1;
        Len:=Length(Filter.Exclude);
        Repeat
              Inc(i);
              If i > Len Then Begin
                 Excludes[ExcludeNum]:=AnsiUpperCase(Trim(Copy(Filter.Exclude, StartCopy, i-StartCopy)));
                 Inc(ExcludeNum);
              End Else If (Filter.Exclude[i] = ';') Then Begin
                 Excludes[ExcludeNum]:=AnsiUpperCase(Trim(Copy(Filter.Exclude, StartCopy, i-StartCopy)));
                 Inc(ExcludeNum);
                 StartCopy:=i+1;
              End;
        Until i > Len;
     End;

     // Dateien einlesen
     If (IncludeNum = 1) And (Includes[0] = '*.*') Then
        CheckNeedless:=True
     Else
        CheckNeedless:=False;
     Canceled:=False;
     AttrMask:=FILE_ATTRIBUTE_DIRECTORY+FILE_ATTRIBUTE_HIDDEN+FILE_ATTRIBUTE_SYSTEM+FILE_ATTRIBUTE_READONLY;
     Attr:=0;
     If Filter.Directory Then Inc(Attr, FILE_ATTRIBUTE_DIRECTORY);
     If Filter.ReadOnly then Inc(Attr, FILE_ATTRIBUTE_READONLY);
     If Filter.Hidden Then Inc(Attr, FILE_ATTRIBUTE_HIDDEN);
     If Filter.SysFile Then Inc(Attr, FILE_ATTRIBUTE_SYSTEM);
     Result:=RecurseSubDir(Path)
End;

End.
