Unit PrevMulti;

Interface

Uses
    Windows, MainForm, SysUtils, inifiles, Classes, Forms;

Function PreviousInstanceIsRunning: Boolean;
Procedure FreeMultiInstancePreventingResources;
Procedure ActivatePreviousInstance;

Implementation

Const
     mutex_name = 'EXEC_BY_JAN_STRAETER_IS_RUNNING';

Var
   MutexHandle: THandle;

Function PreviousInstanceIsRunning;
Var
   PreventMultiInstances: Boolean;
   f: TINIFile;
Begin
     ProgPath:=ExtractFilePath(ParamStr(0));

     f:=TINIFile.Create(ProgPath+IniFilename);
     PreventMultiInstances:=f.ReadBool(EnhancedSection, 'PreventMultiInstances', False);
     f.Free;

     If PreventMultiInstances Then Begin
        MutexHandle:=CreateMutex(Nil, False, mutex_name);
        If (MutexHandle <> 0) And (GetLastError = ERROR_ALREADY_EXISTS) Then Begin
           Result:=True;
           MutexHandle:=0;
        End Else
           Result:=False;
     End Else Result:=False;
End;

Procedure FreeMultiInstancePreventingResources;
Begin
     If MutexHandle <> 0 Then
        CloseHandle(MutexHandle);
End;

Procedure ActivatePreviousInstance;
Var
   PrevhWnd: hWnd;
Begin
     Application.Title:='';
     PrevhWnd:=FindWindowEx(0, 0, PChar(eXec_WNDCLASS), PChar(eXec_Caption));
     If PrevhWnd <> 0 Then Begin
        SetForegroundWindow(PrevhWnd);
        If IsIconic(PrevhWnd) Then
           ShowWindowAsync(PrevhWnd, SW_RESTORE);
     End;
     Application.Title:=eXec_Caption;
End;

Initialization
   MutexHandle:=0;
Finalization
   FreeMultiInstancePreventingResources;
End.
