unit GoToForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons;

type
  TFrmGoTo = class(TForm)
    BtnOK: TButton;
    BtnCancel: TButton;
    EdtGoTo: TEdit;
    Label1: TLabel;
    SpdBrowse: TSpeedButton;
    Bevel1: TBevel;
    BtnHelp: TButton;
    procedure BtnBrowseClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure BtnOKClick(Sender: TObject);
    procedure EdtGoToChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BtnHelpClick(Sender: TObject);
  private
    { Private-Deklarationen }
    Procedure WMNCHitTest(Var Msg: TMessage); Message WM_NCHITTEST;
  public
    { Public-Deklarationen }
  end;

var
  FrmGoTo: TFrmGoTo;

implementation

{$R *.DFM}

Uses
    MainForm;

procedure TFrmGoTo.BtnBrowseClick(Sender: TObject);
Var
   Path: String;
begin
     Path:=BrowseDir('Whlen Sie ein Verzeichnis.',Handle);
     If Path <> '' Then EdtGoTo.Text:=Path;
     EdtGoTo.SelStart:=0;
     EdtGoTo.SelLength:=Length(EdtGoto.Text);
     EdtGoTo.SetFocus;
end;

procedure TFrmGoTo.FormActivate(Sender: TObject);
begin
     EdtGoTo.SelStart:=0;
     EdtGoTo.SelLength:=Length(EdtGoto.Text);
     EdtGoTo.SetFocus;
     EdtGoToChange(Sender);
end;

procedure TFrmGoTo.BtnOKClick(Sender: TObject);
Var
   TmpPath: String;
   OldPath: String;
begin
     {$I-}
     IOResult;
     TmpPath:=EdtGoTo.Text;
     If TmpPath[Length(TmpPath)] <> '\' Then TmpPath:=TmpPath+'\';
     GetDir(0,OldPath);
     IOResult;
     ChDir(TmpPath);
     If IOResult <> 0 Then Begin
        MessageDlg('Das angegebene Verzeichnis ist ungltig.',mtError,[mbOK],0);
     End Else Begin
        FrmGoTo.ModalResult:=mrOK;
     End;
     ChDir(OldPath);
     IOResult;
end;

procedure TFrmGoTo.EdtGoToChange(Sender: TObject);
begin
     If EdtGoTo.Text <> '' Then BtnOK.Enabled:=True Else BtnOK.Enabled:=False;
end;



procedure TFrmGoTo.FormCreate(Sender: TObject);
begin
     HelpContext:=IDH_PathGoTo;
end;

procedure TFrmGoTo.BtnHelpClick(Sender: TObject);
begin
     Application.HelpCommand(HELP_CONTEXT, HelpContext);
end;

Procedure TFrmGoTo.WMNCHitTest(Var Msg : TMessage);
Var
   i: Integer;
   r: TRect;
   ctrl: TControl;

Function LeftMouseButtonPressed: Boolean;
Begin
     If GetSystemMetrics(SM_SWAPBUTTON) = 0 Then
        Result:=(GetAsyncKeyState(VK_LBUTTON) < 0)
     Else
        Result:=(GetAsyncKeyState(VK_RBUTTON) < 0);
End;

Begin
     If Options.WindowClientDraggable And LeftMouseButtonPressed Then Begin
        If (Msg.LParamLo >= Self.ClientToScreen(Point(0, 0)).x) And
           (Msg.LParamHi >= Self.ClientToScreen(Point(0, 0)).y) And
           (Msg.LParamLo <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).x) And
           (Msg.LParamHi <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).y)
        Then Begin
             For i:=0 To Self.ComponentCount-1 Do Begin
                 Try
                    If Self.Components[i] Is TControl Then Begin
                       ctrl:=TControl(Self.Components[i]);
                       r:=ctrl.BoundsRect;
                       If (Msg.LParamLo >= Self.ClientToScreen(Point(r.Left, r.Top)).x) And
                          (Msg.LParamHi >= Self.ClientToScreen(Point(r.Left, r.Top)).y) And
                          (Msg.LParamLo <= Self.ClientToScreen(Point(r.Right, r.Bottom)).x) And
                          (Msg.LParamHi <= Self.ClientToScreen(Point(r.Right, r.Bottom)).y) And ctrl.Visible
                       Then Begin
                          Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                          Exit;
                       End;
                    End;
                 Except
                    Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                    Exit;
                 End;
             End;
             Msg.Result:=HTCAPTION
        End Else
           Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
     End Else
        Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
End;

end.
