unit FormatForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, BJDrive, ExtCtrls;

type
  TFrmFormat = class(TForm)
    Bevel1: TBevel;
    BtnOK: TButton;
    BtnClose: TButton;
    Label1: TLabel;
    BjdFormat: TBJDrive;
    GroupBox1: TGroupBox;
    Label2: TLabel;
    BtnHelp: TButton;
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BtnHelpClick(Sender: TObject);
  private
    { Private-Deklarationen }
    Procedure WMNCHitTest(Var Msg: TMessage); Message WM_NCHITTEST;
  public
    { Public-Deklarationen }
  end;

var
  FrmFormat: TFrmFormat;

implementation

{$R *.DFM}


Uses
    MainForm;

procedure TFrmFormat.FormShow(Sender: TObject);
begin
     BjdFormat.Drive:='A';
     BjdFormat.SetFocus;
end;

procedure TFrmFormat.FormCreate(Sender: TObject);
begin
     HelpContext:=IDH_MediaFormat;
end;

procedure TFrmFormat.BtnHelpClick(Sender: TObject);
begin
     Application.HelpCommand(HELP_CONTEXT, HelpContext);
end;

Procedure TFrmFormat.WMNCHitTest(Var Msg : TMessage);
Var
   i: Integer;
   r: TRect;
   ctrl: TControl;

Function LeftMouseButtonPressed: Boolean;
Begin
     If GetSystemMetrics(SM_SWAPBUTTON) = 0 Then
        Result:=(GetAsyncKeyState(VK_LBUTTON) < 0)
     Else
        Result:=(GetAsyncKeyState(VK_RBUTTON) < 0);
End;

Begin
     If Options.WindowClientDraggable And LeftMouseButtonPressed Then Begin
        If (Msg.LParamLo >= Self.ClientToScreen(Point(0, 0)).x) And
           (Msg.LParamHi >= Self.ClientToScreen(Point(0, 0)).y) And
           (Msg.LParamLo <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).x) And
           (Msg.LParamHi <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).y)
        Then Begin
             For i:=0 To Self.ComponentCount-1 Do Begin
                 Try
                    If Self.Components[i] Is TControl Then Begin
                       ctrl:=TControl(Self.Components[i]);
                       r:=ctrl.BoundsRect;
                       If (Msg.LParamLo >= Self.ClientToScreen(Point(r.Left, r.Top)).x) And
                          (Msg.LParamHi >= Self.ClientToScreen(Point(r.Left, r.Top)).y) And
                          (Msg.LParamLo <= Self.ClientToScreen(Point(r.Right, r.Bottom)).x) And
                          (Msg.LParamHi <= Self.ClientToScreen(Point(r.Right, r.Bottom)).y) And ctrl.Visible
                       Then Begin
                          Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                          Exit;
                       End;
                    End;
                 Except
                    Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                    Exit;
                 End;
             End;
             Msg.Result:=HTCAPTION
        End Else
           Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
     End Else
        Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
End;

end.
