Unit FormatDrive;

Interface

{   ****************************************************************
   The SHFormatDrive API provides access to the Shell's format
   dialog box. This allows applications that want to format disks to bring
   up the same dialog box that the Shell uses for disk formatting.

   PARAMETERS
      hwnd    = The window handle of the window that will own the
                dialog. NOTE that hwnd == NULL does not cause this
                dialog to come up as a "top level application"
                window. This parameter should always be non-null,
                this dialog box is only designed to be the child of
                another window, not a stand-alone application.

      drive   = The 0 based (A: == 0) drive number of the drive
                to format.

      fmtID   = Currently must be set to SHFMT_ID_DEFAULT.

      options = There are currently only two option bits defined.

                   SHFMT_OPT_FULL
                   SHFMT_OPT_SYSONLY

                SHFMT_OPT_FULL specifies that the "Quick Format"
                setting should be cleared by default. If the user
                leaves the "Quick Format" setting cleared, then a
                full format will be applied (this is useful for
                users that detect "unformatted" disks and want
                to bring up the format dialog box).

                If options is set to zero (0), then the "Quick Format"
                setting is set by default. In addition, if the user leaves
                it set, a quick format is performed. Under Windows NT 4.0,
                this flag is ignored and the "Quick Format" box is always
                checked when the dialog box first appears. The user can
                still change it. This is by design.

                The SHFMT_OPT_SYSONLY initializes the dialog to
                default to just sys the disk.

                All other bits are reserved for future expansion
                and must be 0.

                Please note that this is a bit field and not a
                value, treat it accordingly.

      RETURN
         The return is either one of the SHFMT_* values, or if
         the returned DWORD value is not == to one of these
         values, then the return is the physical format ID of the
         last successful format. The LOWORD of this value can be
         passed on subsequent calls as the fmtID parameter to
         "format the same type you did last time".

   *****************************************************************}

Const
     //
     // Special value of fmtID which means "use the defaultformat"
     //
     SHFMT_ID_DEFAULT = $FFFF;

     //
     // Option bits for options parameter
     //
     SHFMT_OPT_FULL = $0001;
     SHFMT_OPT_SYSONLY = $0002;

     //
     // Special return values. PLEASE NOTE that these are DWORD values.
     //
     SHFMT_ERROR = $FFFFFFFF;    // Error on last format,
     SHFMT_CANCEL = $FFFFFFFE;    // Last format wascanceled
     SHFMT_NOFORMAT = $FFFFFFFD;    // Drive is not formatable

Function SHFormatDrive(hwnd, drive, fmtID, options: Integer): Integer; StdCall;

Implementation

Function SHFormatDrive; StdCall; External 'SHELL32.DLL';

End.
