unit FormDrive;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, FileCtrl, BJDrive;

type
  TFrmChangeDriveDir = class(TForm)
    LstDir: TDirectoryListBox;
    LblDir: TLabel;
    LblDrive: TLabel;
    BtnOK: TButton;
    BtnCancel: TButton;
    BvlLine: TBevel;
    CboDrive: TBJDrive;
    BtnHelp: TButton;
    procedure CboDriveChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure CboDriveKeyPress(Sender: TObject; var Key: Char);
    procedure BtnHelpClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private-Deklarationen }
    Procedure WMNCHitTest(Var Msg: TMessage); Message WM_NCHITTEST;
  public
    { Public-Deklarationen }
  end;

var
  FrmChangeDriveDir: TFrmChangeDriveDir;

implementation

{$R *.DFM}

Uses
    MainForm;

procedure TFrmChangeDriveDir.CboDriveChange(Sender: TObject);
Var
   Dr: Char;
   Dummy, Result: Integer;
begin
     {$I-}
     Dr:=UpCase(CboDrive.Drive);
     IOResult;
     Repeat
           Dummy:=mrRetry;
           ChDir(Dr+':\');
           Result:=IOResult;
           If Result = 0 Then Begin
              LstDir.Directory:=Dr+':\';
           End Else Begin
              Dummy:=MessageDlg('Vom Datentrger in Laufwerk '+Dr+': kann nicht gelesen werden.',
                                mtError, [mbRetry, mbCancel], 0);
           End;
     Until (Result = 0) Or (Dummy <> mrRetry);
     If Result <> 0 Then CboDrive.Drive:=Data[0].Directory[1];
     {$I+}
end;

procedure TFrmChangeDriveDir.FormShow(Sender: TObject);
begin
     CboDrive.SetFocus;
end;

procedure TFrmChangeDriveDir.CboDriveKeyPress(Sender: TObject;
  var Key: Char);
begin
     If Key = #13 Then FrmChangeDriveDir.ModalResult:=mrOK;
end;

procedure TFrmChangeDriveDir.BtnHelpClick(Sender: TObject);
begin
     Application.HelpCommand(HELP_CONTEXT, HelpContext);
end;

procedure TFrmChangeDriveDir.FormCreate(Sender: TObject);
begin
     HelpContext:=IDH_PanelsDriveDir;
end;

Procedure TFrmChangeDriveDir.WMNCHitTest(Var Msg : TMessage);
Var
   i: Integer;
   r: TRect;
   ctrl: TControl;

Function LeftMouseButtonPressed: Boolean;
Begin
     If GetSystemMetrics(SM_SWAPBUTTON) = 0 Then
        Result:=(GetAsyncKeyState(VK_LBUTTON) < 0)
     Else
        Result:=(GetAsyncKeyState(VK_RBUTTON) < 0);
End;

Begin
     If Options.WindowClientDraggable And LeftMouseButtonPressed Then Begin
        If (Msg.LParamLo >= Self.ClientToScreen(Point(0, 0)).x) And
           (Msg.LParamHi >= Self.ClientToScreen(Point(0, 0)).y) And
           (Msg.LParamLo <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).x) And
           (Msg.LParamHi <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).y)
        Then Begin
             For i:=0 To Self.ComponentCount-1 Do Begin
                 Try
                    If Self.Components[i] Is TControl Then Begin
                       ctrl:=TControl(Self.Components[i]);
                       r:=ctrl.BoundsRect;
                       If (Msg.LParamLo >= Self.ClientToScreen(Point(r.Left, r.Top)).x) And
                          (Msg.LParamHi >= Self.ClientToScreen(Point(r.Left, r.Top)).y) And
                          (Msg.LParamLo <= Self.ClientToScreen(Point(r.Right, r.Bottom)).x) And
                          (Msg.LParamHi <= Self.ClientToScreen(Point(r.Right, r.Bottom)).y) And ctrl.Visible
                       Then Begin
                          Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                          Exit;
                       End;
                    End;
                 Except
                    Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                    Exit;
                 End;
             End;
             Msg.Result:=HTCAPTION
        End Else
           Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
     End Else
        Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
End;

end.
