unit FilterForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, Buttons, ExtCtrls, SearchDir, MainForm;

Const
  MaxFilterList = 63;

type
  TSavedFilterRec = Record
     Filter: TFilterRec;
     Name: ShortString;
  End;
  TFrmFilter = class(TForm)
    PagFilter: TPageControl;
    TabName: TTabSheet;
    TabAttributes: TTabSheet;
    TabSize: TTabSheet;
    TabDate: TTabSheet;
    Label1: TLabel;
    Label2: TLabel;
    EdtInclude: TEdit;
    EdtExclude: TEdit;
    Label3: TLabel;
    GroupBox1: TGroupBox;
    ChkDirectory: TCheckBox;
    ChkSysFile: TCheckBox;
    ChkHidden: TCheckBox;
    ChkReadOnly: TCheckBox;
    Image1: TImage;
    Label4: TLabel;
    CboFilter: TComboBox;
    Bevel1: TBevel;
    BtnOK: TButton;
    BtnCancel: TButton;
    SpdDeleteFilter: TSpeedButton;
    SpdSaveFilter: TSpeedButton;
    Label5: TLabel;
    Label6: TLabel;
    EdtMinBytes: TEdit;
    EdtMaxBytes: TEdit;
    Label7: TLabel;
    RdoAllFiles: TRadioButton;
    RdoFilesBetween: TRadioButton;
    DateFrom: TDateTimePicker;
    Label8: TLabel;
    DateTo: TDateTimePicker;
    Label9: TLabel;
    BtnReset: TButton;
    BtnHelp: TButton;
    procedure EdtMinBytesKeyPress(Sender: TObject; var Key: Char);
    procedure EdtMaxBytesKeyPress(Sender: TObject; var Key: Char);
    procedure EdtIncludeChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CboFilterChange(Sender: TObject);
    procedure SpdSaveFilterClick(Sender: TObject);
    procedure BtnResetClick(Sender: TObject);
    procedure SpdDeleteFilterClick(Sender: TObject);
    procedure BtnHelpClick(Sender: TObject);
  private
    { Private-Deklarationen }
    Procedure WMNCHitTest(Var Msg: TMessage); Message WM_NCHITTEST;
  public
    { Public-Deklarationen }
    FilterList: Array[0..MaxFilterList] Of TSavedFilterRec;
    FilterNum: Integer;
    Function GetFreeIndex(FilterName: String): Integer;
    Procedure UpdateFilterListCombo;
    Procedure SaveToFile(Filename: String);
    Procedure LoadFromFile(Filename: String);
    Procedure SetFilterRec(FilterRec: TFilterRec);
    Procedure SetFilterRecEx(FilterRec: TFilterRec);
    Function  GetFilterRec: TFilterRec;
    Property  Filter: TFilterRec Read GetFilterRec Write SetFilterRecEx;
  end;

var
  FrmFilter: TFrmFilter;

implementation

uses SaveFilterForm;

{$R *.DFM}

Const
     NumChars = '0123456789'+#8;

Function Stri(i: Longint): String;
Begin
     Str(i, Result);
End;

Procedure TFrmFilter.UpdateFilterListCombo;
Var
   i: Integer;
   FilterRec: TFilterRec;
Begin
     CboFilter.Items.Clear;
     For i:=0 To FilterNum-1 Do Begin
         CboFilter.Items.AddObject(FilterList[i].Name, TObject(i));
     End;
     FilterRec:=FrmFilter.Filter;
     CboFilter.ItemIndex:=-1;
     For i:=0 To FilterNum-1 Do With FilterList[i].Filter Do Begin
         If AnsiCompareText(FilterRec.Include, Include) = 0 Then Begin
            If AnsicompareText(FilterRec.Exclude, Exclude) = 0 Then Begin
               If (FilterRec.ReadOnly = ReadOnly) And
                  (FilterRec.Hidden = Hidden) And
                  (FilterRec.SysFile = SysFile) And
                  (FilterRec.Directory = Directory) Then Begin
                  If (FilterRec.MinSize = MinSize) And (FilterRec.MaxSize = MaxSize) Then Begin
                     If (FilterRec.UseDate = UseDate) And
                        (CompareFileTime(FilterRec.MinDate, MinDate) = 0) And
                        (CompareFileTime(FilterRec.MaxDate, MaxDate) = 0) Then Begin
                        CboFilter.OnChange:=Nil;
                        CboFilter.ItemIndex:=CboFilter.Items.IndexOf(FilterList[i].Name);
                        CboFilter.OnChange:=FrmFilter.CboFilterChange;
                     End;
                  End;
               End;
            End;
         End;
     End;
End;

Procedure TfrmFilter.SetFilterRec;
Begin
     With FilterRec Do Begin
          // Seite "Name"
          EdtInclude.Text:=Include;
          EdtExclude.Text:=Exclude;
          // Seite "Attribute"
          ChkReadOnly.Checked:=ReadOnly;
          ChkHidden.Checked:=Hidden;
          ChkSysFile.Checked:=SysFile;
          ChkDirectory.Checked:=Directory;
          // Seite "Gre"
          If MinSize > 0 Then EdtMinBytes.Text:=Stri(MinSize) Else EdtMinBytes.Text:='';
          If MaxSize > 0 Then EdtMaxBytes.Text:=Stri(MaxSize) Else EdtMaxBytes.Text:='';
          // Seite "Datum"
          If UseDate Then Begin
             RdoFilesBetween.Checked:=True;
             RdoAllFiles.Checked:=False;
          End Else Begin
             RdoFilesBetween.Checked:=False;
             RdoAllFiles.Checked:=True;
          End;
          DateFrom.Date:=FileTimeToDateTime(MinDate);
          DateTo.Date:=FileTimeToDateTime(MaxDate);
     End;
End;

Procedure TFrmFilter.SetFilterRecEx;
Var
   i: Integer;
Begin
     SetFilterRec(FilterRec);
     CboFilter.ItemIndex:=-1;
     For i:=0 To FilterNum-1 Do With FilterList[i].Filter Do Begin
         If AnsiCompareText(FilterRec.Include, Include) = 0 Then Begin
            If AnsicompareText(FilterRec.Exclude, Exclude) = 0 Then Begin
               If (FilterRec.ReadOnly = ReadOnly) And
                  (FilterRec.Hidden = Hidden) And
                  (FilterRec.SysFile = SysFile) And
                  (FilterRec.Directory = Directory) Then Begin
                  If (FilterRec.MinSize = MinSize) And (FilterRec.MaxSize = MaxSize) Then Begin
                     If (FilterRec.UseDate = UseDate) And
                        (CompareFileTime(FilterRec.MinDate, MinDate) = 0) And
                        (CompareFileTime(FilterRec.MaxDate, MaxDate) = 0) Then Begin
                        CboFilter.OnChange:=Nil;
                        CboFilter.ItemIndex:=CboFilter.Items.IndexOf(FilterList[i].Name);
                        CboFilter.OnChange:=FrmFilter.CboFilterChange;
                     End;
                  End;
               End;
            End;
         End;
     End;
End;

Function  TFrmFilter.GetFilterRec;
Begin
     With Result Do Begin
          // Seite "Name"
          Include:=EdtInclude.Text;
          Exclude:=EdtExclude.Text;
          // Seite "Attribute"
          ReadOnly:=ChkReadOnly.Checked;
          Hidden:=ChkHidden.Checked;
          SysFile:=ChkSysFile.Checked;
          Directory:=ChkDirectory.Checked;
          // Seite "Gre"
          If EdtMinBytes.Text > '' Then MinSize:=StrToInt(EdtMinBytes.Text) Else MinSize:=0;
          If EdtMaxBytes.Text > '' Then MaxSize:=StrToInt(EdtMaxBytes.Text) Else MaxSize:=0;
          // Seite "Datum"
          If RdoAllFiles.Checked Then UseDate:=False;
          If RdoFilesBetween.Checked Then UseDate:=True;
          MinDate:=DateTimeToFileTime(DateFrom.Date);
          MaxDate:=DateTimeToFileTime(DateTo.Date);
     End;
End;

procedure TFrmFilter.EdtMinBytesKeyPress(Sender: TObject; var Key: Char);
begin
     If Pos(Key, NumChars) = 0 Then Key:=#0;
end;

procedure TFrmFilter.EdtMaxBytesKeyPress(Sender: TObject; var Key: Char);
begin
     If Pos(Key, NumChars) = 0 Then Key:=#0;
end;

procedure TFrmFilter.EdtIncludeChange(Sender: TObject);
begin
     If EdtInclude.Text = '' Then BtnOK.Enabled:=False Else BtnOK.Enabled:=True;
end;

procedure TFrmFilter.FormShow(Sender: TObject);
begin
     UpdateFilterListCombo;
     PagFilter.ActivePage:=TabName;
     EdtInclude.SelectAll;
     EdtInclude.SetFocus;
end;

procedure TFrmFilter.FormCreate(Sender: TObject);
begin
     HelpContext:=IDH_PanelsFilter;
     FilterNum:=0;
end;

procedure TFrmFilter.CboFilterChange(Sender: TObject);
begin
     If CboFilter.ItemIndex > -1 Then
        SetFilterRec(FilterList[Integer(CboFilter.Items.Objects[CboFilter.ItemIndex])].Filter);
end;

Function TFrmFilter.GetFreeIndex;
Var
   i: Integer;
Begin
     If FilterNum > MaxFilterList Then Begin
        MessageDlg('Es knnen nur maximal '+Stri(MaxFilterList+1)+' Filter gespeichert werden.', mtError, [mbOK], 0);
        Result:=-1;
     End Else If FilterNum = 0 Then Begin
        Result:=0;
        FilterNum:=1;
     End Else Begin
        For i:=0 To FilterNum-1 Do Begin
            If AnsiCompareText(FilterList[i].Name, FilterName) = 0 Then Begin
               If MessageDlg('Ein Filter mit der Bezeichnung '+FilterName+' existiert bereits. berschreiben?', mtWarning, [mbYes, mbNo], 0) = mrYes Then Begin
                  Result:=i;
                  Exit;
               End Else Begin
                  Result:=-1;
                  Exit;
               End;
            End;
        End;
        Result:=FilterNum;
        Inc(FilterNum);
     End;
End;

procedure TFrmFilter.SpdSaveFilterClick(Sender: TObject);
Var
   FilterName: String;
   Index: Integer;
begin
     FrmSaveFilter.EdtName.Text:=CboFilter.Text;
     If FrmSaveFilter.ShowModal = mrOK Then Begin
        FilterName:=FrmSaveFilter.EdtName.Text;
        Index:=GetFreeIndex(FilterName);
        If Index >= 0 Then Begin
           FilterList[Index].Filter:=FrmFilter.Filter;
           FilterList[Index].Name:=FilterName;
           UpdateFilterListCombo;
        End;
     End;
end;

procedure TFrmFilter.BtnResetClick(Sender: TObject);
begin
     FrmFilter.Filter:=FilterAllFiles;
     PagFilter.ActivePage:=TabName;
     EdtInclude.SelectAll;
     EdtInclude.SetFocus;
end;

procedure TFrmFilter.SpdDeleteFilterClick(Sender: TObject);
Var
   FilterName: String;
   i: Integer;
begin
     If CboFilter.ItemIndex > -1 Then Begin
        FilterName:=CboFilter.Text;
        If MessageDlg('Wollen Sie den Filter "'+FilterName+'" wirklich lschen?', mtConfirmation, [mbYes, mbNo], 0) = mrYes Then Begin
           For i:=Integer(CboFilter.Items.Objects[CboFilter.ItemIndex]) To FilterNum-2 Do
               FilterList[i]:=FilterList[i+1];
           Dec(FilterNum);
           UpdateFilterListCombo;
           BtnResetClick(Nil);
        End;
     End;
end;

Procedure TFrmFilter.LoadFromFile;
Var
   f: File Of TSavedFilterRec;
Begin
     FilterNum:=0;
     {$I-}
     IOResult;
     AssignFile(f, Filename);
     Reset(f);
     If IOResult = 0 Then Begin
        While ((Not Eof(f)) And (FilterNum <= MaxFilterList)) Do Begin
              Read(f, FilterList[FilterNum]);
              If IOResult <> 0 Then Begin
                 CloseFile(f);
                 IOResult;
                 Exit;
              End;
              Inc(FilterNum);
        End;
        CloseFile(f);
        IOResult;
     End;
End;

Procedure TFrmFilter.SaveToFile;
Var
   f: File Of TSavedFilterRec;
   i: Integer;
Begin
     {$I-}
     IOResult;
     AssignFile(f, Filename);
     ReWrite(f);
     If IOResult = 0 Then Begin
        For i:=0 To FilterNum-1 Do Begin
            Write(f, FilterList[i]);
            If IOResult <> 0 Then Begin
               CloseFile(f);
               IOResult;
               Exit;
            End;
        End;
        CloseFile(f);
        IOResult;
     End;
End;


procedure TFrmFilter.BtnHelpClick(Sender: TObject);
begin
     Application.HelpCommand(HELP_CONTEXT, HelpContext);
end;

Procedure TFrmFilter.WMNCHitTest(Var Msg : TMessage);
Var
   i: Integer;
   r: TRect;
   ctrl: TControl;

Function LeftMouseButtonPressed: Boolean;
Begin
     If GetSystemMetrics(SM_SWAPBUTTON) = 0 Then
        Result:=(GetAsyncKeyState(VK_LBUTTON) < 0)
     Else
        Result:=(GetAsyncKeyState(VK_RBUTTON) < 0);
End;

Begin
     If Options.WindowClientDraggable And LeftMouseButtonPressed Then Begin
        If (Msg.LParamLo >= Self.ClientToScreen(Point(0, 0)).x) And
           (Msg.LParamHi >= Self.ClientToScreen(Point(0, 0)).y) And
           (Msg.LParamLo <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).x) And
           (Msg.LParamHi <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).y)
        Then Begin
             For i:=0 To Self.ComponentCount-1 Do Begin
                 Try
                    If Self.Components[i] Is TControl Then Begin
                       ctrl:=TControl(Self.Components[i]);
                       r:=ctrl.BoundsRect;
                       If (Msg.LParamLo >= Self.ClientToScreen(Point(r.Left, r.Top)).x) And
                          (Msg.LParamHi >= Self.ClientToScreen(Point(r.Left, r.Top)).y) And
                          (Msg.LParamLo <= Self.ClientToScreen(Point(r.Right, r.Bottom)).x) And
                          (Msg.LParamHi <= Self.ClientToScreen(Point(r.Right, r.Bottom)).y) And ctrl.Visible
                       Then Begin
                          Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                          Exit;
                       End;
                    End;
                 Except
                    Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                    Exit;
                 End;
             End;
             Msg.Result:=HTCAPTION
        End Else
           Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
     End Else
        Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
End;

end.
