Unit EditPathListForm;

Interface

Uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls, Menus, ExtCtrls, ComCtrls, MainForm;

Type
  TFrmEditPathList = Class(TForm)
    BtnOK: TButton;
    BtnCancel: TButton;
    Bevel1: TBevel;
    LstPaths: TListView;
    BtnEdit: TButton;
    BtnDelete: TButton;
    BtnClear: TButton;
    BtnSort: TButton;
    ChkAutoSort: TCheckBox;
    BtnHelp: TButton;
    procedure BtnEditClick(Sender: TObject);
    procedure BtnDeleteClick(Sender: TObject);
    procedure BtnClearClick(Sender: TObject);
    procedure BtnSortClick(Sender: TObject);
    procedure ChkAutoSortClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure LstPathsDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure LstPathsDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure BtnHelpClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure LstPathsKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  Private
    { Private-Deklarationen }
    Procedure WMNCHitTest(Var Msg: TMessage); Message WM_NCHITTEST;
  Public
    { Public-Deklarationen }
    Procedure UpdatePathList;
    Procedure SetNewPathList;
  End;

Var
  FrmEditPathList: TFrmEditPathList;

Implementation

uses EditPathForm;

{$R *.DFM}

Procedure TFrmEditPathList.UpdatePathList;
Var
   i: Integer;
   NewItem: TListItem;
Begin
     LstPaths.Items.Clear;
     For i:=0 To FrmMain.PathNum-1 Do Begin
         NewItem:=LstPaths.Items.Add;
         NewItem.Caption:=FrmMain.Paths[i].Path;
         NewItem.SubItems.Add(ShortCutToText(FrmMain.Paths[i].ShortCut));
     End;
End;

Procedure TFrmEditPathList.SetNewPathList;
Var
   i: Integer;
Begin
     For i:=0 To MaxPaths Do Begin
         FrmMain.Paths[i].Path:='';
         FrmMain.Paths[i].ShortCut:=TShortCut(0);
     End;
     FrmMain.PathNum:=LstPaths.Items.Count;
     For i:=0 To FrmMain.PathNum-1 Do Begin
         FrmMain.Paths[i].Path:=LstPaths.Items[i].Caption;
         FrmMain.Paths[i].ShortCut:=TextToShortCut(LstPaths.Items[i].SubItems[0]);
     End;
End;

procedure TFrmEditPathList.BtnEditClick(Sender: TObject);
Var
   Tmp: String;
begin
     If LstPaths.ItemFocused <> Nil Then With FrmEditPath Do Begin
          IndexSelf:=LstPaths.ItemFocused.Index;
          EdtPath.Text:=LstPaths.ItemFocused.Caption;
          EdtShortCut.HotKey:=TextToShortCut(LstPaths.ItemFocused.SubItems[0]);
          If FrmEditPath.ShowModal = mrOK Then Begin
             Tmp:=EdtPath.Text;
             If Tmp[Length(Tmp)] <> '\' Then Tmp:=Tmp+'\'; 
             LstPaths.ItemFocused.Caption:=Tmp;
             LstPaths.ItemFocused.SubItems[0]:=ShortCutToText(EdtShortCut.HotKey);
          End;
          LstPaths.SetFocus;
     End;
end;

procedure TFrmEditPathList.BtnDeleteClick(Sender: TObject);
Var
   Index: Integer;
begin
     If LstPaths.ItemFocused <> Nil Then Begin
        Index:=LstPaths.ItemFocused.Index;
        LstPaths.ItemFocused.Free;
        If LstPaths.Items.Count > Index Then Begin
           LstPaths.ItemFocused:=LstPaths.Items[Index];
           LstPaths.ItemFocused.Selected:=True;
        End Else Begin
           If Index > 0 Then Begin
              LstPaths.ItemFocused:=LstPaths.Items[Index-1];
              LstPaths.ItemFocused.Selected:=True;
           End;
        End;
        LstPaths.SetFocus;
     End;
end;

procedure TFrmEditPathList.BtnClearClick(Sender: TObject);
begin
     If MessageDlg('Alle Eintrge der Pfadliste werden gelscht. Fortfahren?', mtConfirmation, [mbYes, mbNo], 0) = mrYes Then
        LstPaths.Items.Clear;
end;

procedure TFrmEditPathList.BtnSortClick(Sender: TObject);
Var
   Tmp: TSortType;
begin
     Tmp:=LstPaths.SortType;
     LstPaths.SortType:=stText;
     LstPaths.AlphaSort;
     LstPaths.SortType:=Tmp;
end;

procedure TFrmEditPathList.ChkAutoSortClick(Sender: TObject);
begin
     If ChkAutoSort.Checked Then Begin
        LstPaths.SortType:=stText;
        LstPaths.AlphaSort;
        BtnSort.Enabled:=False;
     End Else Begin
        LstPaths.SortType:=stNone;
        BtnSort.Enabled:=True;
     End;
end;

procedure TFrmEditPathList.FormActivate(Sender: TObject);
begin
     If ChkAutoSort.Checked Then
        BtnSort.Enabled:=False
     Else
        BtnSort.Enabled:=True;
     LstPaths.SetFocus;
end;

procedure TFrmEditPathList.LstPathsDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
     Accept:=True;
end;

procedure TFrmEditPathList.LstPathsDragDrop(Sender, Source: TObject; X,
  Y: Integer);
Var
   SourceIndex, DestIndex: Integer;
   SourceItem, DestItem: TListItem;
begin
     If Source <> LstPaths Then Exit;
     If LstPaths.ItemFocused = Nil Then Exit;
     SourceItem:=LstPaths.ItemFocused;
     SourceIndex:=LstPaths.Items.Indexof(SourceItem);
     DestItem:=LstPaths.GetItemAt(x, y);
     If DestItem = Nil Then Exit;
     DestIndex:=LstPaths.Items.Indexof(DestItem);

     If SourceIndex = DestIndex Then
        Exit
     Else If SourceIndex < DestIndex Then Begin
        LstPaths.Items.Insert(DestIndex+1);
        LstPaths.Items[DestIndex+1]:=SourceItem;
        LstPaths.ItemFocused:=LstPaths.Items[DestIndex+1];
        LstPaths.ItemFocused.Selected:=True;
        SourceItem.Free;
     End Else If SourceIndex > DestIndex Then Begin
        LstPaths.Items.Insert(DestIndex);
        LstPaths.Items[DestIndex]:=SourceItem;
        LstPaths.ItemFocused:=LstPaths.Items[DestIndex];
        LstPaths.ItemFocused.Selected:=True;
        SourceItem.Free;
     End;

end;

procedure TFrmEditPathList.FormCreate(Sender: TObject);
begin
     HelpContext:=IDH_PathEditList;
end;

procedure TFrmEditPathList.BtnHelpClick(Sender: TObject);
begin
     Application.HelpCommand(HELP_CONTEXT, HelpContext);
end;

procedure TFrmEditPathList.LstPathsKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     If (Key = vk_Delete) And (Shift = []) Then BtnDeleteClick(Nil);
end;

Procedure TFrmEditPathList.WMNCHitTest(Var Msg : TMessage);
Var
   i: Integer;
   r: TRect;
   ctrl: TControl;

Function LeftMouseButtonPressed: Boolean;
Begin
     If GetSystemMetrics(SM_SWAPBUTTON) = 0 Then
        Result:=(GetAsyncKeyState(VK_LBUTTON) < 0)
     Else
        Result:=(GetAsyncKeyState(VK_RBUTTON) < 0);
End;

Begin
     If Options.WindowClientDraggable And LeftMouseButtonPressed Then Begin
        If (Msg.LParamLo >= Self.ClientToScreen(Point(0, 0)).x) And
           (Msg.LParamHi >= Self.ClientToScreen(Point(0, 0)).y) And
           (Msg.LParamLo <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).x) And
           (Msg.LParamHi <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).y)
        Then Begin
             For i:=0 To Self.ComponentCount-1 Do Begin
                 Try
                    If Self.Components[i] Is TControl Then Begin
                       ctrl:=TControl(Self.Components[i]);
                       r:=ctrl.BoundsRect;
                       If (Msg.LParamLo >= Self.ClientToScreen(Point(r.Left, r.Top)).x) And
                          (Msg.LParamHi >= Self.ClientToScreen(Point(r.Left, r.Top)).y) And
                          (Msg.LParamLo <= Self.ClientToScreen(Point(r.Right, r.Bottom)).x) And
                          (Msg.LParamHi <= Self.ClientToScreen(Point(r.Right, r.Bottom)).y) And ctrl.Visible
                       Then Begin
                          Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                          Exit;
                       End;
                    End;
                 Except
                    Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                    Exit;
                 End;
             End;
             Msg.Result:=HTCAPTION
        End Else
           Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
     End Else
        Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
End;

End.
