unit EditPathForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ComCtrls, StdCtrls, ExtCtrls, MainForm, Menus;

type
  TFrmEditPath = class(TForm)
    BtnOK: TButton;
    BtnCancel: TButton;
    Bevel1: TBevel;
    Label1: TLabel;
    EdtPath: TEdit;
    Label2: TLabel;
    EdtShortCut: THotKey;
    SpdBrowse: TSpeedButton;
    BtnHelp: TButton;
    procedure FormActivate(Sender: TObject);
    procedure SpdBrowseClick(Sender: TObject);
    procedure EdtPathEnter(Sender: TObject);
    procedure BtnOKClick(Sender: TObject);
    procedure EdtPathChange(Sender: TObject);
    procedure BtnHelpClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private-Deklarationen }
    Procedure WMNCHitTest(Var Msg: TMessage); Message WM_NCHITTEST;
  public
    { Public-Deklarationen }
    IndexSelf: Integer;
  end;

var
  FrmEditPath: TFrmEditPath;

implementation

uses EditPathListForm;

{$R *.DFM}

procedure TFrmEditPath.FormActivate(Sender: TObject);
begin
     EdtPath.SelectAll;
     EdtPath.SetFocus;
end;

procedure TFrmEditPath.SpdBrowseClick(Sender: TObject);
Var
   Tmp: String;
begin
     Tmp:=BrowseDir('Whlen Sie ein Verzeichnis!', FrmEditPath.Handle);
     If Tmp <> '' Then Begin
        EdtPath.Text:=Tmp;
        EdtPath.SelectAll;
        EdtPath.SetFocus;
     End;
end;

procedure TFrmEditPath.EdtPathEnter(Sender: TObject);
begin
     EdtPath.SelectAll;
end;

Function CheckShortCut(ShortCut: TShortCut; IndexSelf: Integer): Boolean;
Var
   i, m: Integer;
Begin
     If Integer(ShortCut) = 0 Then Begin
        Result:=True;
        Exit;
     End;
     Result:=False;
     // Liste berprfen
     For i:=0 To FrmEditPathList.LstPaths.Items.Count-1 Do Begin
         If ShortCut = TextToShortCut(FrmEditPathList.LstPaths.Items[i].SubItems[0]) Then
            If IndexSelf <> i Then Exit;
     End;
     // Mens berprfen
     With FrmMain do Begin
          For i:=0 To MnuMain.Items.Count-1 Do Begin
              For m:=0 To MnuMain.Items[i].Count-1 Do Begin
                  If MnuMain.Items[i].Items[m].ShortCut = ShortCut Then Exit;
              End;
          End;
     End;
     Result:=True;
End;

procedure TFrmEditPath.BtnOKClick(Sender: TObject);
begin
     If CheckShortCut(EdtShortCut.HotKey, IndexSelf) Then
        FrmEditPath.ModalResult:=mrOK
     Else MessageDlg('Das Tastenkrzel "'+ShortCutToText(EdtShortCut.HotKey)+'" ist schon vergeben.', mtWarning, [mbOK], 0);
end;

procedure TFrmEditPath.EdtPathChange(Sender: TObject);
begin
     If Length(EdtPath.Text) > 0 Then BtnOK.Enabled:=True Else BtnOK.Enabled:=False;
end;


procedure TFrmEditPath.BtnHelpClick(Sender: TObject);
begin
     Application.HelpCommand(HELP_CONTEXT, HelpContext);
end;

procedure TFrmEditPath.FormCreate(Sender: TObject);
begin
     HelpContext:=IDH_EditPath;
end;

Procedure TFrmEditPath.WMNCHitTest(Var Msg : TMessage);
Var
   i: Integer;
   r: TRect;
   ctrl: TControl;

Function LeftMouseButtonPressed: Boolean;
Begin
     If GetSystemMetrics(SM_SWAPBUTTON) = 0 Then
        Result:=(GetAsyncKeyState(VK_LBUTTON) < 0)
     Else
        Result:=(GetAsyncKeyState(VK_RBUTTON) < 0);
End;

Begin
     If Options.WindowClientDraggable And LeftMouseButtonPressed Then Begin
        If (Msg.LParamLo >= Self.ClientToScreen(Point(0, 0)).x) And
           (Msg.LParamHi >= Self.ClientToScreen(Point(0, 0)).y) And
           (Msg.LParamLo <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).x) And
           (Msg.LParamHi <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).y)
        Then Begin
             For i:=0 To Self.ComponentCount-1 Do Begin
                 Try
                    If Self.Components[i] Is TControl Then Begin
                       ctrl:=TControl(Self.Components[i]);
                       r:=ctrl.BoundsRect;
                       If (Msg.LParamLo >= Self.ClientToScreen(Point(r.Left, r.Top)).x) And
                          (Msg.LParamHi >= Self.ClientToScreen(Point(r.Left, r.Top)).y) And
                          (Msg.LParamLo <= Self.ClientToScreen(Point(r.Right, r.Bottom)).x) And
                          (Msg.LParamHi <= Self.ClientToScreen(Point(r.Right, r.Bottom)).y) And ctrl.Visible
                       Then Begin
                          Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                          Exit;
                       End;
                    End;
                 Except
                    Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                    Exit;
                 End;
             End;
             Msg.Result:=HTCAPTION
        End Else
           Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
     End Else
        Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
End;

end.

