unit DivideFileForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls, ExtCtrls, Spin, Menus;

type
  TFrmDivideFile = class(TForm)
    BvlLine: TBevel;
    BtnOK: TButton;
    BtnCancel: TButton;
    BtnHelp: TButton;
    Label1: TLabel;
    LblFilename: TLabel;
    Bevel1: TBevel;
    Label2: TLabel;
    EdtTargetDir: TEdit;
    SpdBrowse: TSpeedButton;
    Label3: TLabel;
    EdtBaseName: TEdit;
    Label4: TLabel;
    Label5: TLabel;
    SpnSizeOfFilePart: TSpinEdit;
    Label6: TLabel;
    GroupBox1: TGroupBox;
    ChkOverwrite: TCheckBox;
    ChkDeleteOriginalFile: TCheckBox;
    ChkPromptForDisk: TCheckBox;
    BtnStdSize: TBitBtn;
    PopStdSize: TPopupMenu;
    StdSize1: TMenuItem;
    StdSize2: TMenuItem;
    StdSize4: TMenuItem;
    StdSize3: TMenuItem;
    procedure SpdBrowseClick(Sender: TObject);
    procedure BtnOKClick(Sender: TObject);
    procedure StdSize5Click(Sender: TObject);
    procedure BtnStdSizeClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BtnHelpClick(Sender: TObject);
  private
    { Private-Deklarationen }
    Procedure WMNCHitTest(Var Msg: TMessage); Message WM_NCHITTEST;
  public
    { Public-Deklarationen }
    FileToDivide: String;
    Procedure DivideFile(Filename, TargetDir, BaseName: String; SizeOfFileParts: Cardinal);
  end;

var
  FrmDivideFile: TFrmDivideFile;
  DivideFileProgressFile, DivideFileProgressAll: Longint;
  DivideFileCanceled: Boolean;
  DivideFileOverwriteAll: Boolean;

implementation

Uses
    MainForm, DivideFileProgressForm;

{$R *.DFM}

procedure TFrmDivideFile.SpdBrowseClick(Sender: TObject);
Var
   NewTarget: String;
begin
     NewTarget:=BrowseDir('Whlen Sie das Zielverzeichnis!', Handle);
     If NewTarget <> '' Then Begin
        EdtTargetDir.Text:=NewTarget;
        EdtTargetDir.SelectAll;
     End;
end;

procedure TFrmDivideFile.BtnOKClick(Sender: TObject);
begin
     If EdtTargetDir.Text = '' Then Begin
        MessageDlg('Sie mssen ein Zielverzeichnis angeben!', mtError, [mbOk], 0);
        EdtTargetDir.SetFocus;
        Exit;
     End;
     If Not PathExists(EdtTargetDir.Text, True) Then Begin
        Exit;
     End;
     If EdtBaseName.Text = '' Then Begin
        MessageDlg('Sie mssen einen Namen fr die Teil-Dateien angeben!', mtError, [mbOk], 0);
        EdtBaseName.SetFocus;
        Exit;
     End;
     If SpnSizeOfFilePart.Value <= 0 Then Begin
        MessageDlg('Die Gre der Teil-Dateien mu grer als Null sein!', mtError, [mbOk], 0);
        SpnSizeOfFilePart.SetFocus;
        Exit;
     End;

     Self.Close;
     Application.ProcessMessages;
     DivideFile(FileToDivide, EdtTargetDir.Text, EdtBaseName.Text, SpnSizeOfFilePart.Value);
end;

Procedure TFrmDivideFile.DivideFile;
Var
   Buf: Array[0..65535] Of Byte; // 64k-Puffer
   s, d: THandle;
   Counter: Longint;
   SourceFileSize: Cardinal;
   ActPartName: String;
   BytesWrittenTotal, BytesWrittenPart: Cardinal;
   BytesRead, BytesWritten: Cardinal;
   BytesToCopy, BytesToCopyTmp: Cardinal;
   Res: Integer;
   ProgressFileTmp: Longint;

Function ThreeCharNumber(Num: Longint): String;
Begin
     Str(Num, Result);
     While Length(Result) < 3 Do
           Result:='0'+Result;
End;

Begin
     If FrmMain.Busy > 0 Then Exit;

     FrmMain.BeginBusy;
     Try

        DivideFileCanceled:=False;

        s:=CreateFile(PChar(FileToDivide), GENERIC_READ, FILE_SHARE_READ, Nil, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, 0);
        If s <> INVALID_HANDLE_VALUE Then Begin

           DivideFileOverwriteAll:=ChkOverwrite.Checked;
           If TargetDir[Length(TargetDir)] <> '\' Then TargetDir:=TargetDir+'\';
           SourceFileSize:=GetFileSize(s, Nil);
           If SizeOfFileParts > SourceFileSize Then SizeOfFileParts:=SourceFileSize;
           If SizeOfFileParts >= SizeOf(Buf) Then
              BytesToCopy:=SizeOf(Buf)
           Else
              BytesToCopy:=SizeOfFileParts;
           Counter:=0;
           BytesWrittenTotal:=0;
           FrmDivideFileProgress.PrgFile.Position:=0;
           FrmDivideFileProgress.PrgAll.Position:=0;
           FrmDivideFileProgress.Show;

           While BytesWrittenTotal < SourceFileSize Do Begin

                 If (SourceFileSize - BytesWrittenTotal) < SizeOfFileParts Then
                    ProgressFileTmp:=SourceFileSize - BytesWrittenTotal
                 Else
                    ProgressFileTmp:=SizeOfFileParts;

                 ActPartName:=TargetDir+BaseName+'.'+ThreeCharNumber(Counter);
                 BytesWrittenPart:=0;

                 If ChkPromptForDisk.Checked Then Begin
                    Res:=MessageDlg('Legen Sie bitte eine Diskette in Laufwerk '+TargetDir[1]+':\ ein!', mtInformation, [mbOk, mbCancel], 0);
                    If Res <> mrOk Then Begin
                       MessageDlg('Vorgang abgebrochen!', mtInformation, [mbOk], 0);
                       CloseHandle(s);
                       FrmDivideFileProgress.Close;
                       FrmMain.EndBusy;
                       Exit;
                    End;
                 End;

                 If Not DivideFileOverwriteAll Then Begin
                    If FileExists(ActPartName) Then Begin
                       Res:=MessageDlg(ActPartName+' existiert bereits. berschreiben?', mtConfirmation, [mbOk, mbAll, mbCancel], 0);
                       Case Res Of
                            mrCancel:
                               Begin
                                    MessageDlg('Vorgang abgebrochen!', mtInformation, [mbOk], 0);
                                    CloseHandle(s);
                                    FrmDivideFileProgress.Close;
                                    FrmMain.EndBusy;
                                    Exit;
                               End;
                            mrAll: DivideFileOverwriteAll:=True;
                       End;
                    End;
                 End;

                 FrmDivideFileProgress.LblFilename.Caption:=ExtractFilename(ActPartName);
                 Application.ProcessMessages;
                 Repeat
                       FileSetAttr(ActPartName, faArchive);
                       d:=CreateFile(PChar(ActPartName), GENERIC_WRITE, FILE_SHARE_WRITE, Nil, CREATE_ALWAYS, FILE_FLAG_SEQUENTIAL_SCAN, 0);
                       If d = INVALID_HANDLE_VALUE Then Begin
                          Res:=MessageDlg('Fehler beim Erstellen von '+ActPartName+'.'+#13+#10+GetLastErrorString, mtError, [mbRetry, mbAbort], 0);
                          Case Res Of
                               mrAbort:
                                  Begin
                                       MessageDlg('Vorgang abgebrochen!', mtInformation, [mbOk], 0);
                                       CloseHandle(s);
                                       FrmDivideFileProgress.Close;
                                       FrmMain.EndBusy;
                                       Exit;
                                  End;
                          End;
                       End;
                 Until d <> INVALID_HANDLE_VALUE;

                 Repeat
                       If DivideFileCanceled Then Begin
                          MessageDlg('Vorgang abgebrochen!', mtInformation, [mbOk], 0);
                          CloseHandle(s);
                          CloseHandle(d);
                          FrmDivideFileProgress.Close;
                          FrmMain.EndBusy;
                          Exit;
                       End;

                       If (SizeOfFileParts - BytesWrittenPart) < BytesToCopy Then
                          BytesToCopyTmp:=SizeOfFileParts - BytesWrittenPart
                       Else
                          BytesToCopyTmp:=BytesToCopy;

                       ReadFile(s, Buf, BytesToCopyTmp, BytesRead, Nil);
                       Application.ProcessMessages;
                       WriteFile(d, Buf, BytesRead, BytesWritten, Nil);

                       If BytesRead <> BytesWritten Then Begin
                          MessageDlg('Fehler beim Kopieren aus '+FileToDivide+' nach '+ActPartName+'.'+#13+#10+GetLastErrorString, mtError, [mbOk], 0);
                          CloseHandle(s);
                          CloseHandle(d);
                          FrmDivideFileProgress.Close;
                          FrmMain.EndBusy;
                          Exit;
                       End;

                       Inc(BytesWrittenPart, BytesWritten);
                       Inc(BytesWrittenTotal, BytesWritten);

                       If SourceFileSize > 0 Then
                          FrmDivideFileProgress.PrgAll.Position:=Round(BytesWrittenTotal / SourceFileSize * 100);
                       If ProgressFileTmp > 0 Then
                          FrmDivideFileProgress.PrgFile.Position:=Round(BytesWrittenPart / ProgressFileTmp * 100);
                       Application.ProcessMessages;

                 Until (BytesWrittenPart >= SizeOfFileParts) Or (BytesRead < BytesToCopyTmp);

                 CloseHandle(d);
                 Inc(Counter);

           End;

           CloseHandle(s);
           FrmDivideFileProgress.Close;

           If ChkDeleteOriginalFile.Checked Then Begin
              Kill(FileToDivide);
           End Else Begin
              If MessageDlg('Originaldatei ('+FileToDivide+') lschen?', mtConfirmation, [mbYes, mbNo], 0) = mrYes Then
                 Kill(FileToDivide);
           End;

        End Else MessageDlg(FileToDivide+' konnte nicht geffnet werden!', mtError, [mbOk], 0);

     Finally
        FrmMain.EndBusy;
        FrmMain.UpdateLists;
     End;
End;

procedure TFrmDivideFile.StdSize5Click(Sender: TObject);
begin
     SpnSizeOfFilePart.Value:=Integer((Sender As TMenuItem).Tag);
end;

procedure TFrmDivideFile.BtnStdSizeClick(Sender: TObject);
Var
   p: TPoint;
begin
     p:=ClientToScreen(Point(BtnStdSize.Left, BtnStdSize.Top+BtnStdSize.Height));
     PopStdSize.PopUp(p.x, p.y);
end;

procedure TFrmDivideFile.FormShow(Sender: TObject);
begin
     EdtBaseName.SetFocus;
end;

procedure TFrmDivideFile.FormCreate(Sender: TObject);
begin
     HelpContext:=IDH_DivideFile;
end;

procedure TFrmDivideFile.BtnHelpClick(Sender: TObject);
begin
     Application.HelpCommand(HELP_CONTEXT, HelpContext);
end;

Procedure TFrmDivideFile.WMNCHitTest(Var Msg : TMessage);
Var
   i: Integer;
   r: TRect;
   ctrl: TControl;

Function LeftMouseButtonPressed: Boolean;
Begin
     If GetSystemMetrics(SM_SWAPBUTTON) = 0 Then
        Result:=(GetAsyncKeyState(VK_LBUTTON) < 0)
     Else
        Result:=(GetAsyncKeyState(VK_RBUTTON) < 0);
End;

Begin
     If Options.WindowClientDraggable And LeftMouseButtonPressed Then Begin
        If (Msg.LParamLo >= Self.ClientToScreen(Point(0, 0)).x) And
           (Msg.LParamHi >= Self.ClientToScreen(Point(0, 0)).y) And
           (Msg.LParamLo <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).x) And
           (Msg.LParamHi <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).y)
        Then Begin
             For i:=0 To Self.ComponentCount-1 Do Begin
                 Try
                    If Self.Components[i] Is TControl Then Begin
                       ctrl:=TControl(Self.Components[i]);
                       r:=ctrl.BoundsRect;
                       If (Msg.LParamLo >= Self.ClientToScreen(Point(r.Left, r.Top)).x) And
                          (Msg.LParamHi >= Self.ClientToScreen(Point(r.Left, r.Top)).y) And
                          (Msg.LParamLo <= Self.ClientToScreen(Point(r.Right, r.Bottom)).x) And
                          (Msg.LParamHi <= Self.ClientToScreen(Point(r.Right, r.Bottom)).y) And ctrl.Visible
                       Then Begin
                          Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                          Exit;
                       End;
                    End;
                 Except
                    Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                    Exit;
                 End;
             End;
             Msg.Result:=HTCAPTION
        End Else
           Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
     End Else
        Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
End;

end.
