unit DeleteForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TFrmDelete = class(TForm)
    BvlLine: TBevel;
    Bevel1: TBevel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    LblSize: TLabel;
    LblSubDirs: TLabel;
    LblFileNum: TLabel;
    ImgDelete: TImage;
    BtnOK: TButton;
    BtnCancel: TButton;
    GrpOptions: TGroupBox;
    ChkUseFilter: TCheckBox;
    LblHint: TLabel;
    BvlHint: TBevel;
    LblTheHint: TLabel;
    BtnHelp: TButton;
    ChkDontRemoveEmptyDirectories: TCheckBox;
    procedure FormActivate(Sender: TObject);
    procedure ChkUseFilterClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BtnHelpClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private-Deklarationen }
    Procedure WMNCHitTest(Var Msg: TMessage); Message WM_NCHITTEST;
  public
    { Public-Deklarationen }
    SourceList: Integer;
  end;

var
  FrmDelete: TFrmDelete;

implementation

uses mainform;

{$R *.DFM}

procedure TFrmDelete.FormActivate(Sender: TObject);
begin
     BtnCancel.SetFocus;
end;

procedure TFrmDelete.ChkUseFilterClick(Sender: TObject);
Var
   Size: Int64;
   FileNum, DirNum: Longint;
   Siz: String;
Begin
     DirInfo(False, True, FrmDelete.ChkUseFilter.Checked, FrmDelete.SourceList, FileNum, DirNum, Size);
     FrmDelete.LblSubDirs.Caption:=Formatted(DirNum);
     FrmDelete.LblFileNum.Caption:=Formatted(FileNum);
     If Size >= 1024*1024*1024 Then Begin
        Str(Size/(1024*1024*1024):5:1,Siz);
        Siz:=Siz+' GB ('+Formatted(Size)+' Bytes)';
     End Else If Size >= 1024*1024 Then Begin
        Str(Size/(1024*1024):3:1,Siz);
        Siz:=Siz+' MB ('+Formatted(Size)+' Bytes)';
     End Else If Size >= 1024 Then Begin
        Str(Size/1024:3:1,Siz);
        Siz:=Siz+' KB ('+Formatted(Size)+' Bytes)';
     End Else Begin
        Siz:=Formatted(Size)+' Bytes';
     End;
     FrmDelete.LblSize.Caption:=Siz;
     LblHint.Enabled:=ChkUseFilter.Checked;
     LblTheHint.Enabled:=ChkUseFilter.Checked;
     ChkDontRemoveEmptyDirectories.Enabled:=ChkUseFilter.Checked;
end;

procedure TFrmDelete.FormShow(Sender: TObject);
begin
     ChkUseFilterClick(Nil);
end;

procedure TFrmDelete.BtnHelpClick(Sender: TObject);
begin
     Application.HelpCommand(HELP_CONTEXT, HelpContext);
end;

procedure TFrmDelete.FormCreate(Sender: TObject);
begin
     HelpContext:=IDH_FileDelete;
end;

Procedure TFrmDelete.WMNCHitTest(Var Msg : TMessage);
Var
   i: Integer;
   r: TRect;
   ctrl: TControl;

Function LeftMouseButtonPressed: Boolean;
Begin
     If GetSystemMetrics(SM_SWAPBUTTON) = 0 Then
        Result:=(GetAsyncKeyState(VK_LBUTTON) < 0)
     Else
        Result:=(GetAsyncKeyState(VK_RBUTTON) < 0);
End;

Begin
     If Options.WindowClientDraggable And LeftMouseButtonPressed Then Begin
        If (Msg.LParamLo >= Self.ClientToScreen(Point(0, 0)).x) And
           (Msg.LParamHi >= Self.ClientToScreen(Point(0, 0)).y) And
           (Msg.LParamLo <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).x) And
           (Msg.LParamHi <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).y)
        Then Begin
             For i:=0 To Self.ComponentCount-1 Do Begin
                 Try
                    If Self.Components[i] Is TControl Then Begin
                       ctrl:=TControl(Self.Components[i]);
                       r:=ctrl.BoundsRect;
                       If (Msg.LParamLo >= Self.ClientToScreen(Point(r.Left, r.Top)).x) And
                          (Msg.LParamHi >= Self.ClientToScreen(Point(r.Left, r.Top)).y) And
                          (Msg.LParamLo <= Self.ClientToScreen(Point(r.Right, r.Bottom)).x) And
                          (Msg.LParamHi <= Self.ClientToScreen(Point(r.Right, r.Bottom)).y) And ctrl.Visible
                       Then Begin
                          Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                          Exit;
                       End;
                    End;
                 Except
                    Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                    Exit;
                 End;
             End;
             Msg.Result:=HTCAPTION
        End Else
           Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
     End Else
        Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
End;

end.
