unit CopyMoveForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, MainForm;

type
  TFrmCopyMove = class(TForm)
    BvlLine: TBevel;
    BtnOK: TButton;
    BtnCancel: TButton;
    Label1: TLabel;
    EdtTarget: TEdit;
    SpdBrowse: TSpeedButton;
    GrpOptions: TGroupBox;
    ChkRecursive: TCheckBox;
    ChkUseFilter: TCheckBox;
    Bevel1: TBevel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    LblSize: TLabel;
    LblSubDirs: TLabel;
    LblFileNum: TLabel;
    ImgCopyMove: TImage;
    ImgCopy: TImage;
    ImgMove: TImage;
    BtnHelp: TButton;
    ChkDontRemoveEmptyDirectories: TCheckBox;
    ChkCopyOnlyNewFiles: TCheckBox;
    ChkAlwaysOverwriteOldFiles: TCheckBox;
    procedure FormShow(Sender: TObject);
    procedure ChkRecursiveClick(Sender: TObject);
    procedure SpdBrowseClick(Sender: TObject);
    procedure ChkUseFilterClick(Sender: TObject);
    procedure BtnHelpClick(Sender: TObject);
  private
    { Private-Deklarationen }
    Procedure WMNCHitTest(Var Msg: TMessage); Message WM_NCHITTEST;
  public
    { Public-Deklarationen }
    SourceList: Integer;
    Procedure UpdateInfo;
  end;

var
  FrmCopyMove: TFrmCopyMove;

implementation

{$R *.DFM}

Procedure TFrmCopyMove.UpdateInfo;
Var
   Size: Int64;
   FileNum, DirNum: Longint;
   Siz: String;
Begin
     DirInfo(False, FrmCopyMove.ChkRecursive.Checked, FrmCopyMove.ChkUseFilter.Checked, SourceList, FileNum, DirNum, Size);
     FrmCopyMove.LblSubDirs.Caption:=Formatted(DirNum);
     FrmCopyMove.LblFileNum.Caption:=Formatted(FileNum);
      If Size >= 1024*1024*1024 Then Begin
        Str(Size/(1024*1024*1024):5:1,Siz);
        Siz:=Siz+' GB ('+Formatted(Size)+' Bytes)';
     End Else If Size >= 1024*1024 Then Begin
        Str(Size/(1024*1024):3:1,Siz);
        Siz:=Siz+' MB ('+Formatted(Size)+' Bytes)';
     End Else If Size >= 1024 Then Begin
        Str(Size/1024:3:1,Siz);
        Siz:=Siz+' KB ('+Formatted(Size)+' Bytes)';
     End Else Begin
        Siz:=Formatted(Size)+' Bytes';
     End;
     FrmCopyMove.LblSize.Caption:=Siz;
End;

procedure TFrmCopyMove.FormShow(Sender: TObject);
begin
     EdtTarget.SelectAll;
     EdtTarget.SetFocus;
     ChkRecursiveClick(Nil);
end;

Procedure UpdateChkDontRemoveEmptyDirectoriesEnabled;
Begin
     With FrmCopyMove Do
          ChkDontRemoveEmptyDirectories.Enabled:=(ChkRecursive.Checked And ChkUseFilter.Checked And (cmAction = cmMove));
End;

procedure TFrmCopyMove.ChkRecursiveClick(Sender: TObject);
begin
     ChkUseFilter.Enabled:=ChkRecursive.Checked;
     UpdateChkDontRemoveEmptyDirectoriesEnabled;
     UpdateInfo;
end;

procedure TFrmCopyMove.SpdBrowseClick(Sender: TObject);
Var
   NewTarget: String;
begin
     NewTarget:=BrowseDir('Whlen Sie das Zielverzeichnis!', Handle);
     If NewTarget <> '' Then Begin
        EdtTarget.Text:=NewTarget;
        EdtTarget.SelectAll;
     End;
end;

procedure TFrmCopyMove.ChkUseFilterClick(Sender: TObject);
begin
     UpdateChkDontRemoveEmptyDirectoriesEnabled;
     UpdateInfo;
end;

procedure TFrmCopyMove.BtnHelpClick(Sender: TObject);
begin
     Application.HelpCommand(HELP_CONTEXT, HelpContext);
end;

Procedure TFrmCopyMove.WMNCHitTest(Var Msg : TMessage);
Var
   i: Integer;
   r: TRect;
   ctrl: TControl;

Function LeftMouseButtonPressed: Boolean;
Begin
     If GetSystemMetrics(SM_SWAPBUTTON) = 0 Then
        Result:=(GetAsyncKeyState(VK_LBUTTON) < 0)
     Else
        Result:=(GetAsyncKeyState(VK_RBUTTON) < 0);
End;

Begin
     If Options.WindowClientDraggable And LeftMouseButtonPressed Then Begin
        If (Msg.LParamLo >= Self.ClientToScreen(Point(0, 0)).x) And
           (Msg.LParamHi >= Self.ClientToScreen(Point(0, 0)).y) And
           (Msg.LParamLo <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).x) And
           (Msg.LParamHi <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).y)
        Then Begin
             For i:=0 To Self.ComponentCount-1 Do Begin
                 Try
                    If Self.Components[i] Is TControl Then Begin
                       ctrl:=TControl(Self.Components[i]);
                       r:=ctrl.BoundsRect;
                       If (Msg.LParamLo >= Self.ClientToScreen(Point(r.Left, r.Top)).x) And
                          (Msg.LParamHi >= Self.ClientToScreen(Point(r.Left, r.Top)).y) And
                          (Msg.LParamLo <= Self.ClientToScreen(Point(r.Right, r.Bottom)).x) And
                          (Msg.LParamHi <= Self.ClientToScreen(Point(r.Right, r.Bottom)).y) And ctrl.Visible
                       Then Begin
                          Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                          Exit;
                       End;
                    End;
                 Except
                    Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                    Exit;
                 End;
             End;
             Msg.Result:=HTCAPTION
        End Else
           Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
     End Else
        Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
End;

end.
