unit ConcatFileForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, ComCtrls;

type
  TFrmConcatFile = class(TForm)
    Label1: TLabel;
    LstFileParts: TListView;
    Label2: TLabel;
    EdtOriginalFile: TEdit;
    Label3: TLabel;
    EdtTargetDir: TEdit;
    SpdBrowse: TSpeedButton;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Bevel3: TBevel;
    ChkDeleteAfterConcat: TCheckBox;
    BtnOK: TButton;
    BtnCancel: TButton;
    BtnHelp: TButton;
    Timer1: TTimer;
    procedure SpdBrowseClick(Sender: TObject);
    procedure LstFilePartsDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure LstFilePartsKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure LstFilePartsDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure BtnOKClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BtnHelpClick(Sender: TObject);
  private
    { Private-Deklarationen }
    Procedure WMNCHitTest(Var Msg: TMessage); Message WM_NCHITTEST;
  public
    { Public-Deklarationen }
    Procedure ConcatFile(Filename, TargetDir: String);
  end;

var
  FrmConcatFile: TFrmConcatFile;
  ConcatFileCanceled: Boolean;

implementation

{$R *.DFM}

Uses
    MainForm, ConcatFileProgressForm;

procedure TFrmConcatFile.SpdBrowseClick(Sender: TObject);
Var
   NewTarget: String;
begin
     NewTarget:=BrowseDir('Whlen Sie das Zielverzeichnis!', Handle);
     If NewTarget <> '' Then Begin
        EdtTargetDir.Text:=NewTarget;
        EdtTargetDir.SelectAll;
     End;
end;

procedure TFrmConcatFile.LstFilePartsDragDrop(Sender, Source: TObject; X,
  Y: Integer);
Var
   SourceIndex, DestIndex: Integer;
   SourceItem, DestItem: TListItem;
begin
     If Source <> LstFileParts Then Exit;
     If LstFileParts.ItemFocused = Nil Then Exit;
     SourceItem:=LstFileParts.ItemFocused;
     SourceIndex:=LstFileParts.Items.Indexof(SourceItem);
     DestItem:=LstFileParts.GetItemAt(x, y);
     If DestItem = Nil Then Exit;
     DestIndex:=LstFileParts.Items.Indexof(DestItem);

     If SourceIndex = DestIndex Then
        Exit
     Else If SourceIndex < DestIndex Then Begin
        LstFileParts.Items.Insert(DestIndex+1);
        LstFileParts.Items[DestIndex+1]:=SourceItem;
        LstFileParts.ItemFocused:=LstFileParts.Items[DestIndex+1];
        LstFileParts.ItemFocused.Selected:=True;
        SourceItem.Free;
     End Else If SourceIndex > DestIndex Then Begin
        LstFileParts.Items.Insert(DestIndex);
        LstFileParts.Items[DestIndex]:=SourceItem;
        LstFileParts.ItemFocused:=LstFileParts.Items[DestIndex];
        LstFileParts.ItemFocused.Selected:=True;
        SourceItem.Free;
     End;
end;

procedure TFrmConcatFile.LstFilePartsKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
Var
   Index: Integer;
begin
     If (Key = vk_Delete) And (Shift = []) Then Begin
        If LstFileParts.ItemFocused <> Nil Then Begin
           Index:=LstFileParts.ItemFocused.Index;
           LstFileParts.ItemFocused.Free;
           If LstFileParts.Items.Count > Index Then Begin
              LstFileParts.ItemFocused:=LstFileParts.Items[Index];
              LstFileParts.ItemFocused.Selected:=True;
           End Else Begin
              If Index > 0 Then Begin
                 LstFileParts.ItemFocused:=LstFileParts.Items[Index-1];
                 LstFileParts.ItemFocused.Selected:=True;
              End;
           End;
           LstFileParts.SetFocus;
        End;
     End;
end;

procedure TFrmConcatFile.LstFilePartsDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
     Accept:=True;
end;

procedure TFrmConcatFile.BtnOKClick(Sender: TObject);
begin
     If LstFileParts.Items.Count <= 0 Then Begin
        MessageDlg('Sie haben keine Teil-Dateien angegeben!', mtError, [mbOk], 0);
        Exit;
     End;
     If EdtOriginalFile.Text = '' Then Begin
        MessageDlg('Sie mssen einen Dateinamen angeben!', mtError, [mbOk], 0);
        EdtOriginalFile.SelectAll;
        EdtOriginalFile.SetFocus;
        Exit;
     End;
     If EdtTargetDir.Text = '' Then Begin
        MessageDlg('Sie mssen ein Zielverzeichnis angeben!', mtError, [mbOk], 0);
        EdtTargetDir.SelectAll;
        EdtTargetDir.SetFocus;
        Exit;
     End;
     If Not PathExists(EdtTargetDir.Text, True) Then Exit;

     Self.Close;
     Application.ProcessMessages;
     ConcatFile(EdtOriginalFile.Text, EdtTargetDir.Text);
end;

Procedure TFrmConcatFile.ConcatFile;
Const
   BufSize = 65536;
Var
   Buf: Array[0..BufSize-1] Of Byte;
   OrigFile: String;
   s, d: THandle;
   Res: Integer;
   i, count: Integer;
   ActPartName: String;
   FilePartSize: Cardinal;
   BytesRead, BytesWritten: Cardinal;
   BytesCopied: Cardinal;
Begin
     If FrmMain.Busy > 0 Then Exit;

     FrmMain.BeginBusy;
     Try
        ConcatFileCanceled:=False;

        If TargetDir[Length(TargetDir)] <> '\' Then TargetDir:=TargetDir+'\';
        OrigFile:=TargetDir+Filename;

        If FileExists(OrigFile) Then Begin
           If MessageDlg('Die Datei '+OrigFile+' existiert schon. berschreiben?', mtConfirmation, [mbOk, mbCancel], 0) <> mrOk Then Begin
              FrmMain.EndBusy;
              Exit;
           End;
        End;

        Repeat
              d:=CreateFile(PChar(OrigFile), GENERIC_WRITE, FILE_SHARE_WRITE, Nil, CREATE_ALWAYS, FILE_FLAG_SEQUENTIAL_SCAN, 0);
              If d = INVALID_HANDLE_VALUE Then Begin
                 Res:=MessageDlg('Fehler beim Erstellen von '+OrigFile+'.'+#13+#10+GetLastErrorString, mtError, [mbRetry, mbAbort], 0);
                 Case Res Of
                      mrAbort:
                         Begin
                              MessageDlg('Vorgang abgebrochen!', mtInformation, [mbOk], 0);
                              FrmMain.EndBusy;
                              Exit;
                         End;
                 End;
              End;
        Until d <> INVALID_HANDLE_VALUE;


        count:=LstFileParts.Items.Count-1;
        For i:=0 To count Do Begin

            ActPartName:=LstFileParts.Items[i].Caption;

            FrmConcatFileProgress.LblFilename.Caption:=ActPartName;
            FrmConcatFileProgress.PrgFile.Position:=0;
            FrmConcatFileProgress.Show;

            Application.ProcessMessages;

            Repeat
                  s:=CreateFile(PChar(ActPartName), GENERIC_READ, FILE_SHARE_READ, Nil, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, 0);
                  If s = INVALID_HANDLE_VALUE Then Begin
                     Res:=MessageDlg('Fehler beim ffnen von '+ActPartName+'.'+#13+#10+GetLastErrorString, mtError, [mbRetry, mbAbort], 0);
                     Case Res Of
                          mrAbort:
                             Begin
                                  MessageDlg('Vorgang abgebrochen!', mtInformation, [mbOk], 0);
                                  CloseHandle(d);
                                  FrmConcatFileProgress.Close;
                                  FrmMain.EndBusy;
                                  Exit;
                             End;
                     End;
                  End;
            Until s <> INVALID_HANDLE_VALUE;

            FilePartSize:=GetFileSize(s, Nil);
            BytesCopied:=0;

            Repeat
                  If ConcatFileCanceled Then Begin
                     MessageDlg('Vorgang abgebrochen!', mtInformation, [mbOk], 0);
                     CloseHandle(s);
                     CloseHandle(d);
                     FrmConcatFileProgress.Close;
                     FrmMain.EndBusy;
                     Exit;
                  End;

                  ReadFile(s, Buf, BufSize, BytesRead, Nil);
                  Application.ProcessMessages;
                  WriteFile(d, Buf, BytesRead, BytesWritten, Nil);
                  If BytesRead <> BytesWritten Then Begin
                     MessageDlg('Fehler beim Hinzufgen von '+ActPartName+' zu '+OrigFile+'.'+#13+#10+GetLastErrorString, mtError, [mbOk], 0);
                     CloseHandle(s);
                     CloseHandle(d);
                     FrmConcatFileProgress.Close;
                     FrmMain.EndBusy;
                     Exit;
                  End;
                  Inc(BytesCopied, BytesWritten);

                  If FilePartSize > 0 Then
                     FrmConcatFileProgress.PrgFile.Position:=Round(BytesCopied / FilePartSize * 100);

                  Application.ProcessMessages;

            Until BytesRead < BufSize;

            CloseHandle(s);

        End;

        CloseHandle(d);
        FrmConcatFileProgress.Close;

        If FrmConcatFile.ChkDeleteAfterConcat.Checked Then Begin
           For i:=0 To count Do
               Kill(LstFileParts.Items[i].Caption);
        End Else Begin
           If MessageDlg('Datei '+OrigFile+' erfolgreich zusammengefhrt. Teil-Dateien lschen?', mtConfirmation, [mbYes, mbNo], 0) = mrYes Then Begin
              For i:=0 To count Do
                  Kill(LstFileParts.Items[i].Caption);
           End;
        End;

     Finally
        FrmMain.EndBusy;
        FrmMain.UpdateLists;
     End;

End;

procedure TFrmConcatFile.FormShow(Sender: TObject);
begin
     EdtOriginalFile.SetFocus;
end;

procedure TFrmConcatFile.FormCreate(Sender: TObject);
begin
     HelpContext:=IDH_ConcatFile;
end;

procedure TFrmConcatFile.BtnHelpClick(Sender: TObject);
begin
     Application.HelpCommand(HELP_CONTEXT, HelpContext);
end;

Procedure TFrmConcatFile.WMNCHitTest(Var Msg : TMessage);
Var
   i: Integer;
   r: TRect;
   ctrl: TControl;

Function LeftMouseButtonPressed: Boolean;
Begin
     If GetSystemMetrics(SM_SWAPBUTTON) = 0 Then
        Result:=(GetAsyncKeyState(VK_LBUTTON) < 0)
     Else
        Result:=(GetAsyncKeyState(VK_RBUTTON) < 0);
End;

Begin
     If Options.WindowClientDraggable And LeftMouseButtonPressed Then Begin
        If (Msg.LParamLo >= Self.ClientToScreen(Point(0, 0)).x) And
           (Msg.LParamHi >= Self.ClientToScreen(Point(0, 0)).y) And
           (Msg.LParamLo <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).x) And
           (Msg.LParamHi <= Self.ClientToScreen(Point(Self.ClientWidth, Self.ClientHeight)).y)
        Then Begin
             For i:=0 To Self.ComponentCount-1 Do Begin
                 Try
                    If Self.Components[i] Is TControl Then Begin
                       ctrl:=TControl(Self.Components[i]);
                       r:=ctrl.BoundsRect;
                       If (Msg.LParamLo >= Self.ClientToScreen(Point(r.Left, r.Top)).x) And
                          (Msg.LParamHi >= Self.ClientToScreen(Point(r.Left, r.Top)).y) And
                          (Msg.LParamLo <= Self.ClientToScreen(Point(r.Right, r.Bottom)).x) And
                          (Msg.LParamHi <= Self.ClientToScreen(Point(r.Right, r.Bottom)).y) And ctrl.Visible
                       Then Begin
                          Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                          Exit;
                       End;
                    End;
                 Except
                    Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
                    Exit;
                 End;
             End;
             Msg.Result:=HTCAPTION
        End Else
           Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
     End Else
        Msg.Result:=DefWindowProc(Handle, Msg.Msg, Msg.WParam, Msg.LParam);
End;

End.
